/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfString;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class PdfDate
extends PdfString {
    private static final int[] a = new int[]{1, 4, 0, 2, 2, -1, 5, 2, 0, 11, 2, 0, 12, 2, 0, 13, 2, 0};

    public PdfDate(Calendar calendar) {
        StringBuilder stringBuilder = new StringBuilder("D:");
        stringBuilder.append(PdfDate.b(calendar.get(1), 4));
        stringBuilder.append(PdfDate.b(calendar.get(2) + 1, 2));
        stringBuilder.append(PdfDate.b(calendar.get(5), 2));
        stringBuilder.append(PdfDate.b(calendar.get(11), 2));
        stringBuilder.append(PdfDate.b(calendar.get(12), 2));
        stringBuilder.append(PdfDate.b(calendar.get(13), 2));
        int n2 = (calendar.get(15) + calendar.get(16)) / 3600000;
        if (n2 == 0) {
            stringBuilder.append('Z');
        } else if (n2 < 0) {
            stringBuilder.append('-');
            n2 = -n2;
        } else {
            stringBuilder.append('+');
        }
        if (n2 != 0) {
            stringBuilder.append(PdfDate.b(n2, 2)).append('\'');
            int n3 = Math.abs((calendar.get(15) + calendar.get(16)) / 60000) - n2 * 60;
            stringBuilder.append(PdfDate.b(n3, 2)).append('\'');
        }
        this.value = stringBuilder.toString();
    }

    public PdfDate() {
        this(new GregorianCalendar());
    }

    private static String b(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2);
        while (stringBuilder.length() < n3) {
            stringBuilder.insert(0, "0");
        }
        stringBuilder.setLength(n3);
        return stringBuilder.toString();
    }

    public String getW3CDate() {
        return PdfDate.getW3CDate(this.value);
    }

    public static String getW3CDate(String string) {
        if (string.startsWith("D:")) {
            string = string.substring(2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() < 4) {
            return "0000";
        }
        stringBuilder.append(string, 0, 4);
        string = string.substring(4);
        if (string.length() < 2) {
            return stringBuilder.toString();
        }
        stringBuilder.append('-').append(string, 0, 2);
        string = string.substring(2);
        if (string.length() < 2) {
            return stringBuilder.toString();
        }
        stringBuilder.append('-').append(string, 0, 2);
        string = string.substring(2);
        if (string.length() < 2) {
            return stringBuilder.toString();
        }
        stringBuilder.append('T').append(string, 0, 2);
        string = string.substring(2);
        if (string.length() < 2) {
            stringBuilder.append(":00Z");
            return stringBuilder.toString();
        }
        stringBuilder.append(':').append(string, 0, 2);
        string = string.substring(2);
        if (string.length() < 2) {
            stringBuilder.append('Z');
            return stringBuilder.toString();
        }
        stringBuilder.append(':').append(string, 0, 2);
        string = string.substring(2);
        if (string.startsWith("-") || string.startsWith("+")) {
            String string2 = string.substring(0, 1);
            string = string.substring(1);
            String string3 = "00";
            if (string.length() >= 2) {
                String string4 = string.substring(0, 2);
                if (string.length() > 2 && (string = string.substring(3)).length() >= 2) {
                    string3 = string.substring(0, 2);
                }
                stringBuilder.append(string2).append(string4).append(':').append(string3);
                return stringBuilder.toString();
            }
        }
        stringBuilder.append('Z');
        return stringBuilder.toString();
    }

    public static Calendar decode(String string) {
        try {
            int n2;
            GregorianCalendar gregorianCalendar;
            if (string.startsWith("D:")) {
                string = string.substring(2);
            }
            int n3 = string.length();
            int n4 = string.indexOf(90);
            if (n4 >= 0) {
                n3 = n4;
                gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(0, "ZPDF"));
            } else {
                n2 = 1;
                n4 = string.indexOf(43);
                if (n4 < 0 && (n4 = string.indexOf(45)) >= 0) {
                    n2 = -1;
                }
                if (n4 < 0) {
                    gregorianCalendar = new GregorianCalendar();
                } else {
                    int n5 = Integer.parseInt(string.substring(n4 + 1, n4 + 3)) * 60;
                    if (n4 + 5 < string.length()) {
                        n5 += Integer.parseInt(string.substring(n4 + 4, n4 + 6));
                    }
                    gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(n5 * n2 * 60000, "ZPDF"));
                    n3 = n4;
                }
            }
            gregorianCalendar.clear();
            n4 = 0;
            for (n2 = 0; n2 < a.length && n4 < n3; n4 += a[n2 + 1], n2 += 3) {
                int n6 = n4;
                gregorianCalendar.set(a[n2], Integer.parseInt(string.substring(n6, n6 + a[n2 + 1])) + a[n2 + 2]);
            }
            return gregorianCalendar;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

