/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PdfDictionary
extends PdfObject {
    public static final PdfName FONT = PdfName.FONT;
    public static final PdfName OUTLINES = PdfName.OUTLINES;
    public static final PdfName PAGE = PdfName.PAGE;
    public static final PdfName PAGES = PdfName.PAGES;
    public static final PdfName CATALOG = PdfName.CATALOG;
    private PdfName a = null;
    protected Map<PdfName, PdfObject> hashMap = new HashMap<PdfName, PdfObject>();

    public PdfDictionary() {
        super(6);
    }

    public PdfDictionary(PdfName pdfName) {
        this();
        this.a = pdfName;
        this.put(PdfName.TYPE, this.a);
    }

    @Override
    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) {
        outputStream.write(60);
        outputStream.write(60);
        for (PdfName pdfName : this.hashMap.keySet()) {
            PdfObject pdfObject = this.hashMap.get(pdfName);
            pdfName.toPdf(pdfWriter, outputStream);
            int n2 = pdfObject.type();
            if (n2 != 5 && n2 != 6 && n2 != 4 && n2 != 3) {
                outputStream.write(32);
            }
            pdfObject.toPdf(pdfWriter, outputStream);
        }
        outputStream.write(62);
        outputStream.write(62);
    }

    @Override
    public String toString() {
        if (this.get(PdfName.TYPE) == null) {
            return "Dictionary";
        }
        return "Dictionary of type: " + this.get(PdfName.TYPE);
    }

    public void put(PdfName pdfName, PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            this.hashMap.remove(pdfName);
            return;
        }
        this.hashMap.put(pdfName, pdfObject);
    }

    public void putEx(PdfName pdfName, PdfObject pdfObject) {
        if (pdfObject == null) {
            return;
        }
        this.put(pdfName, pdfObject);
    }

    public void putAll(PdfDictionary pdfDictionary) {
        this.hashMap.putAll(pdfDictionary.hashMap);
    }

    public void remove(PdfName pdfName) {
        this.hashMap.remove(pdfName);
    }

    public PdfObject get(PdfName pdfName) {
        return this.hashMap.get(pdfName);
    }

    public PdfObject getDirectObject(PdfName pdfName) {
        return PdfReader.getPdfObject(this.get(pdfName));
    }

    public Set<PdfName> getKeys() {
        return this.hashMap.keySet();
    }

    public int size() {
        return this.hashMap.size();
    }

    public boolean contains(PdfName pdfName) {
        return this.hashMap.containsKey(pdfName);
    }

    public boolean isFont() {
        return FONT.equals(this.a);
    }

    public boolean isPage() {
        return PAGE.equals(this.a);
    }

    public boolean isPages() {
        return PAGES.equals(this.a);
    }

    public boolean isCatalog() {
        return CATALOG.equals(this.a);
    }

    public boolean isOutlineTree() {
        return OUTLINES.equals(this.a);
    }

    public void merge(PdfDictionary pdfDictionary) {
        this.hashMap.putAll(pdfDictionary.hashMap);
    }

    public void mergeDifferent(PdfDictionary pdfDictionary) {
        for (PdfName pdfName : pdfDictionary.hashMap.keySet()) {
            if (this.hashMap.containsKey(pdfName)) continue;
            this.hashMap.put(pdfName, pdfDictionary.hashMap.get(pdfName));
        }
    }

    public PdfDictionary getAsDict(PdfName pdfObject) {
        PdfDictionary pdfDictionary = null;
        if ((pdfObject = this.getDirectObject((PdfName)pdfObject)) != null && pdfObject.isDictionary()) {
            pdfDictionary = (PdfDictionary)pdfObject;
        }
        return pdfDictionary;
    }

    public PdfArray getAsArray(PdfName pdfObject) {
        PdfArray pdfArray = null;
        if ((pdfObject = this.getDirectObject((PdfName)pdfObject)) != null && pdfObject.isArray()) {
            pdfArray = (PdfArray)pdfObject;
        }
        return pdfArray;
    }

    public PdfStream getAsStream(PdfName pdfObject) {
        PdfStream pdfStream = null;
        if ((pdfObject = this.getDirectObject((PdfName)pdfObject)) != null && pdfObject.isStream()) {
            pdfStream = (PdfStream)pdfObject;
        }
        return pdfStream;
    }

    public PdfString getAsString(PdfName pdfObject) {
        PdfString pdfString = null;
        if ((pdfObject = this.getDirectObject((PdfName)pdfObject)) != null && pdfObject.isString()) {
            pdfString = (PdfString)pdfObject;
        }
        return pdfString;
    }

    public PdfNumber getAsNumber(PdfName pdfObject) {
        PdfNumber pdfNumber = null;
        if ((pdfObject = this.getDirectObject((PdfName)pdfObject)) != null && pdfObject.isNumber()) {
            pdfNumber = (PdfNumber)pdfObject;
        }
        return pdfNumber;
    }

    public PdfName getAsName(PdfName pdfObject) {
        PdfName pdfName = null;
        if ((pdfObject = this.getDirectObject((PdfName)pdfObject)) != null && pdfObject.isName()) {
            pdfName = (PdfName)pdfObject;
        }
        return pdfName;
    }

    public PdfBoolean getAsBoolean(PdfName pdfObject) {
        PdfBoolean pdfBoolean = null;
        if ((pdfObject = this.getDirectObject((PdfName)pdfObject)) != null && pdfObject.isBoolean()) {
            pdfBoolean = (PdfBoolean)pdfObject;
        }
        return pdfBoolean;
    }

    public PdfIndirectReference getAsIndirectObject(PdfName pdfObject) {
        PdfIndirectReference pdfIndirectReference = null;
        if ((pdfObject = this.get((PdfName)pdfObject)) != null && pdfObject.isIndirect()) {
            pdfIndirectReference = (PdfIndirectReference)pdfObject;
        }
        return pdfIndirectReference;
    }
}

