/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.MarkedObject;
import com.lowagie.text.MarkedSection;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.Table;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.LayoutProcessor;
import com.lowagie.text.pdf.MultiColumnText;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfCell;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTable;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PdfXConformanceException;
import com.lowagie.text.pdf.collection.PdfCollection;
import com.lowagie.text.pdf.draw.DrawInterface;
import com.lowagie.text.pdf.e;
import com.lowagie.text.pdf.g;
import com.lowagie.text.pdf.internal.PdfAnnotationsImp;
import com.lowagie.text.pdf.internal.PdfViewerPreferencesImp;
import com.lowagie.text.pdf.j;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PdfDocument
extends Document {
    protected PdfWriter writer;
    protected PdfContentByte text;
    protected PdfContentByte graphics;
    protected float leading = 0.0f;
    protected int alignment = 0;
    protected float currentHeight = 0.0f;
    protected boolean isSectionTitle = false;
    protected int leadingCount = 0;
    protected PdfAction anchorAction = null;
    protected int textEmptySize;
    protected byte[] xmpMetadata = null;
    protected float nextMarginLeft;
    protected float nextMarginRight;
    protected float nextMarginTop;
    protected float nextMarginBottom;
    protected boolean firstPageEvent = true;
    protected PdfLine line = null;
    protected java.util.List<PdfLine> lines = new ArrayList<PdfLine>();
    protected int lastElementType = -1;
    protected Indentation indentation = new Indentation();
    protected PdfInfo info = new PdfInfo();
    protected PdfOutline rootOutline;
    protected PdfOutline currentOutline;
    protected PdfViewerPreferencesImp viewerPreferences = new PdfViewerPreferencesImp();
    protected PdfPageLabels pageLabels;
    protected TreeMap<String, Object[]> localDestinations = new TreeMap();
    private int b;
    protected HashMap<String, PdfIndirectReference> documentLevelJS = new HashMap();
    protected static final DecimalFormat SIXTEEN_DIGITS = new DecimalFormat("0000000000000000");
    protected HashMap<String, PdfIndirectReference> documentFileAttachment = new HashMap();
    protected String openActionName;
    protected PdfAction openActionAction;
    protected PdfDictionary additionalActions;
    protected PdfCollection collection;
    PdfAnnotationsImp a;
    protected int markPoint;
    protected Rectangle nextPageSize = null;
    protected HashMap<String, PdfRectangle> thisBoxSize = new HashMap();
    protected HashMap<String, PdfRectangle> boxSize = new HashMap();
    private boolean c = true;
    protected int duration = -1;
    protected PdfTransition transition = null;
    protected PdfDictionary pageAA = null;
    protected PdfIndirectReference thumb;
    protected e pageResources;
    protected boolean strictImageSequence = false;
    protected float imageEnd = -1.0f;
    protected Image imageWait = null;

    public PdfDocument() {
        this.addProducer();
        this.addCreationDate();
    }

    public void addWriter(PdfWriter pdfWriter) {
        if (this.writer == null) {
            this.writer = pdfWriter;
            this.a = new PdfAnnotationsImp(pdfWriter);
            return;
        }
        throw new DocumentException(MessageLocalization.getComposedMessage("you.can.only.add.a.writer.to.a.pdfdocument.once"));
    }

    public float getLeading() {
        return this.leading;
    }

    final void a(float f2) {
        this.leading = f2;
    }

    @Override
    public boolean add(Element element) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        try {
            switch (element.type()) {
                case 0: {
                    String string = ((Meta)element).getContent();
                    String string2 = ((Meta)element).getName();
                    PdfInfo pdfInfo = this.info;
                    if (string2.equals("Producer") || string2.equals("CreationDate")) break;
                    pdfInfo.put(new PdfName(string2), new PdfString(string, "UnicodeBig"));
                    break;
                }
                case 1: {
                    String string = ((Meta)element).getContent();
                    PdfInfo pdfInfo = this.info;
                    pdfInfo.put(PdfName.TITLE, new PdfString(string, "UnicodeBig"));
                    break;
                }
                case 2: {
                    String string = ((Meta)element).getContent();
                    PdfInfo pdfInfo = this.info;
                    pdfInfo.put(PdfName.SUBJECT, new PdfString(string, "UnicodeBig"));
                    break;
                }
                case 3: {
                    String string = ((Meta)element).getContent();
                    PdfInfo pdfInfo = this.info;
                    pdfInfo.put(PdfName.KEYWORDS, new PdfString(string, "UnicodeBig"));
                    break;
                }
                case 4: {
                    String string = ((Meta)element).getContent();
                    PdfInfo pdfInfo = this.info;
                    pdfInfo.put(PdfName.AUTHOR, new PdfString(string, "UnicodeBig"));
                    break;
                }
                case 7: {
                    String string = ((Meta)element).getContent();
                    PdfInfo pdfInfo = this.info;
                    pdfInfo.put(PdfName.CREATOR, new PdfString(string, "UnicodeBig"));
                    break;
                }
                case 5: {
                    String string = ((Meta)element).getContent();
                    PdfInfo pdfInfo = this.info;
                    pdfInfo.put(PdfName.PRODUCER, new PdfString(string));
                    break;
                }
                case 6: {
                    PdfInfo pdfInfo = this.info;
                    PdfDate pdfDate = new PdfDate();
                    pdfInfo.put(PdfName.CREATIONDATE, pdfDate);
                    pdfInfo.put(PdfName.MODDATE, pdfDate);
                    break;
                }
                case 10: {
                    PdfChunk pdfChunk;
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    PdfChunk pdfChunk2 = new PdfChunk((Chunk)element, this.anchorAction);
                    while ((pdfChunk = this.line.a(pdfChunk2)) != null) {
                        this.carriageReturn();
                        pdfChunk2 = pdfChunk;
                        pdfChunk2.trimFirstSpace();
                    }
                    this.c = false;
                    if (!pdfChunk2.b("NEWPAGE")) break;
                    ((Document)this).newPage();
                    break;
                }
                case 17: {
                    ++this.leadingCount;
                    Anchor anchor = (Anchor)element;
                    String string = anchor.getReference();
                    this.leading = anchor.getLeading();
                    if (string != null) {
                        this.anchorAction = new PdfAction(string);
                    }
                    element.process(this);
                    this.anchorAction = null;
                    --this.leadingCount;
                    break;
                }
                case 29: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    Annotation annotation = (Annotation)element;
                    Rectangle rectangle = new Rectangle(0.0f, 0.0f);
                    if (this.line != null) {
                        rectangle = new Rectangle(annotation.llx(this.indentRight() - this.line.c()), annotation.ury(this.indentTop() - this.currentHeight - 20.0f), annotation.urx(this.indentRight() - this.line.c() + 20.0f), annotation.lly(this.indentTop() - this.currentHeight));
                    }
                    PdfAnnotation pdfAnnotation = PdfAnnotationsImp.convertAnnotation(this.writer, annotation, rectangle);
                    this.a.addPlainAnnotation(pdfAnnotation);
                    this.c = false;
                    break;
                }
                case 11: {
                    ++this.leadingCount;
                    this.leading = ((Phrase)element).getLeading();
                    element.process(this);
                    --this.leadingCount;
                    break;
                }
                case 12: {
                    ++this.leadingCount;
                    Paragraph paragraph = (Paragraph)element;
                    this.addSpacing(paragraph.getSpacingBefore(), this.leading, paragraph.getFont());
                    this.alignment = paragraph.getAlignment();
                    this.leading = paragraph.getTotalLeading();
                    this.carriageReturn();
                    if (this.currentHeight + this.line.a() + this.leading > this.indentTop() - this.a()) {
                        ((Document)this).newPage();
                    }
                    this.indentation.a += paragraph.getIndentationLeft();
                    this.indentation.e += paragraph.getIndentationRight();
                    this.carriageReturn();
                    PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
                    if (pdfPageEvent != null && !this.isSectionTitle) {
                        PdfDocument pdfDocument = this;
                        pdfPageEvent.onParagraph(this.writer, pdfDocument, pdfDocument.indentTop() - this.currentHeight);
                    }
                    if (paragraph.getKeepTogether()) {
                        this.carriageReturn();
                        Element element2 = paragraph;
                        PdfPTable pdfPTable = new PdfPTable(1);
                        pdfPTable.setWidthPercentage(100.0f);
                        PdfPCell pdfPCell = new PdfPCell();
                        pdfPCell.setBorder(0);
                        pdfPCell.setPadding(0.0f);
                        for (int i2 = 0; i2 < ((ArrayList)((Object)element2)).size(); ++i2) {
                            if (((ArrayList)((Object)element2)).get(i2) instanceof Chunk) {
                                Paragraph paragraph2 = new Paragraph();
                                boolean bl2 = false;
                                do {
                                    Chunk chunk = (Chunk)((ArrayList)((Object)element2)).get(i2);
                                    ++i2;
                                    if (chunk.getContent().equals("\n")) {
                                        bl2 = true;
                                        break;
                                    }
                                    ((Phrase)paragraph2).add(chunk);
                                } while (i2 < ((ArrayList)((Object)element2)).size() && ((ArrayList)((Object)element2)).get(i2) instanceof Chunk);
                                --i2;
                                pdfPCell.addElement(paragraph2);
                                if (!bl2) continue;
                                pdfPCell.addElement(new Chunk("\n"));
                                continue;
                            }
                            pdfPCell.addElement((Element)((ArrayList)((Object)element2)).get(i2));
                        }
                        pdfPTable.addCell(pdfPCell);
                        element2 = pdfPTable;
                        this.indentation.a -= paragraph.getIndentationLeft();
                        this.indentation.e -= paragraph.getIndentationRight();
                        ((Document)this).add(element2);
                        this.indentation.a += paragraph.getIndentationLeft();
                        this.indentation.e += paragraph.getIndentationRight();
                    } else {
                        this.line.a(paragraph.getFirstLineIndent());
                        element.process(this);
                        this.carriageReturn();
                        this.addSpacing(paragraph.getSpacingAfter(), paragraph.getTotalLeading(), paragraph.getFont());
                    }
                    if (pdfPageEvent != null && !this.isSectionTitle) {
                        PdfDocument pdfDocument = this;
                        pdfPageEvent.onParagraphEnd(this.writer, pdfDocument, pdfDocument.indentTop() - this.currentHeight);
                    }
                    this.alignment = 0;
                    this.indentation.a -= paragraph.getIndentationLeft();
                    this.indentation.e -= paragraph.getIndentationRight();
                    this.carriageReturn();
                    --this.leadingCount;
                    break;
                }
                case 13: 
                case 16: {
                    boolean bl3;
                    Section section = (Section)element;
                    PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
                    boolean bl4 = bl3 = section.isNotAddedYet() && section.getTitle() != null;
                    if (section.isTriggerNewPage()) {
                        ((Document)this).newPage();
                    }
                    if (bl3) {
                        float f2 = this.indentTop() - this.currentHeight;
                        int n2 = this.pageSize.getRotation();
                        if (n2 == 90 || n2 == 180) {
                            f2 = this.pageSize.getHeight() - f2;
                        }
                        PdfObject pdfObject = new PdfDestination(2, f2);
                        while (this.currentOutline.level() >= section.getDepth()) {
                            this.currentOutline = this.currentOutline.parent();
                        }
                        pdfObject = new PdfOutline(this.currentOutline, (PdfDestination)pdfObject, section.getBookmarkTitle(), section.isBookmarkOpen());
                        this.currentOutline = pdfObject;
                    }
                    this.carriageReturn();
                    this.indentation.b += section.getIndentationLeft();
                    this.indentation.f += section.getIndentationRight();
                    if (section.isNotAddedYet() && pdfPageEvent != null) {
                        if (element.type() == 16) {
                            PdfDocument pdfDocument = this;
                            pdfPageEvent.onChapter(this.writer, pdfDocument, pdfDocument.indentTop() - this.currentHeight, section.getTitle());
                        } else {
                            PdfDocument pdfDocument = this;
                            pdfPageEvent.onSection(this.writer, pdfDocument, pdfDocument.indentTop() - this.currentHeight, section.getDepth(), section.getTitle());
                        }
                    }
                    if (bl3) {
                        this.isSectionTitle = true;
                        ((Document)this).add(section.getTitle());
                        this.isSectionTitle = false;
                    }
                    this.indentation.b += section.getIndentation();
                    element.process(this);
                    this.flushLines();
                    this.indentation.b -= section.getIndentationLeft() + section.getIndentation();
                    this.indentation.f -= section.getIndentationRight();
                    if (!section.isComplete() || pdfPageEvent == null) break;
                    if (element.type() == 16) {
                        PdfDocument pdfDocument = this;
                        pdfPageEvent.onChapterEnd(this.writer, pdfDocument, pdfDocument.indentTop() - this.currentHeight);
                        break;
                    }
                    PdfDocument pdfDocument = this;
                    pdfPageEvent.onSectionEnd(this.writer, pdfDocument, pdfDocument.indentTop() - this.currentHeight);
                    break;
                }
                case 14: {
                    List list = (List)element;
                    if (list.isAlignindent()) {
                        list.normalizeIndentation();
                    }
                    this.indentation.c += list.getIndentationLeft();
                    this.indentation.e += list.getIndentationRight();
                    element.process(this);
                    this.indentation.c -= list.getIndentationLeft();
                    this.indentation.e -= list.getIndentationRight();
                    this.carriageReturn();
                    break;
                }
                case 15: {
                    ++this.leadingCount;
                    ListItem listItem = (ListItem)element;
                    this.addSpacing(listItem.getSpacingBefore(), this.leading, listItem.getFont());
                    this.alignment = listItem.getAlignment();
                    this.indentation.c += listItem.getIndentationLeft();
                    this.indentation.e += listItem.getIndentationRight();
                    this.leading = listItem.getTotalLeading();
                    this.carriageReturn();
                    this.line.setListItem(listItem);
                    element.process(this);
                    this.addSpacing(listItem.getSpacingAfter(), listItem.getTotalLeading(), listItem.getFont());
                    if (this.line.hasToBeJustified()) {
                        this.line.resetAlignment();
                    }
                    this.carriageReturn();
                    this.indentation.c -= listItem.getIndentationLeft();
                    this.indentation.e -= listItem.getIndentationRight();
                    --this.leadingCount;
                    break;
                }
                case 30: {
                    Rectangle rectangle = (Rectangle)element;
                    this.graphics.rectangle(rectangle);
                    this.c = false;
                    break;
                }
                case 23: {
                    PdfPTable pdfPTable = (PdfPTable)element;
                    if (pdfPTable.size() <= pdfPTable.getHeaderRows()) break;
                    this.ensureNewLine();
                    this.flushLines();
                    this.a(pdfPTable);
                    this.c = false;
                    this.newLine();
                    break;
                }
                case 40: {
                    this.ensureNewLine();
                    this.flushLines();
                    MultiColumnText multiColumnText = (MultiColumnText)element;
                    PdfDocument pdfDocument = this;
                    float f3 = multiColumnText.write(this.writer.getDirectContent(), pdfDocument, pdfDocument.indentTop() - this.currentHeight);
                    this.currentHeight += f3;
                    this.text.moveText(0.0f, -1.0f * f3);
                    this.c = false;
                    break;
                }
                case 22: {
                    if (element instanceof SimpleTable) {
                        PdfPTable pdfPTable = ((SimpleTable)element).createPdfPTable();
                        if (pdfPTable.size() <= pdfPTable.getHeaderRows()) break;
                        this.ensureNewLine();
                        this.flushLines();
                        this.a(pdfPTable);
                        this.c = false;
                        break;
                    }
                    if (element instanceof Table) {
                        try {
                            PdfPTable pdfPTable = ((Table)element).createPdfPTable();
                            if (pdfPTable.size() <= pdfPTable.getHeaderRows()) break;
                            this.ensureNewLine();
                            this.flushLines();
                            this.a(pdfPTable);
                            this.c = false;
                        }
                        catch (BadElementException badElementException) {
                            float f4 = ((Table)element).getOffset();
                            if (Float.isNaN(f4)) {
                                f4 = this.leading;
                            }
                            this.carriageReturn();
                            this.lines.add(new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, f4));
                            this.currentHeight += f4;
                            Table table = (Table)element;
                            PdfDocument pdfDocument = this;
                            pdfDocument.flushLines();
                            PdfTable pdfTable = new PdfTable(table, pdfDocument.indentLeft(), pdfDocument.indentRight(), pdfDocument.indentTop() - pdfDocument.currentHeight);
                            RenderingContext renderingContext = new RenderingContext();
                            new RenderingContext().a = pdfDocument.indentTop();
                            renderingContext.b = pdfDocument.currentHeight;
                            renderingContext.c = new PdfContentByte(pdfDocument.writer);
                            renderingContext.f = new HashMap<PdfCell, Integer>();
                            renderingContext.table = pdfTable;
                            ArrayList<PdfCell> arrayList = pdfTable.a();
                            ArrayList<PdfCell> arrayList2 = pdfTable.b();
                            java.util.List<java.util.List<PdfCell>> list = pdfDocument.extractRows(arrayList2, renderingContext);
                            boolean bl5 = false;
                            while (!arrayList2.isEmpty()) {
                                int n2;
                                float f2;
                                boolean bl6;
                                Collection<PdfCell> collection;
                                renderingContext.d = 0.0f;
                                Iterator<java.util.List<PdfCell>> iterator = list.iterator();
                                boolean bl62 = false;
                                while (iterator.hasNext()) {
                                    boolean object2;
                                    collection = iterator.next();
                                    pdfDocument.analyzeRow(list, renderingContext);
                                    pdfDocument.renderCells(renderingContext, (java.util.List)collection, (pdfTable.hasToFitPageCells() & object2) != 0);
                                    if (!pdfDocument.mayBeRemoved((java.util.List<PdfCell>)collection)) break;
                                    pdfDocument.consumeRowspan((java.util.List<PdfCell>)collection, renderingContext);
                                    iterator.remove();
                                    object2 = true;
                                }
                                arrayList2.clear();
                                collection = new HashSet();
                                for (ArrayList rectangle : list) {
                                    for (Object e2 : rectangle) {
                                        PdfCell pdfCell = (PdfCell)e2;
                                        if (collection.contains(pdfCell)) continue;
                                        arrayList2.add(pdfCell);
                                        collection.add(pdfCell);
                                    }
                                }
                                Rectangle pdfCell2 = new Rectangle(pdfTable);
                                pdfCell2.setBorder(pdfTable.getBorder());
                                pdfCell2.setBorderWidth(pdfTable.getBorderWidth());
                                pdfCell2.setBorderColor(pdfTable.getBorderColor());
                                pdfCell2.setBackgroundColor(pdfTable.getBackgroundColor());
                                PdfContentByte pdfContentByte = pdfDocument.writer.getDirectContentUnder();
                                pdfContentByte.rectangle(pdfCell2.rectangle(pdfDocument.top(), pdfDocument.a()));
                                pdfContentByte.add(renderingContext.c);
                                pdfCell2.setBackgroundColor(null);
                                Rectangle pdfCell = pdfCell2.rectangle(pdfDocument.top(), pdfDocument.a());
                                pdfCell.setBorder(pdfTable.getBorder());
                                pdfContentByte.rectangle(pdfCell);
                                renderingContext.c = new PdfContentByte(null);
                                if (list.isEmpty()) continue;
                                bl5 = true;
                                pdfDocument.graphics.setLineWidth(pdfTable.getBorderWidth());
                                pdfDocument.c = false;
                                float f3 = renderingContext.d;
                                ((Document)pdfDocument).newPage();
                                float f7 = 0.0f;
                                boolean bl7 = false;
                                if (pdfDocument.currentHeight > 0.0f) {
                                    f7 = 6.0f;
                                    pdfDocument.currentHeight += 6.0f;
                                    bl6 = true;
                                    pdfDocument.newLine();
                                    pdfDocument.flushLines();
                                    pdfDocument.indentation.h = pdfDocument.currentHeight - pdfDocument.leading;
                                    pdfDocument.currentHeight = 0.0f;
                                } else {
                                    pdfDocument.flushLines();
                                }
                                int n3 = arrayList.size();
                                if (n3 > 0) {
                                    PdfCell pdfCell3 = (PdfCell)arrayList.get(0);
                                    float f5 = pdfCell3.getTop(0.0f);
                                    for (int i2 = 0; i2 < n3; ++i2) {
                                        PdfCell pdfCell4 = (PdfCell)arrayList.get(i2);
                                        pdfCell4.setTop(pdfDocument.indentTop() - f5 + pdfCell4.getTop(0.0f));
                                        ((Rectangle)pdfCell4).setBottom(pdfDocument.indentTop() - f5 + pdfCell4.getBottom(0.0f));
                                        renderingContext.a = ((Rectangle)pdfCell4).getBottom();
                                        renderingContext.c.rectangle(((Rectangle)pdfCell4).rectangle(pdfDocument.indentTop(), pdfDocument.a()));
                                        Object object = pdfCell4.getImages(pdfDocument.indentTop(), pdfDocument.a());
                                        object = object.iterator();
                                        while (object.hasNext()) {
                                            Object object2 = object.next();
                                            object2 = (Image)object2;
                                            pdfDocument.graphics.addImage((Image)object2);
                                        }
                                        pdfDocument.lines = pdfCell4.getLines(pdfDocument.indentTop(), pdfDocument.a());
                                        f2 = pdfCell4.getTop(pdfDocument.indentTop());
                                        pdfDocument.text.moveText(0.0f, f2 - f7);
                                        float f6 = pdfDocument.flushLines() - f2 + f7;
                                        pdfDocument.text.moveText(0.0f, f6);
                                    }
                                    pdfDocument.currentHeight = pdfDocument.indentTop() - renderingContext.a + pdfTable.d();
                                    pdfDocument.text.moveText(0.0f, renderingContext.a - pdfDocument.indentTop() - pdfDocument.currentHeight);
                                } else if (bl6) {
                                    renderingContext.a = pdfDocument.indentTop();
                                    pdfDocument.text.moveText(0.0f, -pdfTable.d());
                                }
                                renderingContext.b = pdfDocument.currentHeight - f7;
                                n3 = Math.min(arrayList2.size(), pdfTable.c());
                                for (n2 = 0; n2 < n3; ++n2) {
                                    float f8;
                                    PdfCell pdfCell5;
                                    PdfCell pdfCell6 = (PdfCell)arrayList2.get(n2);
                                    if (!(pdfCell5.getTop(-pdfTable.d()) > renderingContext.d) || !((f8 = renderingContext.a - f3 + ((Rectangle)pdfCell6).getBottom()) > renderingContext.a - (f2 = pdfCell6.remainingHeight()))) continue;
                                    f3 += f8 - (renderingContext.a - f2);
                                }
                                n3 = arrayList2.size();
                                pdfTable.setTop(pdfDocument.indentTop());
                                PdfTable pdfTable2 = pdfTable;
                                pdfTable.setBottom(renderingContext.a - f3 + pdfTable2.getBottom(pdfTable2.d()));
                                for (n2 = 0; n2 < n3; ++n2) {
                                    float f9;
                                    PdfCell pdfCell7 = (PdfCell)arrayList2.get(n2);
                                    float f10 = renderingContext.a - f3 + ((Rectangle)pdfCell7).getBottom();
                                    f2 = renderingContext.a - f3 + pdfCell7.getTop(-pdfTable.d());
                                    if (f9 > pdfDocument.indentTop() - pdfDocument.currentHeight) {
                                        f2 = pdfDocument.indentTop() - pdfDocument.currentHeight;
                                    }
                                    pdfCell7.setTop(f2);
                                    ((Rectangle)pdfCell7).setBottom(f10);
                                }
                            }
                            float f13 = pdfTable.getTop() - pdfTable.getBottom();
                            if (bl5) {
                                pdfDocument.currentHeight = f13;
                                pdfDocument.text.moveText(0.0f, -(f13 - renderingContext.b * 2.0f));
                            } else {
                                pdfDocument.currentHeight = renderingContext.b + f13;
                                pdfDocument.text.moveText(0.0f, -f13);
                            }
                            pdfDocument.c = false;
                        }
                        break;
                    }
                    return false;
                }
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    this.add((Image)element);
                    break;
                }
                case 55: {
                    DrawInterface drawInterface = (DrawInterface)((Object)element);
                    drawInterface.draw(this.graphics, this.indentLeft(), this.a(), this.indentRight(), this.indentTop(), this.indentTop() - this.currentHeight - (this.leadingCount > 0 ? this.leading : 0.0f));
                    this.c = false;
                    break;
                }
                case 50: {
                    MarkedObject markedObject;
                    if (element instanceof MarkedSection && (markedObject = ((MarkedSection)element).getTitle()) != null) {
                        markedObject.process(this);
                    }
                    markedObject = (MarkedObject)element;
                    markedObject.process(this);
                    break;
                }
                default: {
                    return false;
                }
            }
            this.lastElementType = element.type();
            return true;
        }
        catch (Exception exception) {
            throw new DocumentException(exception);
        }
    }

    @Override
    public void open() {
        if (!this.open) {
            super.open();
            ((DocWriter)this.writer).open();
            this.currentOutline = this.rootOutline = new PdfOutline(this.writer);
        }
        try {
            this.initPage();
            return;
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    @Override
    public void close() {
        if (this.close) {
            return;
        }
        try {
            boolean bl2 = this.imageWait != null;
            ((Document)this).newPage();
            if (this.imageWait != null || bl2) {
                ((Document)this).newPage();
            }
            if (this.a.hasUnusedAnnotations()) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("not.all.annotations.could.be.added.to.the.document.the.document.doesn.t.have.enough.pages"));
            }
            Object object = this.writer.getPageEvent();
            if (object != null) {
                object.onCloseDocument(this.writer, this);
            }
            super.close();
            TreeMap<String, Object[]> treeMap = this.localDestinations;
            object = this.writer;
            for (Object e2 : treeMap.entrySet()) {
                Map.Entry entry = (Map.Entry)e2;
                String string = (String)entry.getKey();
                Object[] object2 = (Object[])entry.getValue();
                PdfDestination pdfDestination = (PdfDestination)object2[2];
                if (object2[1] == null) {
                    object2[1] = ((PdfWriter)object).getPdfIndirectReference();
                }
                if (pdfDestination == null) {
                    ((PdfWriter)object).addToBody((PdfObject)new PdfString("invalid_" + string), (PdfIndirectReference)object2[1]);
                    continue;
                }
                ((PdfWriter)object).addToBody((PdfObject)pdfDestination, (PdfIndirectReference)object2[1]);
            }
            object = this;
            if (((PdfDocument)object).rootOutline.getKids().size() != 0) {
                Object object2 = object;
                ((PdfDocument)object2).a(((PdfDocument)object2).rootOutline);
            }
            object = this;
            if (((PdfDocument)object).rootOutline.getKids().size() != 0) {
                Object object3 = object;
                ((PdfDocument)object3).b(((PdfDocument)object3).rootOutline);
                ((PdfDocument)object).writer.addToBody((PdfObject)((PdfDocument)object).rootOutline, ((PdfDocument)object).rootOutline.indirectReference());
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        ((DocWriter)this.writer).close();
    }

    public void setXmpMetadata(byte[] byArray) {
        this.xmpMetadata = byArray;
    }

    @Override
    public boolean newPage() {
        this.lastElementType = -1;
        if (this.f()) {
            this.setNewPageSizeAndMargins();
            return false;
        }
        if (!this.open || this.close) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("the.document.is.not.open"));
        }
        PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
        if (pdfPageEvent != null) {
            pdfPageEvent.onEndPage(this.writer, this);
        }
        super.newPage();
        this.indentation.d = 0.0f;
        this.indentation.g = 0.0f;
        try {
            PdfObject pdfObject;
            this.flushLines();
            int n2 = this.pageSize.getRotation();
            if (this.writer.isPdfX()) {
                if (this.thisBoxSize.containsKey("art") && this.thisBoxSize.containsKey("trim")) {
                    throw new PdfXConformanceException(MessageLocalization.getComposedMessage("only.one.of.artbox.or.trimbox.can.exist.in.the.page"));
                }
                if (!this.thisBoxSize.containsKey("art") && !this.thisBoxSize.containsKey("trim")) {
                    if (this.thisBoxSize.containsKey("crop")) {
                        this.thisBoxSize.put("trim", this.thisBoxSize.get("crop"));
                    } else {
                        this.thisBoxSize.put("trim", new PdfRectangle(this.pageSize, this.pageSize.getRotation()));
                    }
                }
            }
            this.pageResources.b(this.writer.getDefaultColorspace());
            if (this.writer.isRgbTransparencyBlending()) {
                pdfObject = new PdfDictionary();
                ((PdfDictionary)pdfObject).put(PdfName.CS, PdfName.DEVICERGB);
                this.pageResources.b((PdfDictionary)pdfObject);
            }
            pdfObject = this.pageResources.a();
            PdfPage pdfPage = new PdfPage(new PdfRectangle(this.pageSize, n2), this.thisBoxSize, (PdfDictionary)pdfObject, n2);
            pdfPage.put(PdfName.TABS, this.writer.getTabs());
            if (this.xmpMetadata != null) {
                pdfObject = new PdfStream(this.xmpMetadata);
                ((PdfDictionary)pdfObject).put(PdfName.TYPE, PdfName.METADATA);
                ((PdfDictionary)pdfObject).put(PdfName.SUBTYPE, PdfName.XML);
                Object object = this.writer.o();
                if (object != null && !((PdfEncryption)object).isMetadataEncrypted()) {
                    object = new PdfArray();
                    ((PdfArray)object).add(PdfName.CRYPT);
                    ((PdfDictionary)pdfObject).put(PdfName.FILTER, (PdfObject)object);
                }
                pdfPage.put(PdfName.METADATA, this.writer.addToBody(pdfObject).getIndirectReference());
            }
            if (this.transition != null) {
                pdfPage.put(PdfName.TRANS, this.transition.getTransitionDictionary());
                this.transition = null;
            }
            if (this.duration > 0) {
                pdfPage.put(PdfName.DUR, new PdfNumber(this.duration));
                this.duration = 0;
            }
            if (this.pageAA != null) {
                pdfPage.put(PdfName.AA, this.writer.addToBody(this.pageAA).getIndirectReference());
                this.pageAA = null;
            }
            if (this.thumb != null) {
                pdfPage.put(PdfName.THUMB, this.thumb);
                this.thumb = null;
            }
            if (this.writer.getUserunit() > 0.0f) {
                pdfPage.put(PdfName.USERUNIT, new PdfNumber(this.writer.getUserunit()));
            }
            if (this.a.hasUnusedAnnotations() && ((PdfArray)(pdfObject = this.a.rotateAnnotations(this.writer, this.pageSize))).size() != 0) {
                pdfPage.put(PdfName.ANNOTS, pdfObject);
            }
            if (this.writer.isTagged()) {
                pdfPage.put(PdfName.STRUCTPARENTS, new PdfNumber(this.writer.getCurrentPageNumber() - 1));
            }
            if (this.text.a() > this.textEmptySize) {
                this.text.endText();
            } else {
                this.text = null;
            }
            this.writer.a(pdfPage, new g(this.writer.getDirectContentUnder(), this.graphics, this.text, this.writer.getDirectContent(), this.pageSize));
            this.initPage();
        }
        catch (DocumentException | IOException exception) {
            throw new ExceptionConverter(exception);
        }
        return true;
    }

    @Override
    public boolean setPageSize(Rectangle rectangle) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextPageSize = new Rectangle(rectangle);
        return true;
    }

    @Override
    public boolean setMargins(float f2, float f3, float f4, float f5) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.nextMarginLeft = f2;
        this.nextMarginRight = f3;
        this.nextMarginTop = f4;
        this.nextMarginBottom = f5;
        return true;
    }

    @Override
    public boolean setMarginMirroring(boolean bl2) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        return super.setMarginMirroring(bl2);
    }

    @Override
    public boolean setMarginMirroringTopBottom(boolean bl2) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        return super.setMarginMirroringTopBottom(bl2);
    }

    @Override
    public void setPageCount(int n2) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setPageCount(n2);
    }

    @Override
    public void resetPageCount() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetPageCount();
    }

    @Override
    public void setHeader(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setHeader(headerFooter);
    }

    @Override
    public void resetHeader() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetHeader();
    }

    @Override
    public void setFooter(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setFooter(headerFooter);
    }

    @Override
    public void resetFooter() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetFooter();
    }

    protected void initPage() {
        ++this.pageN;
        this.a.resetAnnotations();
        this.pageResources = new e();
        this.writer.j();
        this.graphics = new PdfContentByte(this.writer);
        this.text = new PdfContentByte(this.writer);
        this.text.reset();
        this.text.beginText();
        this.textEmptySize = this.text.a();
        this.markPoint = 0;
        this.setNewPageSizeAndMargins();
        this.imageEnd = -1.0f;
        this.indentation.g = 0.0f;
        this.indentation.d = 0.0f;
        this.indentation.i = 0.0f;
        this.indentation.h = 0.0f;
        this.currentHeight = 0.0f;
        this.thisBoxSize = new HashMap<String, PdfRectangle>(this.boxSize);
        if (this.pageSize.getBackgroundColor() != null || this.pageSize.hasBorders() || this.pageSize.getBorderColor() != null) {
            PdfDocument pdfDocument = this;
            ((Document)pdfDocument).add(pdfDocument.pageSize);
        }
        float f2 = this.leading;
        int n2 = this.alignment;
        this.doFooter();
        this.text.moveText(this.left(), this.top());
        this.doHeader();
        this.c = true;
        try {
            if (this.imageWait != null) {
                PdfDocument pdfDocument = this;
                pdfDocument.add(pdfDocument.imageWait);
                this.imageWait = null;
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.leading = f2;
        this.alignment = n2;
        this.carriageReturn();
        PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
        if (pdfPageEvent != null) {
            if (this.firstPageEvent) {
                pdfPageEvent.onOpenDocument(this.writer, this);
            }
            pdfPageEvent.onStartPage(this.writer, this);
        }
        this.firstPageEvent = false;
    }

    protected void newLine() {
        this.lastElementType = -1;
        this.carriageReturn();
        if (this.lines != null && !this.lines.isEmpty()) {
            this.lines.add(this.line);
            this.currentHeight += this.line.a();
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    protected void carriageReturn() {
        if (this.lines == null) {
            this.lines = new ArrayList<PdfLine>();
        }
        if (this.line != null) {
            if (this.currentHeight + this.line.a() + this.leading < this.indentTop() - this.a()) {
                if (this.line.size() > 0) {
                    this.currentHeight += this.line.a();
                    this.lines.add(this.line);
                    this.c = false;
                }
            } else {
                ((Document)this).newPage();
            }
        }
        if (this.imageEnd > -1.0f && this.currentHeight > this.imageEnd) {
            this.imageEnd = -1.0f;
            this.indentation.g = 0.0f;
            this.indentation.d = 0.0f;
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    public float getVerticalPosition(boolean bl2) {
        if (bl2) {
            this.ensureNewLine();
        }
        return this.top() - this.currentHeight - this.indentation.h;
    }

    protected void ensureNewLine() {
        try {
            if (this.lastElementType == 11 || this.lastElementType == 10) {
                this.newLine();
                this.flushLines();
            }
            return;
        }
        catch (DocumentException documentException) {
            throw new ExceptionConverter(documentException);
        }
    }

    protected float flushLines() {
        if (this.lines == null) {
            return 0.0f;
        }
        if (this.line != null && this.line.size() > 0) {
            this.lines.add(this.line);
            this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
        }
        if (this.lines.isEmpty()) {
            return 0.0f;
        }
        Object[] objectArray = new Object[2];
        j j2 = null;
        float f2 = 0.0f;
        objectArray[1] = Float.valueOf(0.0f);
        for (PdfLine pdfLine : this.lines) {
            PdfLine pdfLine2 = pdfLine;
            pdfLine2 = pdfLine;
            float f3 = pdfLine.b() - this.indentLeft() + this.indentation.a + this.indentation.c + this.indentation.b;
            this.text.moveText(f3, -pdfLine2.a());
            if (pdfLine2.listSymbol() != null) {
                ColumnText.showTextAligned(this.graphics, 0, new Phrase(pdfLine2.listSymbol()), this.text.getXTLM() - pdfLine2.listIndent(), this.text.getYTLM(), 0.0f);
            }
            objectArray[0] = j2;
            this.a(pdfLine2, this.text, this.graphics, objectArray, this.writer.getSpaceCharRatio());
            j2 = (j)objectArray[0];
            f2 += pdfLine2.a();
            this.text.moveText(-f3, 0.0f);
        }
        this.lines = new ArrayList<PdfLine>();
        return f2;
    }

    final void a(PdfLine pdfLine, PdfContentByte pdfContentByte, PdfContentByte pdfContentByte2, Object[] objectArray, float f2) {
        float f3;
        float f4;
        j j2 = (j)objectArray[0];
        float f5 = ((Float)objectArray[1]).floatValue();
        float f6 = 0.0f;
        float f7 = Float.NaN;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        int n2 = pdfLine.d();
        int n3 = pdfLine.GetLineLengthUtf32();
        boolean bl2 = pdfLine.hasToBeJustified() && (n2 != 0 || n3 > 1);
        int n4 = pdfLine.g();
        if (n4 > 0) {
            f10 = pdfLine.c() / (float)n4;
        } else if (bl2) {
            if (pdfLine.isNewlineSplit() && pdfLine.c() >= f5 * (f2 * (float)n2 + (float)n3 - 1.0f)) {
                if (pdfLine.f() || LayoutProcessor.isEnabled() && LayoutProcessor.isSet(1)) {
                    pdfContentByte.moveText(pdfLine.c() - f5 * (f2 * (float)n2 + (float)n3 - 1.0f), 0.0f);
                }
                f8 = f2 * f5;
                f9 = f5;
            } else {
                String string;
                float f11 = pdfLine.c();
                PdfLine pdfLine2 = pdfLine;
                PdfChunk pdfChunk = pdfLine2.getChunk(pdfLine2.size() - 1);
                if (pdfChunk != null && (string = pdfChunk.toString()).length() > 0) {
                    String string2 = string;
                    char c2 = string2.charAt(string2.length() - 1);
                    if (".,;:'".indexOf(c2) >= 0) {
                        f4 = f11;
                        f6 = (f11 += pdfChunk.a().a(c2) * 0.4f) - f4;
                    }
                }
                f3 = n2 == 0 && f2 == 1.0E7f ? 0.0f : f11 / (f2 * (float)n2 + (float)n3 - 1.0f);
                f8 = f2 * f3;
                f9 = f3;
                f5 = f3;
            }
        }
        n4 = pdfLine.getLastStrokeChunk();
        int n5 = 0;
        float f12 = f3 = pdfContentByte.getXTLM();
        f4 = pdfContentByte.getYTLM();
        boolean bl3 = false;
        float f13 = 0.0f;
        Iterator iterator = pdfLine.iterator();
        while (iterator.hasNext()) {
            Object object;
            Serializable serializable;
            Object object2;
            float f14;
            PdfChunk pdfChunk = (PdfChunk)iterator.next();
            Color color = pdfChunk.b();
            float f15 = 1.0f;
            if (n5 <= n4) {
                f14 = bl2 ? pdfChunk.getWidthCorrected(f9, f8) : pdfChunk.c();
                if (pdfChunk.d()) {
                    Object object3;
                    float f16;
                    float f17;
                    float f18;
                    DrawInterface drawInterface;
                    Object[] objectArray2;
                    object2 = pdfLine.getChunk(n5 + 1);
                    if (pdfChunk.e()) {
                        f14 = f10;
                        objectArray2 = (Object[])pdfChunk.a("SEPARATOR");
                        drawInterface = (DrawInterface)objectArray2[0];
                        serializable = (Boolean)objectArray2[1];
                        f18 = pdfChunk.a().a();
                        f17 = pdfChunk.a().b().getFontDescriptor(1, f18);
                        f16 = pdfChunk.a().b().getFontDescriptor(3, f18);
                        if (serializable.booleanValue()) {
                            drawInterface.draw(pdfContentByte2, f12, f4 + f16, f12 + pdfLine.getOriginalWidth(), f17 - f16, f4);
                        } else {
                            drawInterface.draw(pdfContentByte2, f3, f4 + f16, f3 + f14, f17 - f16, f4);
                        }
                    }
                    if (pdfChunk.h()) {
                        objectArray2 = (Object[])pdfChunk.a("TAB");
                        drawInterface = (DrawInterface)objectArray2[0];
                        f13 = ((Float)objectArray2[1]).floatValue() + ((Float)objectArray2[3]).floatValue();
                        float f19 = pdfChunk.a().a();
                        f18 = pdfChunk.a().b().getFontDescriptor(1, f19);
                        f17 = pdfChunk.a().b().getFontDescriptor(3, f19);
                        if (f13 > f3) {
                            drawInterface.draw(pdfContentByte2, f3, f4 + f17, f13, f18 - f17, f4);
                        }
                        f16 = f3;
                        f3 = f13;
                        f13 = f16;
                    }
                    if (pdfChunk.b("BACKGROUND")) {
                        pdfContentByte2.saveState();
                        float f20 = f5;
                        if (object2 != null && ((PdfChunk)object2).b("BACKGROUND")) {
                            f20 = 0.0f;
                        }
                        if (object2 == null) {
                            f20 += f6;
                        }
                        float f21 = pdfChunk.a().a();
                        float f22 = pdfChunk.a().b().getFontDescriptor(1, f21);
                        f18 = pdfChunk.a().b().getFontDescriptor(3, f21);
                        Object[] objectArray3 = (Object[])pdfChunk.a("BACKGROUND");
                        pdfContentByte2.setColorFill((Color)objectArray3[0]);
                        float[] fArray = (float[])objectArray3[1];
                        pdfContentByte2.rectangle(f3 - fArray[0], f4 + f18 - fArray[1] + pdfChunk.getTextRise(), f14 - f20 + fArray[0] + fArray[2], f22 - f18 + fArray[1] + fArray[3]);
                        pdfContentByte2.fill();
                        pdfContentByte2.setGrayFill(0.0f);
                        pdfContentByte2.restoreState();
                    }
                    if (pdfChunk.b("UNDERLINE")) {
                        Object[][] objectArray4;
                        float f23 = f5;
                        if (object2 != null && ((PdfChunk)object2).b("UNDERLINE")) {
                            f23 = 0.0f;
                        }
                        if (object2 == null) {
                            f23 += f6;
                        }
                        Object[][] objectArray5 = objectArray4 = (Object[][])pdfChunk.a("UNDERLINE");
                        int n6 = objectArray4.length;
                        for (int i2 = 0; i2 < n6; ++i2) {
                            Object[] objectArray6 = objectArray5[i2];
                            object3 = (Color)objectArray6[0];
                            object = (float[])objectArray6[1];
                            if (object3 == null) {
                                object3 = color;
                            }
                            if (object3 != null) {
                                pdfContentByte2.setColorStroke((Color)object3);
                            }
                            float f24 = pdfChunk.a().a();
                            pdfContentByte2.setLineWidth(object[0] + f24 * object[1]);
                            float f25 = object[2] + f24 * object[3];
                            int n7 = (int)object[4];
                            if (n7 != 0) {
                                pdfContentByte2.setLineCap(n7);
                            }
                            pdfContentByte2.moveTo(f3, f4 + f25);
                            pdfContentByte2.lineTo(f3 + f14 - f23, f4 + f25);
                            pdfContentByte2.stroke();
                            if (object3 != null) {
                                pdfContentByte2.resetGrayStroke();
                            }
                            if (n7 == 0) continue;
                            pdfContentByte2.setLineCap(0);
                        }
                        pdfContentByte2.setLineWidth(1.0f);
                    }
                    if (pdfChunk.b("ACTION")) {
                        float f26 = f5;
                        if (object2 != null && ((PdfChunk)object2).b("ACTION")) {
                            f26 = 0.0f;
                        }
                        if (object2 == null) {
                            f26 += f6;
                        }
                        pdfContentByte.a(new PdfAnnotation(this.writer, f3, f4, f3 + f14 - f26, f4 + pdfChunk.a().a(), (PdfAction)pdfChunk.a("ACTION")));
                    }
                    if (pdfChunk.b("REMOTEGOTO")) {
                        float f27 = f5;
                        if (object2 != null && ((PdfChunk)object2).b("REMOTEGOTO")) {
                            f27 = 0.0f;
                        }
                        if (object2 == null) {
                            f27 += f6;
                        }
                        Object[] objectArray7 = (Object[])pdfChunk.a("REMOTEGOTO");
                        object3 = (String)objectArray7[0];
                        if (objectArray7[1] instanceof String) {
                            this.a((String)object3, (String)objectArray7[1], f3, f4, f3 + f14 - f27, f4 + pdfChunk.a().a());
                        } else {
                            this.a((String)object3, (Integer)objectArray7[1], f3, f4, f3 + f14 - f27, f4 + pdfChunk.a().a());
                        }
                    }
                    if (pdfChunk.b("LOCALGOTO")) {
                        float f28 = f5;
                        if (object2 != null && ((PdfChunk)object2).b("LOCALGOTO")) {
                            f28 = 0.0f;
                        }
                        if (object2 == null) {
                            f28 += f6;
                        }
                        this.a((String)pdfChunk.a("LOCALGOTO"), f3, f4, f3 + f14 - f28, f4 + pdfChunk.a().a());
                    }
                    if (pdfChunk.b("LOCALDESTINATION")) {
                        if (object2 != null) {
                            ((PdfChunk)object2).b("LOCALDESTINATION");
                        }
                        this.a((String)pdfChunk.a("LOCALDESTINATION"), new PdfDestination(0, f3, f4 + pdfChunk.a().a(), 0.0f));
                    }
                    if (pdfChunk.b("GENERICTAG")) {
                        float f29 = f5;
                        if (object2 != null && ((PdfChunk)object2).b("GENERICTAG")) {
                            f29 = 0.0f;
                        }
                        if (object2 == null) {
                            f29 += f6;
                        }
                        Rectangle rectangle = new Rectangle(f3, f4, f3 + f14 - f29, f4 + pdfChunk.a().a());
                        object3 = this.writer.getPageEvent();
                        if (object3 != null) {
                            object3.onGenericTag(this.writer, this, rectangle, (String)pdfChunk.a("GENERICTAG"));
                        }
                    }
                    if (pdfChunk.b("PDFANNOTATION")) {
                        float f30 = f5;
                        if (object2 != null && ((PdfChunk)object2).b("PDFANNOTATION")) {
                            f30 = 0.0f;
                        }
                        if (object2 == null) {
                            f30 += f6;
                        }
                        float f31 = pdfChunk.a().a();
                        float f32 = pdfChunk.a().b().getFontDescriptor(1, f31);
                        float f33 = pdfChunk.a().b().getFontDescriptor(3, f31);
                        PdfAnnotation pdfAnnotation = PdfFormField.shallowDuplicate((PdfAnnotation)pdfChunk.a("PDFANNOTATION"));
                        pdfAnnotation.put(PdfName.RECT, new PdfRectangle(f3, f4 + f33, f3 + f14 - f30, f4 + f32));
                        pdfContentByte.a(pdfAnnotation);
                    }
                    float[] fArray = (float[])pdfChunk.a("SKEW");
                    Float f34 = (Float)pdfChunk.a("HSCALE");
                    if (fArray != null || f34 != null) {
                        float f35 = 0.0f;
                        float f36 = 0.0f;
                        if (fArray != null) {
                            f35 = fArray[0];
                            f36 = fArray[1];
                        }
                        if (f34 != null) {
                            f15 = f34.floatValue();
                        }
                        pdfContentByte.setTextMatrix(f15, f35, f36, 1.0f, f3, f4);
                    }
                    if (pdfChunk.b("CHAR_SPACING")) {
                        Float f37 = (Float)pdfChunk.a("CHAR_SPACING");
                        pdfContentByte.setCharacterSpacing(f37.floatValue());
                    }
                    if (pdfChunk.i()) {
                        Image image = pdfChunk.j();
                        float[] fArray2 = image.matrix();
                        float[] fArray3 = fArray2;
                        fArray2[4] = f3 + pdfChunk.k() - fArray3[4];
                        fArray3[5] = f4 + pdfChunk.l() - fArray3[5];
                        pdfContentByte2.addImage(image, fArray3[0], fArray3[1], fArray3[2], fArray3[3], fArray3[4], fArray3[5]);
                        pdfContentByte.moveText(f3 + f5 + image.getScaledWidth() - pdfContentByte.getXTLM(), 0.0f);
                    }
                }
                f3 += f14;
                ++n5;
            }
            if (pdfChunk.a().compareTo(j2) != 0) {
                j2 = pdfChunk.a();
                pdfContentByte.setFontAndSize(j2.b(), j2.a());
            }
            f14 = 0.0f;
            object2 = (Object[])pdfChunk.a("TEXTRENDERMODE");
            int n8 = 0;
            float f38 = 1.0f;
            serializable = null;
            Float f39 = (Float)pdfChunk.a("SUBSUPSCRIPT");
            if (object2 != null) {
                n8 = (Integer)object2[0] & 3;
                if (n8 != 0) {
                    pdfContentByte.setTextRenderingMode(n8);
                }
                if (n8 == 1 || n8 == 2) {
                    f38 = ((Float)object2[1]).floatValue();
                    if (f38 != 1.0f) {
                        pdfContentByte.setLineWidth(f38);
                    }
                    if ((serializable = (Color)object2[2]) == null) {
                        serializable = color;
                    }
                    if (serializable != null) {
                        pdfContentByte.setColorStroke((Color)serializable);
                    }
                }
            }
            if (f39 != null) {
                f14 = f39.floatValue();
            }
            if (color != null) {
                pdfContentByte.setColorFill(color);
            }
            if (f14 != 0.0f) {
                pdfContentByte.setTextRise(f14);
            }
            if (pdfChunk.i()) {
                bl3 = true;
            } else if (!pdfChunk.g()) {
                if (pdfChunk.f()) {
                    PdfTextArray pdfTextArray = new PdfTextArray();
                    pdfTextArray.add(-f10 * 1000.0f / pdfChunk.font.a() / f15);
                    pdfContentByte.showText(pdfTextArray);
                } else if (pdfChunk.h()) {
                    PdfTextArray pdfTextArray = new PdfTextArray();
                    pdfTextArray.add((f13 - f3) * 1000.0f / pdfChunk.font.a() / f15);
                    pdfContentByte.showText(pdfTextArray);
                } else if (bl2 && n2 > 0 && pdfChunk.m()) {
                    String string;
                    int n9;
                    if (f15 != f7) {
                        f7 = f15;
                        pdfContentByte.setWordSpacing(f8 / f15);
                        pdfContentByte.setCharacterSpacing(f9 / f15 + pdfContentByte.getCharacterSpacing());
                    }
                    if ((n9 = (string = pdfChunk.toString()).indexOf(32)) < 0) {
                        pdfContentByte.showText(string);
                    } else {
                        float f40 = -f8 * 1000.0f / pdfChunk.font.a() / f15;
                        object = new PdfTextArray();
                        if (LayoutProcessor.isEnabled() && LayoutProcessor.isSet(1)) {
                            ((PdfTextArray)object).setRTL(true);
                        }
                        ((PdfTextArray)object).add(string.substring(0, n9));
                        int n10 = n9;
                        while ((n9 = string.indexOf(32, n10 + 1)) >= 0) {
                            ((PdfTextArray)object).add(f40);
                            ((PdfTextArray)object).add(string.substring(n10, n9));
                            n10 = n9;
                        }
                        ((PdfTextArray)object).add(f40);
                        ((PdfTextArray)object).add(string.substring(n10));
                        pdfContentByte.showText((PdfTextArray)object);
                    }
                } else {
                    if (bl2 && f15 != f7) {
                        f7 = f15;
                        pdfContentByte.setWordSpacing(f8 / f15);
                        pdfContentByte.setCharacterSpacing(f9 / f15 + pdfContentByte.getCharacterSpacing());
                    }
                    pdfContentByte.showText(pdfChunk.toString());
                }
            }
            if (f14 != 0.0f) {
                pdfContentByte.setTextRise(0.0f);
            }
            if (color != null) {
                pdfContentByte.resetRGBColorFill();
            }
            if (n8 != 0) {
                pdfContentByte.setTextRenderingMode(0);
            }
            if (serializable != null) {
                pdfContentByte.resetRGBColorStroke();
            }
            if (f38 != 1.0f) {
                pdfContentByte.setLineWidth(1.0f);
            }
            if (pdfChunk.b("SKEW") || pdfChunk.b("HSCALE")) {
                bl3 = true;
                pdfContentByte.setTextMatrix(f3, f4);
            }
            if (!pdfChunk.b("CHAR_SPACING")) continue;
            pdfContentByte.setCharacterSpacing(f9);
        }
        if (bl2) {
            pdfContentByte.setWordSpacing(0.0f);
            pdfContentByte.setCharacterSpacing(0.0f);
            if (pdfLine.isNewlineSplit()) {
                f5 = 0.0f;
            }
        }
        if (bl3) {
            pdfContentByte.moveText(f12 - pdfContentByte.getXTLM(), 0.0f);
        }
        objectArray[0] = j2;
        objectArray[1] = Float.valueOf(f5);
    }

    protected float indentLeft() {
        PdfDocument pdfDocument = this;
        return pdfDocument.left(pdfDocument.indentation.a + this.indentation.c + this.indentation.d + this.indentation.b);
    }

    protected float indentRight() {
        PdfDocument pdfDocument = this;
        return pdfDocument.right(pdfDocument.indentation.e + this.indentation.f + this.indentation.g);
    }

    protected float indentTop() {
        PdfDocument pdfDocument = this;
        return pdfDocument.top(pdfDocument.indentation.h);
    }

    final float a() {
        PdfDocument pdfDocument = this;
        return pdfDocument.bottom(pdfDocument.indentation.i);
    }

    protected void addSpacing(float f2, float f3, Font font) {
        if (f2 == 0.0f) {
            return;
        }
        if (this.c) {
            return;
        }
        if (this.currentHeight + this.line.a() + this.leading > this.indentTop() - this.a()) {
            return;
        }
        this.leading = f2;
        this.carriageReturn();
        if (font.isUnderlined() || font.isStrikethru()) {
            font = new Font(font);
            int n2 = font.getStyle();
            n2 &= 0xFFFFFFFB;
            font.setStyle(n2 &= 0xFFFFFFF7);
        }
        Chunk chunk = new Chunk(" ", font);
        chunk.process(this);
        this.carriageReturn();
        this.leading = f3;
    }

    protected PdfInfo getInfo() {
        return this.info;
    }

    final a a(PdfIndirectReference pdfObject) {
        pdfObject = new a((PdfIndirectReference)pdfObject, this.writer);
        if (this.rootOutline.getKids().size() > 0) {
            ((PdfDictionary)pdfObject).put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            ((PdfDictionary)pdfObject).put(PdfName.OUTLINES, this.rootOutline.indirectReference());
        }
        this.writer.n().addToCatalog((PdfDictionary)pdfObject);
        this.viewerPreferences.addToCatalog((PdfDictionary)pdfObject);
        if (this.pageLabels != null) {
            ((PdfDictionary)pdfObject).put(PdfName.PAGELABELS, this.pageLabels.a(this.writer));
        }
        Object object = this;
        PdfWriter pdfWriter = this.writer;
        HashMap<String, PdfIndirectReference> hashMap = this.documentFileAttachment;
        HashMap<String, PdfIndirectReference> hashMap2 = ((PdfDocument)object).documentLevelJS;
        Object object2 = this.localDestinations;
        object = pdfObject;
        if (!(((AbstractMap)object2).isEmpty() && hashMap2.isEmpty() && hashMap.isEmpty())) {
            try {
                PdfObject pdfObject2;
                PdfDictionary pdfDictionary = new PdfDictionary();
                if (!((AbstractMap)object2).isEmpty()) {
                    pdfObject2 = new PdfArray();
                    for (Map.Entry entry : ((TreeMap)object2).entrySet()) {
                        String string = (String)entry.getKey();
                        Object[] objectArray = (Object[])entry.getValue();
                        if (objectArray[2] == null) continue;
                        PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)objectArray[1];
                        ((PdfArray)pdfObject2).add(new PdfString(string, null));
                        ((PdfArray)pdfObject2).add(pdfIndirectReference);
                    }
                    if (((PdfArray)pdfObject2).size() > 0) {
                        object2 = new PdfDictionary();
                        ((PdfDictionary)object2).put(PdfName.NAMES, pdfObject2);
                        pdfDictionary.put(PdfName.DESTS, pdfWriter.addToBody((PdfObject)object2).getIndirectReference());
                    }
                }
                if (!hashMap2.isEmpty()) {
                    pdfObject2 = PdfNameTree.writeTree(hashMap2, pdfWriter);
                    pdfDictionary.put(PdfName.JAVASCRIPT, pdfWriter.addToBody(pdfObject2).getIndirectReference());
                }
                if (!hashMap.isEmpty()) {
                    pdfDictionary.put(PdfName.EMBEDDEDFILES, pdfWriter.addToBody(PdfNameTree.writeTree(hashMap, pdfWriter)).getIndirectReference());
                }
                if (pdfDictionary.size() > 0) {
                    ((PdfDictionary)object).put(PdfName.NAMES, pdfWriter.addToBody(pdfDictionary).getIndirectReference());
                }
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
        if (this.openActionName != null) {
            PdfDocument pdfDocument = this;
            object = pdfDocument.c(pdfDocument.openActionName);
            ((a)pdfObject).a((PdfAction)object);
        } else if (this.openActionAction != null) {
            ((a)pdfObject).a(this.openActionAction);
        }
        if (this.additionalActions != null) {
            object2 = this.additionalActions;
            object = pdfObject;
            try {
                ((PdfDictionary)object).put(PdfName.AA, ((a)object).a.addToBody((PdfObject)object2).getIndirectReference());
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        if (this.collection != null) {
            ((PdfDictionary)pdfObject).put(PdfName.COLLECTION, this.collection);
        }
        if (this.a.hasValidAcroForm()) {
            try {
                ((PdfDictionary)pdfObject).put(PdfName.ACROFORM, this.writer.addToBody(this.a.getAcroForm()).getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
        return pdfObject;
    }

    public PdfOutline getRootOutline() {
        return this.rootOutline;
    }

    private void a(PdfOutline pdfOutline) {
        Object object = pdfOutline.getKids();
        PdfOutline pdfOutline2 = pdfOutline.parent();
        if (object.isEmpty()) {
            if (pdfOutline2 != null) {
                PdfOutline pdfOutline3 = pdfOutline2;
                pdfOutline3.a(pdfOutline3.a() + 1);
                return;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                PdfOutline pdfOutline4 = (PdfOutline)object.next();
                this.a(pdfOutline4);
            }
            if (pdfOutline2 != null) {
                if (pdfOutline.isOpen()) {
                    pdfOutline2.a(pdfOutline.a() + pdfOutline2.a() + 1);
                    return;
                }
                PdfOutline pdfOutline5 = pdfOutline2;
                pdfOutline5.a(pdfOutline5.a() + 1);
                PdfOutline pdfOutline6 = pdfOutline;
                pdfOutline6.a(-pdfOutline6.a());
            }
        }
    }

    private void b(PdfOutline pdfOutline) {
        pdfOutline.setIndirectReference(this.writer.getPdfIndirectReference());
        if (pdfOutline.parent() != null) {
            pdfOutline.put(PdfName.PARENT, pdfOutline.parent().indirectReference());
        }
        java.util.List<PdfOutline> list = pdfOutline.getKids();
        int n2 = list.size();
        for (PdfOutline pdfOutline2 : list) {
            this.b(pdfOutline2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                list.get(i2).put(PdfName.PREV, list.get(i2 - 1).indirectReference());
            }
            if (i2 >= n2 - 1) continue;
            list.get(i2).put(PdfName.NEXT, list.get(i2 + 1).indirectReference());
        }
        if (n2 > 0) {
            pdfOutline.put(PdfName.FIRST, list.get(0).indirectReference());
            pdfOutline.put(PdfName.LAST, list.get(n2 - 1).indirectReference());
        }
        Iterator<PdfOutline> iterator = list.iterator();
        while (iterator.hasNext()) {
            PdfOutline pdfOutline2;
            PdfOutline pdfOutline3 = pdfOutline2 = iterator.next();
            this.writer.addToBody((PdfObject)pdfOutline3, pdfOutline3.indirectReference());
        }
    }

    final void a(int n2) {
        this.viewerPreferences.setViewerPreferences(n2);
    }

    final void a(PdfName pdfName, PdfObject pdfObject) {
        this.viewerPreferences.addViewerPreference(pdfName, pdfObject);
    }

    final void a(PdfPageLabels pdfPageLabels) {
        this.pageLabels = pdfPageLabels;
    }

    final void a(String object, float f2, float f3, float f4, float f5) {
        object = this.c((String)object);
        this.a.addPlainAnnotation(new PdfAnnotation(this.writer, f2, f3, f4, f5, (PdfAction)object));
    }

    final void a(String string, String string2, float f2, float f3, float f4, float f5) {
        this.a.addPlainAnnotation(new PdfAnnotation(this.writer, f2, f3, f4, f5, new PdfAction(string, string2)));
    }

    final void a(String string, int n2, float f2, float f3, float f4, float f5) {
        this.a(new PdfAnnotation(this.writer, f2, f3, f4, f5, new PdfAction(string, n2)));
    }

    final void a(PdfAction pdfAction, float f2, float f3, float f4, float f5) {
        this.a(new PdfAnnotation(this.writer, f2, f3, f4, f5, pdfAction));
    }

    private PdfAction c(String string) {
        PdfAction pdfAction;
        Object[] objectArray = this.localDestinations.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        if (objectArray[0] == null) {
            if (objectArray[1] == null) {
                objectArray[1] = this.writer.getPdfIndirectReference();
            }
            pdfAction = new PdfAction((PdfIndirectReference)objectArray[1]);
            objectArray[0] = pdfAction;
            this.localDestinations.put(string, objectArray);
        } else {
            pdfAction = (PdfAction)objectArray[0];
        }
        return pdfAction;
    }

    final boolean a(String string, PdfDestination pdfDestination) {
        Object[] objectArray = this.localDestinations.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        if (objectArray[2] != null) {
            return false;
        }
        objectArray[2] = pdfDestination;
        this.localDestinations.put(string, objectArray);
        if (!pdfDestination.hasPage()) {
            pdfDestination.addPage(this.writer.m());
        }
        return true;
    }

    final void a(PdfAction pdfAction) {
        if (pdfAction.get(PdfName.JS) == null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("only.javascript.actions.are.allowed"));
        }
        try {
            this.documentLevelJS.put(SIXTEEN_DIGITS.format(this.b++), this.writer.addToBody(pdfAction).getIndirectReference());
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    final void a(String string, PdfAction pdfAction) {
        if (pdfAction.get(PdfName.JS) == null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("only.javascript.actions.are.allowed"));
        }
        try {
            this.documentLevelJS.put(string, this.writer.addToBody(pdfAction).getIndirectReference());
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    final HashMap<String, PdfIndirectReference> b() {
        return this.documentLevelJS;
    }

    final void a(String string, PdfFileSpecification pdfFileSpecification) {
        Object object;
        if (string == null) {
            object = (PdfString)pdfFileSpecification.get(PdfName.DESC);
            string = object == null ? "" : PdfEncodings.convertToString(((PdfObject)object).getBytes(), null);
        }
        pdfFileSpecification.addDescription(string, true);
        if (string.length() == 0) {
            string = "Unnamed";
        }
        object = PdfEncodings.convertToString(((PdfObject)new PdfString(string, "UnicodeBig")).getBytes(), null);
        int n2 = 0;
        while (this.documentFileAttachment.containsKey(object)) {
            object = PdfEncodings.convertToString(((PdfObject)new PdfString(string + " " + ++n2, "UnicodeBig")).getBytes(), null);
        }
        this.documentFileAttachment.put((String)object, pdfFileSpecification.getReference());
    }

    final HashMap<String, PdfIndirectReference> c() {
        return this.documentFileAttachment;
    }

    final void a(String string) {
        this.openActionName = string;
        this.openActionAction = null;
    }

    final void b(PdfAction pdfAction) {
        this.openActionAction = pdfAction;
        this.openActionName = null;
    }

    final void a(PdfName pdfName, PdfAction pdfAction) {
        if (this.additionalActions == null) {
            this.additionalActions = new PdfDictionary();
        }
        if (pdfAction == null) {
            this.additionalActions.remove(pdfName);
        } else {
            this.additionalActions.put(pdfName, pdfAction);
        }
        if (this.additionalActions.size() == 0) {
            this.additionalActions = null;
        }
    }

    public void setCollection(PdfCollection pdfCollection) {
        this.collection = pdfCollection;
    }

    final void a(PdfAnnotation pdfAnnotation) {
        this.c = false;
        this.a.addAnnotation(pdfAnnotation);
    }

    final int d() {
        return this.markPoint;
    }

    final void e() {
        ++this.markPoint;
    }

    final void a(Rectangle rectangle) {
        this.a("crop", rectangle);
    }

    final void a(String string, Rectangle rectangle) {
        if (rectangle == null) {
            this.boxSize.remove(string);
            return;
        }
        this.boxSize.put(string, new PdfRectangle(rectangle));
    }

    protected void setNewPageSizeAndMargins() {
        this.pageSize = this.nextPageSize;
        if (this.marginMirroring && (this.getPageNumber() & 1) == 0) {
            this.marginRight = this.nextMarginLeft;
            this.marginLeft = this.nextMarginRight;
        } else {
            this.marginLeft = this.nextMarginLeft;
            this.marginRight = this.nextMarginRight;
        }
        if (this.marginMirroringTopBottom && (this.getPageNumber() & 1) == 0) {
            this.marginTop = this.nextMarginBottom;
            this.marginBottom = this.nextMarginTop;
            return;
        }
        this.marginTop = this.nextMarginTop;
        this.marginBottom = this.nextMarginBottom;
    }

    final Rectangle b(String object) {
        if ((object = this.thisBoxSize.get(object)) != null) {
            return ((PdfRectangle)object).getRectangle();
        }
        return null;
    }

    final void a(boolean bl2) {
        this.c = bl2;
    }

    final boolean f() {
        return this.writer == null || this.writer.getDirectContent().a() == 0 && this.writer.getDirectContentUnder().a() == 0 && (this.c || this.writer.isPaused());
    }

    final void b(int n2) {
        if (n2 > 0) {
            this.duration = n2;
            return;
        }
        this.duration = -1;
    }

    final void a(PdfTransition pdfTransition) {
        this.transition = pdfTransition;
    }

    final void b(PdfName pdfName, PdfAction pdfAction) {
        if (this.pageAA == null) {
            this.pageAA = new PdfDictionary();
        }
        this.pageAA.put(pdfName, pdfAction);
    }

    final void a(Image image) {
        this.thumb = this.writer.a(this.writer.addDirectImageSimple(image));
    }

    final e g() {
        return this.pageResources;
    }

    final boolean h() {
        return this.strictImageSequence;
    }

    final void b(boolean bl2) {
        this.strictImageSequence = bl2;
    }

    public void clearTextWrap() {
        float f2 = this.imageEnd - this.currentHeight;
        if (this.line != null) {
            f2 += this.line.a();
        }
        if (this.imageEnd > -1.0f && f2 > 0.0f) {
            this.carriageReturn();
            this.currentHeight += f2;
        }
    }

    protected void add(Image image) {
        if (image.hasAbsoluteY()) {
            this.graphics.addImage(image);
            this.c = false;
            return;
        }
        if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.getScaledHeight() < this.a()) {
            if (!this.strictImageSequence && this.imageWait == null) {
                this.imageWait = image;
                return;
            }
            ((Document)this).newPage();
            if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.getScaledHeight() < this.a()) {
                this.imageWait = image;
                return;
            }
        }
        this.c = false;
        if (image == this.imageWait) {
            this.imageWait = null;
        }
        boolean bl2 = (image.getAlignment() & 4) == 4 && (image.getAlignment() & 1) != 1;
        boolean bl3 = (image.getAlignment() & 8) == 8;
        float f2 = this.leading / 2.0f;
        if (bl2) {
            f2 += this.leading;
        }
        float f3 = this.indentTop() - this.currentHeight - image.getScaledHeight() - f2;
        float[] fArray = image.matrix();
        float f4 = this.indentLeft() - fArray[4];
        if ((image.getAlignment() & 2) == 2) {
            f4 = this.indentRight() - image.getScaledWidth() - fArray[4];
        }
        if ((image.getAlignment() & 1) == 1) {
            f4 = this.indentLeft() + (this.indentRight() - this.indentLeft() - image.getScaledWidth()) / 2.0f - fArray[4];
        }
        if (image.hasAbsoluteX()) {
            f4 = image.getAbsoluteX();
        }
        if (bl2) {
            if (this.imageEnd < 0.0f || this.imageEnd < this.currentHeight + image.getScaledHeight() + f2) {
                this.imageEnd = this.currentHeight + image.getScaledHeight() + f2;
            }
            if ((image.getAlignment() & 2) == 2) {
                this.indentation.g += image.getScaledWidth() + image.getIndentationLeft();
            } else {
                this.indentation.d += image.getScaledWidth() + image.getIndentationRight();
            }
        } else {
            f4 = (image.getAlignment() & 2) == 2 ? (f4 -= image.getIndentationRight()) : ((image.getAlignment() & 1) == 1 ? (f4 += image.getIndentationLeft() - image.getIndentationRight()) : (f4 += image.getIndentationLeft()));
        }
        this.graphics.addImage(image, fArray[0], fArray[1], fArray[2], fArray[3], f4, f3 - fArray[5]);
        if (!bl2 && !bl3) {
            this.currentHeight += image.getScaledHeight() + f2;
            this.flushLines();
            this.text.moveText(0.0f, -(image.getScaledHeight() + f2));
            this.newLine();
        }
    }

    private void a(PdfPTable pdfPTable) {
        ColumnText columnText = new ColumnText(this.writer.getDirectContent());
        if (pdfPTable.getKeepTogether() && !this.a(pdfPTable, 0.0f) && this.currentHeight > 0.0f) {
            ((Document)this).newPage();
        }
        if (this.currentHeight > 0.0f || pdfPTable.isSkipFirstHeader()) {
            Paragraph paragraph = new Paragraph();
            ((Phrase)paragraph).setLeading(0.0f);
            columnText.addElement(paragraph);
        }
        columnText.addElement(pdfPTable);
        boolean bl2 = pdfPTable.isHeadersInEvent();
        pdfPTable.setHeadersInEvent(true);
        int n2 = 0;
        while (true) {
            columnText.setSimpleColumn(this.indentLeft(), this.a(), this.indentRight(), this.indentTop() - this.currentHeight);
            int n3 = columnText.go();
            if ((n3 & 1) != 0) {
                this.text.moveText(0.0f, columnText.getYLine() - this.indentTop() + this.currentHeight);
                this.currentHeight = this.indentTop() - columnText.getYLine();
                break;
            }
            n2 = this.indentTop() - this.currentHeight == columnText.getYLine() ? ++n2 : 0;
            if (n2 == 3) {
                ((Document)this).add(new Paragraph("ERROR: Infinite table loop"));
                break;
            }
            ((Document)this).newPage();
        }
        pdfPTable.setHeadersInEvent(bl2);
    }

    private boolean a(PdfPTable pdfPTable, float f2) {
        if (!pdfPTable.isLockedWidth()) {
            f2 = (this.indentRight() - this.indentLeft()) * pdfPTable.getWidthPercentage() / 100.0f;
            pdfPTable.setTotalWidth(f2);
        }
        this.ensureNewLine();
        return pdfPTable.getTotalHeight() + (this.currentHeight > 0.0f ? pdfPTable.spacingBefore() : 0.0f) <= this.indentTop() - this.currentHeight - this.a();
    }

    protected void analyzeRow(java.util.List<java.util.List<PdfCell>> object, RenderingContext renderingContext) {
        renderingContext.e = this.a();
        Object object2 = object.get(0);
        int n2 = 1;
        object2 = object2.iterator();
        while (object2.hasNext()) {
            PdfCell pdfCell = (PdfCell)object2.next();
            n2 = Math.max(renderingContext.currentRowspan(pdfCell), n2);
        }
        int n3 = n2 + 0;
        boolean bl2 = true;
        if (n3 == object.size()) {
            n3 = object.size() - 1;
            bl2 = false;
        }
        if (n3 < 0 || n3 >= object.size()) {
            return;
        }
        Object object3 = object.get(n3);
        object3 = object3.iterator();
        while (object3.hasNext()) {
            object = (PdfCell)object3.next();
            Rectangle rectangle = ((Rectangle)object).rectangle(renderingContext.a, this.a());
            if (bl2) {
                renderingContext.e = Math.max(renderingContext.e, rectangle.getTop());
                continue;
            }
            if (renderingContext.currentRowspan((PdfCell)object) != 1) continue;
            renderingContext.e = Math.max(renderingContext.e, rectangle.getBottom());
        }
    }

    protected boolean mayBeRemoved(java.util.List<PdfCell> object) {
        object = object.iterator();
        boolean bl2 = true;
        while (object.hasNext()) {
            PdfCell pdfCell = (PdfCell)object.next();
            bl2 &= pdfCell.c();
        }
        return bl2;
    }

    protected void consumeRowspan(java.util.List<PdfCell> object, RenderingContext renderingContext) {
        object = object.iterator();
        while (object.hasNext()) {
            PdfCell pdfCell = (PdfCell)object.next();
            renderingContext.consumeRowspan(pdfCell);
        }
    }

    protected java.util.List<java.util.List<PdfCell>> extractRows(java.util.List<PdfCell> object, RenderingContext object2) {
        int n2;
        int n3;
        object2 = null;
        ArrayList<java.util.List<PdfCell>> arrayList = new ArrayList<java.util.List<PdfCell>>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Object object3 = object.iterator();
        while (object3.hasNext()) {
            object = object3.next();
            n3 = 0;
            boolean bl2 = !object3.hasNext();
            int n4 = n2 = !object3.hasNext() ? 1 : 0;
            if (object2 != null && ((Rectangle)object).getLeft() <= ((Rectangle)object2).getLeft()) {
                bl2 = true;
                n2 = 0;
            }
            if (n2 != 0) {
                arrayList2.add(object);
                n3 = 1;
            }
            if (bl2) {
                if (!arrayList2.isEmpty()) {
                    arrayList.add(arrayList2);
                }
                arrayList2 = new ArrayList();
            }
            if (n3 == 0) {
                arrayList2.add(object);
            }
            object2 = object;
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(arrayList2);
        }
        for (n3 = arrayList.size() - 1; n3 >= 0; --n3) {
            java.util.List list = (java.util.List)arrayList.get(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                object = (PdfCell)list.get(n2);
                int n5 = ((PdfCell)object).rowspan();
                for (int i2 = 1; i2 < n5 && arrayList.size() < n3 + i2; ++i2) {
                    object3 = (java.util.List)arrayList.get(n3 + i2);
                    if (object3.size() <= n2) continue;
                    object3.add(n2, object);
                }
            }
        }
        return arrayList;
    }

    protected void renderCells(RenderingContext renderingContext, java.util.List object, boolean bl2) {
        Iterator iterator;
        if (bl2) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                PdfCell pdfCell = (PdfCell)iterator.next();
                if (pdfCell.a() || !(((Rectangle)pdfCell).getBottom() < this.a())) continue;
                return;
            }
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            Rectangle rectangle;
            Rectangle rectangle2 = (PdfCell)iterator.next();
            if (renderingContext.isCellRenderedOnPage((PdfCell)rectangle2, this.getPageNumber())) continue;
            float f2 = 0.0f;
            if (renderingContext.numCellRendered((PdfCell)rectangle2) > 0) {
                f2 = 1.0f;
            }
            this.lines = rectangle2.getLines(renderingContext.a, this.a() - f2);
            if (this.lines != null && !this.lines.isEmpty()) {
                f2 = rectangle2.getTop(renderingContext.a - renderingContext.b);
                this.text.moveText(0.0f, f2);
                float f3 = this.flushLines() - f2;
                this.text.moveText(0.0f, f3);
                if (renderingContext.b + f3 > this.currentHeight) {
                    this.currentHeight = renderingContext.b + f3;
                }
                renderingContext.cellRendered((PdfCell)rectangle2, this.getPageNumber());
            }
            f2 = Math.max(((Rectangle)rectangle2).getBottom(), this.a());
            Rectangle rectangle3 = renderingContext.table.rectangle(renderingContext.a, this.a());
            f2 = Math.max(rectangle3.getBottom(), f2);
            rectangle3 = ((Rectangle)rectangle2).rectangle(rectangle3.getTop(), f2);
            if (rectangle.getHeight() > 0.0f) {
                renderingContext.d = f2;
                renderingContext.c.rectangle(rectangle3);
            }
            object = rectangle2.getImages(renderingContext.a, this.a());
            object = object.iterator();
            while (object.hasNext()) {
                rectangle2 = object.next();
                rectangle2 = (Image)rectangle2;
                this.graphics.addImage((Image)rectangle2);
            }
        }
    }

    final float a(Table rectangle) {
        rectangle = new PdfTable((Table)rectangle, this.indentLeft(), this.indentRight(), this.indentTop() - this.currentHeight);
        return rectangle.getBottom();
    }

    protected void doFooter() {
        if (this.footer == null) {
            return;
        }
        float f2 = this.indentation.a;
        float f3 = this.indentation.e;
        float f4 = this.indentation.c;
        float f5 = this.indentation.d;
        float f6 = this.indentation.g;
        this.indentation.e = 0.0f;
        this.indentation.a = 0.0f;
        this.indentation.c = 0.0f;
        this.indentation.d = 0.0f;
        this.indentation.g = 0.0f;
        this.footer.setPageNumber(this.pageN);
        this.leading = this.footer.paragraph().getTotalLeading();
        PdfDocument pdfDocument = this;
        ((Document)pdfDocument).add(pdfDocument.footer.paragraph());
        this.indentation.i = this.currentHeight;
        this.text.moveText(this.left(), this.a());
        this.flushLines();
        this.text.moveText(-this.left(), -this.bottom());
        PdfDocument pdfDocument2 = this;
        this.footer.setTop(pdfDocument2.bottom(pdfDocument2.currentHeight));
        this.footer.setBottom(this.bottom() - 0.75f * this.leading);
        this.footer.setLeft(this.left());
        this.footer.setRight(this.right());
        this.graphics.rectangle(this.footer);
        this.indentation.i = this.currentHeight + this.leading * 2.0f;
        this.currentHeight = 0.0f;
        this.indentation.a = f2;
        this.indentation.e = f3;
        this.indentation.c = f4;
        this.indentation.d = f5;
        this.indentation.g = f6;
    }

    protected void doHeader() {
        if (this.header == null) {
            return;
        }
        float f2 = this.indentation.a;
        float f3 = this.indentation.e;
        float f4 = this.indentation.c;
        float f5 = this.indentation.d;
        float f6 = this.indentation.g;
        this.indentation.e = 0.0f;
        this.indentation.a = 0.0f;
        this.indentation.c = 0.0f;
        this.indentation.d = 0.0f;
        this.indentation.g = 0.0f;
        this.header.setPageNumber(this.pageN);
        this.leading = this.header.paragraph().getTotalLeading();
        this.text.moveText(0.0f, this.leading);
        PdfDocument pdfDocument = this;
        ((Document)pdfDocument).add(pdfDocument.header.paragraph());
        this.newLine();
        this.indentation.h = this.currentHeight - this.leading;
        this.header.setTop(this.top() + this.leading);
        this.header.setBottom(this.indentTop() + this.leading * 2.0f / 3.0f);
        this.header.setLeft(this.left());
        this.header.setRight(this.right());
        this.graphics.rectangle(this.header);
        this.flushLines();
        this.currentHeight = 0.0f;
        this.indentation.a = f2;
        this.indentation.e = f3;
        this.indentation.c = f4;
        this.indentation.d = f5;
        this.indentation.g = f6;
    }

    protected static class RenderingContext {
        float a = -1.0f;
        float b = -1.0f;
        PdfContentByte c = null;
        float d;
        float e;
        Map<PdfCell, Integer> f = new HashMap<PdfCell, Integer>();
        private Map<PdfCell, Integer> g = new HashMap<PdfCell, Integer>();
        private Map<Integer, Set<PdfCell>> h = new HashMap<Integer, Set<PdfCell>>();
        public PdfTable table;

        protected RenderingContext() {
        }

        public int consumeRowspan(PdfCell pdfCell) {
            if (pdfCell.rowspan() == 1) {
                return 1;
            }
            Integer n2 = this.f.get(pdfCell);
            if (n2 == null) {
                n2 = pdfCell.rowspan();
            }
            n2 = n2 - 1;
            this.f.put(pdfCell, n2);
            if (n2 <= 0) {
                return 1;
            }
            return n2;
        }

        public int currentRowspan(PdfCell pdfCell) {
            Integer n2 = this.f.get(pdfCell);
            if (n2 == null) {
                return pdfCell.rowspan();
            }
            return n2;
        }

        public int cellRendered(PdfCell pdfCell, int n3) {
            Integer n4 = this.g.get(pdfCell);
            n4 = n4 == null ? Integer.valueOf(1) : Integer.valueOf(n4 + 1);
            this.g.put(pdfCell, n4);
            Object object = n3;
            object = this.h.computeIfAbsent((Integer)object, n2 -> new HashSet());
            object.add(pdfCell);
            return n4;
        }

        public int numCellRendered(PdfCell object) {
            if ((object = this.g.get(object)) == null) {
                object = 0;
            }
            return (Integer)object;
        }

        public boolean isCellRenderedOnPage(PdfCell pdfCell, int n2) {
            Object object = n2;
            if ((object = this.h.get(object)) != null) {
                return object.contains(pdfCell);
            }
            return false;
        }
    }

    public static class Indentation {
        float a = 0.0f;
        float b = 0.0f;
        float c = 0.0f;
        float d = 0.0f;
        float e = 0.0f;
        float f = 0.0f;
        float g = 0.0f;
        float h = 0.0f;
        float i = 0.0f;
    }

    static final class a
    extends PdfDictionary {
        PdfWriter a;

        a(PdfIndirectReference pdfIndirectReference, PdfWriter pdfWriter) {
            super(CATALOG);
            this.a = pdfWriter;
            this.put(PdfName.PAGES, pdfIndirectReference);
        }

        final void a(PdfAction pdfAction) {
            this.put(PdfName.OPENACTION, pdfAction);
        }
    }

    public static class PdfInfo
    extends PdfDictionary {
        PdfInfo() {
        }
    }
}

