/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.OutputStreamEncryption;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPublicKeyRecipient;
import com.lowagie.text.pdf.PdfPublicKeySecurityHandler;
import com.lowagie.text.pdf.StandardDecryption;
import com.lowagie.text.pdf.crypto.ARCFOUREncryption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;

public class PdfEncryption {
    public static final int STANDARD_ENCRYPTION_40 = 2;
    public static final int STANDARD_ENCRYPTION_128 = 3;
    public static final int AES_128 = 4;
    private static final byte[] b = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private static final byte[] c = new byte[]{115, 65, 108, 84};
    private static final byte[] d = new byte[]{-1, -1, -1, -1};
    private byte[] e;
    private int f;
    private byte[] g;
    private byte[] h = new byte[5];
    private MessageDigest i;
    private byte[] j = new byte[32];
    byte[] a = new byte[32];
    protected PdfPublicKeySecurityHandler publicKeyHandler = null;
    private int k;
    private byte[] l;
    private static long m = System.currentTimeMillis();
    private int n;
    private ARCFOUREncryption o = new ARCFOUREncryption();
    private int p;
    private boolean q;
    private boolean r;
    private int s;

    public PdfEncryption() {
        try {
            this.i = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        this.publicKeyHandler = new PdfPublicKeySecurityHandler();
    }

    public PdfEncryption(PdfEncryption pdfEncryption) {
        this();
        this.g = (byte[])pdfEncryption.g.clone();
        this.j = (byte[])pdfEncryption.j.clone();
        this.a = (byte[])pdfEncryption.a.clone();
        this.k = pdfEncryption.k;
        if (pdfEncryption.l != null) {
            this.l = (byte[])pdfEncryption.l.clone();
        }
        this.n = pdfEncryption.n;
        this.p = pdfEncryption.p;
        this.q = pdfEncryption.q;
        this.r = pdfEncryption.r;
        this.publicKeyHandler = pdfEncryption.publicKeyHandler;
    }

    public void setCryptoMode(int n2, int n3) {
        this.s = n2;
        this.q = (n2 & 8) == 0;
        this.r = (n2 & 0x18) != 0;
        switch (n2 &= 7) {
            case 0: {
                this.q = true;
                this.r = false;
                this.p = 40;
                this.n = 2;
                return;
            }
            case 1: {
                this.r = false;
                this.p = n3 > 0 ? n3 : 128;
                this.n = 3;
                return;
            }
            case 2: {
                this.p = 128;
                this.n = 4;
                return;
            }
        }
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("no.valid.encryption.mode"));
    }

    public int getCryptoMode() {
        return this.s;
    }

    public boolean isMetadataEncrypted() {
        return this.q;
    }

    public boolean isEmbeddedFilesOnly() {
        return this.r;
    }

    private static byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        if (byArray == null) {
            System.arraycopy(b, 0, byArray2, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 32));
            if (byArray.length < 32) {
                System.arraycopy(b, 0, byArray2, byArray.length, 32 - byArray.length);
            }
        }
        return byArray2;
    }

    private byte[] a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[32];
        byArray2 = this.i.digest(byArray2);
        if (this.n == 3 || this.n == 4) {
            int n2;
            byte[] byArray4 = new byte[this.p / 8];
            for (n2 = 0; n2 < 50; ++n2) {
                System.arraycopy(this.i.digest(byArray2), 0, byArray2, 0, byArray4.length);
            }
            System.arraycopy(byArray, 0, byArray3, 0, 32);
            for (n2 = 0; n2 < 20; ++n2) {
                for (int i2 = 0; i2 < byArray4.length; ++i2) {
                    byArray4[i2] = (byte)(byArray2[i2] ^ n2);
                }
                this.o.prepareARCFOURKey(byArray4);
                this.o.encryptARCFOUR(byArray3);
            }
        } else {
            this.o.prepareARCFOURKey(byArray2, 0, 5);
            this.o.encryptARCFOUR(byArray, byArray3);
        }
        return byArray3;
    }

    private void a(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        this.l = byArray;
        this.j = byArray3;
        this.k = n2;
        this.g = new byte[this.p / 8];
        this.i.reset();
        this.i.update(byArray2);
        this.i.update(byArray3);
        byte[] byArray4 = new byte[4];
        byArray2 = byArray4;
        byArray4[0] = (byte)n2;
        byArray2[1] = (byte)(n2 >> 8);
        byArray2[2] = (byte)(n2 >> 16);
        byArray2[3] = (byte)(n2 >> 24);
        this.i.update(byArray2, 0, 4);
        if (byArray != null) {
            this.i.update(byArray);
        }
        if (!this.q) {
            this.i.update(d);
        }
        byArray = new byte[this.g.length];
        System.arraycopy(this.i.digest(), 0, byArray, 0, this.g.length);
        if (this.n == 3 || this.n == 4) {
            for (int i2 = 0; i2 < 50; ++i2) {
                System.arraycopy(this.i.digest(byArray), 0, byArray, 0, this.g.length);
            }
        }
        System.arraycopy(byArray, 0, this.g, 0, this.g.length);
    }

    private void a() {
        if (this.n == 3 || this.n == 4) {
            int n2;
            this.i.update(b);
            byte[] byArray = this.i.digest(this.l);
            System.arraycopy(byArray, 0, this.a, 0, 16);
            for (n2 = 16; n2 < 32; ++n2) {
                this.a[n2] = 0;
            }
            for (n2 = 0; n2 < 20; ++n2) {
                for (int i2 = 0; i2 < this.g.length; ++i2) {
                    byArray[i2] = (byte)(this.g[i2] ^ n2);
                }
                this.o.prepareARCFOURKey(byArray, 0, this.g.length);
                this.o.encryptARCFOUR(this.a, 0, 16);
            }
            return;
        }
        this.o.prepareARCFOURKey(this.g);
        this.o.encryptARCFOUR(b, this.a);
    }

    public void setupAllKeys(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray2 == null || byArray2.length == 0) {
            byArray2 = this.i.digest(PdfEncryption.createDocumentId());
        }
        n2 |= this.n == 3 || this.n == 4 ? -3904 : -64;
        n2 &= 0xFFFFFFFC;
        byArray = PdfEncryption.a(byArray);
        byArray2 = PdfEncryption.a(byArray2);
        this.j = this.a(byArray, byArray2);
        this.l = PdfEncryption.createDocumentId();
        PdfEncryption pdfEncryption = this;
        pdfEncryption.b(pdfEncryption.l, byArray, this.j, n2);
    }

    public static byte[] createDocumentId() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        long l2 = System.currentTimeMillis();
        long l3 = Runtime.getRuntime().freeMemory();
        String string = l2 + "+" + l3 + "+" + m++;
        return messageDigest.digest(string.getBytes());
    }

    public void setupByUserPassword(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        this.b(byArray, PdfEncryption.a(byArray2), byArray3, n2);
    }

    private void b(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        this.a(byArray, byArray2, byArray3, n2);
        this.a();
    }

    public void setupByOwnerPassword(byte[] object, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        PdfEncryption pdfEncryption = this;
        byArray2 = PdfEncryption.a(byArray);
        byArray = object;
        object = pdfEncryption;
        byArray2 = pdfEncryption.a(byArray3, byArray2);
        super.a(byArray, byArray2, byArray3, n2);
        super.a();
    }

    public void setupByEncryptionKey(byte[] byArray, int n2) {
        this.g = new byte[n2 / 8];
        System.arraycopy(byArray, 0, this.g, 0, this.g.length);
    }

    public void setHashKey(int n2, int n3) {
        this.i.reset();
        this.h[0] = (byte)n2;
        this.h[1] = (byte)(n2 >> 8);
        this.h[2] = (byte)(n2 >> 16);
        this.h[3] = (byte)n3;
        this.h[4] = (byte)(n3 >> 8);
        this.i.update(this.g);
        this.i.update(this.h);
        if (this.n == 4) {
            this.i.update(c);
        }
        this.e = this.i.digest();
        this.f = this.g.length + 5;
        if (this.f > 16) {
            this.f = 16;
        }
    }

    public static PdfObject createInfoId(byte[] byArray) {
        int n2;
        ByteBuffer byteBuffer = new ByteBuffer(90);
        byteBuffer.append('[').append('<');
        for (n2 = 0; n2 < 16; ++n2) {
            byteBuffer.appendHex(byArray[n2]);
        }
        byteBuffer.append('>').append('<');
        byArray = PdfEncryption.createDocumentId();
        for (n2 = 0; n2 < 16; ++n2) {
            byteBuffer.appendHex(byArray[n2]);
        }
        byteBuffer.append('>').append(']');
        return new PdfLiteral(byteBuffer.toByteArray());
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (this.publicKeyHandler.getRecipientsSize() > 0) {
            Object object;
            Object object2;
            pdfDictionary.put(PdfName.FILTER, PdfName.PUBSEC);
            pdfDictionary.put(PdfName.R, new PdfNumber(this.n));
            try {
                object2 = this.publicKeyHandler.getEncodedRecipients();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            if (this.n == 2) {
                pdfDictionary.put(PdfName.V, new PdfNumber(1));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S4);
                pdfDictionary.put(PdfName.RECIPIENTS, (PdfObject)object2);
            } else if (this.n == 3 && this.q) {
                pdfDictionary.put(PdfName.V, new PdfNumber(2));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S4);
                pdfDictionary.put(PdfName.RECIPIENTS, (PdfObject)object2);
            } else {
                pdfDictionary.put(PdfName.R, new PdfNumber(4));
                pdfDictionary.put(PdfName.V, new PdfNumber(4));
                pdfDictionary.put(PdfName.SUBFILTER, PdfName.ADBE_PKCS7_S5);
                object = new PdfDictionary();
                ((PdfDictionary)object).put(PdfName.RECIPIENTS, (PdfObject)object2);
                if (!this.q) {
                    ((PdfDictionary)object).put(PdfName.ENCRYPTMETADATA, PdfBoolean.PDFFALSE);
                }
                if (this.n == 4) {
                    ((PdfDictionary)object).put(PdfName.CFM, PdfName.AESV2);
                } else {
                    ((PdfDictionary)object).put(PdfName.CFM, PdfName.V2);
                }
                object2 = new PdfDictionary();
                ((PdfDictionary)object2).put(PdfName.DEFAULTCRYPTFILTER, (PdfObject)object);
                pdfDictionary.put(PdfName.CF, (PdfObject)object2);
                if (this.r) {
                    pdfDictionary.put(PdfName.EFF, PdfName.DEFAULTCRYPTFILTER);
                    pdfDictionary.put(PdfName.STRF, PdfName.IDENTITY);
                    pdfDictionary.put(PdfName.STMF, PdfName.IDENTITY);
                } else {
                    pdfDictionary.put(PdfName.STRF, PdfName.DEFAULTCRYPTFILTER);
                    pdfDictionary.put(PdfName.STMF, PdfName.DEFAULTCRYPTFILTER);
                }
            }
            try {
                object = MessageDigest.getInstance("SHA-1");
                ((MessageDigest)object).update(this.publicKeyHandler.getSeed());
                for (int i2 = 0; i2 < this.publicKeyHandler.getRecipientsSize(); ++i2) {
                    object2 = this.publicKeyHandler.getEncodedRecipient(i2);
                    ((MessageDigest)object).update((byte[])object2);
                }
                if (!this.q) {
                    ((MessageDigest)object).update(new byte[]{-1, -1, -1, -1});
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            byte[] byArray = ((MessageDigest)object).digest();
            this.setupByEncryptionKey(byArray, this.p);
        } else {
            pdfDictionary.put(PdfName.FILTER, PdfName.STANDARD);
            pdfDictionary.put(PdfName.O, new PdfLiteral(PdfContentByte.a(this.j)));
            pdfDictionary.put(PdfName.U, new PdfLiteral(PdfContentByte.a(this.a)));
            pdfDictionary.put(PdfName.P, new PdfNumber(this.k));
            pdfDictionary.put(PdfName.R, new PdfNumber(this.n));
            if (this.n == 2) {
                pdfDictionary.put(PdfName.V, new PdfNumber(1));
            } else if (this.n == 3 && this.q) {
                pdfDictionary.put(PdfName.V, new PdfNumber(2));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
            } else {
                if (!this.q) {
                    pdfDictionary.put(PdfName.ENCRYPTMETADATA, PdfBoolean.PDFFALSE);
                }
                pdfDictionary.put(PdfName.R, new PdfNumber(4));
                pdfDictionary.put(PdfName.V, new PdfNumber(4));
                pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
                PdfDictionary pdfDictionary2 = new PdfDictionary();
                pdfDictionary2.put(PdfName.LENGTH, new PdfNumber(16));
                if (this.r) {
                    pdfDictionary2.put(PdfName.AUTHEVENT, PdfName.EFOPEN);
                    pdfDictionary.put(PdfName.EFF, PdfName.STDCF);
                    pdfDictionary.put(PdfName.STRF, PdfName.IDENTITY);
                    pdfDictionary.put(PdfName.STMF, PdfName.IDENTITY);
                } else {
                    pdfDictionary2.put(PdfName.AUTHEVENT, PdfName.DOCOPEN);
                    pdfDictionary.put(PdfName.STRF, PdfName.STDCF);
                    pdfDictionary.put(PdfName.STMF, PdfName.STDCF);
                }
                if (this.n == 4) {
                    pdfDictionary2.put(PdfName.CFM, PdfName.AESV2);
                } else {
                    pdfDictionary2.put(PdfName.CFM, PdfName.V2);
                }
                PdfDictionary pdfDictionary3 = new PdfDictionary();
                pdfDictionary3.put(PdfName.STDCF, pdfDictionary2);
                pdfDictionary.put(PdfName.CF, pdfDictionary3);
            }
        }
        return pdfDictionary;
    }

    public PdfObject getFileID() {
        return PdfEncryption.createInfoId(this.l);
    }

    public OutputStreamEncryption getEncryptionStream(OutputStream outputStream) {
        return new OutputStreamEncryption(outputStream, this.e, 0, this.f, this.n);
    }

    public int calculateStreamSize(int n2) {
        if (this.n == 4) {
            return (n2 & 0x7FFFFFF0) + 32;
        }
        return n2;
    }

    public byte[] encryptByteArray(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamEncryption outputStreamEncryption = this.getEncryptionStream(byteArrayOutputStream);
            outputStreamEncryption.write(byArray);
            outputStreamEncryption.finish();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public StandardDecryption getDecryptor() {
        return new StandardDecryption(this.e, 0, this.f, this.n);
    }

    public byte[] decryptByteArray(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StandardDecryption standardDecryption = this.getDecryptor();
            byArray = standardDecryption.update(byArray, 0, byArray.length);
            if (byArray != null) {
                byteArrayOutputStream.write(byArray);
            }
            if ((byArray = standardDecryption.finish()) != null) {
                byteArrayOutputStream.write(byArray);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void addRecipient(Certificate certificate, int n2) {
        this.l = PdfEncryption.createDocumentId();
        this.publicKeyHandler.addRecipient(new PdfPublicKeyRecipient(certificate, n2));
    }

    public byte[] computeUserPassword(byte[] byArray) {
        PdfEncryption pdfEncryption = this;
        byArray = pdfEncryption.a(pdfEncryption.j, PdfEncryption.a(byArray));
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            boolean bl2 = true;
            for (int i3 = 0; i3 < byArray.length - i2; ++i3) {
                if (byArray[i2 + i3] == b[i3]) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            byte[] byArray2 = new byte[i2];
            System.arraycopy(byArray, 0, byArray2, 0, i2);
            return byArray2;
        }
        return byArray;
    }
}

