/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEFStream;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.collection.PdfCollectionItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class PdfFileSpecification
extends PdfDictionary {
    protected PdfWriter writer;
    protected PdfIndirectReference ref;

    public PdfFileSpecification() {
        super(PdfName.FILESPEC);
    }

    public static PdfFileSpecification url(PdfWriter pdfWriter, String string) {
        PdfFileSpecification pdfFileSpecification = new PdfFileSpecification();
        new PdfFileSpecification().writer = pdfWriter;
        pdfFileSpecification.put(PdfName.FS, PdfName.URL);
        pdfFileSpecification.put(PdfName.F, new PdfString(string));
        return pdfFileSpecification;
    }

    public static PdfFileSpecification fileEmbedded(PdfWriter pdfWriter, String string, String string2, byte[] byArray) {
        return PdfFileSpecification.fileEmbedded(pdfWriter, string, string2, byArray, 9);
    }

    public static PdfFileSpecification fileEmbedded(PdfWriter pdfWriter, String string, String string2, byte[] byArray, int n2) {
        return PdfFileSpecification.fileEmbedded(pdfWriter, string, string2, byArray, null, null, n2);
    }

    public static PdfFileSpecification fileEmbedded(PdfWriter pdfWriter, String string, String string2, byte[] byArray, boolean bl2) {
        return PdfFileSpecification.fileEmbedded(pdfWriter, string, string2, byArray, null, null, bl2 ? 9 : 0);
    }

    public static PdfFileSpecification fileEmbedded(PdfWriter pdfWriter, String string, String string2, byte[] byArray, boolean bl2, String string3, PdfDictionary pdfDictionary) {
        return PdfFileSpecification.fileEmbedded(pdfWriter, string, string2, byArray, string3, pdfDictionary, bl2 ? 9 : 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PdfFileSpecification fileEmbedded(PdfWriter pdfWriter, String object, String object2, byte[] byArray, String object3, PdfDictionary pdfDictionary, int n2) {
        Object object4;
        PdfFileSpecification pdfFileSpecification;
        block18: {
            pdfFileSpecification = new PdfFileSpecification();
            new PdfFileSpecification().writer = pdfWriter;
            pdfFileSpecification.put(PdfName.F, new PdfString((String)object2));
            Object object5 = object2;
            pdfFileSpecification.setUnicodeFileName((String)object5, !PdfEncodings.isPdfDocEncoding((String)object5));
            object2 = null;
            PdfIndirectReference pdfIndirectReference = null;
            try {
                if (byArray == null) {
                    pdfIndirectReference = pdfWriter.getPdfIndirectReference();
                    object4 = new File((String)object);
                    if (((File)object4).canRead()) {
                        object2 = new FileInputStream((String)object);
                    } else if (((String)object).startsWith("file:/") || ((String)object).startsWith("http://") || ((String)object).startsWith("https://") || ((String)object).startsWith("jar:")) {
                        object2 = new URL((String)object).openStream();
                    } else {
                        object2 = BaseFont.getResourceStream((String)object);
                        if (object2 == null) {
                            throw new IOException(MessageLocalization.getComposedMessage("1.not.found.as.file.or.resource", object));
                        }
                    }
                    object = new PdfEFStream((InputStream)object2, pdfWriter);
                } else {
                    object = new PdfEFStream(byArray);
                }
                ((PdfDictionary)object).put(PdfName.TYPE, PdfName.EMBEDDEDFILE);
                ((PdfStream)object).flateCompress(n2);
                object4 = new PdfDictionary();
                if (pdfDictionary != null) {
                    ((PdfDictionary)object4).merge(pdfDictionary);
                }
                if (byArray != null) {
                    ((PdfDictionary)object4).put(PdfName.SIZE, new PdfNumber(((PdfStream)object).getRawLength()));
                    ((PdfDictionary)object).put(PdfName.PARAMS, (PdfObject)object4);
                } else {
                    ((PdfDictionary)object).put(PdfName.PARAMS, pdfIndirectReference);
                }
                if (object3 != null) {
                    ((PdfDictionary)object).put(PdfName.SUBTYPE, new PdfName((String)object3));
                }
                object3 = pdfWriter.addToBody((PdfObject)object).getIndirectReference();
                if (byArray == null) {
                    ((PdfStream)object).writeLength();
                    ((PdfDictionary)object4).put(PdfName.SIZE, new PdfNumber(((PdfStream)object).getRawLength()));
                    pdfWriter.addToBody((PdfObject)object4, pdfIndirectReference);
                }
                if (object2 == null) break block18;
            }
            catch (Throwable throwable) {
                if (object2 == null) throw throwable;
                try {
                    ((InputStream)object2).close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                ((InputStream)object2).close();
            }
            catch (Exception exception) {}
        }
        object4 = new PdfDictionary();
        ((PdfDictionary)object4).put(PdfName.F, (PdfObject)object3);
        ((PdfDictionary)object4).put(PdfName.UF, (PdfObject)object3);
        pdfFileSpecification.put(PdfName.EF, (PdfObject)object4);
        return pdfFileSpecification;
    }

    public static PdfFileSpecification fileExtern(PdfWriter pdfWriter, String string) {
        PdfFileSpecification pdfFileSpecification = new PdfFileSpecification();
        new PdfFileSpecification().writer = pdfWriter;
        pdfFileSpecification.put(PdfName.F, new PdfString(string));
        String string2 = string;
        pdfFileSpecification.setUnicodeFileName(string2, !PdfEncodings.isPdfDocEncoding(string2));
        return pdfFileSpecification;
    }

    public PdfIndirectReference getReference() {
        if (this.ref != null) {
            return this.ref;
        }
        this.ref = this.writer.addToBody(this).getIndirectReference();
        return this.ref;
    }

    public void setMultiByteFileName(byte[] byArray) {
        this.put(PdfName.F, new PdfString(byArray).setHexWriting(true));
    }

    public void setUnicodeFileName(String string, boolean bl2) {
        this.put(PdfName.UF, new PdfString(string, bl2 ? "UnicodeBig" : "PDF"));
    }

    public void setVolatile(boolean bl2) {
        this.put(PdfName.V, new PdfBoolean(bl2));
    }

    public void addDescription(String string, boolean bl2) {
        this.put(PdfName.DESC, new PdfString(string, bl2 ? "UnicodeBig" : "PDF"));
    }

    public void addCollectionItem(PdfCollectionItem pdfCollectionItem) {
        this.put(PdfName.CI, pdfCollectionItem);
    }
}

