/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfSignature;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.m;
import java.util.ArrayList;
import java.util.List;

public class PdfFormField
extends PdfAnnotation {
    public static final int FF_READ_ONLY = 1;
    public static final int FF_REQUIRED = 2;
    public static final int FF_NO_EXPORT = 4;
    public static final int FF_NO_TOGGLE_TO_OFF = 16384;
    public static final int FF_RADIO = 32768;
    public static final int FF_PUSHBUTTON = 65536;
    public static final int FF_MULTILINE = 4096;
    public static final int FF_PASSWORD = 8192;
    public static final int FF_COMBO = 131072;
    public static final int FF_EDIT = 262144;
    public static final int FF_FILESELECT = 0x100000;
    public static final int FF_MULTISELECT = 0x200000;
    public static final int FF_DONOTSPELLCHECK = 0x400000;
    public static final int FF_DONOTSCROLL = 0x800000;
    public static final int FF_COMB = 0x1000000;
    public static final int FF_RADIOSINUNISON = 0x2000000;
    public static final int Q_LEFT = 0;
    public static final int Q_CENTER = 1;
    public static final int Q_RIGHT = 2;
    public static final int MK_NO_ICON = 0;
    public static final int MK_NO_CAPTION = 1;
    public static final int MK_CAPTION_BELOW = 2;
    public static final int MK_CAPTION_ABOVE = 3;
    public static final int MK_CAPTION_RIGHT = 4;
    public static final int MK_CAPTION_LEFT = 5;
    public static final int MK_CAPTION_OVERLAID = 6;
    public static final PdfName IF_SCALE_ALWAYS = PdfName.A;
    public static final PdfName IF_SCALE_BIGGER = PdfName.B;
    public static final PdfName IF_SCALE_SMALLER = PdfName.S;
    public static final PdfName IF_SCALE_NEVER = PdfName.N;
    public static final PdfName IF_SCALE_ANAMORPHIC = PdfName.A;
    public static final PdfName IF_SCALE_PROPORTIONAL = PdfName.P;
    public static final boolean MULTILINE = true;
    public static final boolean SINGLELINE = false;
    public static final boolean PLAINTEXT = false;
    public static final boolean PASSWORD = true;
    private static PdfName[] a = new PdfName[]{PdfName.FONT, PdfName.XOBJECT, PdfName.COLORSPACE, PdfName.PATTERN};
    protected PdfFormField parent;
    protected List<PdfFormField> kids;

    public PdfFormField(PdfWriter pdfWriter, float f2, float f3, float f4, float f5, PdfAction pdfAction) {
        super(pdfWriter, f2, f3, f4, f5, pdfAction);
        this.put(PdfName.TYPE, PdfName.ANNOT);
        this.put(PdfName.SUBTYPE, PdfName.WIDGET);
        this.annotation = true;
    }

    protected PdfFormField(PdfWriter pdfWriter) {
        super(pdfWriter, null);
        this.form = true;
        this.annotation = false;
    }

    public void setWidget(Rectangle rectangle, PdfName pdfName) {
        this.put(PdfName.TYPE, PdfName.ANNOT);
        this.put(PdfName.SUBTYPE, PdfName.WIDGET);
        this.put(PdfName.RECT, new PdfRectangle(rectangle));
        this.annotation = true;
        if (pdfName != null && !pdfName.equals(HIGHLIGHT_INVERT)) {
            this.put(PdfName.H, pdfName);
        }
    }

    public static PdfFormField createEmpty(PdfWriter object) {
        object = new PdfFormField((PdfWriter)object);
        return object;
    }

    public void setButton(int n2) {
        this.put(PdfName.FT, PdfName.BTN);
        if (n2 != 0) {
            this.put(PdfName.FF, new PdfNumber(n2));
        }
    }

    protected static PdfFormField createButton(PdfWriter object, int n2) {
        object = new PdfFormField((PdfWriter)object);
        ((PdfFormField)object).setButton(n2);
        return object;
    }

    public static PdfFormField createPushButton(PdfWriter pdfWriter) {
        return PdfFormField.createButton(pdfWriter, 65536);
    }

    public static PdfFormField createCheckBox(PdfWriter pdfWriter) {
        return PdfFormField.createButton(pdfWriter, 0);
    }

    public static PdfFormField createRadioButton(PdfWriter pdfWriter, boolean bl2) {
        return PdfFormField.createButton(pdfWriter, 32768 + (bl2 ? 16384 : 0));
    }

    /*
     * WARNING - void declaration
     */
    public static PdfFormField createTextField(PdfWriter object, boolean bl2, boolean bl3, int n2) {
        void var3_5;
        void var2_4;
        object = new PdfFormField((PdfWriter)object);
        ((PdfDictionary)object).put(PdfName.FT, PdfName.TX);
        int n4 = bl2 ? 4096 : 0;
        n4 = n4 + (var2_4 != false ? 8192 : 0);
        ((PdfDictionary)object).put(PdfName.FF, new PdfNumber(n4));
        if (var3_5 > 0) {
            ((PdfDictionary)object).put(PdfName.MAXLEN, new PdfNumber((int)var3_5));
        }
        return object;
    }

    protected static PdfFormField createChoice(PdfWriter object, int n2, PdfArray pdfArray, int n3) {
        object = new PdfFormField((PdfWriter)object);
        ((PdfDictionary)object).put(PdfName.FT, PdfName.CH);
        ((PdfDictionary)object).put(PdfName.FF, new PdfNumber(n2));
        ((PdfDictionary)object).put(PdfName.OPT, pdfArray);
        if (n3 > 0) {
            ((PdfDictionary)object).put(PdfName.TI, new PdfNumber(n3));
        }
        return object;
    }

    public static PdfFormField createList(PdfWriter pdfWriter, String[] stringArray, int n2) {
        return PdfFormField.createChoice(pdfWriter, 0, PdfFormField.processOptions(stringArray), n2);
    }

    public static PdfFormField createList(PdfWriter pdfWriter, String[][] stringArray, int n2) {
        return PdfFormField.createChoice(pdfWriter, 0, PdfFormField.processOptions(stringArray), n2);
    }

    public static PdfFormField createCombo(PdfWriter pdfWriter, boolean bl2, String[] stringArray, int n2) {
        return PdfFormField.createChoice(pdfWriter, 131072 + (bl2 ? 262144 : 0), PdfFormField.processOptions(stringArray), n2);
    }

    public static PdfFormField createCombo(PdfWriter pdfWriter, boolean bl2, String[][] stringArray, int n2) {
        return PdfFormField.createChoice(pdfWriter, 131072 + (bl2 ? 262144 : 0), PdfFormField.processOptions(stringArray), n2);
    }

    protected static PdfArray processOptions(String[] stringArray) {
        PdfArray pdfArray = new PdfArray();
        for (String string : stringArray) {
            pdfArray.add(new PdfString(string, "UnicodeBig"));
        }
        return pdfArray;
    }

    protected static PdfArray processOptions(String[][] stringArray) {
        PdfArray pdfArray = new PdfArray();
        for (String[] stringArray2 : stringArray) {
            PdfArray pdfArray2 = new PdfArray(new PdfString(stringArray2[0], "UnicodeBig"));
            pdfArray2.add(new PdfString(stringArray2[1], "UnicodeBig"));
            pdfArray.add(pdfArray2);
        }
        return pdfArray;
    }

    public static PdfFormField createSignature(PdfWriter object) {
        object = new PdfFormField((PdfWriter)object);
        ((PdfDictionary)object).put(PdfName.FT, PdfName.SIG);
        return object;
    }

    public PdfFormField getParent() {
        return this.parent;
    }

    public void addKid(PdfFormField pdfFormField) {
        pdfFormField.parent = this;
        if (this.kids == null) {
            this.kids = new ArrayList<PdfFormField>();
        }
        this.kids.add(pdfFormField);
    }

    @Deprecated
    public ArrayList getKids() {
        return (ArrayList)this.kids;
    }

    public List<PdfFormField> getKidFields() {
        return this.kids;
    }

    public int setFieldFlags(int n2) {
        PdfNumber pdfNumber = (PdfNumber)this.get(PdfName.FF);
        int n3 = pdfNumber == null ? 0 : pdfNumber.intValue();
        n2 = n3 | n2;
        this.put(PdfName.FF, new PdfNumber(n2));
        return n3;
    }

    public void setValueAsString(String string) {
        this.put(PdfName.V, new PdfString(string, "UnicodeBig"));
    }

    public void setValueAsName(String string) {
        this.put(PdfName.V, new PdfName(string));
    }

    public void setValue(PdfSignature pdfSignature) {
        this.put(PdfName.V, pdfSignature);
    }

    public void setDefaultValueAsString(String string) {
        this.put(PdfName.DV, new PdfString(string, "UnicodeBig"));
    }

    public void setDefaultValueAsName(String string) {
        this.put(PdfName.DV, new PdfName(string));
    }

    public void setFieldName(String string) {
        if (string != null) {
            this.put(PdfName.T, new PdfString(string, "UnicodeBig"));
        }
    }

    public void setUserName(String string) {
        this.put(PdfName.TU, new PdfString(string, "UnicodeBig"));
    }

    public void setMappingName(String string) {
        this.put(PdfName.TM, new PdfString(string, "UnicodeBig"));
    }

    public void setQuadding(int n2) {
        this.put(PdfName.Q, new PdfNumber(n2));
    }

    static void a(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2, m m2) {
        PdfName[] pdfNameArray = a;
        int n2 = a.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PdfObject pdfObject;
            PdfName pdfName = pdfObject = pdfNameArray[i2];
            PdfDictionary pdfDictionary3 = pdfDictionary2.getAsDict(pdfName);
            pdfObject = pdfDictionary3;
            pdfObject = pdfDictionary3;
            if (pdfDictionary3 == null) continue;
            PdfDictionary pdfDictionary4 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(pdfName), pdfDictionary);
            if (pdfDictionary4 == null) {
                pdfDictionary4 = new PdfDictionary();
            }
            pdfDictionary4.mergeDifferent((PdfDictionary)pdfObject);
            pdfDictionary.put(pdfName, pdfDictionary4);
            if (m2 == null) continue;
            m2.a((PdfObject)pdfDictionary4);
        }
    }

    static void a(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2) {
        PdfFormField.a(pdfDictionary, pdfDictionary2, null);
    }

    @Override
    public void setUsed() {
        PdfObject pdfObject;
        this.used = true;
        if (this.parent != null) {
            this.put(PdfName.PARENT, this.parent.getIndirectReference());
        }
        if (this.kids != null) {
            pdfObject = new PdfArray();
            for (PdfFormField object : this.kids) {
                ((PdfArray)pdfObject).add(object.getIndirectReference());
            }
            this.put(PdfName.KIDS, pdfObject);
        }
        if (this.templates == null) {
            return;
        }
        pdfObject = new PdfDictionary();
        for (PdfTemplate pdfTemplate : this.templates.keySet()) {
            PdfDictionary pdfDictionary = (PdfDictionary)pdfTemplate.c();
            PdfObject pdfObject2 = pdfObject;
            PdfFormField.a((PdfDictionary)pdfObject2, pdfDictionary, null);
        }
        this.put(PdfName.DR, pdfObject);
    }

    public static PdfAnnotation shallowDuplicate(PdfAnnotation pdfAnnotation) {
        PdfAnnotation pdfAnnotation2;
        if (pdfAnnotation.isForm()) {
            pdfAnnotation2 = new PdfFormField(pdfAnnotation.writer);
            PdfFormField pdfFormField = pdfAnnotation2;
            PdfFormField pdfFormField2 = (PdfFormField)pdfAnnotation;
            pdfFormField.parent = pdfFormField2.parent;
            pdfFormField.kids = pdfFormField2.kids;
        } else {
            pdfAnnotation2 = new PdfAnnotation(pdfAnnotation.writer, null);
        }
        pdfAnnotation2.merge(pdfAnnotation);
        pdfAnnotation2.form = pdfAnnotation.form;
        pdfAnnotation2.annotation = pdfAnnotation.annotation;
        pdfAnnotation2.templates = pdfAnnotation.templates;
        return pdfAnnotation2;
    }
}

