/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import com.lowagie.text.pdf.internal.PolylineShape;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class PdfGraphics2D
extends Graphics2D {
    private BasicStroke a = new BasicStroke(1.0f);
    private static final AffineTransform b = new AffineTransform();
    private static final Set<String> c = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Dialog", "DialogInput", "Monospaced", "Serif", "SansSerif")));
    private Font d;
    private BaseFont e;
    private float f;
    private AffineTransform g;
    private Paint h;
    private Color i;
    private float j;
    private float k;
    private Area l;
    private RenderingHints m = new RenderingHints(null);
    private Stroke n;
    private Stroke o;
    private PdfContentByte p;
    private Map<String, BaseFont> q;
    private boolean r = false;
    private FontMapper s;
    private List<Object> t;
    private boolean u = false;
    private Graphics2D v = new BufferedImage(2, 2, 1).createGraphics();
    private boolean w = false;
    private Stroke x;
    private Paint y;
    private Paint z;
    private MediaTracker A;
    protected boolean underline;
    protected PdfGState[] fillGState = new PdfGState[256];
    protected PdfGState[] strokeGState = new PdfGState[256];
    protected int currentFillGState = 255;
    protected int currentStrokeGState = 255;
    public static final int AFM_DIVISOR = 1000;
    private boolean B = false;
    private float C = 0.95f;
    private float D;
    private Composite E;
    private Paint F;
    private final CompositeFontDrawer G = new CompositeFontDrawer(0);

    private PdfGraphics2D() {
        this.v.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.setRenderingHint(HyperLinkKey.KEY_INSTANCE, HyperLinkKey.VALUE_HYPERLINKKEY_OFF);
    }

    public PdfGraphics2D(PdfContentByte pdfContentByte, float f2, float f3) {
        this(pdfContentByte, f2, f3, null, false, false, 0.0f);
    }

    public PdfGraphics2D(PdfContentByte pdfContentByte, float f2, float f3, FontMapper fontMapper, boolean bl2, boolean bl3, float f4) {
        this.v.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.setRenderingHint(HyperLinkKey.KEY_INSTANCE, HyperLinkKey.VALUE_HYPERLINKKEY_OFF);
        this.B = bl3;
        this.C = f4;
        this.w = bl2;
        this.g = new AffineTransform();
        this.q = new HashMap<String, BaseFont>();
        if (!bl2) {
            this.s = fontMapper;
            if (this.s == null) {
                this.s = new DefaultFontMapper();
            }
        }
        this.h = Color.black;
        this.i = Color.white;
        this.setFont(new Font("sanserif", 0, 12));
        this.p = pdfContentByte;
        pdfContentByte.saveState();
        this.j = f2;
        this.k = f3;
        this.l = new Area(new Rectangle2D.Float(0.0f, 0.0f, f2, f3));
        PdfGraphics2D pdfGraphics2D = this;
        pdfGraphics2D.clip(pdfGraphics2D.l);
        PdfGraphics2D pdfGraphics2D2 = this;
        pdfGraphics2D2.n = this.x = this.a;
        pdfGraphics2D2.o = this.x;
        PdfGraphics2D pdfGraphics2D3 = this;
        pdfGraphics2D3.a(pdfGraphics2D3.n, null);
        pdfContentByte.saveState();
    }

    @Override
    public void draw(Shape shape) {
        this.a(shape, 2);
    }

    @Override
    public boolean drawImage(java.awt.Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.a(image, null, affineTransform, null, imageObserver);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImageOp != null) {
            BufferedImage bufferedImage3 = bufferedImage;
            bufferedImage2 = bufferedImageOp.createCompatibleDestImage(bufferedImage3, bufferedImage3.getColorModel());
            bufferedImage2 = bufferedImageOp.filter(bufferedImage, bufferedImage2);
        }
        this.drawImage((java.awt.Image)bufferedImage2, n2, n3, null);
    }

    @Override
    public void drawRenderedImage(RenderedImage object, AffineTransform affineTransform) {
        if (object instanceof BufferedImage) {
            object = (BufferedImage)object;
        } else {
            ColorModel colorModel = object.getColorModel();
            int n2 = object.getWidth();
            int bl2 = object.getHeight();
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, bl2);
            boolean bl3 = colorModel.isAlphaPremultiplied();
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Object object2 = object.getPropertyNames();
            if (object2 != null) {
                for (String string : object2) {
                    hashtable.put(string, object.getProperty(string));
                }
            }
            object2 = new BufferedImage(colorModel, writableRaster, bl3, hashtable);
            object.copyData(writableRaster);
            object = object2;
        }
        this.drawImage((java.awt.Image)object, affineTransform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    @Override
    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (float)n2, (float)n3);
    }

    public static double asPoints(double d2, int n2) {
        return d2 * (double)n2 / 1000.0;
    }

    protected void doAttributes(AttributedCharacterIterator attributedCharacterIterator) {
        this.underline = false;
        Object object = attributedCharacterIterator.getAttributes().keySet();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2;
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)object.next();
            if (!(attribute instanceof TextAttribute)) continue;
            if ((attribute = (TextAttribute)attribute).equals(TextAttribute.FONT)) {
                object2 = (Font)attributedCharacterIterator.getAttributes().get(attribute);
                this.setFont((Font)object2);
                continue;
            }
            if (attribute.equals(TextAttribute.UNDERLINE)) {
                if (attributedCharacterIterator.getAttributes().get(attribute) != TextAttribute.UNDERLINE_ON) continue;
                this.underline = true;
                continue;
            }
            if (attribute.equals(TextAttribute.SIZE)) {
                object2 = attributedCharacterIterator.getAttributes().get(attribute);
                if (object2 instanceof Integer) {
                    int n2 = (Integer)object2;
                    PdfGraphics2D pdfGraphics2D = this;
                    pdfGraphics2D.setFont(pdfGraphics2D.getFont().deriveFont(this.getFont().getStyle(), n2));
                    continue;
                }
                if (!(object2 instanceof Float)) continue;
                float f2 = ((Float)object2).floatValue();
                PdfGraphics2D pdfGraphics2D = this;
                pdfGraphics2D.setFont(pdfGraphics2D.getFont().deriveFont(this.getFont().getStyle(), f2));
                continue;
            }
            if (attribute.equals(TextAttribute.FOREGROUND)) {
                this.setColor((Color)attributedCharacterIterator.getAttributes().get(attribute));
                continue;
            }
            if (attribute.equals(TextAttribute.FAMILY)) {
                object2 = this.getFont();
                Map<TextAttribute, ?> map = ((Font)object2).getAttributes();
                map.put(TextAttribute.FAMILY, attributedCharacterIterator.getAttributes().get(attribute));
                this.setFont(((Font)object2).deriveFont(map));
                continue;
            }
            if (attribute.equals(TextAttribute.POSTURE)) {
                object2 = this.getFont();
                Map<TextAttribute, ?> map = ((Font)object2).getAttributes();
                map.put(TextAttribute.POSTURE, attributedCharacterIterator.getAttributes().get(attribute));
                this.setFont(((Font)object2).deriveFont(map));
                continue;
            }
            if (!attribute.equals(TextAttribute.WEIGHT)) continue;
            object2 = this.getFont();
            Map<TextAttribute, ?> map = ((Font)object2).getAttributes();
            map.put(TextAttribute.WEIGHT, attributedCharacterIterator.getAttributes().get(attribute));
            this.setFont(((Font)object2).deriveFont(map));
        }
    }

    @Override
    public void drawString(String object, float f2, float f3) {
        if (((String)object).length() == 0) {
            return;
        }
        this.b();
        if (this.w) {
            PdfGraphics2D pdfGraphics2D = this;
            pdfGraphics2D.drawGlyphVector(pdfGraphics2D.d.layoutGlyphVector(this.getFontRenderContext(), ((String)object).toCharArray(), 0, ((String)object).length(), 0), f2, f3);
            return;
        }
        if (!Float.isFinite(this.f) || this.f < 1.0E-4f) {
            return;
        }
        double d2 = 0.0;
        if (CompositeFontDrawer.a() && this.G.a(this.d)) {
            d2 = this.G.a((String)object, this.d, f2, f3, this::a, this::a);
        } else {
            String string = object;
            object = this;
            Object object2 = new ArrayList<String>();
            CharSequence charSequence = new StringBuilder();
            boolean bl2 = true;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                boolean bl3 = ((PdfGraphics2D)object).d.canDisplay(c2);
                if (i2 > 0 && bl2 != bl3) {
                    object2.add(((StringBuilder)charSequence).toString());
                    ((StringBuilder)charSequence).setLength(0);
                }
                bl2 = bl3;
                ((StringBuilder)charSequence).append(c2);
            }
            object2.add(((StringBuilder)charSequence).toString());
            object = object2;
            object2 = object.iterator();
            while (object2.hasNext()) {
                charSequence = (String)object2.next();
                d2 += this.a((String)charSequence, this.e, (double)f2 + d2, f3);
            }
        }
        if (this.underline) {
            double d3 = PdfGraphics2D.asPoints(50.0, (int)this.f);
            object = this.o;
            this.setStroke(new BasicStroke((float)d3));
            f3 = (float)((double)f3 + PdfGraphics2D.asPoints(50.0, (int)this.f));
            Line2D.Double double_ = new Line2D.Double(f2, f3, d2 + (double)f2, f3);
            this.draw(double_);
            this.setStroke((Stroke)object);
        }
    }

    private double a(String string, BaseFont baseFont, double d2, double d3) {
        boolean bl2 = false;
        AffineTransform affineTransform = this.getTransform();
        try {
            Object object;
            Serializable serializable;
            float f2;
            AffineTransform affineTransform2 = this.getTransform();
            affineTransform2.translate(d2, d3);
            affineTransform2.concatenate(this.d.getTransform());
            this.setTransform(affineTransform2);
            AffineTransform affineTransform3 = this.a();
            Object object2 = AffineTransform.getScaleInstance(1.0, -1.0);
            affineTransform3.concatenate((AffineTransform)object2);
            object2 = new double[6];
            affineTransform3.getMatrix((double[])object2);
            this.p.beginText();
            this.p.setFontAndSize(baseFont, this.f);
            if (this.d.isItalic()) {
                float f3 = baseFont.getFontDescriptor(4, 1000.0f);
                float f4 = this.d.getItalicAngle();
                if (Objects.equals(this.d.getFontName(), this.d.getName()) || f3 == 0.0f && f4 == 0.0f) {
                    f4 = f4 == 0.0f ? 15.0f : -f4;
                    if (f3 == 0.0f) {
                        object2[2] = (double)(f4 / 100.0f);
                    }
                }
            }
            this.p.setTextMatrix((float)object2[0], (float)object2[1], (float)object2[2], (float)object2[3], (float)object2[4], (float)object2[5]);
            Float f5 = (Float)this.d.getAttributes().get(TextAttribute.WIDTH);
            Float f6 = f5 = f5 == null ? TextAttribute.WIDTH_REGULAR : f5;
            if (!TextAttribute.WIDTH_REGULAR.equals(f5)) {
                this.p.setHorizontalScaling(100.0f / f5.floatValue());
            }
            if (!baseFont.getPostscriptFontName().toLowerCase(Locale.ROOT).contains("bold")) {
                Float f7 = (Float)this.d.getAttributes().get(TextAttribute.WEIGHT);
                if (f7 == null) {
                    f7 = this.d.isBold() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR;
                }
                String string2 = this.d.getFontName();
                object2 = this.d.getName();
                if ((this.d.isBold() || f7.floatValue() >= TextAttribute.WEIGHT_SEMIBOLD.floatValue()) && (string2.equals(object2) || c.contains(object2) && (string2.equals((String)object2 + ".bold") || string2.equals((String)object2 + ".bolditalic"))) && (f2 = this.d.getSize2D() * (f7.floatValue() - TextAttribute.WEIGHT_REGULAR.floatValue()) / 30.0f) != 1.0f && this.F instanceof Color) {
                    this.p.setTextRenderingMode(2);
                    this.x = new BasicStroke(f2);
                    this.p.setLineWidth(f2);
                    serializable = (Color)this.F;
                    int n2 = ((Color)serializable).getAlpha();
                    if (n2 != this.currentStrokeGState) {
                        this.currentStrokeGState = n2;
                        PdfGState pdfGState = this.strokeGState[n2];
                        if (pdfGState == null) {
                            pdfGState = new PdfGState();
                            pdfGState.setStrokeOpacity((float)n2 / 255.0f);
                            this.strokeGState[n2] = pdfGState;
                        }
                        this.p.setGState(pdfGState);
                    }
                    this.c();
                    bl2 = true;
                }
            }
            double d4 = 0.0;
            if (this.d.getSize2D() > 0.0f) {
                float f8 = 1000.0f / this.d.getSize2D();
                Font font = this.d.deriveFont(AffineTransform.getScaleInstance(f8, f8));
                d4 = font.getStringBounds(string, this.getFontRenderContext()).getWidth();
                if (font.isTransformed()) {
                    d4 /= (double)f8;
                }
            }
            if ((object = this.getRenderingHint(HyperLinkKey.KEY_INSTANCE)) != null && !object.equals(HyperLinkKey.VALUE_HYPERLINKKEY_OFF)) {
                f2 = 1000.0f / this.d.getSize2D();
                serializable = this.d.deriveFont(AffineTransform.getScaleInstance(f2, f2));
                double d5 = serializable.getStringBounds(string, this.getFontRenderContext()).getHeight();
                if (serializable.isTransformed()) {
                    d5 /= (double)f2;
                }
                double d6 = this.p.getXTLM();
                double d7 = this.p.getYTLM();
                object = new PdfAction(object.toString());
                this.p.setAction((PdfAction)object, (float)d6, (float)d7, (float)(d6 + d4), (float)(d7 + d5));
            }
            if (string.length() > 1) {
                f2 = ((float)d4 - baseFont.getWidthPoint(string, this.f)) / (float)(string.length() - 1);
                this.p.setCharacterSpacing(f2);
            }
            this.p.showText(string);
            if (string.length() > 1) {
                this.p.setCharacterSpacing(0.0f);
            }
            if (!TextAttribute.WIDTH_REGULAR.equals(f5)) {
                this.p.setHorizontalScaling(100.0f);
            }
            if (bl2) {
                this.p.setTextRenderingMode(0);
            }
            this.p.endText();
            double d8 = d4;
            return d8;
        }
        finally {
            this.setTransform(affineTransform);
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        this.drawString(attributedCharacterIterator, (float)n2, (float)n3);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        StringBuilder stringBuilder = new StringBuilder(attributedCharacterIterator.getEndIndex());
        char c2 = attributedCharacterIterator.first();
        while (c2 != '\uffff') {
            if (attributedCharacterIterator.getIndex() == attributedCharacterIterator.getRunStart()) {
                if (stringBuilder.length() > 0) {
                    this.drawString(stringBuilder.toString(), f2, f3);
                    FontMetrics fontMetrics = this.getFontMetrics();
                    f2 = (float)((double)f2 + fontMetrics.getStringBounds(stringBuilder.toString(), this).getWidth());
                    stringBuilder.delete(0, stringBuilder.length());
                }
                this.doAttributes(attributedCharacterIterator);
            }
            stringBuilder.append(c2);
            c2 = attributedCharacterIterator.next();
        }
        this.drawString(stringBuilder.toString(), f2, f3);
        this.underline = false;
    }

    @Override
    public void drawGlyphVector(GlyphVector object, float f2, float f3) {
        object = ((GlyphVector)object).getOutline(f2, f3);
        this.fill((Shape)object);
    }

    @Override
    public void fill(Shape shape) {
        this.a(shape, 1);
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl2) {
        if (bl2) {
            shape = this.n.createStrokedShape(shape);
        }
        shape = this.g.createTransformedShape(shape);
        shape = new Area(shape);
        if (this.l != null) {
            ((Area)shape).intersect(this.l);
        }
        return ((Area)shape).intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.v.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite object) {
        AlphaComposite alphaComposite;
        if (object instanceof AlphaComposite && (alphaComposite = (AlphaComposite)object).getRule() == 3) {
            this.D = alphaComposite.getAlpha();
            this.E = alphaComposite;
            if (this.F != null && this.F instanceof Color) {
                object = (Color)this.F;
                this.h = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), (int)((float)((Color)object).getAlpha() * this.D));
            }
            return;
        }
        this.E = object;
        this.D = 1.0f;
    }

    @Override
    public void setPaint(Paint paint) {
        Object object;
        if (paint == null) {
            return;
        }
        this.h = paint;
        this.F = paint;
        if (this.E instanceof AlphaComposite && paint instanceof Color && ((AlphaComposite)(object = (AlphaComposite)this.E)).getRule() == 3) {
            object = (Color)paint;
            this.h = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), (int)((float)((Color)object).getAlpha() * this.D));
            this.F = paint;
        }
    }

    private Stroke a(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return stroke;
        }
        stroke = (BasicStroke)stroke;
        float f2 = (float)Math.sqrt(Math.abs(this.g.getDeterminant()));
        float[] fArray = ((BasicStroke)stroke).getDashArray();
        if (fArray != null) {
            int n2 = 0;
            while (n2 < fArray.length) {
                int n3 = n2++;
                fArray[n3] = fArray[n3] * f2;
            }
        }
        return new BasicStroke(((BasicStroke)stroke).getLineWidth() * f2, ((BasicStroke)stroke).getEndCap(), ((BasicStroke)stroke).getLineJoin(), ((BasicStroke)stroke).getMiterLimit(), fArray, ((BasicStroke)stroke).getDashPhase() * f2);
    }

    private void a(Stroke stroke, Stroke stroke2) {
        boolean bl2;
        block20: {
            block18: {
                BasicStroke basicStroke;
                block19: {
                    if (stroke == stroke2) {
                        return;
                    }
                    if (!(stroke instanceof BasicStroke)) {
                        return;
                    }
                    stroke = (BasicStroke)stroke;
                    int n2 = stroke2 instanceof BasicStroke;
                    basicStroke = null;
                    if (n2 != 0) {
                        basicStroke = (BasicStroke)stroke2;
                    }
                    if (n2 == 0 || ((BasicStroke)stroke).getLineWidth() != basicStroke.getLineWidth()) {
                        this.p.setLineWidth(((BasicStroke)stroke).getLineWidth());
                    }
                    if (n2 == 0 || ((BasicStroke)stroke).getEndCap() != basicStroke.getEndCap()) {
                        switch (((BasicStroke)stroke).getEndCap()) {
                            case 0: {
                                this.p.setLineCap(0);
                                break;
                            }
                            case 2: {
                                this.p.setLineCap(2);
                                break;
                            }
                            default: {
                                this.p.setLineCap(1);
                            }
                        }
                    }
                    if (n2 == 0 || ((BasicStroke)stroke).getLineJoin() != basicStroke.getLineJoin()) {
                        switch (((BasicStroke)stroke).getLineJoin()) {
                            case 0: {
                                this.p.setLineJoin(0);
                                break;
                            }
                            case 2: {
                                this.p.setLineJoin(2);
                                break;
                            }
                            default: {
                                this.p.setLineJoin(1);
                            }
                        }
                    }
                    if (n2 == 0 || ((BasicStroke)stroke).getMiterLimit() != basicStroke.getMiterLimit()) {
                        this.p.setMiterLimit(((BasicStroke)stroke).getMiterLimit());
                    }
                    if (n2 == 0) break block18;
                    if (((BasicStroke)stroke).getDashArray() == null) break block19;
                    if (((BasicStroke)stroke).getDashPhase() != basicStroke.getDashPhase()) break block18;
                    bl2 = !Arrays.equals(((BasicStroke)stroke).getDashArray(), basicStroke.getDashArray());
                    break block20;
                }
                bl2 = basicStroke.getDashArray() != null;
                break block20;
            }
            bl2 = true;
        }
        if (bl2) {
            float[] fArray = ((BasicStroke)stroke).getDashArray();
            if (fArray == null) {
                this.p.setLiteral("[]0 d\n");
                return;
            }
            this.p.setLiteral('[');
            int cfr_ignored_0 = fArray.length;
            for (float f2 : fArray) {
                this.p.setLiteral(f2);
                this.p.setLiteral(' ');
            }
            this.p.setLiteral(']');
            this.p.setLiteral(((BasicStroke)stroke).getDashPhase());
            this.p.setLiteral(" d\n");
        }
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.o = stroke;
        this.n = this.a(stroke);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (object != null) {
            this.m.put(key, object);
            return;
        }
        if (key instanceof HyperLinkKey) {
            this.m.put(key, HyperLinkKey.VALUE_HYPERLINKKEY_OFF);
            return;
        }
        this.m.remove(key);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.m.get(key);
    }

    public void setRenderingHints(Map map) {
        this.m.clear();
        this.m.putAll((Map<?, ?>)map);
    }

    public void addRenderingHints(Map map) {
        this.m.putAll((Map<?, ?>)map);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.m;
    }

    @Override
    public void translate(int n2, int n3) {
        this.translate((double)n2, (double)n3);
    }

    @Override
    public void translate(double d2, double d3) {
        this.g.translate(d2, d3);
    }

    @Override
    public void rotate(double d2) {
        this.g.rotate(d2);
    }

    @Override
    public void rotate(double d2, double d3, double d4) {
        this.g.rotate(d2, d3, d4);
    }

    @Override
    public void scale(double d2, double d3) {
        this.g.scale(d2, d3);
        this.n = this.a(this.o);
    }

    @Override
    public void shear(double d2, double d3) {
        this.g.shear(d2, d3);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.g.concatenate(affineTransform);
        this.n = this.a(this.o);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.g = new AffineTransform(affineTransform);
        this.n = this.a(this.o);
    }

    @Override
    public AffineTransform getTransform() {
        return new AffineTransform(this.g);
    }

    @Override
    public Paint getPaint() {
        if (this.F != null) {
            return this.F;
        }
        return this.h;
    }

    @Override
    public Composite getComposite() {
        return this.E;
    }

    @Override
    public void setBackground(Color color) {
        this.i = color;
    }

    @Override
    public Color getBackground() {
        return this.i;
    }

    @Override
    public Stroke getStroke() {
        return this.o;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        boolean bl2 = RenderingHints.VALUE_TEXT_ANTIALIAS_ON.equals(this.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
        boolean bl3 = RenderingHints.VALUE_FRACTIONALMETRICS_ON.equals(this.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
        return new FontRenderContext(new AffineTransform(), bl2, bl3);
    }

    @Override
    public Graphics create() {
        PdfGraphics2D pdfGraphics2D = new PdfGraphics2D();
        pdfGraphics2D.m.putAll((Map<?, ?>)this.m);
        pdfGraphics2D.w = this.w;
        pdfGraphics2D.g = new AffineTransform(this.g);
        pdfGraphics2D.q = this.q;
        pdfGraphics2D.s = this.s;
        pdfGraphics2D.h = this.h;
        pdfGraphics2D.fillGState = this.fillGState;
        pdfGraphics2D.currentFillGState = this.currentFillGState;
        pdfGraphics2D.currentStrokeGState = this.currentStrokeGState;
        pdfGraphics2D.strokeGState = this.strokeGState;
        pdfGraphics2D.i = this.i;
        pdfGraphics2D.A = this.A;
        pdfGraphics2D.B = this.B;
        pdfGraphics2D.C = this.C;
        pdfGraphics2D.setFont(this.d);
        pdfGraphics2D.p = this.p.getDuplicate();
        pdfGraphics2D.p.saveState();
        pdfGraphics2D.j = this.j;
        pdfGraphics2D.k = this.k;
        pdfGraphics2D.a(new Area(new Rectangle2D.Float(0.0f, 0.0f, this.j, this.k)), 3);
        if (this.l != null) {
            pdfGraphics2D.l = new Area(this.l);
        }
        pdfGraphics2D.E = this.E;
        pdfGraphics2D.n = this.n;
        pdfGraphics2D.o = this.o;
        pdfGraphics2D.a = (BasicStroke)pdfGraphics2D.a(pdfGraphics2D.a);
        pdfGraphics2D.x = pdfGraphics2D.a;
        PdfGraphics2D pdfGraphics2D2 = pdfGraphics2D;
        pdfGraphics2D2.a(pdfGraphics2D2.x, null);
        pdfGraphics2D.p.saveState();
        if (pdfGraphics2D.l != null) {
            PdfGraphics2D pdfGraphics2D3 = pdfGraphics2D;
            pdfGraphics2D3.a(pdfGraphics2D3.l, 3);
        }
        pdfGraphics2D.u = true;
        if (this.t == null) {
            this.t = new ArrayList<Object>();
        }
        this.t.add(this.p.getInternalBuffer().size());
        this.t.add(pdfGraphics2D);
        return pdfGraphics2D;
    }

    public PdfContentByte getContent() {
        return this.p;
    }

    @Override
    public Color getColor() {
        if (this.h instanceof Color) {
            return (Color)this.h;
        }
        return Color.black;
    }

    @Override
    public void setColor(Color color) {
        this.setPaint(color);
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public Font getFont() {
        return this.d;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (this.w) {
            this.d = font;
            return;
        }
        if (font == this.d) {
            return;
        }
        this.d = font;
        this.f = font.getSize2D();
        this.e = this.a(font);
    }

    private BaseFont a(Font font) {
        Map<String, BaseFont> map = this.q;
        synchronized (map) {
            BaseFont baseFont = this.q.get(font.getFontName());
            if (baseFont == null) {
                baseFont = this.s.awtToPdf(font);
                this.q.put(font.getFontName(), baseFont);
            }
            return baseFont;
        }
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.v.getFontMetrics(font);
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.l == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    @Override
    public void clipRect(int n2, int n3, int n4, int n5) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(n2, n3, n4, n5);
        this.clip(double_);
    }

    @Override
    public void setClip(int n2, int n3, int n4, int n5) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(n2, n3, n4, n5);
        this.setClip(double_);
    }

    @Override
    public void clip(Shape shape) {
        if (shape == null) {
            this.setClip(null);
            return;
        }
        shape = this.g.createTransformedShape(shape);
        if (this.l == null) {
            this.l = new Area(shape);
        } else {
            this.l.intersect(new Area(shape));
        }
        this.a(shape, 3);
    }

    @Override
    public Shape getClip() {
        try {
            return this.g.createInverse().createTransformedShape(this.l);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    @Override
    public void setClip(Shape shape) {
        this.p.restoreState();
        this.p.saveState();
        if (shape != null) {
            shape = this.g.createTransformedShape(shape);
        }
        if (shape == null) {
            this.l = null;
        } else {
            this.l = new Area(shape);
            this.a(shape, 3);
        }
        PdfGraphics2D pdfGraphics2D = this;
        pdfGraphics2D.z = null;
        pdfGraphics2D.y = null;
        PdfGraphics2D pdfGraphics2D2 = this;
        pdfGraphics2D2.currentStrokeGState = -1;
        pdfGraphics2D2.currentFillGState = -1;
        this.x = this.a;
    }

    @Override
    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    @Override
    public void drawLine(int n2, int n3, int n4, int n5) {
        Line2D.Double double_ = new Line2D.Double(n2, n3, n4, n5);
        this.draw(double_);
    }

    @Override
    public void drawRect(int n2, int n3, int n4, int n5) {
        this.draw(new Rectangle(n2, n3, n4, n5));
    }

    @Override
    public void fillRect(int n2, int n3, int n4, int n5) {
        this.fill(new Rectangle(n2, n3, n4, n5));
    }

    @Override
    public void clearRect(int n2, int n3, int n4, int n5) {
        Paint paint = this.h;
        PdfGraphics2D pdfGraphics2D = this;
        pdfGraphics2D.setPaint(pdfGraphics2D.i);
        this.fillRect(n2, n3, n4, n5);
        this.setPaint(paint);
    }

    @Override
    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n2, n3, n4, n5, n6, n7);
        this.draw(double_);
    }

    @Override
    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n2, n3, n4, n5, n6, n7);
        this.fill(double_);
    }

    @Override
    public void drawOval(int n2, int n3, int n4, int n5) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n2, n3, n4, n5);
        this.draw(float_);
    }

    @Override
    public void fillOval(int n2, int n3, int n4, int n5) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n2, n3, n4, n5);
        this.fill(float_);
    }

    @Override
    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        Arc2D.Double double_ = new Arc2D.Double(n2, n3, n4, n5, n6, n7, 0);
        this.draw(double_);
    }

    @Override
    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        Arc2D.Double double_ = new Arc2D.Double(n2, n3, n4, n5, n6, n7, 2);
        this.fill(double_);
    }

    @Override
    public void drawPolyline(int[] object, int[] nArray, int n2) {
        object = new PolylineShape((int[])object, nArray, n2);
        this.draw((Shape)object);
    }

    @Override
    public void drawPolygon(int[] object, int[] nArray, int n2) {
        object = new Polygon((int[])object, nArray, n2);
        this.draw((Shape)object);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        Polygon polygon = new Polygon();
        for (int i2 = 0; i2 < n2; ++i2) {
            polygon.addPoint(nArray[i2], nArray2[i2]);
        }
        this.fill(polygon);
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, null, imageObserver);
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, null, imageObserver);
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        this.a(image);
        return this.drawImage(image, n2, n3, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        this.a(image);
        double d2 = (double)n4 / (double)image.getWidth(imageObserver);
        double d3 = (double)n5 / (double)image.getHeight(imageObserver);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n2, n3);
        affineTransform.scale(d2, d3);
        return this.a(image, null, affineTransform, color, imageObserver);
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, null, imageObserver);
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        this.a(image);
        double d2 = (double)n4 - (double)n2;
        double d3 = (double)n5 - (double)n3;
        double d4 = (double)n8 - (double)n6;
        double d5 = (double)n9 - (double)n7;
        if (d2 == 0.0 || d3 == 0.0 || d4 == 0.0 || d5 == 0.0) {
            return true;
        }
        double d6 = d2 / d4;
        double d7 = d3 / d5;
        double d8 = (double)n6 * d6;
        double d9 = (double)n7 * d7;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)n2 - d8, (double)n3 - d9);
        affineTransform.scale(d6, d7);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(imageObserver), image.getHeight(imageObserver), 12);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.fillRect(n6, n7, (int)d4, (int)d5);
        this.a(image, bufferedImage, affineTransform, null, imageObserver);
        graphics.dispose();
        return true;
    }

    @Override
    public void dispose() {
        if (this.u) {
            return;
        }
        if (!this.r) {
            this.r = true;
            this.p.restoreState();
            this.p.restoreState();
            this.v.dispose();
            this.v = null;
            if (this.t != null) {
                ByteBuffer byteBuffer = new ByteBuffer();
                this.a(byteBuffer);
                ByteBuffer byteBuffer2 = this.p.getInternalBuffer();
                byteBuffer2.reset();
                byteBuffer2.append(byteBuffer);
            }
        }
    }

    private void a(ByteBuffer byteBuffer) {
        int n2 = 0;
        ByteBuffer byteBuffer2 = this.p.getInternalBuffer();
        if (this.t != null) {
            for (int i2 = 0; i2 < this.t.size(); i2 += 2) {
                int n3 = (Integer)this.t.get(i2);
                PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)this.t.get(i2 + 1);
                pdfGraphics2D.p.restoreState();
                pdfGraphics2D.p.restoreState();
                byteBuffer.append(byteBuffer2.getBuffer(), n2, n3 - n2);
                pdfGraphics2D.v.dispose();
                pdfGraphics2D.v = null;
                pdfGraphics2D.a(byteBuffer);
                n2 = n3;
            }
        }
        byteBuffer.append(byteBuffer2.getBuffer(), n2, byteBuffer2.size() - n2);
    }

    private void a(Shape object, int n2) {
        while (true) {
            if (object == null) {
                return;
            }
            if (n2 != 2 || this.n instanceof BasicStroke) break;
            object = this.n.createStrokedShape((Shape)object);
            n2 = 1;
        }
        if (n2 == 2) {
            PdfGraphics2D pdfGraphics2D = this;
            pdfGraphics2D.a(pdfGraphics2D.n, this.x);
            this.x = this.n;
            this.c();
        } else if (n2 == 1) {
            this.b();
        }
        int n3 = 0;
        object = n2 == 3 ? object.getPathIterator(b) : object.getPathIterator(this.g);
        float[] fArray = new float[6];
        while (!object.isDone()) {
            ++n3;
            int n4 = object.currentSegment(fArray);
            this.a(fArray);
            switch (n4) {
                case 4: {
                    this.p.closePath();
                    break;
                }
                case 3: {
                    this.p.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 1: {
                    this.p.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 0: {
                    this.p.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.p.curveTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                }
            }
            object.next();
        }
        switch (n2) {
            case 1: {
                if (n3 <= 0) break;
                if (object.getWindingRule() == 0) {
                    this.p.eoFill();
                    return;
                }
                this.p.fill();
                return;
            }
            case 2: {
                if (n3 <= 0) break;
                this.p.stroke();
                return;
            }
            default: {
                if (n3 == 0) {
                    this.p.rectangle(0.0f, 0.0f, 0.0f, 0.0f);
                }
                if (object.getWindingRule() == 0) {
                    this.p.eoClip();
                } else {
                    this.p.clip();
                }
                this.p.newPath();
            }
        }
    }

    private void a(float[] fArray) {
        float f2 = fArray[1];
        PdfGraphics2D pdfGraphics2D = this;
        fArray[1] = pdfGraphics2D.k - f2;
        f2 = fArray[3];
        pdfGraphics2D = this;
        fArray[3] = pdfGraphics2D.k - f2;
        f2 = fArray[5];
        pdfGraphics2D = this;
        fArray[5] = pdfGraphics2D.k - f2;
    }

    private AffineTransform a() {
        double[] dArray = new double[6];
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(0.0, 0.0);
        affineTransform.getMatrix(dArray);
        dArray[3] = -1.0;
        dArray[5] = this.k;
        affineTransform = new AffineTransform(dArray);
        affineTransform.concatenate(this.g);
        return affineTransform;
    }

    private boolean a(java.awt.Image object, java.awt.Image image, AffineTransform object2, Color object3, ImageObserver object4) {
        object2 = object2 == null ? new AffineTransform() : new AffineTransform((AffineTransform)object2);
        ((AffineTransform)object2).translate(0.0, ((java.awt.Image)object).getHeight((ImageObserver)object4));
        ((AffineTransform)object2).scale(((java.awt.Image)object).getWidth((ImageObserver)object4), ((java.awt.Image)object).getHeight((ImageObserver)object4));
        object4 = this.a();
        Object object5 = AffineTransform.getScaleInstance(1.0, -1.0);
        ((AffineTransform)object4).concatenate((AffineTransform)object2);
        ((AffineTransform)object4).concatenate((AffineTransform)object5);
        object2 = new double[6];
        ((AffineTransform)object4).getMatrix((double[])object2);
        if (this.currentFillGState != 255) {
            object4 = this.fillGState[255];
            if (object4 == null) {
                object4 = new PdfGState();
                ((PdfGState)object4).setFillOpacity(1.0f);
                this.fillGState[255] = object4;
            }
            this.p.setGState((PdfGState)object4);
        }
        try {
            if (!this.B) {
                object4 = Image.getInstance((java.awt.Image)object, (Color)object3);
            } else {
                object3 = new BufferedImage(((java.awt.Image)object).getWidth(null), ((java.awt.Image)object).getHeight(null), 1);
                object4 = ((BufferedImage)object3).createGraphics();
                ((Graphics)object4).drawImage((java.awt.Image)object, 0, 0, ((java.awt.Image)object).getWidth(null), ((java.awt.Image)object).getHeight(null), null);
                ((Graphics)object4).dispose();
                object = new ByteArrayOutputStream();
                object4 = new JPEGImageWriteParam(Locale.getDefault());
                ((ImageWriteParam)object4).setCompressionMode(2);
                ((ImageWriteParam)object4).setCompressionQuality(this.C);
                object5 = ImageIO.getImageWritersByFormatName("jpg").next();
                ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(object);
                ((ImageWriter)object5).setOutput(imageOutputStream);
                ((ImageWriter)object5).write(null, new IIOImage((RenderedImage)object3, null, null), (ImageWriteParam)object4);
                ((ImageWriter)object5).dispose();
                imageOutputStream.close();
                ((java.awt.Image)object3).flush();
                object4 = Image.getInstance(((ByteArrayOutputStream)object).toByteArray());
            }
            if (image != null) {
                object3 = Image.getInstance(image, null, true);
                ((Image)object3).makeMask();
                ((Image)object3).setInverted(true);
                ((Image)object4).setImageMask((Image)object3);
            }
            this.p.addImage((Image)object4, (float)object2[0], (float)object2[1], (float)object2[2], (float)object2[3], (float)object2[4], (float)object2[5]);
            object3 = this.getRenderingHint(HyperLinkKey.KEY_INSTANCE);
            if (object3 != null && !object3.equals(HyperLinkKey.VALUE_HYPERLINKKEY_OFF)) {
                object4 = new PdfAction(object3.toString());
                this.p.setAction((PdfAction)object4, (float)object2[4], (float)object2[5], (float)(object2[0] + object2[4]), (float)(object2[3] + object2[5]));
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
        if (this.currentFillGState != 255 && this.currentFillGState != -1) {
            object4 = this.fillGState[this.currentFillGState];
            this.p.setGState((PdfGState)object4);
        }
        return true;
    }

    private boolean a(Paint paint) {
        if (this.h == paint) {
            return false;
        }
        return !(this.h instanceof Color) || !this.h.equals(paint);
    }

    private void b() {
        PdfGraphics2D pdfGraphics2D = this;
        if (pdfGraphics2D.a(pdfGraphics2D.y)) {
            this.y = this.h;
            this.a(false, 0.0, 0.0, true);
        }
    }

    private void c() {
        PdfGraphics2D pdfGraphics2D = this;
        if (pdfGraphics2D.a(pdfGraphics2D.z)) {
            this.z = this.h;
            this.a(false, 0.0, 0.0, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(boolean bl2, double d2, double d3, boolean bl3) {
        if (this.h instanceof Color) {
            Color color = (Color)this.h;
            int n2 = color.getAlpha();
            if (bl3) {
                if (n2 != this.currentFillGState) {
                    this.currentFillGState = n2;
                    PdfGState pdfGState = this.fillGState[n2];
                    if (pdfGState == null) {
                        pdfGState = new PdfGState();
                        pdfGState.setFillOpacity((float)n2 / 255.0f);
                        this.fillGState[n2] = pdfGState;
                    }
                    this.p.setGState(pdfGState);
                }
                this.p.setColorFill(color);
                return;
            }
            if (n2 != this.currentStrokeGState) {
                this.currentStrokeGState = n2;
                PdfGState pdfGState = this.strokeGState[n2];
                if (pdfGState == null) {
                    pdfGState = new PdfGState();
                    pdfGState.setStrokeOpacity((float)n2 / 255.0f);
                    this.strokeGState[n2] = pdfGState;
                }
                this.p.setGState(pdfGState);
            }
            this.p.setColorStroke(color);
            return;
        }
        if (this.h instanceof GradientPaint) {
            Point2D point2D;
            Point2D point2D2;
            Object object = (GradientPaint)this.h;
            Point2D point2D3 = point2D2 = ((GradientPaint)object).getPoint1();
            this.g.transform(point2D3, point2D3);
            Point2D point2D4 = point2D = ((GradientPaint)object).getPoint2();
            this.g.transform(point2D4, point2D4);
            Color color = ((GradientPaint)object).getColor1();
            Color color2 = ((GradientPaint)object).getColor2();
            float f2 = (float)point2D2.getY();
            object = this;
            float f3 = ((PdfGraphics2D)object).k - f2;
            f2 = (float)point2D.getY();
            object = this;
            object = PdfShading.simpleAxial(this.p.getPdfWriter(), (float)point2D2.getX(), f3, (float)point2D.getX(), ((PdfGraphics2D)object).k - f2, color, color2);
            PdfShadingPattern pdfShadingPattern = new PdfShadingPattern((PdfShading)object);
            if (bl3) {
                this.p.setShadingFill(pdfShadingPattern);
                return;
            }
            this.p.setShadingStroke(pdfShadingPattern);
            return;
        }
        if (this.h instanceof TexturePaint) {
            try {
                Object object = (TexturePaint)this.h;
                Object object2 = ((TexturePaint)object).getImage();
                Rectangle2D rectangle2D = ((TexturePaint)object).getAnchorRect();
                Image image = Image.getInstance((java.awt.Image)object2, null);
                PdfPatternPainter pdfPatternPainter = this.p.createPattern(image.getWidth(), image.getHeight());
                object = this.a();
                ((AffineTransform)object).translate(rectangle2D.getX(), rectangle2D.getY());
                ((AffineTransform)object).scale(rectangle2D.getWidth() / (double)image.getWidth(), -rectangle2D.getHeight() / (double)image.getHeight());
                object2 = new double[6];
                ((AffineTransform)object).getMatrix((double[])object2);
                pdfPatternPainter.setPatternMatrix((float)object2[0], (float)object2[1], (float)object2[2], (float)object2[3], (float)object2[4], (float)object2[5]);
                image.setAbsolutePosition(0.0f, 0.0f);
                pdfPatternPainter.addImage(image);
                if (!bl3) {
                    this.p.setPatternStroke(pdfPatternPainter);
                    return;
                }
                this.p.setPatternFill(pdfPatternPainter);
                return;
            }
            catch (Exception exception) {
                if (bl3) {
                    this.p.setColorFill(Color.gray);
                    return;
                }
                this.p.setColorStroke(Color.gray);
                return;
            }
        }
        try {
            int n3 = 6;
            if (this.h.getTransparency() == 1) {
                n3 = 5;
            }
            Object object = new BufferedImage((int)this.j, (int)this.k, n3);
            Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
            graphics2D.transform(this.g);
            AffineTransform affineTransform = this.g.createInverse();
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, ((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
            Shape shape = affineTransform.createTransformedShape(double_);
            graphics2D.setPaint(this.h);
            graphics2D.fill(shape);
            graphics2D.dispose();
            object = Image.getInstance((java.awt.Image)object, null);
            PdfPatternPainter pdfPatternPainter = this.p.createPattern(this.j, this.k);
            ((Image)object).setAbsolutePosition(0.0f, 0.0f);
            pdfPatternPainter.addImage((Image)object);
            if (bl3) {
                if (this.currentFillGState != 255) {
                    this.currentFillGState = 255;
                    object = this.fillGState[255];
                    if (object == null) {
                        object = new PdfGState();
                        ((PdfGState)object).setFillOpacity(1.0f);
                        this.fillGState[255] = object;
                    }
                    this.p.setGState((PdfGState)object);
                }
            } else {
                this.p.setPatternStroke(pdfPatternPainter);
                return;
            }
            this.p.setPatternFill(pdfPatternPainter);
            return;
        }
        catch (Exception exception) {
            if (bl3) {
                this.p.setColorFill(Color.gray);
                return;
            }
            this.p.setColorStroke(Color.gray);
        }
    }

    private synchronized void a(java.awt.Image image) {
        if (this.A == null) {
            this.A = new MediaTracker(new a(0));
        }
        this.A.addImage(image, 0);
        try {
            this.A.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        this.A.removeImage(image);
    }

    private static class CompositeFontDrawer {
        private static final Class<?> a;
        private static final Method b;
        private static final Method c;
        private static final Class<?> d;
        private static final Method e;
        private static final Class<?> f;
        private static final Method g;
        private static final Method h;
        private static final boolean i;
        private final transient StringBuilder j = new StringBuilder();
        private final transient List<String> k = new ArrayList<String>();
        private final transient List<BaseFont> l = new ArrayList<BaseFont>();
        private final transient Map<String, Boolean> m = new HashMap<String, Boolean>();

        private CompositeFontDrawer() {
        }

        static boolean a() {
            return i;
        }

        private static Class<?> a(String string) {
            try {
                return Class.forName(string);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static Method a(Class<?> genericDeclaration, String string, Class<?> ... classArray) {
            if (genericDeclaration == null) {
                return null;
            }
            try {
                genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod(string, classArray);
                if (!((AccessibleObject)((Object)genericDeclaration)).isAccessible()) {
                    ((Method)genericDeclaration).setAccessible(true);
                }
            }
            catch (Exception exception) {
                genericDeclaration = null;
            }
            return genericDeclaration;
        }

        final boolean a(Font object) {
            if (!i || object == null) {
                assert (false);
                return false;
            }
            String string = ((Font)object).getFamily();
            if (string != null && this.m.containsKey(string)) {
                return this.m.get(string);
            }
            try {
                boolean bl2;
                object = e.invoke(null, object);
                boolean bl3 = bl2 = object != null && object.getClass() == a;
                if (string != null) {
                    this.m.put(string, bl2);
                }
                return bl2;
            }
            catch (Exception exception) {
                return false;
            }
        }

        final double a(String string, Font font, double d2, double d3, Function<Font, BaseFont> function, DrawStringFunction drawStringFunction) {
            Object object = font.getFamily();
            if (!i || object != null && !this.m.get(object).booleanValue()) {
                assert (false);
                return drawStringFunction.drawString(string, function.apply(font), d2, d3);
            }
            try {
                Object object2 = function;
                Font font2 = font;
                String string2 = string;
                object = this;
                Object object3 = e.invoke(null, font2);
                if (object3.getClass() != a) {
                    throw new IllegalArgumentException("Given font isn't a composite font.");
                }
                ((CompositeFontDrawer)object).j.setLength(0);
                ((CompositeFontDrawer)object).k.clear();
                ((CompositeFontDrawer)object).l.clear();
                BaseFont baseFont = object2.apply((Font)font2);
                Object object4 = null;
                Object object5 = b.invoke(object3, new Object[0]);
                int n2 = (Integer)object5;
                for (int i2 = 0; i2 < string2.length(); ++i2) {
                    char c2 = string2.charAt(i2);
                    boolean bl2 = false;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        Boolean bl3;
                        Object object6 = c.invoke(object3, i3);
                        if (object6 == null || !(bl3 = (Boolean)g.invoke(object6, Character.valueOf(c2))).booleanValue()) continue;
                        object6 = h.invoke(object6, new Object[]{null});
                        object6 = new Font((String)object6, font2.getStyle(), font2.getSize());
                        if ((object6 = (BaseFont)object2.apply(object6)) == null || !((BaseFont)object6).charExists(c2)) continue;
                        if (((CompositeFontDrawer)object).j.length() == 0) {
                            ((CompositeFontDrawer)object).l.add((BaseFont)object6);
                            object4 = object6;
                        } else if (!Objects.equals(object4, object6)) {
                            ((CompositeFontDrawer)object).k.add(((CompositeFontDrawer)object).j.toString());
                            ((CompositeFontDrawer)object).j.setLength(0);
                            ((CompositeFontDrawer)object).l.add((BaseFont)object6);
                            object4 = object6;
                        }
                        ((CompositeFontDrawer)object).j.append(c2);
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    if (((CompositeFontDrawer)object).j.length() == 0) {
                        ((CompositeFontDrawer)object).l.add(baseFont);
                        object4 = null;
                    } else if (object4 != null) {
                        ((CompositeFontDrawer)object).k.add(((CompositeFontDrawer)object).j.toString());
                        ((CompositeFontDrawer)object).j.setLength(0);
                        ((CompositeFontDrawer)object).l.add(baseFont);
                        object4 = null;
                    }
                    ((CompositeFontDrawer)object).j.append(c2);
                }
                ((CompositeFontDrawer)object).k.add(((CompositeFontDrawer)object).j.toString());
                ((CompositeFontDrawer)object).j.setLength(0);
                double d4 = 0.0;
                for (int i4 = 0; i4 < this.k.size(); ++i4) {
                    object2 = this.k.get(i4);
                    object3 = this.l.get(i4);
                    object3 = object3 == null ? function.apply(font) : object3;
                    d4 += drawStringFunction.drawString((String)object2, (BaseFont)object3, d2 + d4, d3);
                }
                return d4;
            }
            catch (Exception exception) {
                BaseFont baseFont = function.apply(font);
                return drawStringFunction.drawString(string, baseFont, d2, d3);
            }
        }

        /* synthetic */ CompositeFontDrawer(byte by) {
            this();
        }

        static {
            String string = System.getProperty("os.name", "unknownOS");
            boolean bl2 = string.startsWith("Mac");
            if (!bl2) {
                Object object;
                d = CompositeFontDrawer.a("sun.font.FontUtilities");
                String string2 = "sun.font";
                Object object2 = d;
                if (d != null && (object = CompositeFontDrawer.a(Class.class, "getModule", new Class[0])) != null) {
                    try {
                        object2 = ((Method)object).invoke(object2, new Object[0]);
                        if (object2 != null) {
                            GenericDeclaration genericDeclaration = object2.getClass();
                            object = ((Method)object).invoke(CompositeFontDrawer.class, new Object[0]);
                            Object object3 = CompositeFontDrawer.a(genericDeclaration, "isOpen", new Class[]{String.class, genericDeclaration});
                            if (object3 != null && (object3 = ((Method)object3).invoke(object2, string2, object)) instanceof Boolean && ((Boolean)object3).booleanValue()) {
                                genericDeclaration = CompositeFontDrawer.a(genericDeclaration, "addOpens", new Class[]{String.class, genericDeclaration});
                                if (object != null) {
                                    ((Method)genericDeclaration).invoke(object2, string2, object);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        object2 = exception;
                        exception.printStackTrace();
                    }
                }
                e = CompositeFontDrawer.a(d, "getFont2D", Font.class);
                a = CompositeFontDrawer.a("sun.font.CompositeFont");
                b = CompositeFontDrawer.a(a, "getNumSlots", new Class[0]);
                c = CompositeFontDrawer.a(a, "getSlotFont", Integer.TYPE);
                f = CompositeFontDrawer.a("sun.font.Font2D");
                g = CompositeFontDrawer.a(f, "canDisplay", Character.TYPE);
                h = CompositeFontDrawer.a(f, "getFontName", Locale.class);
            } else {
                d = null;
                e = null;
                a = null;
                b = null;
                c = null;
                f = null;
                g = null;
                h = null;
            }
            i = d != null && a != null && f != null && e != null && b != null && c != null && g != null && h != null;
        }

        @FunctionalInterface
        public static interface DrawStringFunction {
            public double drawString(String var1, BaseFont var2, double var3, double var5);
        }
    }

    public static class HyperLinkKey
    extends RenderingHints.Key {
        public static final HyperLinkKey KEY_INSTANCE = new HyperLinkKey(9999);
        public static final Object VALUE_HYPERLINKKEY_OFF = "0";

        protected HyperLinkKey(int n2) {
            super(n2);
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return true;
        }

        public String toString() {
            return "HyperLinkKey";
        }
    }

    private static final class a
    extends Component {
        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

