/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.util.ArrayList;

public class PdfLayer
extends PdfDictionary
implements PdfOCG {
    protected PdfIndirectReference ref;
    protected ArrayList<PdfLayer> children;
    protected PdfLayer parent;
    protected String title;
    private boolean a = true;
    private boolean b = true;

    PdfLayer(String string) {
        this.title = string;
    }

    public static PdfLayer createTitle(String object, PdfWriter pdfWriter) {
        if (object == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("title.cannot.be.null"));
        }
        object = new PdfLayer((String)object);
        pdfWriter.a((PdfLayer)object);
        return object;
    }

    public PdfLayer(String string, PdfWriter pdfWriter) {
        super(PdfName.OCG);
        this.setName(string);
        this.ref = pdfWriter.getPdfIndirectReference();
        pdfWriter.a(this);
    }

    final String a() {
        return this.title;
    }

    public void addChild(PdfLayer pdfObject) {
        if (((PdfLayer)pdfObject).parent != null) {
            String string = null;
            if ((pdfObject = ((PdfDictionary)pdfObject).getAsString(PdfName.NAME)) != null) {
                string = ((PdfString)pdfObject).toUnicodeString();
            }
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.layer.1.already.has.a.parent", string));
        }
        ((PdfLayer)pdfObject).parent = this;
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add((PdfLayer)pdfObject);
    }

    public PdfLayer getParent() {
        return this.parent;
    }

    public ArrayList<PdfLayer> getChildren() {
        return this.children;
    }

    @Override
    public PdfIndirectReference getRef() {
        return this.ref;
    }

    final void a(PdfIndirectReference pdfIndirectReference) {
        this.ref = pdfIndirectReference;
    }

    public void setName(String string) {
        this.put(PdfName.NAME, new PdfString(string, "UnicodeBig"));
    }

    @Override
    public PdfObject getPdfObject() {
        return this;
    }

    public boolean isOn() {
        return this.a;
    }

    public void setOn(boolean bl2) {
        this.a = bl2;
    }

    private PdfDictionary b() {
        PdfDictionary pdfDictionary = (PdfDictionary)this.get(PdfName.USAGE);
        if (pdfDictionary == null) {
            pdfDictionary = new PdfDictionary();
            this.put(PdfName.USAGE, pdfDictionary);
        }
        return pdfDictionary;
    }

    public void setCreatorInfo(String string, String string2) {
        PdfDictionary pdfDictionary = this.b();
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.CREATOR, new PdfString(string, "UnicodeBig"));
        pdfDictionary2.put(PdfName.SUBTYPE, new PdfName(string2));
        pdfDictionary.put(PdfName.CREATORINFO, pdfDictionary2);
    }

    public void setLanguage(String string, boolean bl2) {
        PdfDictionary pdfDictionary = this.b();
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.LANG, new PdfString(string, "UnicodeBig"));
        if (bl2) {
            pdfDictionary2.put(PdfName.PREFERRED, PdfName.ON);
        }
        pdfDictionary.put(PdfName.LANGUAGE, pdfDictionary2);
    }

    public void setExport(boolean bl2) {
        PdfDictionary pdfDictionary = this.b();
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.EXPORTSTATE, bl2 ? PdfName.ON : PdfName.OFF);
        pdfDictionary.put(PdfName.EXPORT, pdfDictionary2);
    }

    public void setZoom(float f2, float f3) {
        if (f2 <= 0.0f && f3 < 0.0f) {
            return;
        }
        PdfDictionary pdfDictionary = this.b();
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        if (f2 > 0.0f) {
            pdfDictionary2.put(PdfName.MIN_LOWER_CASE, new PdfNumber(f2));
        }
        if (f3 >= 0.0f) {
            pdfDictionary2.put(PdfName.MAX_LOWER_CASE, new PdfNumber(f3));
        }
        pdfDictionary.put(PdfName.ZOOM, pdfDictionary2);
    }

    public void setPrint(String string, boolean bl2) {
        PdfDictionary pdfDictionary = this.b();
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.SUBTYPE, new PdfName(string));
        pdfDictionary2.put(PdfName.PRINTSTATE, bl2 ? PdfName.ON : PdfName.OFF);
        pdfDictionary.put(PdfName.PRINT, pdfDictionary2);
    }

    public void setView(boolean bl2) {
        PdfDictionary pdfDictionary = this.b();
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.VIEWSTATE, bl2 ? PdfName.ON : PdfName.OFF);
        pdfDictionary.put(PdfName.VIEW, pdfDictionary2);
    }

    public boolean isOnPanel() {
        return this.b;
    }

    public void setOnPanel(boolean bl2) {
        this.b = bl2;
    }
}

