/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.ListItem;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.j;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfLine {
    protected ArrayList<PdfChunk> line;
    protected float left;
    protected float width;
    protected int alignment;
    protected float height;
    protected Chunk listSymbol = null;
    protected float symbolIndent;
    protected boolean newlineSplit = false;
    protected float originalWidth;
    protected boolean isRTL = false;

    PdfLine(float f2, float f3, int n2, float f4) {
        this.left = f2;
        this.originalWidth = this.width = f3 - f2;
        this.alignment = n2;
        this.height = f4;
        this.line = new ArrayList();
    }

    PdfLine(float f2, float f3, float f4, int n2, boolean bl2, ArrayList<PdfChunk> arrayList, boolean bl3) {
        this.left = 0.0f;
        this.originalWidth = f3;
        this.width = f4;
        this.alignment = n2;
        this.line = arrayList;
        this.newlineSplit = bl2;
        this.isRTL = bl3;
    }

    final PdfChunk a(PdfChunk pdfChunk) {
        if (pdfChunk == null || pdfChunk.toString().equals("")) {
            return null;
        }
        PdfChunk pdfChunk2 = pdfChunk.a(this.width);
        boolean bl2 = this.newlineSplit = pdfChunk.isNewlineSplit() || pdfChunk2 == null;
        if (pdfChunk.h()) {
            Object[] objectArray = (Object[])pdfChunk.a("TAB");
            float f2 = ((Float)objectArray[1]).floatValue();
            boolean bl3 = (Boolean)objectArray[2];
            if (bl3 && f2 < this.originalWidth - this.width) {
                return pdfChunk;
            }
            this.width = this.originalWidth - f2;
            pdfChunk.c(this.left);
            this.b(pdfChunk);
        } else if (pdfChunk.n() > 0 || pdfChunk.i()) {
            if (pdfChunk2 != null) {
                pdfChunk.trimLastSpace();
            }
            this.width -= pdfChunk.c();
            this.b(pdfChunk);
        } else {
            if (this.line.size() <= 0) {
                pdfChunk = pdfChunk2;
                pdfChunk2 = pdfChunk.b(this.width);
                this.width -= pdfChunk.c();
                if (pdfChunk.n() > 0) {
                    this.b(pdfChunk);
                    return pdfChunk2;
                }
                if (pdfChunk2 != null) {
                    this.b(pdfChunk2);
                }
                return null;
            }
            this.width += this.line.get(this.line.size() - 1).trimLastSpace();
        }
        return pdfChunk2;
    }

    private void b(PdfChunk pdfChunk) {
        if (pdfChunk.changeLeading && pdfChunk.i()) {
            float f2;
            float f3 = pdfChunk.j().getScaledHeight() + pdfChunk.l() + pdfChunk.j().getBorderWidthTop();
            if (f2 > this.height) {
                this.height = f3;
            }
        }
        this.line.add(pdfChunk);
    }

    public int size() {
        return this.line.size();
    }

    public Iterator iterator() {
        return this.line.iterator();
    }

    final float a() {
        return this.height;
    }

    final float b() {
        if (this.isRTL) {
            switch (this.alignment) {
                case 0: {
                    return this.left + this.width;
                }
                case 1: {
                    return this.left + this.width / 2.0f;
                }
            }
            return this.left;
        }
        if (this.g() == 0) {
            switch (this.alignment) {
                case 2: {
                    return this.left + this.width;
                }
                case 1: {
                    return this.left + this.width / 2.0f;
                }
            }
        }
        return this.left;
    }

    public boolean hasToBeJustified() {
        return (this.alignment == 3 || this.alignment == 8) && this.width != 0.0f;
    }

    public void resetAlignment() {
        if (this.alignment == 3) {
            this.alignment = 0;
        }
    }

    final void a(float f2) {
        this.left += f2;
        this.width -= f2;
    }

    final float c() {
        return this.width;
    }

    final int d() {
        String string = this.toString();
        int n2 = string.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) != ' ') continue;
            ++n3;
        }
        return n3;
    }

    public void setListItem(ListItem listItem) {
        this.listSymbol = listItem.getListSymbol();
        this.symbolIndent = listItem.getIndentationLeft();
    }

    public Chunk listSymbol() {
        return this.listSymbol;
    }

    public float listIndent() {
        return this.symbolIndent;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (PdfChunk pdfChunk : this.line) {
            stringBuilder.append(((Object)pdfChunk).toString());
        }
        return stringBuilder.toString();
    }

    public int GetLineLengthUtf32() {
        int n2 = 0;
        for (PdfChunk pdfChunk : this.line) {
            n2 += pdfChunk.o();
        }
        return n2;
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit && this.alignment != 8;
    }

    public int getLastStrokeChunk() {
        PdfChunk pdfChunk;
        int n2;
        for (n2 = this.line.size() - 1; n2 >= 0 && !(pdfChunk = this.line.get(n2)).d(); --n2) {
        }
        return n2;
    }

    public PdfChunk getChunk(int n2) {
        if (n2 < 0 || n2 >= this.line.size()) {
            return null;
        }
        return this.line.get(n2);
    }

    public float getOriginalWidth() {
        return this.originalWidth;
    }

    final float[] e() {
        float f2 = 0.0f;
        float f3 = -10000.0f;
        for (PdfChunk pdfChunk : this.line) {
            PdfChunk pdfChunk2 = pdfChunk;
            pdfChunk2 = pdfChunk;
            if (!pdfChunk.i()) {
                f2 = Math.max(pdfChunk2.a().a(), f2);
                continue;
            }
            f3 = Math.max(pdfChunk2.j().getScaledHeight() + pdfChunk2.l(), f3);
        }
        return new float[]{f2, f3};
    }

    final boolean f() {
        return this.isRTL;
    }

    final int g() {
        int n2 = 0;
        for (PdfChunk pdfChunk : this.line) {
            PdfChunk pdfChunk2;
            pdfChunk = pdfChunk;
            if (pdfChunk2.h()) {
                return 0;
            }
            if (!pdfChunk.f()) continue;
            ++n2;
        }
        return n2;
    }

    public float getWidthCorrected(float f2, float f3) {
        float f4 = 0.0f;
        for (PdfChunk pdfChunk : this.line) {
            f4 += pdfChunk.getWidthCorrected(f2, f3);
        }
        return f4;
    }

    public float getAscender() {
        float f2 = 0.0f;
        Iterator<PdfChunk> iterator = this.line.iterator();
        while (iterator.hasNext()) {
            PdfChunk pdfChunk;
            PdfChunk pdfChunk2 = pdfChunk = iterator.next();
            if (pdfChunk.i()) {
                f2 = Math.max(f2, pdfChunk2.j().getScaledHeight() + pdfChunk2.l());
                continue;
            }
            j j2 = pdfChunk2.a();
            f2 = Math.max(f2, j2.b().getFontDescriptor(1, j2.a()));
        }
        return f2;
    }

    public float getDescender() {
        float f2 = 0.0f;
        Iterator<PdfChunk> iterator = this.line.iterator();
        while (iterator.hasNext()) {
            PdfChunk pdfChunk;
            PdfChunk pdfChunk2 = pdfChunk = iterator.next();
            if (pdfChunk.i()) {
                f2 = Math.min(f2, pdfChunk2.l());
                continue;
            }
            j j2 = pdfChunk2.a();
            f2 = Math.min(f2, j2.b().getFontDescriptor(3, j2.a()));
        }
        return f2;
    }
}

