/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.k;
import java.io.IOException;
import java.io.PrintStream;

public class PdfLister {
    private PrintStream a;

    public PdfLister(PrintStream printStream) {
        this.a = printStream;
    }

    public void listAnyObject(PdfObject pdfObject) {
        switch (pdfObject.type()) {
            case 5: {
                this.listArray((PdfArray)pdfObject);
                return;
            }
            case 6: {
                this.listDict((PdfDictionary)pdfObject);
                return;
            }
            case 3: {
                this.a.println("(" + pdfObject.toString() + ")");
                return;
            }
        }
        this.a.println(pdfObject.toString());
    }

    public void listDict(PdfDictionary pdfDictionary) {
        this.a.println("<<");
        for (PdfName pdfName : pdfDictionary.getKeys()) {
            PdfObject pdfObject = pdfDictionary.get(pdfName);
            this.a.print(pdfName.toString());
            this.a.print(' ');
            this.listAnyObject(pdfObject);
        }
        this.a.println(">>");
    }

    public void listArray(PdfArray pdfArray) {
        this.a.println('[');
        pdfArray.getElements().forEach(this::listAnyObject);
        this.a.println(']');
    }

    public void listStream(PRStream object, k k2) {
        try {
            this.listDict((PdfDictionary)object);
            this.a.println("startstream");
            byte[] byArray = PdfReader.getStreamBytes((PRStream)object);
            object = byArray;
            int n2 = byArray.length - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (object[i2] != 13 || object[i2 + 1] == 10) continue;
                object[i2] = 10;
            }
            this.a.println(new String((byte[])object));
            this.a.println("endstream");
            return;
        }
        catch (IOException iOException) {
            System.err.println("I/O exception: " + iOException);
            return;
        }
    }

    public void listPage(PdfImportedPage object) {
        int n2 = ((PdfImportedPage)object).getPageNumber();
        Object object22 = object;
        object = ((PdfImportedPage)object22).a;
        k k2 = object;
        PdfReader pdfReader = ((k)object).c;
        Object object3 = pdfReader.getPageN(n2);
        this.listDict((PdfDictionary)object3);
        object3 = PdfReader.getPdfObject(((PdfDictionary)object3).get(PdfName.CONTENTS));
        if (object3 == null) {
            return;
        }
        switch (((PdfObject)object3).type) {
            case 7: {
                this.listStream((PRStream)object3, (k)object);
                return;
            }
            case 5: {
                for (PdfObject pdfObject : ((PdfArray)object3).getElements()) {
                    PdfObject pdfObject2 = PdfReader.getPdfObject(pdfObject);
                    this.listStream((PRStream)pdfObject2, (k)object);
                    this.a.println("-----------");
                }
                break;
            }
        }
    }
}

