/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PdfNameTree {
    public static PdfDictionary writeTree(HashMap<String, ? extends PdfObject> hashMap, PdfWriter pdfWriter) {
        return PdfNameTree.writeTree(hashMap, pdfWriter);
    }

    public static PdfDictionary writeTree(Map<String, ? extends PdfObject> object, PdfWriter pdfWriter) {
        int n2;
        int n3;
        int n4;
        if (object.isEmpty()) {
            return null;
        }
        Object[] objectArray = object.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        if (objectArray.length <= 64) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            Object[] objectArray2 = objectArray;
            int n5 = objectArray.length;
            for (int i2 = 0; i2 < n5; ++i2) {
                Object object2 = objectArray2[i2];
                pdfArray.add(new PdfString((String)object2, null));
                pdfArray.add(object.get(object2));
            }
            pdfDictionary.put(PdfName.NAMES, pdfArray);
            return pdfDictionary;
        }
        int n6 = 64;
        PdfIndirectReference[] pdfIndirectReferenceArray = new PdfIndirectReference[(objectArray.length + 64 - 1) / 64];
        for (n4 = 0; n4 < pdfIndirectReferenceArray.length; ++n4) {
            n2 = Math.min(n3 + 64, objectArray.length);
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            pdfArray.add(new PdfString((String)objectArray[n3], null));
            pdfArray.add(new PdfString((String)objectArray[n2 - 1], null));
            pdfDictionary.put(PdfName.LIMITS, pdfArray);
            pdfArray = new PdfArray();
            for (n3 = n4 << 6; n3 < n2; ++n3) {
                pdfArray.add(new PdfString((String)objectArray[n3], null));
                pdfArray.add((PdfObject)object.get(objectArray[n3]));
            }
            pdfDictionary.put(PdfName.NAMES, pdfArray);
            pdfIndirectReferenceArray[n4] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
        }
        n4 = pdfIndirectReferenceArray.length;
        while (true) {
            if (n4 <= 64) {
                PdfArray pdfArray = new PdfArray();
                for (n2 = 0; n2 < n4; ++n2) {
                    pdfArray.add(pdfIndirectReferenceArray[n2]);
                }
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                return pdfDictionary;
            }
            n3 = (objectArray.length + (n6 <<= 6) - 1) / n6;
            for (n2 = 0; n2 < n3; ++n2) {
                int n7;
                int n8 = Math.min(n7 + 64, n4);
                object = new PdfDictionary();
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(new PdfString((String)objectArray[n2 * n6], null));
                pdfArray.add(new PdfString((String)objectArray[Math.min((n2 + 1) * n6, objectArray.length) - 1], null));
                ((PdfDictionary)object).put(PdfName.LIMITS, pdfArray);
                pdfArray = new PdfArray();
                for (n7 = n2 << 6; n7 < n8; ++n7) {
                    pdfArray.add(pdfIndirectReferenceArray[n7]);
                }
                ((PdfDictionary)object).put(PdfName.KIDS, pdfArray);
                pdfIndirectReferenceArray[n2] = pdfWriter.addToBody((PdfObject)object).getIndirectReference();
            }
            n4 = n3;
        }
    }

    private static void a(PdfDictionary pdfDictionary, HashMap<String, PdfObject> hashMap) {
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.NAMES));
        if (pdfArray != null) {
            for (int i2 = 0; i2 < pdfArray.size(); ++i2) {
                PdfString pdfString = (PdfString)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(i2++));
                hashMap.put(PdfEncodings.convertToString(((PdfObject)pdfString).getBytes(), null), pdfArray.getPdfObject(i2));
            }
            return;
        }
        pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.KIDS));
        if (pdfArray != null) {
            for (int i3 = 0; i3 < pdfArray.size(); ++i3) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(i3));
                PdfNameTree.a(pdfDictionary2, hashMap);
            }
        }
    }

    public static HashMap<String, PdfObject> readTree(PdfDictionary pdfDictionary) {
        HashMap<String, PdfObject> hashMap = new HashMap<String, PdfObject>();
        if (pdfDictionary != null) {
            PdfNameTree.a(pdfDictionary, hashMap);
        }
        return hashMap;
    }
}

