/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfObject;
import java.util.Objects;

public class PdfNumber
extends PdfObject
implements Comparable<PdfNumber> {
    private double a;

    public PdfNumber(String string) {
        super(2);
        try {
            this.a = Double.parseDouble(string.trim());
            this.setContent(string);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("1.is.not.a.valid.number.2", string, numberFormatException.toString()));
        }
    }

    public PdfNumber(int n2) {
        super(2);
        this.a = n2;
        this.setContent(String.valueOf(n2));
    }

    public PdfNumber(long l2) {
        super(2);
        this.a = l2;
        this.setContent(String.valueOf(l2));
    }

    public PdfNumber(double d2) {
        super(2);
        this.a = d2;
        this.setContent(ByteBuffer.formatDouble(d2));
    }

    public PdfNumber(float f2) {
        this((double)f2);
    }

    public int intValue() {
        return (int)this.a;
    }

    public double doubleValue() {
        return this.a;
    }

    public float floatValue() {
        return (float)this.a;
    }

    public void increment() {
        this.a += 1.0;
        PdfNumber pdfNumber = this;
        pdfNumber.setContent(ByteBuffer.formatDouble(pdfNumber.a));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PdfNumber)) {
            return false;
        }
        object = (PdfNumber)object;
        return Double.compare(((PdfNumber)object).a, this.a) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.a);
    }

    @Override
    public int compareTo(PdfNumber pdfNumber) {
        Objects.requireNonNull(pdfNumber, "PdfNumber is null, can't be compared to current instance.");
        if (this == pdfNumber) {
            return 0;
        }
        return Double.compare(pdfNumber.a, this.a);
    }
}

