/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PdfOutline
extends PdfDictionary {
    private PdfIndirectReference a;
    private int b = 0;
    private PdfOutline c;
    private PdfDestination d;
    private PdfAction e;
    protected List<PdfOutline> kids = new ArrayList<PdfOutline>();
    protected PdfWriter writer;
    private String f;
    private boolean g;
    private Color h;
    private int i = 0;

    PdfOutline(PdfWriter pdfWriter) {
        super(OUTLINES);
        this.g = true;
        this.c = null;
        this.writer = pdfWriter;
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, String string) {
        this(pdfOutline, pdfAction, string, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, String string, boolean bl2) {
        this.e = pdfAction;
        this.a(pdfOutline, string, bl2);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, String string) {
        this(pdfOutline, pdfDestination, string, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, String string, boolean bl2) {
        this.d = pdfDestination;
        this.a(pdfOutline, string, bl2);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, PdfString pdfString) {
        this(pdfOutline, pdfAction, pdfString, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, PdfString pdfString, boolean bl2) {
        this(pdfOutline, pdfAction, ((PdfObject)pdfString).toString(), bl2);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, PdfString pdfString) {
        this(pdfOutline, pdfDestination, pdfString, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, PdfString pdfString, boolean bl2) {
        this(pdfOutline, pdfDestination, ((PdfObject)pdfString).toString(), true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, Paragraph paragraph) {
        this(pdfOutline, pdfAction, paragraph, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfAction pdfAction, Paragraph object, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : ((Phrase)((Object)object)).getChunks()) {
            Chunk object2 = (Chunk)element;
            stringBuilder.append(object2.getContent());
        }
        this.e = pdfAction;
        this.a(pdfOutline, stringBuilder.toString(), bl2);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, Paragraph paragraph) {
        this(pdfOutline, pdfDestination, paragraph, true);
    }

    public PdfOutline(PdfOutline pdfOutline, PdfDestination pdfDestination, Paragraph object, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : ((Phrase)((Object)object)).getChunks()) {
            Chunk object2 = (Chunk)element;
            stringBuilder.append(object2.getContent());
        }
        this.d = pdfDestination;
        this.a(pdfOutline, stringBuilder.toString(), bl2);
    }

    private void a(PdfOutline pdfOutline, String string, boolean bl2) {
        this.g = bl2;
        this.c = pdfOutline;
        this.writer = pdfOutline.writer;
        this.put(PdfName.TITLE, new PdfString(string, "UnicodeBig"));
        pdfOutline.addKid(this);
        if (this.d != null && !this.d.hasPage()) {
            PdfOutline pdfOutline2 = this;
            pdfOutline2.setDestinationPage(pdfOutline2.writer.m());
        }
    }

    public void setIndirectReference(PdfIndirectReference pdfIndirectReference) {
        this.a = pdfIndirectReference;
    }

    public PdfIndirectReference indirectReference() {
        return this.a;
    }

    public PdfOutline parent() {
        return this.c;
    }

    public boolean setDestinationPage(PdfIndirectReference pdfIndirectReference) {
        if (this.d == null) {
            return false;
        }
        return this.d.addPage(pdfIndirectReference);
    }

    public PdfDestination getPdfDestination() {
        return this.d;
    }

    final int a() {
        return this.b;
    }

    final void a(int n2) {
        this.b = n2;
    }

    public int level() {
        if (this.c == null) {
            return 0;
        }
        return this.c.level() + 1;
    }

    @Override
    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) {
        if (this.h != null && !this.h.equals(Color.black)) {
            this.put(PdfName.C, new PdfArray(new float[]{(float)this.h.getRed() / 255.0f, (float)this.h.getGreen() / 255.0f, (float)this.h.getBlue() / 255.0f}));
        }
        int n2 = 0;
        if ((this.i & 1) != 0) {
            n2 = 2;
        }
        if ((this.i & 2) != 0) {
            n2 |= 1;
        }
        if (n2 != 0) {
            this.put(PdfName.F, new PdfNumber(n2));
        }
        if (this.c != null) {
            this.put(PdfName.PARENT, this.c.indirectReference());
        }
        if (this.d != null && this.d.hasPage()) {
            this.put(PdfName.DEST, this.d);
        }
        if (this.e != null) {
            this.put(PdfName.A, this.e);
        }
        if (this.b != 0) {
            this.put(PdfName.COUNT, new PdfNumber(this.b));
        }
        super.toPdf(pdfWriter, outputStream);
    }

    public void addKid(PdfOutline pdfOutline) {
        this.kids.add(pdfOutline);
    }

    public List<PdfOutline> getKids() {
        return this.kids;
    }

    public void setKids(List<PdfOutline> list) {
        this.kids = list;
    }

    public String getTag() {
        return this.f;
    }

    public void setTag(String string) {
        this.f = string;
    }

    public String getTitle() {
        PdfString pdfString = (PdfString)this.get(PdfName.TITLE);
        return ((PdfObject)pdfString).toString();
    }

    public void setTitle(String string) {
        this.put(PdfName.TITLE, new PdfString(string, "UnicodeBig"));
    }

    public boolean isOpen() {
        return this.g;
    }

    public void setOpen(boolean bl2) {
        this.g = bl2;
    }

    public Color getColor() {
        return this.h;
    }

    public void setColor(Color color) {
        this.h = color;
    }

    public int getStyle() {
        return this.i;
    }

    public void setStyle(int n2) {
        this.i = n2;
    }
}

