/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.events.PdfPCellEventForwarder;
import java.util.List;

public class PdfPCell
extends Rectangle {
    private ColumnText a = new ColumnText(null);
    private int b = 4;
    private float c = 2.0f;
    private float d = 2.0f;
    private float e = 2.0f;
    private float f = 2.0f;
    private float g = 0.0f;
    private float h;
    private boolean i = false;
    private PdfPTable j;
    private int k = 1;
    private int l = 1;
    private Image m;
    private PdfPCellEvent n;
    private boolean o;
    private boolean p = false;
    protected Phrase phrase;
    private int q;

    public PdfPCell() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.a.setLeading(0.0f, 1.0f);
    }

    public PdfPCell(Phrase phrase) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.phrase = phrase;
        this.a.addText(this.phrase);
        this.a.setLeading(0.0f, 1.0f);
    }

    public PdfPCell(Image image) {
        this(image, false);
    }

    public PdfPCell(Image image, boolean bl2) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        if (bl2) {
            this.m = image;
            this.a.setLeading(0.0f, 1.0f);
            PdfPCell pdfPCell = this;
            pdfPCell.setPadding(pdfPCell.borderWidth / 2.0f);
            return;
        }
        this.phrase = new Phrase(new Chunk(image, 0.0f, 0.0f));
        this.a.addText(this.phrase);
        this.a.setLeading(0.0f, 1.0f);
        this.setPadding(0.0f);
    }

    public PdfPCell(PdfPTable pdfPTable) {
        this(pdfPTable, null);
    }

    public PdfPCell(PdfPTable pdfPTable, PdfPCell pdfPCell) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.borderWidth = 0.5f;
        this.border = 15;
        this.a.setLeading(0.0f, 1.0f);
        this.j = pdfPTable;
        pdfPTable.setWidthPercentage(100.0f);
        pdfPTable.setExtendLastRow(true);
        this.a.addElement(pdfPTable);
        if (pdfPCell != null) {
            this.cloneNonPositionParameters(pdfPCell);
            this.b = pdfPCell.b;
            this.c = pdfPCell.c;
            this.d = pdfPCell.d;
            this.e = pdfPCell.e;
            this.f = pdfPCell.f;
            this.k = pdfPCell.k;
            this.l = pdfPCell.l;
            this.n = pdfPCell.n;
            this.o = pdfPCell.o;
            this.p = pdfPCell.p;
            this.q = pdfPCell.q;
            return;
        }
        this.setPadding(0.0f);
    }

    public PdfPCell(PdfPCell pdfPCell) {
        super(pdfPCell.llx, pdfPCell.lly, pdfPCell.urx, pdfPCell.ury);
        this.cloneNonPositionParameters(pdfPCell);
        this.b = pdfPCell.b;
        this.c = pdfPCell.c;
        this.d = pdfPCell.d;
        this.e = pdfPCell.e;
        this.f = pdfPCell.f;
        this.phrase = pdfPCell.phrase;
        this.g = pdfPCell.g;
        this.h = pdfPCell.h;
        this.i = pdfPCell.i;
        this.k = pdfPCell.k;
        this.l = pdfPCell.l;
        if (pdfPCell.j != null) {
            this.j = new PdfPTable(pdfPCell.j);
        }
        this.m = Image.getInstance(pdfPCell.m);
        this.n = pdfPCell.n;
        this.o = pdfPCell.o;
        this.a = ColumnText.duplicate(pdfPCell.a);
        this.p = pdfPCell.p;
        this.q = pdfPCell.q;
    }

    public void addElement(Element element) {
        if (this.j != null) {
            this.j = null;
            this.a.setText(null);
        }
        this.a.addElement(element);
    }

    public Phrase getPhrase() {
        return this.phrase;
    }

    public void setPhrase(Phrase phrase) {
        this.j = null;
        this.m = null;
        this.phrase = phrase;
        this.a.setText(this.phrase);
    }

    public int getHorizontalAlignment() {
        return this.a.getAlignment();
    }

    public void setHorizontalAlignment(int n2) {
        this.a.setAlignment(n2);
    }

    public int getVerticalAlignment() {
        return this.b;
    }

    public void setVerticalAlignment(int n2) {
        if (this.j != null) {
            this.j.setExtendLastRow(n2 == 4);
        }
        this.b = n2;
    }

    public float getEffectivePaddingLeft() {
        if (this.isUseBorderPadding()) {
            float f2 = this.getBorderWidthLeft() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.c + f2;
        }
        return this.c;
    }

    public float getPaddingLeft() {
        return this.c;
    }

    public void setPaddingLeft(float f2) {
        this.c = f2;
    }

    public float getEffectivePaddingRight() {
        if (this.isUseBorderPadding()) {
            float f2 = this.getBorderWidthRight() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.d + f2;
        }
        return this.d;
    }

    public float getPaddingRight() {
        return this.d;
    }

    public void setPaddingRight(float f2) {
        this.d = f2;
    }

    public float getEffectivePaddingTop() {
        if (this.isUseBorderPadding()) {
            float f2 = this.getBorderWidthTop() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.e + f2;
        }
        return this.e;
    }

    public float getPaddingTop() {
        return this.e;
    }

    public void setPaddingTop(float f2) {
        this.e = f2;
    }

    public float getEffectivePaddingBottom() {
        if (this.isUseBorderPadding()) {
            float f2 = this.getBorderWidthBottom() / (this.isUseVariableBorders() ? 1.0f : 2.0f);
            return this.f + f2;
        }
        return this.f;
    }

    public float getPaddingBottom() {
        return this.f;
    }

    public void setPaddingBottom(float f2) {
        this.f = f2;
    }

    public void setPadding(float f2) {
        this.f = f2;
        this.e = f2;
        this.c = f2;
        this.d = f2;
    }

    public boolean isUseBorderPadding() {
        return this.p;
    }

    public void setUseBorderPadding(boolean bl2) {
        this.p = bl2;
    }

    public void setLeading(float f2, float f3) {
        this.a.setLeading(f2, f3);
    }

    public float getLeading() {
        return this.a.getLeading();
    }

    public float getMultipliedLeading() {
        return this.a.getMultipliedLeading();
    }

    public void setIndent(float f2) {
        this.a.setIndent(f2);
    }

    public float getIndent() {
        return this.a.getIndent();
    }

    public float getExtraParagraphSpace() {
        return this.a.getExtraParagraphSpace();
    }

    public void setExtraParagraphSpace(float f2) {
        this.a.setExtraParagraphSpace(f2);
    }

    public void setFixedHeight(float f2) {
        this.g = f2;
        this.h = 0.0f;
    }

    public float getFixedHeight() {
        return this.g;
    }

    public boolean hasFixedHeight() {
        return this.getFixedHeight() > 0.0f;
    }

    public void setMinimumHeight(float f2) {
        this.h = f2;
        this.g = 0.0f;
    }

    public float getMinimumHeight() {
        return this.h;
    }

    public boolean hasMinimumHeight() {
        return this.getMinimumHeight() > 0.0f;
    }

    public boolean isNoWrap() {
        return this.i;
    }

    public void setNoWrap(boolean bl2) {
        this.i = bl2;
    }

    public PdfPTable getTable() {
        return this.j;
    }

    final void a(PdfPTable pdfPTable) {
        this.j = pdfPTable;
        this.a.setText(null);
        this.m = null;
        if (pdfPTable != null) {
            pdfPTable.setExtendLastRow(this.b == 4);
            this.a.addElement(pdfPTable);
            pdfPTable.setWidthPercentage(100.0f);
        }
    }

    public int getColspan() {
        return this.k;
    }

    public void setColspan(int n2) {
        this.k = n2;
    }

    public int getRowspan() {
        return this.l;
    }

    public void setRowspan(int n2) {
        this.l = n2;
    }

    public void setFollowingIndent(float f2) {
        this.a.setFollowingIndent(f2);
    }

    public float getFollowingIndent() {
        return this.a.getFollowingIndent();
    }

    public void setRightIndent(float f2) {
        this.a.setRightIndent(f2);
    }

    public float getRightIndent() {
        return this.a.getRightIndent();
    }

    public float getSpaceCharRatio() {
        return this.a.getSpaceCharRatio();
    }

    public void setSpaceCharRatio(float f2) {
        this.a.setSpaceCharRatio(f2);
    }

    public void setRunDirection(int n2) {
        this.a.setRunDirection(n2);
    }

    public int getRunDirection() {
        return this.a.getRunDirection();
    }

    public Image getImage() {
        return this.m;
    }

    public void setImage(Image image) {
        this.a.setText(null);
        this.j = null;
        this.m = image;
    }

    public PdfPCellEvent getCellEvent() {
        return this.n;
    }

    public void setCellEvent(PdfPCellEvent pdfPCellEvent) {
        if (pdfPCellEvent == null) {
            this.n = null;
            return;
        }
        if (this.n == null) {
            this.n = pdfPCellEvent;
            return;
        }
        if (this.n instanceof PdfPCellEventForwarder) {
            ((PdfPCellEventForwarder)this.n).addCellEvent(pdfPCellEvent);
            return;
        }
        PdfPCellEventForwarder pdfPCellEventForwarder = new PdfPCellEventForwarder();
        pdfPCellEventForwarder.addCellEvent(this.n);
        pdfPCellEventForwarder.addCellEvent(pdfPCellEvent);
        this.n = pdfPCellEventForwarder;
    }

    public int getArabicOptions() {
        return this.a.getArabicOptions();
    }

    public void setArabicOptions(int n2) {
        this.a.setArabicOptions(n2);
    }

    public boolean isUseAscender() {
        return this.a.isUseAscender();
    }

    public void setUseAscender(boolean bl2) {
        this.a.setUseAscender(bl2);
    }

    public boolean isUseDescender() {
        return this.o;
    }

    public void setUseDescender(boolean bl2) {
        this.o = bl2;
    }

    public ColumnText getColumn() {
        return this.a;
    }

    public List getCompositeElements() {
        return this.getColumn().compositeElements;
    }

    public void setColumn(ColumnText columnText) {
        this.a = columnText;
    }

    @Override
    public int getRotation() {
        return this.q;
    }

    @Override
    public void setRotation(int n2) {
        if ((n2 %= 360) < 0) {
            n2 += 360;
        }
        if (n2 % 90 != 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("rotation.must.be.a.multiple.of.90"));
        }
        this.q = n2;
    }

    final void a(float f2) {
        float f3 = this.getRight() - this.getEffectivePaddingRight();
        float f4 = this.getLeft() + this.getEffectivePaddingLeft();
        f2 = f2 - this.getEffectivePaddingTop() - this.getEffectivePaddingBottom();
        if (((Rectangle)this).getRotation() != 90 && ((Rectangle)this).getRotation() != 270) {
            this.a.setSimpleColumn(f4, f2 + 0.001f, f3, 0.0f);
        } else {
            this.a.setSimpleColumn(0.0f, f4, f2 + 0.001f, f3);
        }
        try {
            this.a.go(true);
            return;
        }
        catch (DocumentException documentException) {
            return;
        }
    }

    public float getMaxHeight() {
        float f2;
        boolean bl2 = ((Rectangle)this).getRotation() == 90 || ((Rectangle)this).getRotation() == 270;
        Image image = this.getImage();
        if (image != null) {
            image.scalePercent(100.0f);
            f2 = bl2 ? image.getScaledHeight() : image.getScaledWidth();
            float f3 = (this.getRight() - this.getEffectivePaddingRight() - this.getEffectivePaddingLeft() - this.getLeft()) / f2;
            image.scalePercent(f3 * 100.0f);
            float f4 = bl2 ? image.getScaledWidth() : image.getScaledHeight();
            PdfPCell pdfPCell = this;
            pdfPCell.setBottom(pdfPCell.getTop() - this.getEffectivePaddingTop() - this.getEffectivePaddingBottom() - f4);
        } else if (bl2 && this.hasFixedHeight() || this.getColumn() == null) {
            PdfPCell pdfPCell = this;
            pdfPCell.setBottom(pdfPCell.getTop() - this.getFixedHeight());
        } else {
            float f5;
            float f6;
            float f7;
            float f8;
            ColumnText columnText = ColumnText.duplicate(this.getColumn());
            if (bl2) {
                f8 = 20000.0f;
                f7 = this.getRight() - this.getEffectivePaddingRight();
                f6 = 0.0f;
                f5 = this.getLeft() + this.getEffectivePaddingLeft();
            } else {
                f8 = this.isNoWrap() ? 20000.0f : this.getRight() - this.getEffectivePaddingRight();
                f7 = this.getTop() - this.getEffectivePaddingTop();
                f6 = this.getLeft() + this.getEffectivePaddingLeft();
                f5 = this.hasFixedHeight() ? this.getTop() + this.getEffectivePaddingBottom() - this.getFixedHeight() : -1.0737418E9f;
            }
            float f9 = f5;
            PdfPRow.setColumn(columnText, f6, f9, f8, f7);
            try {
                columnText.go(true);
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
            if (bl2) {
                PdfPCell pdfPCell = this;
                pdfPCell.setBottom(pdfPCell.getTop() - this.getEffectivePaddingTop() - this.getEffectivePaddingBottom() - columnText.getFilledWidth());
            } else {
                float f10 = columnText.getYLine();
                if (this.isUseDescender()) {
                    f10 += columnText.getDescender();
                }
                this.setBottom(f10 - this.getEffectivePaddingBottom());
            }
        }
        f2 = this.getHeight();
        if (this.hasFixedHeight()) {
            f2 = this.getFixedHeight();
        } else if (f2 < this.getMinimumHeight()) {
            f2 = this.getMinimumHeight();
        }
        return f2;
    }
}

