/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.TSAClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jce.provider.X509CRLParser;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.TimeStampToken;

public class PdfPKCS7 {
    private byte[] a;
    private byte[] b;
    private int c;
    private int d;
    private Set<String> e;
    private List<Certificate> f;
    private List<Certificate> g;
    private List<CRL> h;
    private X509Certificate i;
    private byte[] j;
    private MessageDigest k;
    private String l;
    private String m;
    private Signature n;
    private transient PrivateKey o;
    private byte[] p;
    private boolean q;
    private boolean r;
    private byte[] s;
    private byte[] t;
    private String u;
    private String v;
    private String w;
    private Calendar x;
    private String y;
    private TimeStampToken z;
    private static final Map<String, String> A = new HashMap<String, String>();
    private static final Map<String, String> B = new HashMap<String, String>();
    private static final Map<String, String> C = new HashMap<String, String>();
    private BasicOCSPResp D;

    public static String getDigest(String string) {
        return Optional.ofNullable(A.get(string)).orElse(string);
    }

    public static String getAlgorithm(String string) {
        return Optional.ofNullable(B.get(string)).orElse(string);
    }

    public static String getDigestOid(String string) {
        if (string != null) {
            return C.get(string);
        }
        return null;
    }

    public TimeStampToken getTimeStampToken() {
        return this.z;
    }

    @Nullable
    public Calendar getTimeStampDate() {
        if (this.z == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = this.z.getTimeStampInfo().getGenTime();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    public PdfPKCS7(byte[] object, byte[] object2, String string) {
        try {
            this.u = string;
            CertificateFactory certificateFactory = new CertificateFactory();
            object2 = certificateFactory.engineGenerateCertificates((InputStream)new ByteArrayInputStream((byte[])object2));
            this.f = new ArrayList<Certificate>((Collection<Certificate>)object2);
            this.g = this.f;
            this.i = (X509Certificate)this.f.iterator().next();
            this.h = new ArrayList<CRL>();
            object = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object));
            this.j = ((DEROctetString)object.readObject()).getOctets();
            this.n = string == null ? Signature.getInstance("SHA1withRSA") : Signature.getInstance("SHA1withRSA", string);
            this.n.initVerify(this.i.getPublicKey());
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public BasicOCSPResp getOcsp() {
        return this.D;
    }

    private void a(ASN1Sequence aSN1Sequence) {
        this.D = null;
        while (!(aSN1Sequence.getObjectAt(0) instanceof ASN1ObjectIdentifier) || !((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic.getId())) {
            boolean bl2 = true;
            for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
                if (aSN1Sequence.getObjectAt(i2) instanceof ASN1Sequence) {
                    aSN1Sequence = (ASN1Sequence)aSN1Sequence.getObjectAt(0);
                    bl2 = false;
                    break;
                }
                if (!(aSN1Sequence.getObjectAt(i2) instanceof ASN1TaggedObject)) continue;
                if ((aSN1Sequence = (ASN1TaggedObject)aSN1Sequence.getObjectAt(i2)).getObject() instanceof ASN1Sequence) {
                    aSN1Sequence = (ASN1Sequence)aSN1Sequence.getObject();
                    bl2 = false;
                    break;
                }
                return;
            }
            if (!bl2) continue;
            return;
        }
        DEROctetString dEROctetString = (DEROctetString)aSN1Sequence.getObjectAt(1);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(dEROctetString.getOctets());
        aSN1Sequence = BasicOCSPResponse.getInstance((Object)aSN1InputStream.readObject());
        this.D = new BasicOCSPResp((BasicOCSPResponse)aSN1Sequence);
    }

    public PdfPKCS7(byte[] object, String string) {
        try {
            X509Certificate x509Certificate;
            this.u = string;
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object));
            try {
                aSN1InputStream = aSN1InputStream.readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("can.t.decode.pkcs7signeddata.object"));
            }
            if (!(aSN1InputStream instanceof ASN1Sequence)) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("not.a.valid.pkcs.7.object.not.a.sequence"));
            }
            Object object3 = (ASN1ObjectIdentifier)(aSN1InputStream = (ASN1Sequence)aSN1InputStream).getObjectAt(0);
            if (!object3.getId().equals("1.2.840.113549.1.7.2")) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("not.a.valid.pkcs.7.object.not.signed.data"));
            }
            aSN1InputStream = (ASN1Sequence)((ASN1TaggedObject)aSN1InputStream.getObjectAt(1)).getObject();
            this.c = ((ASN1Integer)aSN1InputStream.getObjectAt(0)).getValue().intValue();
            this.e = new HashSet<String>();
            object3 = ((ASN1Set)aSN1InputStream.getObjectAt(1)).getObjects();
            while (object3.hasMoreElements()) {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)object3.nextElement();
                ASN1ObjectIdentifier object22 = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
                this.e.add(object22.getId());
            }
            CertificateFactory certificateFactory = new CertificateFactory();
            Collection collection = certificateFactory.engineGenerateCertificates((InputStream)new ByteArrayInputStream((byte[])object));
            this.f = new ArrayList<Certificate>(collection);
            object3 = new X509CRLParser();
            object3.engineInit((InputStream)new ByteArrayInputStream((byte[])object));
            this.h = (List)object3.engineReadAll();
            object = (ASN1Sequence)aSN1InputStream.getObjectAt(2);
            if (object.size() > 1) {
                object = (ASN1OctetString)((ASN1TaggedObject)object.getObjectAt(1)).getObject();
                this.p = object.getOctets();
            }
            int n2 = 3;
            while (aSN1InputStream.getObjectAt(n2) instanceof ASN1TaggedObject) {
                ++n2;
            }
            Object object4 = (ASN1Set)aSN1InputStream.getObjectAt(n2);
            if (object4.size() != 1) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("this.pkcs.7.object.has.multiple.signerinfos.only.one.is.supported.at.this.time"));
            }
            aSN1InputStream = (ASN1Sequence)object4.getObjectAt(0);
            this.d = ((ASN1Integer)aSN1InputStream.getObjectAt(0)).getValue().intValue();
            object4 = (ASN1Sequence)aSN1InputStream.getObjectAt(1);
            object4 = ((ASN1Integer)object4.getObjectAt(1)).getValue();
            for (Object e2 : this.f) {
                x509Certificate = (X509Certificate)e2;
                if (!((BigInteger)object4).equals(x509Certificate.getSerialNumber())) continue;
                this.i = x509Certificate;
                break;
            }
            if (this.i == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("can.t.find.signing.certificate.with.serial.1", ((BigInteger)object4).toString(16)));
            }
            this.a();
            this.l = ((ASN1ObjectIdentifier)((ASN1Sequence)aSN1InputStream.getObjectAt(2)).getObjectAt(0)).getId();
            int n3 = 3;
            if (aSN1InputStream.getObjectAt(3) instanceof ASN1TaggedObject) {
                object3 = (ASN1TaggedObject)aSN1InputStream.getObjectAt(3);
                ASN1Set aSN1Set = ASN1Set.getInstance((ASN1TaggedObject)object3, (boolean)false);
                this.a = aSN1Set.getEncoded("DER");
                for (int i2 = 0; i2 < aSN1Set.size(); ++i2) {
                    object3 = (ASN1Sequence)aSN1Set.getObjectAt(i2);
                    if (((ASN1ObjectIdentifier)object3.getObjectAt(0)).getId().equals("1.2.840.113549.1.9.4")) {
                        object3 = (ASN1Set)object3.getObjectAt(1);
                        this.b = ((DEROctetString)object3.getObjectAt(0)).getOctets();
                        continue;
                    }
                    if (!((ASN1ObjectIdentifier)object3.getObjectAt(0)).getId().equals("1.2.840.113583.1.1.8")) continue;
                    object3 = (ASN1Set)object3.getObjectAt(1);
                    object3 = (ASN1Sequence)object3.getObjectAt(0);
                    for (int i3 = 0; i3 < object3.size(); ++i3) {
                        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object3.getObjectAt(i3);
                        if (aSN1TaggedObject.getTagNo() != 1) continue;
                        aSN1TaggedObject = (ASN1Sequence)aSN1TaggedObject.getObject();
                        this.a((ASN1Sequence)aSN1TaggedObject);
                    }
                }
                if (this.b == null) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("authenticated.attribute.is.missing.the.digest"));
                }
            }
            int n4 = ++n3;
            this.m = ((ASN1ObjectIdentifier)((ASN1Sequence)aSN1InputStream.getObjectAt(n4)).getObjectAt(0)).getId();
            int n5 = ++n3;
            this.j = ((DEROctetString)aSN1InputStream.getObjectAt(n5)).getOctets();
            if (++n3 < aSN1InputStream.size() && aSN1InputStream.getObjectAt(n3) instanceof ASN1TaggedObject) {
                object3 = (ASN1TaggedObject)aSN1InputStream.getObjectAt(n3);
                ASN1Set aSN1Set = ASN1Set.getInstance((ASN1TaggedObject)object3, (boolean)false);
                x509Certificate = new AttributeTable(aSN1Set);
                if ((object3 = x509Certificate.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null && object3.getAttrValues().size() > 0) {
                    object3 = object3.getAttrValues();
                    object3 = ASN1Sequence.getInstance((Object)object3.getObjectAt(0));
                    ContentInfo contentInfo = ContentInfo.getInstance((Object)object3);
                    this.z = new TimeStampToken(contentInfo);
                }
            }
            if (this.p != null || this.b != null) {
                this.k = string == null || string.startsWith("SunPKCS11") ? MessageDigest.getInstance(PdfPKCS7.a(this.getHashAlgorithm())) : MessageDigest.getInstance(PdfPKCS7.a(this.getHashAlgorithm()), string);
            }
            this.n = string == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), string);
            this.n.initVerify(this.i.getPublicKey());
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public PdfPKCS7(PrivateKey privateKey, Certificate[] certificateArray, CRL[] cRLArray, String string, String string2, boolean bl2) {
        this.o = privateKey;
        this.u = string2;
        this.l = C.get(string.toUpperCase());
        if (this.l == null) {
            throw new NoSuchAlgorithmException(MessageLocalization.getComposedMessage("unknown.hash.algorithm.1", string));
        }
        PdfPKCS7 pdfPKCS7 = this;
        pdfPKCS7.d = 1;
        pdfPKCS7.c = 1;
        this.f = new ArrayList<Certificate>();
        this.h = new ArrayList<CRL>();
        this.e = new HashSet<String>();
        this.e.add(this.l);
        this.i = (X509Certificate)certificateArray[0];
        this.f.addAll(Arrays.asList(certificateArray));
        if (cRLArray != null) {
            this.h.addAll(Arrays.asList(cRLArray));
        }
        if (privateKey != null) {
            this.m = privateKey.getAlgorithm();
            if (this.m.equals("RSA")) {
                this.m = "1.2.840.113549.1.1.1";
            } else if (this.m.equals("DSA")) {
                this.m = "1.2.840.10040.4.1";
            } else {
                throw new NoSuchAlgorithmException(MessageLocalization.getComposedMessage("unknown.key.algorithm.1", this.m));
            }
        }
        if (bl2) {
            this.p = new byte[0];
            this.k = string2 == null || string2.startsWith("SunPKCS11") ? MessageDigest.getInstance(PdfPKCS7.a(this.getHashAlgorithm())) : MessageDigest.getInstance(PdfPKCS7.a(this.getHashAlgorithm()), string2);
        }
        if (privateKey != null) {
            this.n = string2 == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), string2);
            this.n.initSign(privateKey);
        }
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (this.p != null || this.b != null) {
            this.k.update(byArray, n2, n3);
            return;
        }
        this.n.update(byArray, n2, n3);
    }

    public boolean verify() {
        if (this.q) {
            return this.r;
        }
        if (this.a != null) {
            this.n.update(this.a);
            if (this.p != null) {
                byte[] byArray = this.k.digest();
                this.k.update(byArray);
            }
            this.r = Arrays.equals(this.k.digest(), this.b) && this.n.verify(this.j);
        } else {
            if (this.p != null) {
                this.n.update(this.k.digest());
            }
            this.r = this.n.verify(this.j);
        }
        this.q = true;
        return this.r;
    }

    public boolean verifyTimestampImprint() {
        if (this.z == null) {
            return false;
        }
        Object object = this.z.getTimeStampInfo().toASN1Structure().getMessageImprint();
        Object object2 = this.z.getTimeStampInfo();
        object2 = object2.getMessageImprintAlgOID().getId();
        object2 = MessageDigest.getInstance(PdfPKCS7.a(PdfPKCS7.getDigest((String)object2))).digest(this.j);
        object = object.getHashedMessage();
        return Arrays.equals((byte[])object2, (byte[])object);
    }

    public Certificate[] getCertificates() {
        return this.f.toArray(new Certificate[0]);
    }

    public Certificate[] getSignCertificateChain() {
        return this.g.toArray(new X509Certificate[0]);
    }

    private void a() {
        int n2;
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        arrayList.add(this.i);
        ArrayList<Certificate> arrayList2 = new ArrayList<Certificate>(this.f);
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            if (!this.i.getSerialNumber().equals(((X509Certificate)arrayList2.get(n2)).getSerialNumber())) continue;
            arrayList2.remove(n2);
            --n2;
        }
        n2 = 1;
        block3: while (n2 != 0) {
            ArrayList<Certificate> arrayList3 = arrayList;
            X509Certificate x509Certificate = (X509Certificate)arrayList3.get(arrayList3.size() - 1);
            n2 = 0;
            for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                try {
                    if (this.u == null) {
                        x509Certificate.verify(((Certificate)arrayList2.get(i2)).getPublicKey());
                    } else {
                        x509Certificate.verify(((Certificate)arrayList2.get(i2)).getPublicKey(), this.u);
                    }
                    n2 = 1;
                    arrayList.add((Certificate)arrayList2.get(i2));
                    arrayList2.remove(i2);
                    continue block3;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        this.g = arrayList;
    }

    public Collection getCRLs() {
        return this.h;
    }

    public X509Certificate getSigningCertificate() {
        return this.i;
    }

    public int getVersion() {
        return this.c;
    }

    public int getSigningInfoVersion() {
        return this.d;
    }

    public String getDigestAlgorithm() {
        String string = PdfPKCS7.getAlgorithm(this.m);
        if (string == null) {
            string = this.m;
        }
        return this.getHashAlgorithm() + "with" + string;
    }

    public String getHashAlgorithm() {
        return PdfPKCS7.getDigest(this.l);
    }

    public static KeyStore loadCacertsKeyStore() {
        return PdfPKCS7.loadCacertsKeyStore(null);
    }

    public static KeyStore loadCacertsKeyStore(String object) {
        Object object2 = new File(System.getProperty("java.home"), "lib");
        object2 = new File((File)object2, "security");
        object2 = new File((File)object2, "cacerts");
        object2 = new FileInputStream((File)object2);
        Throwable throwable = null;
        try {
            object = object == null ? KeyStore.getInstance("JKS") : KeyStore.getInstance("JKS", (String)object);
            ((KeyStore)object).load((InputStream)object2, null);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            ((FileInputStream)object2).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((FileInputStream)object2).close();
                    }
                    throw throwable3;
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        ((FileInputStream)object2).close();
        return object;
    }

    public static String verifyCertificate(X509Certificate x509Certificate, Collection iterator, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        if (x509Certificate.hasUnsupportedCriticalExtension()) {
            return "Has unsupported critical extension";
        }
        try {
            x509Certificate.checkValidity(calendar.getTime());
        }
        catch (Exception exception) {
            iterator = exception;
            return exception.getMessage();
        }
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                calendar = iterator.next();
                if (!((CRL)((Object)calendar)).isRevoked(x509Certificate)) continue;
                return "Certificate revoked";
            }
        }
        return null;
    }

    public static Object[] verifyCertificates(Certificate[] certificateArray, KeyStore keyStore, Collection collection, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        for (int i2 = 0; i2 < certificateArray.length; ++i2) {
            int n2;
            Object object;
            X509Certificate x509Certificate = (X509Certificate)certificateArray[i2];
            Object object2 = PdfPKCS7.verifyCertificate(x509Certificate, collection, calendar);
            if (object2 != null) {
                return new Object[]{x509Certificate, object2};
            }
            try {
                object2 = keyStore.aliases();
                while (object2.hasMoreElements()) {
                    try {
                        object = (String)object2.nextElement();
                        if (!keyStore.isCertificateEntry((String)object)) continue;
                        if (PdfPKCS7.verifyCertificate((X509Certificate)(object = (X509Certificate)keyStore.getCertificate((String)object)), collection, calendar) != null) continue;
                    }
                    catch (Exception exception) {}
                    try {
                        x509Certificate.verify(((Certificate)object).getPublicKey());
                        return null;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception exception) {}
            for (n2 = 0; n2 < certificateArray.length; ++n2) {
                if (n2 == i2) continue;
                object = (X509Certificate)certificateArray[n2];
                try {
                    x509Certificate.verify(((Certificate)object).getPublicKey());
                    break;
                }
                catch (Exception exception) {}
            }
            if (n2 != certificateArray.length) continue;
            return new Object[]{x509Certificate, "Cannot be verified against the KeyStore or the certificate chain"};
        }
        return new Object[]{null, "Invalid state. Possible circular certificate chain"};
    }

    public static String getOCSPURL(X509Certificate object) {
        try {
            Object object2;
            String string = Extension.authorityInfoAccess.getId();
            byte[] byArray = object.getExtensionValue(string);
            object = byArray;
            if (byArray == null) {
                object2 = null;
            } else {
                object = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object));
                object = (ASN1OctetString)object.readObject();
                object = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
                object2 = object = object.readObject();
            }
            if (object2 == null) {
                return null;
            }
            object = (ASN1Sequence)object;
            for (int i2 = 0; i2 < object.size(); ++i2) {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)object.getObjectAt(i2);
                if (aSN1Sequence.size() != 2 || !(aSN1Sequence.getObjectAt(0) instanceof ASN1ObjectIdentifier) || !((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId().equals("1.3.6.1.5.5.7.48.1")) continue;
                object = (ASN1Primitive)aSN1Sequence.getObjectAt(1);
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
                return new String(ASN1OctetString.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false).getOctets(), StandardCharsets.ISO_8859_1);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public boolean isRevocationValid() {
        if (this.D == null) {
            return false;
        }
        if (this.g.size() < 2) {
            return false;
        }
        try {
            CertificateID certificateID = (X509Certificate[])this.getSignCertificateChain();
            SingleResp singleResp = this.D.getResponses()[0];
            singleResp = singleResp.getCertID();
            X509Certificate x509Certificate = this.getSigningCertificate();
            certificateID = certificateID[1];
            DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().setProvider(this.u).build();
            certificateID = new CertificateID(digestCalculatorProvider.get(CertificateID.HASH_SHA1), (X509CertificateHolder)new JcaX509CertificateHolder((X509Certificate)certificateID), x509Certificate.getSerialNumber());
            return certificateID.equals((Object)singleResp);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static ASN1Primitive a(byte[] object) {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object));
            object = aSN1InputStream;
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            object = aSN1Sequence;
            return (ASN1Primitive)aSN1Sequence.getObjectAt(object.getObjectAt(0) instanceof ASN1TaggedObject ? 3 : 2);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    private static ASN1Primitive b(byte[] object) {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object));
            object = aSN1InputStream;
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            object = aSN1Sequence;
            return (ASN1Primitive)aSN1Sequence.getObjectAt(object.getObjectAt(0) instanceof ASN1TaggedObject ? 5 : 4);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public static X509Name getIssuerFields(X509Certificate x509Certificate) {
        try {
            return new X509Name((ASN1Sequence)PdfPKCS7.a(x509Certificate.getTBSCertificate()));
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static X509Name getSubjectFields(X509Certificate x509Certificate) {
        try {
            return new X509Name((ASN1Sequence)PdfPKCS7.b(x509Certificate.getTBSCertificate()));
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public byte[] getEncodedPKCS1() {
        try {
            this.j = this.s != null ? this.s : this.n.sign();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((ASN1Primitive)new DEROctetString(this.j));
            aSN1OutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void setExternalDigest(byte[] byArray, byte[] byArray2, String string) {
        this.s = byArray;
        this.t = byArray2;
        if (string != null) {
            if (string.equals("RSA")) {
                this.m = "1.2.840.113549.1.1.1";
                return;
            }
            if (string.equals("DSA")) {
                this.m = "1.2.840.10040.4.1";
                return;
            }
            throw new ExceptionConverter(new NoSuchAlgorithmException(MessageLocalization.getComposedMessage("unknown.key.algorithm.1", string)));
        }
    }

    public byte[] getEncodedPKCS7() {
        return this.getEncodedPKCS7(null, null, null, null);
    }

    public byte[] getEncodedPKCS7(byte[] byArray, Calendar calendar) {
        return this.getEncodedPKCS7(byArray, calendar, null, null);
    }

    public byte[] getEncodedPKCS7(byte[] object, Calendar object2, TSAClient tSAClient, byte[] object3) {
        try {
            Object object4;
            Object object6;
            String string22;
            if (this.s != null) {
                this.j = this.s;
                if (this.p != null) {
                    this.p = this.t;
                }
            } else {
                if (this.t != null && this.p != null) {
                    this.p = this.t;
                    this.n.update(this.p);
                } else if (this.p != null) {
                    this.p = this.k.digest();
                    this.n.update(this.p);
                }
                this.j = this.n.sign();
            }
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (String string22 : this.e) {
                object6 = new ASN1EncodableVector();
                object6.add((ASN1Encodable)new ASN1ObjectIdentifier(string22));
                object6.add((ASN1Encodable)DERNull.INSTANCE);
                aSN1EncodableVector.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)object6));
            }
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1"));
            if (this.p != null) {
                aSN1EncodableVector2.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DEROctetString(this.p)));
            }
            string22 = new DERSequence(aSN1EncodableVector2);
            aSN1EncodableVector2 = new ASN1EncodableVector();
            for (Object object52 : this.f) {
                object4 = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509Certificate)object52).getEncoded()));
                aSN1EncodableVector2.add((ASN1Encodable)object4.readObject());
            }
            object6 = new DERSet(aSN1EncodableVector2);
            ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
            aSN1EncodableVector3.add((ASN1Encodable)new ASN1Integer((long)this.d));
            aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)PdfPKCS7.a(this.i.getTBSCertificate()));
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer(this.i.getSerialNumber()));
            aSN1EncodableVector3.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier(this.l));
            aSN1EncodableVector2.add((ASN1Encodable)DERNull.INSTANCE);
            aSN1EncodableVector3.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            if (object != null && object2 != null) {
                aSN1EncodableVector3.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.a((byte[])object, (Calendar)object2, (byte[])object3)));
            }
            aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier(this.m));
            aSN1EncodableVector2.add((ASN1Encodable)DERNull.INSTANCE);
            aSN1EncodableVector3.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            aSN1EncodableVector3.add((ASN1Encodable)new DEROctetString(this.j));
            if (tSAClient != null) {
                object4 = tSAClient.getMessageDigest().digest(this.j);
                byte[] byArray = tSAClient.getTimeStampToken(this, (byte[])object4);
                object = byArray;
                if (byArray != null) {
                    Object object5;
                    if (object == null) {
                        object5 = null;
                    } else {
                        object2 = "1.2.840.113549.1.9.16.2.14";
                        object = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object));
                        tSAClient = new ASN1EncodableVector();
                        object3 = new ASN1EncodableVector();
                        object3.add((ASN1Encodable)new ASN1ObjectIdentifier((String)object2));
                        object = (ASN1Sequence)object.readObject();
                        object3.add((ASN1Encodable)new DERSet((ASN1Encodable)object));
                        tSAClient.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)object3));
                        object5 = object2 = tSAClient;
                    }
                    if (object5 != null) {
                        aSN1EncodableVector3.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DERSet((ASN1EncodableVector)object2)));
                    }
                }
            }
            object4 = new ASN1EncodableVector();
            object4.add((ASN1Encodable)new ASN1Integer((long)this.c));
            object4.add((ASN1Encodable)new DERSet(aSN1EncodableVector));
            object4.add((ASN1Encodable)string22);
            object4.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)object6));
            object4.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence(aSN1EncodableVector3)));
            ASN1EncodableVector aSN1EncodableVector4 = new ASN1EncodableVector();
            object = aSN1EncodableVector4;
            aSN1EncodableVector4.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.2"));
            object.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DERSequence((ASN1EncodableVector)object4)));
            object2 = new ByteArrayOutputStream();
            tSAClient = new ASN1OutputStream((OutputStream)object2);
            tSAClient.writeObject((ASN1Primitive)new DERSequence((ASN1EncodableVector)object));
            tSAClient.close();
            return ((ByteArrayOutputStream)object2).toByteArray();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public byte[] getAuthenticatedAttributeBytes(byte[] byArray, Calendar calendar, byte[] byArray2) {
        try {
            return this.a(byArray, calendar, byArray2).getEncoded("DER");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private DERSet a(byte[] object, Calendar object2, byte[] object32) {
        try {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.3"));
            aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.5"));
            aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERUTCTime(((Calendar)((Object)object2)).getTime())));
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.4"));
            aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)new DEROctetString((byte[])object)));
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            if (object32 != null) {
                aSN1EncodableVector2 = new ASN1EncodableVector();
                aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113583.1.1.8"));
                object = new DEROctetString((byte[])object32);
                object2 = new ASN1EncodableVector();
                ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
                aSN1EncodableVector3.add((ASN1Encodable)OCSPObjectIdentifiers.id_pkix_ocsp_basic);
                aSN1EncodableVector3.add((ASN1Encodable)object);
                ASN1Enumerated aSN1Enumerated = new ASN1Enumerated(0);
                object = new ASN1EncodableVector();
                object.add((ASN1Encodable)aSN1Enumerated);
                object.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(aSN1EncodableVector3)));
                object2.add((ASN1Encodable)new DERSequence((ASN1EncodableVector)object));
                aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERSequence(object2)))));
                aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            } else if (!this.h.isEmpty()) {
                aSN1EncodableVector2 = new ASN1EncodableVector();
                aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113583.1.1.8"));
                object = new ASN1EncodableVector();
                for (CRL cRL : this.h) {
                    ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509CRL)cRL).getEncoded()));
                    object.add((ASN1Encodable)aSN1InputStream.readObject());
                }
                aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence((ASN1EncodableVector)object)))));
                aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            }
            return new DERSet(aSN1EncodableVector);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public String getReason() {
        return this.v;
    }

    public void setReason(String string) {
        this.v = string;
    }

    public String getLocation() {
        return this.w;
    }

    public void setLocation(String string) {
        this.w = string;
    }

    public Calendar getSignDate() {
        return this.x;
    }

    public void setSignDate(Calendar calendar) {
        this.x = calendar;
    }

    public String getSignName() {
        return this.y;
    }

    public void setSignName(String string) {
        this.y = string;
    }

    private static String a(String string) {
        if ("SHA1".equals(string)) {
            return "SHA-1";
        }
        if ("SHA224".equals(string)) {
            return "SHA-224";
        }
        if ("SHA256".equals(string)) {
            return "SHA-256";
        }
        if ("SHA384".equals(string)) {
            return "SHA-384";
        }
        if ("SHA512".equals(string)) {
            return "SHA-512";
        }
        return string;
    }

    static {
        A.put("1.2.840.113549.2.5", "MD5");
        A.put("1.2.840.113549.2.2", "MD2");
        A.put("1.3.14.3.2.26", "SHA1");
        A.put("2.16.840.1.101.3.4.2.4", "SHA224");
        A.put("2.16.840.1.101.3.4.2.1", "SHA256");
        A.put("2.16.840.1.101.3.4.2.2", "SHA384");
        A.put("2.16.840.1.101.3.4.2.3", "SHA512");
        A.put("1.3.36.3.2.2", "RIPEMD128");
        A.put("1.3.36.3.2.1", "RIPEMD160");
        A.put("1.3.36.3.2.3", "RIPEMD256");
        A.put("1.2.840.113549.1.1.4", "MD5");
        A.put("1.2.840.113549.1.1.2", "MD2");
        A.put("1.2.840.113549.1.1.5", "SHA1");
        A.put("1.2.840.113549.1.1.14", "SHA224");
        A.put("1.2.840.113549.1.1.11", "SHA256");
        A.put("1.2.840.113549.1.1.12", "SHA384");
        A.put("1.2.840.113549.1.1.13", "SHA512");
        A.put("1.2.840.10040.4.3", "SHA1");
        A.put("2.16.840.1.101.3.4.3.1", "SHA224");
        A.put("2.16.840.1.101.3.4.3.2", "SHA256");
        A.put("2.16.840.1.101.3.4.3.3", "SHA384");
        A.put("2.16.840.1.101.3.4.3.4", "SHA512");
        A.put("1.3.36.3.3.1.3", "RIPEMD128");
        A.put("1.3.36.3.3.1.2", "RIPEMD160");
        A.put("1.3.36.3.3.1.4", "RIPEMD256");
        B.put("1.2.840.113549.1.1.1", "RSA");
        B.put("1.2.840.10040.4.1", "DSA");
        B.put("1.2.840.113549.1.1.2", "RSA");
        B.put("1.2.840.113549.1.1.4", "RSA");
        B.put("1.2.840.113549.1.1.5", "RSA");
        B.put("1.2.840.113549.1.1.14", "RSA");
        B.put("1.2.840.113549.1.1.11", "RSA");
        B.put("1.2.840.113549.1.1.12", "RSA");
        B.put("1.2.840.113549.1.1.13", "RSA");
        B.put("1.2.840.10040.4.3", "DSA");
        B.put("2.16.840.1.101.3.4.3.1", "DSA");
        B.put("2.16.840.1.101.3.4.3.2", "DSA");
        B.put("1.3.36.3.3.1.3", "RSA");
        B.put("1.3.36.3.3.1.2", "RSA");
        B.put("1.3.36.3.3.1.4", "RSA");
        C.put("MD5", "1.2.840.113549.2.5");
        C.put("MD2", "1.2.840.113549.2.2");
        C.put("SHA1", "1.3.14.3.2.26");
        C.put("SHA224", "2.16.840.1.101.3.4.2.4");
        C.put("SHA256", "2.16.840.1.101.3.4.2.1");
        C.put("SHA384", "2.16.840.1.101.3.4.2.2");
        C.put("SHA512", "2.16.840.1.101.3.4.2.3");
        C.put("MD-5", "1.2.840.113549.2.5");
        C.put("MD-2", "1.2.840.113549.2.2");
        C.put("SHA-1", "1.3.14.3.2.26");
        C.put("SHA-224", "2.16.840.1.101.3.4.2.4");
        C.put("SHA-256", "2.16.840.1.101.3.4.2.1");
        C.put("SHA-384", "2.16.840.1.101.3.4.2.2");
        C.put("SHA-512", "2.16.840.1.101.3.4.2.3");
        C.put("RIPEMD128", "1.3.36.3.2.2");
        C.put("RIPEMD-128", "1.3.36.3.2.2");
        C.put("RIPEMD160", "1.3.36.3.2.1");
        C.put("RIPEMD-160", "1.3.36.3.2.1");
        C.put("RIPEMD256", "1.3.36.3.2.3");
        C.put("RIPEMD-256", "1.3.36.3.2.3");
    }

    public static class X509NameTokenizer {
        private final String a;
        private int b;
        private final StringBuffer c = new StringBuffer();

        public X509NameTokenizer(String string) {
            this.a = string;
            this.b = -1;
        }

        public boolean hasMoreTokens() {
            return this.b != this.a.length();
        }

        public String nextToken() {
            int n2;
            if (this.b == this.a.length()) {
                return null;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            this.c.setLength(0);
            for (n2 = this.b + 1; n2 != this.a.length(); ++n2) {
                char c2 = this.a.charAt(n2);
                if (c2 == '\"') {
                    if (!bl3) {
                        bl2 = !bl2;
                    } else {
                        this.c.append(c2);
                    }
                    bl3 = false;
                    continue;
                }
                if (bl3 || bl2) {
                    this.c.append(c2);
                    bl3 = false;
                    continue;
                }
                if (c2 == '\\') {
                    bl3 = true;
                    continue;
                }
                if (c2 == ',') break;
                this.c.append(c2);
            }
            this.b = n2;
            return this.c.toString().trim();
        }
    }

    public static class X509Name {
        public static final ASN1ObjectIdentifier C = new ASN1ObjectIdentifier("2.5.4.6");
        public static final ASN1ObjectIdentifier O = new ASN1ObjectIdentifier("2.5.4.10");
        public static final ASN1ObjectIdentifier OU = new ASN1ObjectIdentifier("2.5.4.11");
        public static final ASN1ObjectIdentifier T = new ASN1ObjectIdentifier("2.5.4.12");
        public static final ASN1ObjectIdentifier CN = new ASN1ObjectIdentifier("2.5.4.3");
        public static final ASN1ObjectIdentifier SN = new ASN1ObjectIdentifier("2.5.4.5");
        public static final ASN1ObjectIdentifier L = new ASN1ObjectIdentifier("2.5.4.7");
        public static final ASN1ObjectIdentifier ST = new ASN1ObjectIdentifier("2.5.4.8");
        public static final ASN1ObjectIdentifier SURNAME = new ASN1ObjectIdentifier("2.5.4.4");
        public static final ASN1ObjectIdentifier GIVENNAME = new ASN1ObjectIdentifier("2.5.4.42");
        public static final ASN1ObjectIdentifier INITIALS = new ASN1ObjectIdentifier("2.5.4.43");
        public static final ASN1ObjectIdentifier GENERATION = new ASN1ObjectIdentifier("2.5.4.44");
        public static final ASN1ObjectIdentifier UNIQUE_IDENTIFIER = new ASN1ObjectIdentifier("2.5.4.45");
        public static final ASN1ObjectIdentifier EmailAddress;
        public static final ASN1ObjectIdentifier E;
        public static final ASN1ObjectIdentifier DC;
        public static final ASN1ObjectIdentifier UID;
        @Deprecated
        public static HashMap DefaultSymbols;
        public static Map<ASN1Encodable, String> defaultSymbols;
        @Deprecated
        public HashMap values = new HashMap();
        public Map<String, List<String>> valuesMap = new HashMap<String, List<String>>();

        public X509Name(ASN1Sequence object) {
            object = object.getObjects();
            while (object.hasMoreElements()) {
                ASN1Set aSN1Set = (ASN1Set)object.nextElement();
                for (int i2 = 0; i2 < aSN1Set.size(); ++i2) {
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(i2);
                    Object object2 = aSN1Sequence.getObjectAt(0);
                    if ((object2 = defaultSymbols.get(object2)) == null) continue;
                    object2 = this.valuesMap.computeIfAbsent((String)object2, string -> new ArrayList());
                    object2.add(((ASN1String)aSN1Sequence.getObjectAt(1)).getString());
                }
            }
        }

        public X509Name(String object) {
            object = new X509NameTokenizer((String)object);
            while (((X509NameTokenizer)object).hasMoreTokens()) {
                String string2 = ((X509NameTokenizer)object).nextToken();
                int n2 = string2.indexOf(61);
                if (n2 == -1) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("badly.formated.directory.string"));
                }
                String string3 = string2.substring(0, n2).toUpperCase();
                string2 = string2.substring(n2 + 1);
                List list = this.valuesMap.computeIfAbsent(string3, string -> new ArrayList());
                list.add(string2);
            }
        }

        @Nullable
        public String getField(String object) {
            if ((object = this.valuesMap.get(object)) == null) {
                return null;
            }
            return (String)object.get(0);
        }

        @Deprecated
        public ArrayList getFieldArray(String string) {
            return (ArrayList)this.valuesMap.get(string);
        }

        public List<String> getFieldsByName(String string) {
            return this.valuesMap.get(string);
        }

        @Deprecated
        public HashMap getFields() {
            return (HashMap)this.valuesMap;
        }

        public Map<String, List<String>> getAllFields() {
            return this.valuesMap;
        }

        public String toString() {
            return this.valuesMap.toString();
        }

        static {
            E = EmailAddress = new ASN1ObjectIdentifier("1.2.840.113549.1.9.1");
            DC = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.25");
            UID = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.1");
            DefaultSymbols = new HashMap();
            defaultSymbols = new HashMap<ASN1Encodable, String>();
            defaultSymbols.put((ASN1Encodable)C, "C");
            defaultSymbols.put((ASN1Encodable)O, "O");
            defaultSymbols.put((ASN1Encodable)T, "T");
            defaultSymbols.put((ASN1Encodable)OU, "OU");
            defaultSymbols.put((ASN1Encodable)CN, "CN");
            defaultSymbols.put((ASN1Encodable)L, "L");
            defaultSymbols.put((ASN1Encodable)ST, "ST");
            defaultSymbols.put((ASN1Encodable)SN, "SN");
            defaultSymbols.put((ASN1Encodable)EmailAddress, "E");
            defaultSymbols.put((ASN1Encodable)DC, "DC");
            defaultSymbols.put((ASN1Encodable)UID, "UID");
            defaultSymbols.put((ASN1Encodable)SURNAME, "SURNAME");
            defaultSymbols.put((ASN1Encodable)GIVENNAME, "GIVENNAME");
            defaultSymbols.put((ASN1Encodable)INITIALS, "INITIALS");
            defaultSymbols.put((ASN1Encodable)GENERATION, "GENERATION");
            DefaultSymbols.putAll(defaultSymbols);
        }
    }
}

