/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    public static final float RIGHT_LIMIT = 20000.0f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float[] extraHeights;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;
    private int[] a;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
        this.widths = new float[pdfPCellArray.length];
        this.initExtraHeights();
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (pdfPRow.cells[i2] == null) continue;
            this.cells[i2] = new PdfPCell(pdfPRow.cells[i2]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(pdfPRow.widths, 0, this.widths, 0, this.cells.length);
        this.initExtraHeights();
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        System.arraycopy(fArray, 0, this.widths, 0, this.cells.length);
        float f2 = 0.0f;
        this.calculated = false;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            PdfPCell pdfPCell = this.cells[i2];
            if (pdfPCell == null) {
                f2 += fArray[i2];
                continue;
            }
            pdfPCell.setLeft(f2);
            int n2 = i2 + pdfPCell.getColspan();
            while (i2 < n2) {
                f2 += fArray[i2];
                ++i2;
            }
            --i2;
            pdfPCell.setRight(f2);
            pdfPCell.setTop(0.0f);
        }
        return true;
    }

    public void initExtraHeights() {
        this.extraHeights = new float[this.cells.length];
        for (int i2 = 0; i2 < this.extraHeights.length; ++i2) {
            this.extraHeights[i2] = 0.0f;
        }
    }

    public void setExtraHeight(int n2, float f2) {
        if (n2 < 0 || n2 >= this.cells.length) {
            return;
        }
        this.extraHeights[n2] = f2;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        PdfPCell[] pdfPCellArray = this.cells;
        int n2 = this.cells.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2;
            PdfPCell pdfPCell = pdfPCellArray[i2];
            if (pdfPCell == null) continue;
            float f3 = pdfPCell.getMaxHeight();
            if (!(f2 > this.maxHeight) || pdfPCell.getRowspan() != 1) continue;
            this.maxHeight = f3;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackground(float f2, float f3, float f4, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        Color color = pdfPCell.getBackgroundColor();
        if (color != null || pdfPCell.hasBorders()) {
            Object object;
            float f5 = pdfPCell.getRight() + f2;
            f3 = pdfPCell.getTop() + f3;
            f2 = pdfPCell.getLeft() + f2;
            f4 = f3 - f4;
            if (color != null) {
                object = pdfContentByteArray[1];
                ((PdfContentByte)object).setColorFill(color);
                ((PdfContentByte)object).rectangle(f2, f4, f5 - f2, f3 - f4);
                ((PdfContentByte)object).fill();
            }
            if (pdfPCell.hasBorders()) {
                object = new Rectangle(f2, f4, f5, f3);
                ((Rectangle)object).cloneNonPositionParameters(pdfPCell);
                ((Rectangle)object).setBackgroundColor(null);
                PdfContentByte pdfContentByte = pdfContentByteArray[2];
                pdfContentByte.rectangle((Rectangle)object);
            }
        }
    }

    protected void saveAndRotateCanvases(PdfContentByte[] pdfContentByteArray, float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.a == null) {
            this.a = new int[8];
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            ByteBuffer byteBuffer = pdfContentByteArray[i2].getInternalBuffer();
            this.a[i2 << 1] = byteBuffer.size();
            pdfContentByteArray[i2].saveState();
            pdfContentByteArray[i2].concatCTM(f2, f3, f4, f5, f6, f7);
            this.a[(i2 << 1) + 1] = byteBuffer.size();
        }
    }

    protected void restoreCanvases(PdfContentByte[] pdfContentByteArray) {
        for (int i2 = 0; i2 < 4; ++i2) {
            ByteBuffer byteBuffer = pdfContentByteArray[i2].getInternalBuffer();
            int n2 = byteBuffer.size();
            pdfContentByteArray[i2].restoreState();
            if (n2 != this.a[(i2 << 1) + 1]) continue;
            byteBuffer.setSize(this.a[i2 << 1]);
        }
    }

    public static float setColumn(ColumnText columnText, float f2, float f3, float f4, float f5) {
        if (f2 > f4) {
            f4 = f2;
        }
        if (f3 > f5) {
            f5 = f3;
        }
        columnText.setSimpleColumn(f2, f3, f4, f5);
        return f5;
    }

    public void writeCells(int n2, int n3, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        if (!this.calculated) {
            this.calculateHeights();
        }
        n3 = n3 < 0 ? this.cells.length : Math.min(n3, this.cells.length);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= n3) {
            return;
        }
        while (n2 >= 0 && this.cells[n2] == null) {
            if (n2 > 0) {
                f2 -= this.widths[n2 - 1];
            }
            --n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.cells[n2] != null) {
            f2 -= this.cells[n2].getLeft();
        }
        while (n2 < n3) {
            PdfPCell pdfPCell = this.cells[n2];
            if (pdfPCell != null) {
                float f4;
                float f5;
                float f6 = this.maxHeight + this.extraHeights[n2];
                this.writeBorderAndBackground(f2, f3, f6, pdfPCell, pdfContentByteArray);
                Object object = pdfPCell.getImage();
                float f7 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                if (pdfPCell.getHeight() <= f6) {
                    switch (pdfPCell.getVerticalAlignment()) {
                        case 6: {
                            f7 = pdfPCell.getTop() + f3 - f6 + pdfPCell.getHeight() - pdfPCell.getEffectivePaddingTop();
                            break;
                        }
                        case 5: {
                            f7 = pdfPCell.getTop() + f3 + (pdfPCell.getHeight() - f6) / 2.0f - pdfPCell.getEffectivePaddingTop();
                        }
                    }
                }
                if (object != null) {
                    if (((Rectangle)pdfPCell).getRotation() != 0) {
                        object = Image.getInstance((Image)object);
                        ((Image)object).setRotation(((Image)object).getImageRotation() + (float)((double)((Rectangle)pdfPCell).getRotation() * Math.PI / 180.0));
                    }
                    boolean bl2 = false;
                    if (pdfPCell.getHeight() > f6) {
                        ((Image)object).scalePercent(100.0f);
                        f5 = (f6 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom()) / ((Image)object).getScaledHeight();
                        ((Image)object).scalePercent(f5 * 100.0f);
                        bl2 = true;
                    }
                    f5 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                    if (bl2) {
                        switch (pdfPCell.getHorizontalAlignment()) {
                            case 1: {
                                f5 = f2 + (pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft() + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - ((Image)object).getScaledWidth()) / 2.0f;
                                break;
                            }
                            case 2: {
                                f5 = f2 + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - ((Image)object).getScaledWidth();
                            }
                        }
                        f7 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                    }
                    ((Image)object).setAbsolutePosition(f5, f7 - ((Image)object).getScaledHeight());
                    try {
                        pdfContentByteArray[3].addImage((Image)object);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                }
                if (((Rectangle)pdfPCell).getRotation() == 90 || ((Rectangle)pdfPCell).getRotation() == 270) {
                    float f8 = f6 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom();
                    f5 = pdfPCell.getWidth() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight();
                    object = ColumnText.duplicate(pdfPCell.getColumn());
                    ((ColumnText)object).setCanvases(pdfContentByteArray);
                    ((ColumnText)object).setSimpleColumn(0.0f, 0.0f, f8 + 0.001f, -f5);
                    try {
                        ((ColumnText)object).go(true);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    float f9 = -((ColumnText)object).getYLine();
                    if (f8 <= 0.0f || f5 <= 0.0f) {
                        f9 = 0.0f;
                    }
                    if (f9 > 0.0f) {
                        if (pdfPCell.isUseDescender()) {
                            f9 -= ((ColumnText)object).getDescender();
                        }
                        object = ColumnText.duplicate(pdfPCell.getColumn());
                        ((ColumnText)object).setCanvases(pdfContentByteArray);
                        ((ColumnText)object).setSimpleColumn(-0.003f, -0.001f, f8 + 0.003f, f9);
                        if (((Rectangle)pdfPCell).getRotation() == 90) {
                            f7 = pdfPCell.getTop() + f3 - f6 + pdfPCell.getEffectivePaddingBottom();
                            switch (pdfPCell.getVerticalAlignment()) {
                                case 6: {
                                    f4 = pdfPCell.getLeft() + f2 + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight();
                                    break;
                                }
                                case 5: {
                                    f4 = pdfPCell.getLeft() + f2 + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() + f9) / 2.0f;
                                    break;
                                }
                                default: {
                                    f4 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft() + f9;
                                }
                            }
                            this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, 1.0f, -1.0f, 0.0f, f4, f7);
                        } else {
                            f7 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                            switch (pdfPCell.getVerticalAlignment()) {
                                case 6: {
                                    f4 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                                    break;
                                }
                                case 5: {
                                    f4 = pdfPCell.getLeft() + f2 + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() - f9) / 2.0f;
                                    break;
                                }
                                default: {
                                    f4 = pdfPCell.getLeft() + f2 + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight() - f9;
                                }
                            }
                            this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, -1.0f, 1.0f, 0.0f, f4, f7);
                        }
                        try {
                            ((ColumnText)object).go();
                        }
                        catch (DocumentException documentException) {
                            throw new ExceptionConverter(documentException);
                        }
                        finally {
                            this.restoreCanvases(pdfContentByteArray);
                        }
                    }
                } else {
                    float f10;
                    float f11;
                    block61: {
                        f11 = pdfPCell.getFixedHeight();
                        f5 = pdfPCell.getRight() + f2 - pdfPCell.getEffectivePaddingRight();
                        f10 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                        if (pdfPCell.isNoWrap()) {
                            switch (pdfPCell.getHorizontalAlignment()) {
                                case 1: {
                                    f5 += 10000.0f;
                                    f10 -= 10000.0f;
                                    break block61;
                                }
                                case 2: {
                                    if (((Rectangle)pdfPCell).getRotation() == 180) break;
                                    f10 -= 20000.0f;
                                    break block61;
                                }
                                default: {
                                    if (((Rectangle)pdfPCell).getRotation() != 180) break;
                                    f10 -= 20000.0f;
                                    break block61;
                                }
                            }
                            f5 += 20000.0f;
                        }
                    }
                    ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                    columnText.setCanvases(pdfContentByteArray);
                    f4 = f7 - (f6 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom());
                    if (f11 > 0.0f && pdfPCell.getHeight() > f6) {
                        f7 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                        f4 = pdfPCell.getTop() + f3 - f6 + pdfPCell.getEffectivePaddingBottom();
                    }
                    if ((f7 > f4 || columnText.zeroHeightElement()) && f10 < f5) {
                        columnText.setSimpleColumn(f10, f4 - 0.001f, f5, f7);
                        if (((Rectangle)pdfPCell).getRotation() == 180) {
                            f7 = f10 + f5;
                            float f12 = f3;
                            f10 = f12 + f12 - f6 + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getEffectivePaddingTop();
                            this.saveAndRotateCanvases(pdfContentByteArray, -1.0f, 0.0f, 0.0f, -1.0f, f7, f10);
                        }
                        try {
                            columnText.go();
                        }
                        catch (DocumentException documentException) {
                            throw new ExceptionConverter(documentException);
                        }
                        finally {
                            if (((Rectangle)pdfPCell).getRotation() == 180) {
                                this.restoreCanvases(pdfContentByteArray);
                            }
                        }
                    }
                }
                PdfPCellEvent pdfPCellEvent = pdfPCell.getCellEvent();
                if (pdfPCellEvent != null) {
                    Rectangle rectangle = new Rectangle(pdfPCell.getLeft() + f2, pdfPCell.getTop() + f3 - f6, pdfPCell.getRight() + f2, pdfPCell.getTop() + f3);
                    pdfPCellEvent.cellLayout(pdfPCell, rectangle, pdfContentByteArray);
                }
            }
            ++n2;
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f2) {
        this.maxHeight = f2;
    }

    final float[] a(float f2) {
        int n2;
        int n3 = 0;
        Object[] objectArray = this.cells;
        int n4 = this.cells.length;
        for (n2 = 0; n2 < n4; ++n2) {
            PdfPCell pdfPCell = objectArray[n2];
            if (pdfPCell == null) continue;
            ++n3;
        }
        objectArray = new float[n3 + 1];
        n3 = 0;
        ++n3;
        objectArray[0] = (PdfPCell)f2;
        PdfPCell[] pdfPCellArray = this.cells;
        n2 = this.cells.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PdfPCell pdfPCell = pdfPCellArray[i2];
            if (pdfPCell == null) continue;
            objectArray[n3] = objectArray[n3 - 1] + pdfPCell.getWidth();
            ++n3;
        }
        return objectArray;
    }

    public PdfPRow splitRow(PdfPTable pdfPTable, int n2, float f2) {
        PdfPCell pdfPCell;
        int n3;
        PdfPCell[] pdfPCellArray = new PdfPCell[this.cells.length];
        float[] fArray = new float[this.cells.length];
        float[] fArray2 = new float[this.cells.length];
        boolean bl2 = true;
        for (n3 = 0; n3 < this.cells.length; ++n3) {
            Object object;
            pdfPCell = this.cells[n3];
            if (pdfPCell == null) {
                int n4 = n2;
                if (!pdfPTable.a(n2, n3)) continue;
                float f3 = f2 + pdfPTable.getRowHeight(n2);
                while (pdfPTable.a(--n4, n3)) {
                    f3 += pdfPTable.getRowHeight(n4);
                }
                object = pdfPTable.getRow(n4);
                if (object == null || ((PdfPRow)object).getCells()[n3] == null) continue;
                pdfPCellArray[n3] = new PdfPCell(((PdfPRow)object).getCells()[n3]);
                pdfPCellArray[n3].a(f3);
                pdfPCellArray[n3].setRowspan(((PdfPRow)object).getCells()[n3].getRowspan() - n2 + n4);
                bl2 = false;
                continue;
            }
            fArray[n3] = pdfPCell.getFixedHeight();
            fArray2[n3] = pdfPCell.getMinimumHeight();
            Image image = pdfPCell.getImage();
            object = new PdfPCell(pdfPCell);
            if (image != null) {
                if (f2 > pdfPCell.getEffectivePaddingBottom() + pdfPCell.getEffectivePaddingTop() + 2.0f) {
                    ((PdfPCell)object).setPhrase(null);
                    bl2 = false;
                }
            } else {
                int n5;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                float f4 = pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft();
                float f5 = pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop();
                float f6 = f5 + pdfPCell.getEffectivePaddingBottom() - f2;
                float f7 = pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight();
                switch (((Rectangle)pdfPCell).getRotation()) {
                    case 90: 
                    case 270: {
                        f4 = PdfPRow.setColumn(columnText, f6, f4, f5, f7);
                        break;
                    }
                    default: {
                        f4 = PdfPRow.setColumn(columnText, f4, f6, pdfPCell.isNoWrap() ? 20000.0f : f7, f5);
                    }
                }
                try {
                    n5 = columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                boolean bl3 = columnText.getYLine() == f4;
                if (bl3) {
                    ((PdfPCell)object).setColumn(ColumnText.duplicate(pdfPCell.getColumn()));
                    columnText.setFilledWidth(0.0f);
                } else if ((n5 & 1) == 0) {
                    ((PdfPCell)object).setColumn(columnText);
                    columnText.setFilledWidth(0.0f);
                } else {
                    ((PdfPCell)object).setPhrase(null);
                }
                bl2 = bl2 && bl3;
            }
            pdfPCellArray[n3] = object;
            pdfPCell.setFixedHeight(f2);
        }
        if (bl2) {
            for (n3 = 0; n3 < this.cells.length; ++n3) {
                pdfPCell = this.cells[n3];
                if (pdfPCell == null) continue;
                if (fArray[n3] > 0.0f) {
                    pdfPCell.setFixedHeight(fArray[n3]);
                    continue;
                }
                pdfPCell.setMinimumHeight(fArray2[n3]);
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow pdfPRow = new PdfPRow(pdfPCellArray);
        new PdfPRow(pdfPCellArray).widths = (float[])this.widths.clone();
        pdfPRow.calculateHeights();
        return pdfPRow;
    }

    public PdfPCell[] getCells() {
        return this.cells;
    }
}

