/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Image;
import com.lowagie.text.LargeElement;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTableEvent;
import com.lowagie.text.pdf.events.PdfPTableEventForwarder;
import java.util.ArrayList;

public class PdfPTable
implements LargeElement {
    public static final int BASECANVAS = 0;
    public static final int BACKGROUNDCANVAS = 1;
    public static final int LINECANVAS = 2;
    public static final int TEXTCANVAS = 3;
    protected ArrayList<PdfPRow> rows = new ArrayList();
    protected float totalHeight = 0.0f;
    protected PdfPCell[] currentRow;
    protected int currentRowIdx = 0;
    protected PdfPCell defaultCell = new PdfPCell(null);
    protected float totalWidth = 0.0f;
    protected float[] relativeWidths;
    protected float[] absoluteWidths;
    protected PdfPTableEvent tableEvent;
    protected int headerRows;
    protected float widthPercentage = 80.0f;
    private int a = 1;
    private boolean b = false;
    private boolean c = false;
    protected boolean isColspan = false;
    protected int runDirection = 0;
    private boolean d = false;
    private boolean e = true;
    protected float spacingBefore;
    protected float spacingAfter;
    private boolean[] f = new boolean[]{false, false};
    private boolean g;
    private boolean h = true;
    private boolean i;
    protected boolean complete = true;
    private int j;
    protected boolean rowCompleted = true;

    protected PdfPTable() {
    }

    public PdfPTable(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("the.widths.array.in.pdfptable.constructor.can.not.be.null"));
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.widths.array.in.pdfptable.constructor.can.not.have.zero.length"));
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.i = false;
    }

    public PdfPTable(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.number.of.columns.in.pdfptable.constructor.must.be.greater.than.zero"));
        }
        this.relativeWidths = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.relativeWidths[i2] = 1.0f;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.i = false;
    }

    public PdfPTable(PdfPTable pdfPTable) {
        int n2;
        this.copyFormat(pdfPTable);
        for (n2 = 0; n2 < this.currentRow.length && pdfPTable.currentRow[n2] != null; ++n2) {
            this.currentRow[n2] = new PdfPCell(pdfPTable.currentRow[n2]);
        }
        for (n2 = 0; n2 < pdfPTable.rows.size(); ++n2) {
            PdfPRow pdfPRow = pdfPTable.rows.get(n2);
            if (pdfPRow != null) {
                pdfPRow = new PdfPRow(pdfPRow);
            }
            this.rows.add(pdfPRow);
        }
    }

    public static PdfPTable shallowCopy(PdfPTable pdfPTable) {
        PdfPTable pdfPTable2 = new PdfPTable();
        pdfPTable2.copyFormat(pdfPTable);
        return pdfPTable2;
    }

    protected void copyFormat(PdfPTable pdfPTable) {
        this.relativeWidths = new float[pdfPTable.getNumberOfColumns()];
        this.absoluteWidths = new float[pdfPTable.getNumberOfColumns()];
        System.arraycopy(pdfPTable.relativeWidths, 0, this.relativeWidths, 0, this.getNumberOfColumns());
        System.arraycopy(pdfPTable.absoluteWidths, 0, this.absoluteWidths, 0, this.getNumberOfColumns());
        this.totalWidth = pdfPTable.totalWidth;
        this.totalHeight = pdfPTable.totalHeight;
        this.currentRowIdx = 0;
        this.tableEvent = pdfPTable.tableEvent;
        this.runDirection = pdfPTable.runDirection;
        this.defaultCell = new PdfPCell(pdfPTable.defaultCell);
        this.currentRow = new PdfPCell[pdfPTable.currentRow.length];
        this.isColspan = pdfPTable.isColspan;
        this.e = pdfPTable.e;
        this.spacingAfter = pdfPTable.spacingAfter;
        this.spacingBefore = pdfPTable.spacingBefore;
        this.headerRows = pdfPTable.headerRows;
        this.j = pdfPTable.j;
        this.d = pdfPTable.d;
        this.f = pdfPTable.f;
        this.g = pdfPTable.g;
        this.widthPercentage = pdfPTable.widthPercentage;
        this.h = pdfPTable.h;
        this.b = pdfPTable.b;
        this.c = pdfPTable.c;
        this.a = pdfPTable.a;
        this.i = pdfPTable.i;
        this.complete = pdfPTable.complete;
    }

    public void setWidths(float[] fArray) {
        if (fArray.length != this.getNumberOfColumns()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("wrong.number.of.columns"));
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights(true);
    }

    public void setWidths(int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        this.setWidths(fArray);
    }

    protected void calculateWidths() {
        int n2;
        if (this.totalWidth <= 0.0f) {
            return;
        }
        float f2 = 0.0f;
        int n3 = this.getNumberOfColumns();
        for (n2 = 0; n2 < n3; ++n2) {
            f2 += this.relativeWidths[n2];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.absoluteWidths[n2] = this.totalWidth * this.relativeWidths[n2] / f2;
        }
    }

    public void setTotalWidth(float f2) {
        if (this.totalWidth == f2) {
            return;
        }
        this.totalWidth = f2;
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights(true);
    }

    public void setTotalWidth(float[] fArray) {
        if (fArray.length != this.getNumberOfColumns()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("wrong.number.of.columns"));
        }
        this.totalWidth = 0.0f;
        float[] fArray2 = fArray;
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2 = fArray2[i2];
            this.totalWidth += f2;
        }
        this.setWidths(fArray);
    }

    public void setWidthPercentage(float[] fArray, Rectangle rectangle) {
        if (fArray.length != this.getNumberOfColumns()) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("wrong.number.of.columns"));
        }
        float f2 = 0.0f;
        float[] fArray2 = fArray;
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f3 = fArray2[i2];
            f2 += f3;
        }
        this.widthPercentage = f2 / (rectangle.getRight() - rectangle.getLeft()) * 100.0f;
        this.setWidths(fArray);
    }

    public float getTotalWidth() {
        return this.totalWidth;
    }

    public float calculateHeights(boolean bl2) {
        if (this.totalWidth <= 0.0f) {
            return 0.0f;
        }
        this.totalHeight = 0.0f;
        for (int i2 = 0; i2 < this.rows.size(); ++i2) {
            this.totalHeight += this.getRowHeight(i2, bl2);
        }
        return this.totalHeight;
    }

    public void calculateHeightsFast() {
        this.calculateHeights(false);
    }

    public PdfPCell getDefaultCell() {
        return this.defaultCell;
    }

    public void addCell(PdfPCell pdfPCell) {
        int n2;
        this.rowCompleted = false;
        pdfPCell = new PdfPCell(pdfPCell);
        int n3 = pdfPCell.getColspan();
        n3 = Math.max(n3, 1);
        n3 = Math.min(n3, this.currentRow.length - this.currentRowIdx);
        pdfPCell.setColspan(n3);
        if (n3 != 1) {
            this.isColspan = true;
        }
        if ((n2 = pdfPCell.getRunDirection()) == 0) {
            pdfPCell.setRunDirection(this.runDirection);
        }
        this.a();
        n2 = 0;
        if (this.currentRowIdx < this.currentRow.length) {
            this.currentRow[this.currentRowIdx] = pdfPCell;
            this.currentRowIdx += n3;
            n2 = 1;
        }
        this.a();
        while (this.currentRowIdx >= this.currentRow.length) {
            Object object;
            int n4 = this.getNumberOfColumns();
            if (this.runDirection == 3) {
                object = new PdfPCell[n4];
                int n5 = this.currentRow.length;
                for (int i2 = 0; i2 < this.currentRow.length; ++i2) {
                    PdfPCell pdfPCell2 = this.currentRow[i2];
                    int n6 = pdfPCell2.getColspan();
                    object[n5 -= n6] = pdfPCell2;
                    i2 += n6 - 1;
                }
                this.currentRow = object;
            }
            object = new PdfPRow(this.currentRow);
            if (this.totalWidth > 0.0f) {
                ((PdfPRow)object).setWidths(this.absoluteWidths);
                this.totalHeight += ((PdfPRow)object).getMaxHeights();
            }
            this.rows.add((PdfPRow)object);
            this.currentRow = new PdfPCell[n4];
            this.currentRowIdx = 0;
            this.a();
            this.rowCompleted = true;
        }
        if (n2 == 0) {
            this.currentRow[this.currentRowIdx] = pdfPCell;
            this.currentRowIdx += n3;
        }
    }

    private void a() {
        int n2 = 1;
        if (this.runDirection == 3) {
            n2 = -1;
        }
        while (true) {
            PdfPTable pdfPTable = this;
            if (!pdfPTable.a(pdfPTable.rows.size(), this.currentRowIdx)) break;
            this.currentRowIdx += n2;
        }
    }

    private PdfPCell b(int n2, int n3) {
        PdfPCell[] pdfPCellArray = this.rows.get(n2).getCells();
        for (int i2 = 0; i2 < pdfPCellArray.length; ++i2) {
            if (pdfPCellArray[i2] == null || n3 < i2 || n3 >= i2 + pdfPCellArray[i2].getColspan()) continue;
            return pdfPCellArray[i2];
        }
        return null;
    }

    final boolean a(int n2, int n3) {
        if (n3 >= this.getNumberOfColumns() || n3 < 0 || n2 <= 0) {
            return false;
        }
        int n4 = n2 - 1;
        PdfPRow pdfPRow = this.rows.get(n4);
        if (pdfPRow == null) {
            return false;
        }
        PdfPCell pdfPCell = this.b(n4, n3);
        while (pdfPCell == null && n4 > 0) {
            if ((pdfPRow = this.rows.get(--n4)) == null) {
                return false;
            }
            pdfPCell = this.b(n4, n3);
        }
        n2 -= n4;
        if (pdfPCell == null) {
            pdfPCell = this.b(n4, --n3);
            while (pdfPCell == null && n4 > 0) {
                pdfPCell = this.b(n4, --n3);
            }
            return pdfPCell != null && pdfPCell.getRowspan() > n2;
        }
        if (pdfPCell.getRowspan() == 1 && n2 > 1) {
            pdfPRow = this.rows.get(n4 + 1);
            --n2;
            pdfPCell = pdfPRow.getCells()[--n3];
            while (pdfPCell == null && n3 > 0) {
                pdfPCell = pdfPRow.getCells()[--n3];
            }
        }
        return pdfPCell != null && pdfPCell.getRowspan() > n2;
    }

    public void addCell(String string) {
        this.addCell(new Phrase(string));
    }

    public void addCell(PdfPTable pdfPTable) {
        this.defaultCell.a(pdfPTable);
        PdfPTable pdfPTable2 = this;
        pdfPTable2.addCell(pdfPTable2.defaultCell);
        this.defaultCell.a(null);
    }

    public void addCell(Image image) {
        this.defaultCell.setImage(image);
        PdfPTable pdfPTable = this;
        pdfPTable.addCell(pdfPTable.defaultCell);
        this.defaultCell.setImage(null);
    }

    public void addCell(Phrase phrase) {
        this.defaultCell.setPhrase(phrase);
        PdfPTable pdfPTable = this;
        pdfPTable.addCell(pdfPTable.defaultCell);
        this.defaultCell.setPhrase(null);
    }

    public float writeSelectedRows(int n2, int n3, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        return this.writeSelectedRows(0, -1, n2, n3, f2, f3, pdfContentByteArray);
    }

    public float writeSelectedRows(int n2, int n3, int n4, int n5, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        if (this.totalWidth <= 0.0f) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("the.table.width.must.be.greater.than.zero"));
        }
        int n6 = this.rows.size();
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= (n5 = n5 < 0 ? n6 : Math.min(n5, n6))) {
            return f3;
        }
        n6 = this.getNumberOfColumns();
        n2 = n2 < 0 ? 0 : Math.min(n2, n6);
        n3 = n3 < 0 ? n6 : Math.min(n3, n6);
        float f4 = f3;
        for (int i2 = n4; i2 < n5; ++i2) {
            PdfPRow pdfPRow = this.rows.get(i2);
            if (pdfPRow == null) continue;
            pdfPRow.writeCells(n2, n3, f2, f3, pdfContentByteArray);
            f3 -= pdfPRow.getMaxHeights();
        }
        if (this.tableEvent != null && n2 == 0 && n3 == n6) {
            int n7;
            float[] fArray = new float[n5 - n4 + 1];
            float[] fArray2 = fArray;
            fArray[0] = f4;
            for (n7 = n4; n7 < n5; ++n7) {
                PdfPRow pdfPRow = this.rows.get(n7);
                float f5 = 0.0f;
                if (pdfPRow != null) {
                    f5 = pdfPRow.getMaxHeights();
                }
                fArray2[n7 - n4 + 1] = fArray2[n7 - n4] - f5;
            }
            n6 = this.g ? 1 : 0;
            int n8 = n5;
            n5 = n4;
            float f6 = f2;
            PdfPTable pdfPTable = this;
            if (n6 != 0) {
                n5 = Math.max(n5, pdfPTable.headerRows);
                n8 = Math.max(n8, pdfPTable.headerRows);
            }
            float[][] fArrayArray = new float[(n6 != 0 ? pdfPTable.headerRows : 0) + n8 - n5][];
            if (pdfPTable.isColspan) {
                n7 = 0;
                if (n6 != 0) {
                    for (n6 = 0; n6 < pdfPTable.headerRows; ++n6) {
                        PdfPRow pdfPRow = pdfPTable.rows.get(n6);
                        if (pdfPRow == null) {
                            ++n7;
                            continue;
                        }
                        fArrayArray[n7++] = pdfPRow.a(f6);
                    }
                }
                while (n5 < n8) {
                    PdfPRow pdfPRow = pdfPTable.rows.get(n5);
                    if (pdfPRow == null) {
                        ++n7;
                    } else {
                        fArrayArray[n7++] = pdfPRow.a(f6);
                    }
                    ++n5;
                }
            } else {
                int n9;
                n7 = pdfPTable.getNumberOfColumns();
                float[] fArray3 = new float[n7 + 1];
                float[] fArray4 = fArray3;
                fArray3[0] = f6;
                for (n9 = 0; n9 < n7; ++n9) {
                    fArray4[n9 + 1] = fArray4[n9] + pdfPTable.absoluteWidths[n9];
                }
                for (n9 = 0; n9 < fArrayArray.length; ++n9) {
                    fArrayArray[n9] = fArray4;
                }
            }
            this.tableEvent.tableLayout(pdfPTable, fArrayArray, fArray2, this.g ? this.headerRows : 0, n4, pdfContentByteArray);
        }
        return f3;
    }

    public float writeSelectedRows(int n2, int n3, float f2, float f3, PdfContentByte pdfContentByte) {
        return this.writeSelectedRows(0, -1, n2, n3, f2, f3, pdfContentByte);
    }

    public float writeSelectedRows(int n2, int n3, int n4, int n5, float f2, float f3, PdfContentByte pdfContentByte) {
        float f4;
        int n6 = this.getNumberOfColumns();
        n2 = n2 < 0 ? 0 : Math.min(n2, n6);
        n3 = n3 < 0 ? n6 : Math.min(n3, n6);
        boolean bl2 = n2 != 0 || n3 != n6;
        if (bl2) {
            float f5 = 0.0f;
            for (int i2 = n2; i2 < n3; ++i2) {
                f5 += this.absoluteWidths[i2];
            }
            pdfContentByte.saveState();
            f4 = n2 == 0 ? 10000.0f : 0.0f;
            float f6 = n3 == n6 ? 10000.0f : 0.0f;
            pdfContentByte.rectangle(f2 - f4, -10000.0f, f5 + f4 + f6, 20000.0f);
            pdfContentByte.clip();
            pdfContentByte.newPath();
        }
        PdfContentByte[] pdfContentByteArray = PdfPTable.beginWritingRows(pdfContentByte);
        f4 = this.writeSelectedRows(n2, n3, n4, n5, f2, f3, pdfContentByteArray);
        PdfPTable.endWritingRows(pdfContentByteArray);
        if (bl2) {
            pdfContentByte.restoreState();
        }
        return f4;
    }

    public static PdfContentByte[] beginWritingRows(PdfContentByte pdfContentByte) {
        return new PdfContentByte[]{pdfContentByte, pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate()};
    }

    public static void endWritingRows(PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[0];
        pdfContentByte.saveState();
        pdfContentByte.add(pdfContentByteArray[1]);
        pdfContentByte.restoreState();
        pdfContentByte.saveState();
        pdfContentByte.setLineCap(2);
        pdfContentByte.resetRGBColorStroke();
        pdfContentByte.add(pdfContentByteArray[2]);
        pdfContentByte.restoreState();
        pdfContentByte.add(pdfContentByteArray[3]);
    }

    public int size() {
        return this.rows.size();
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public float getRowHeight(int n2) {
        return this.getRowHeight(n2, false);
    }

    public float getRowHeight(int n2, boolean bl2) {
        if (this.totalWidth <= 0.0f || n2 < 0 || n2 >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow pdfPRow = this.rows.get(n2);
        if (pdfPRow == null) {
            return 0.0f;
        }
        if (bl2) {
            pdfPRow.setWidths(this.absoluteWidths);
        }
        float f2 = pdfPRow.getMaxHeights();
        for (int i2 = 0; i2 < this.relativeWidths.length; ++i2) {
            if (!this.a(n2, i2)) continue;
            int n3 = 1;
            while (this.a(n2 - n3, i2)) {
                ++n3;
            }
            Object object = this.rows.get(n2 - n3);
            object = ((PdfPRow)object).getCells()[i2];
            float f3 = 0.0f;
            if (object != null && ((PdfPCell)object).getRowspan() == n3 + 1) {
                f3 = ((PdfPCell)object).getMaxHeight();
                while (n3 > 0) {
                    f3 -= this.getRowHeight(n2 - n3);
                    --n3;
                }
            }
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        pdfPRow.setMaxHeights(f2);
        return f2;
    }

    public float getRowspanHeight(int n2, int n3) {
        if (this.totalWidth <= 0.0f || n2 < 0 || n2 >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow pdfPRow = this.rows.get(n2);
        if (pdfPRow == null || n3 >= pdfPRow.getCells().length) {
            return 0.0f;
        }
        PdfPCell pdfPCell = pdfPRow.getCells()[n3];
        if (pdfPCell == null) {
            return 0.0f;
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < pdfPCell.getRowspan(); ++i2) {
            f2 += this.getRowHeight(n2 + i2);
        }
        return f2;
    }

    public float getHeaderHeight() {
        float f2 = 0.0f;
        int n2 = Math.min(this.rows.size(), this.headerRows);
        for (int i2 = 0; i2 < n2; ++i2) {
            PdfPRow pdfPRow = this.rows.get(i2);
            if (pdfPRow == null) continue;
            f2 += pdfPRow.getMaxHeights();
        }
        return f2;
    }

    public float getFooterHeight() {
        float f2 = 0.0f;
        int n2 = Math.max(0, this.headerRows - this.j);
        int n3 = Math.min(this.rows.size(), this.headerRows);
        while (n2 < n3) {
            PdfPRow pdfPRow = this.rows.get(n2);
            if (pdfPRow != null) {
                f2 += pdfPRow.getMaxHeights();
            }
            ++n2;
        }
        return f2;
    }

    public boolean deleteRow(int n2) {
        PdfPRow pdfPRow;
        if (n2 < 0 || n2 >= this.rows.size()) {
            return false;
        }
        if (this.totalWidth > 0.0f && (pdfPRow = this.rows.get(n2)) != null) {
            this.totalHeight -= pdfPRow.getMaxHeights();
        }
        this.rows.remove(n2);
        if (n2 < this.headerRows) {
            --this.headerRows;
            if (n2 >= this.headerRows - this.j) {
                --this.j;
            }
        }
        return true;
    }

    public boolean deleteLastRow() {
        PdfPTable pdfPTable = this;
        return pdfPTable.deleteRow(pdfPTable.rows.size() - 1);
    }

    public void deleteBodyRows() {
        ArrayList<PdfPRow> arrayList = new ArrayList<PdfPRow>();
        for (int i2 = 0; i2 < this.headerRows; ++i2) {
            arrayList.add(this.rows.get(i2));
        }
        this.rows = arrayList;
        this.totalHeight = 0.0f;
        if (this.totalWidth > 0.0f) {
            this.totalHeight = this.getHeaderHeight();
        }
    }

    public int getNumberOfColumns() {
        return this.relativeWidths.length;
    }

    public int getHeaderRows() {
        return this.headerRows;
    }

    public void setHeaderRows(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.headerRows = n2;
    }

    @Override
    public ArrayList<Element> getChunks() {
        return new ArrayList<Element>();
    }

    @Override
    public int type() {
        return 23;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float f2) {
        this.widthPercentage = f2;
    }

    public int getHorizontalAlignment() {
        return this.a;
    }

    public void setHorizontalAlignment(int n2) {
        this.a = n2;
    }

    public PdfPRow getRow(int n2) {
        return this.rows.get(n2);
    }

    public ArrayList<PdfPRow> getRows() {
        return this.rows;
    }

    public ArrayList<PdfPRow> getRows(int n2, int n3) {
        ArrayList<PdfPRow> arrayList = new ArrayList<PdfPRow>();
        if (n2 < 0 || n3 > this.size()) {
            return arrayList;
        }
        PdfPRow pdfPRow = this.adjustCellsInRow(n2, n3);
        int n4 = 0;
        while (n4 < this.getNumberOfColumns()) {
            int n5 = n2;
            while (this.a(n5--, n4)) {
                Object object = this.getRow(n5);
                if (object == null || (object = ((PdfPRow)object).getCells()[n4]) == null) continue;
                pdfPRow.getCells()[n4] = new PdfPCell((PdfPCell)object);
                float f2 = 0.0f;
                int n6 = Math.min(n5 + ((PdfPCell)object).getRowspan(), n3);
                for (int i2 = n2 + 1; i2 < n6; ++i2) {
                    f2 += this.getRowHeight(i2);
                }
                pdfPRow.setExtraHeight(n4, f2);
                float f3 = this.getRowspanHeight(n5, n4) - this.getRowHeight(n2) - f2;
                pdfPRow.getCells()[n4].a(f3);
            }
            PdfPCell pdfPCell = pdfPRow.getCells()[n4];
            if (pdfPCell == null) {
                ++n4;
                continue;
            }
            n4 += pdfPCell.getColspan();
        }
        arrayList.add(pdfPRow);
        for (int i3 = n2 + 1; i3 < n3; ++i3) {
            arrayList.add(this.adjustCellsInRow(i3, n3));
        }
        return arrayList;
    }

    protected PdfPRow adjustCellsInRow(int n2, int n3) {
        PdfPRow pdfPRow = new PdfPRow(this.getRow(n2));
        pdfPRow.initExtraHeights();
        PdfPCell[] pdfPCellArray = pdfPRow.getCells();
        for (int i2 = 0; i2 < pdfPCellArray.length; ++i2) {
            PdfPCell pdfPCell = pdfPCellArray[i2];
            if (pdfPCell == null || pdfPCell.getRowspan() == 1) continue;
            int n4 = Math.min(n3, n2 + pdfPCell.getRowspan());
            float f2 = 0.0f;
            for (int i3 = n2 + 1; i3 < n4; ++i3) {
                f2 += this.getRowHeight(i3);
            }
            pdfPRow.setExtraHeight(i2, f2);
        }
        return pdfPRow;
    }

    public void setTableEvent(PdfPTableEvent pdfPTableEvent) {
        if (pdfPTableEvent == null) {
            this.tableEvent = null;
            return;
        }
        if (this.tableEvent == null) {
            this.tableEvent = pdfPTableEvent;
            return;
        }
        if (this.tableEvent instanceof PdfPTableEventForwarder) {
            ((PdfPTableEventForwarder)this.tableEvent).addTableEvent(pdfPTableEvent);
            return;
        }
        PdfPTableEventForwarder pdfPTableEventForwarder = new PdfPTableEventForwarder();
        pdfPTableEventForwarder.addTableEvent(this.tableEvent);
        pdfPTableEventForwarder.addTableEvent(pdfPTableEvent);
        this.tableEvent = pdfPTableEventForwarder;
    }

    public PdfPTableEvent getTableEvent() {
        return this.tableEvent;
    }

    public float[] getAbsoluteWidths() {
        return this.absoluteWidths;
    }

    public boolean isSkipFirstHeader() {
        return this.b;
    }

    public boolean isSkipLastFooter() {
        return this.c;
    }

    public void setSkipFirstHeader(boolean bl2) {
        this.b = bl2;
    }

    public void setSkipLastFooter(boolean bl2) {
        this.c = bl2;
    }

    public void setRunDirection(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.runDirection = n2;
                return;
            }
        }
        throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.run.direction.1", n2));
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public boolean isLockedWidth() {
        return this.d;
    }

    public void setLockedWidth(boolean bl2) {
        this.d = bl2;
    }

    public boolean isSplitRows() {
        return this.e;
    }

    public void setSplitRows(boolean bl2) {
        this.e = bl2;
    }

    public void setSpacingBefore(float f2) {
        this.spacingBefore = f2;
    }

    public void setSpacingAfter(float f2) {
        this.spacingAfter = f2;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public boolean isExtendLastRow() {
        return this.f[0];
    }

    public void setExtendLastRow(boolean bl2) {
        this.f[0] = bl2;
        this.f[1] = bl2;
    }

    public void setExtendLastRow(boolean bl2, boolean bl3) {
        this.f[0] = bl2;
        this.f[1] = bl3;
    }

    public boolean isExtendLastRow(boolean bl2) {
        if (bl2) {
            return this.f[0];
        }
        return this.f[1];
    }

    public boolean isHeadersInEvent() {
        return this.g;
    }

    public void setHeadersInEvent(boolean bl2) {
        this.g = bl2;
    }

    public boolean isSplitLate() {
        return this.h;
    }

    public void setSplitLate(boolean bl2) {
        this.h = bl2;
    }

    public void setKeepTogether(boolean bl2) {
        this.i = bl2;
    }

    public boolean getKeepTogether() {
        return this.i;
    }

    public int getFooterRows() {
        return this.j;
    }

    public void setFooterRows(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.j = n2;
    }

    public void completeRow() {
        while (!this.rowCompleted) {
            PdfPTable pdfPTable = this;
            pdfPTable.addCell(pdfPTable.defaultCell);
        }
    }

    @Override
    public void flushContent() {
        this.deleteBodyRows();
        this.setSkipFirstHeader(true);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void setComplete(boolean bl2) {
        this.complete = bl2;
    }
}

