/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.factories.RomanAlphabetFactory;
import com.lowagie.text.factories.RomanNumberFactory;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfNumberTree;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class PdfPageLabels {
    public static final int DECIMAL_ARABIC_NUMERALS = 0;
    public static final int UPPERCASE_ROMAN_NUMERALS = 1;
    public static final int LOWERCASE_ROMAN_NUMERALS = 2;
    public static final int UPPERCASE_LETTERS = 3;
    public static final int LOWERCASE_LETTERS = 4;
    public static final int EMPTY = 5;
    private static PdfName[] a = new PdfName[]{PdfName.D, PdfName.R, new PdfName("r"), PdfName.A, new PdfName("a")};
    private HashMap<Integer, PdfDictionary> b = new HashMap();

    public PdfPageLabels() {
        this.addPageLabel(1, 0, null, 1);
    }

    public void addPageLabel(int n2, int n3, String string, int n4) {
        if (n2 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("in.a.page.label.the.page.numbers.must.be.greater.or.equal.to.1"));
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        if (n3 >= 0 && n3 < a.length) {
            pdfDictionary.put(PdfName.S, a[n3]);
        }
        if (string != null) {
            pdfDictionary.put(PdfName.P, new PdfString(string, "UnicodeBig"));
        }
        if (n4 != 1) {
            pdfDictionary.put(PdfName.ST, new PdfNumber(n4));
        }
        this.b.put(n2 - 1, pdfDictionary);
    }

    public void addPageLabel(int n2, int n3, String string) {
        this.addPageLabel(n2, n3, string, 1);
    }

    public void addPageLabel(int n2, int n3) {
        this.addPageLabel(n2, n3, null, 1);
    }

    public void addPageLabel(PdfPageLabelFormat pdfPageLabelFormat) {
        this.addPageLabel(pdfPageLabelFormat.physicalPage, pdfPageLabelFormat.numberStyle, pdfPageLabelFormat.prefix, pdfPageLabelFormat.logicalPage);
    }

    public void removePageLabel(int n2) {
        if (n2 <= 1) {
            return;
        }
        this.b.remove(n2 - 1);
    }

    final PdfDictionary a(PdfWriter pdfWriter) {
        try {
            return PdfNumberTree.writeTree(this.b, pdfWriter);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public static String[] getPageLabels(PdfReader hashMap) {
        int n2 = ((PdfReader)((Object)hashMap)).getNumberOfPages();
        hashMap = ((PdfReader)((Object)hashMap)).getCatalog();
        if ((hashMap = (PdfDictionary)PdfReader.getPdfObjectRelease(((PdfDictionary)((Object)hashMap)).get(PdfName.PAGELABELS))) == null) {
            return null;
        }
        String[] stringArray = new String[n2];
        hashMap = PdfNumberTree.readTree((PdfDictionary)((Object)hashMap));
        int n3 = 1;
        int n4 = 68;
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = i2;
            if (hashMap.containsKey(object)) {
                n3 = ((PdfDictionary)(object = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)hashMap.get(object)))).contains(PdfName.ST) ? ((PdfNumber)((PdfDictionary)object).get(PdfName.ST)).intValue() : 1;
                string = ((PdfDictionary)object).contains(PdfName.P) ? ((PdfString)((PdfDictionary)object).get(PdfName.P)).toUnicodeString() : "";
                if (((PdfDictionary)object).contains(PdfName.S)) {
                    n4 = ((PdfDictionary)object).get(PdfName.S).toString().charAt(1);
                }
            }
            switch (n4) {
                default: {
                    stringArray[i2] = string + n3;
                    break;
                }
                case 82: {
                    stringArray[i2] = string + RomanNumberFactory.getUpperCaseString(n3);
                    break;
                }
                case 114: {
                    stringArray[i2] = string + RomanNumberFactory.getLowerCaseString(n3);
                    break;
                }
                case 65: {
                    stringArray[i2] = string + RomanAlphabetFactory.getUpperCaseString(n3);
                    break;
                }
                case 97: {
                    stringArray[i2] = string + RomanAlphabetFactory.getLowerCaseString(n3);
                }
            }
            ++n3;
        }
        return stringArray;
    }

    public static PdfPageLabelFormat[] getPageLabelFormats(PdfReader hashMap) {
        hashMap = ((PdfReader)((Object)hashMap)).getCatalog();
        if ((hashMap = (PdfDictionary)PdfReader.getPdfObjectRelease(((PdfDictionary)((Object)hashMap)).get(PdfName.PAGELABELS))) == null) {
            return null;
        }
        hashMap = PdfNumberTree.readTree((PdfDictionary)((Object)hashMap));
        Integer[] integerArray = new Integer[hashMap.size()];
        integerArray = hashMap.keySet().toArray(integerArray);
        Arrays.sort((Object[])integerArray);
        PdfPageLabelFormat[] pdfPageLabelFormatArray = new PdfPageLabelFormat[hashMap.size()];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            int n2;
            Integer n3 = integerArray[i2];
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)hashMap.get(n3));
            int n4 = pdfDictionary.contains(PdfName.ST) ? ((PdfNumber)pdfDictionary.get(PdfName.ST)).intValue() : 1;
            String string = pdfDictionary.contains(PdfName.P) ? ((PdfString)pdfDictionary.get(PdfName.P)).toUnicodeString() : "";
            if (pdfDictionary.contains(PdfName.S)) {
                char c2 = pdfDictionary.get(PdfName.S).toString().charAt(1);
                n2 = c2;
                switch (c2) {
                    case 'R': {
                        n2 = 1;
                        break;
                    }
                    case 'r': {
                        n2 = 2;
                        break;
                    }
                    case 'A': {
                        n2 = 3;
                        break;
                    }
                    case 'a': {
                        n2 = 4;
                        break;
                    }
                    default: {
                        n2 = 0;
                        break;
                    }
                }
            } else {
                n2 = 5;
            }
            pdfPageLabelFormatArray[i2] = new PdfPageLabelFormat(n3 + 1, n2, string, n4);
        }
        return pdfPageLabelFormatArray;
    }

    public static class PdfPageLabelFormat {
        public int physicalPage;
        public int numberStyle;
        public String prefix;
        public int logicalPage;

        public PdfPageLabelFormat(int n2, int n3, String string, int n4) {
            this.physicalPage = n2;
            this.numberStyle = n3;
            this.prefix = string;
            this.logicalPage = n4;
        }

        public String toString() {
            return "PdfPageLabelFormat{physicalPage=" + this.physicalPage + ", numberStyle=" + this.numberStyle + ", prefix='" + this.prefix + '\'' + ", logicalPage=" + this.logicalPage + '}';
        }
    }
}

