/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfPublicKeyRecipient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificate;

public class PdfPublicKeySecurityHandler {
    private final List<PdfPublicKeyRecipient> a;
    private byte[] b = new byte[20];

    public PdfPublicKeySecurityHandler() {
        try {
            Object object = KeyGenerator.getInstance("AES");
            ((KeyGenerator)object).init(192, new SecureRandom());
            object = ((KeyGenerator)object).generateKey();
            System.arraycopy(object.getEncoded(), 0, this.b, 0, 20);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.b = SecureRandom.getSeed(20);
        }
        this.a = new ArrayList<PdfPublicKeyRecipient>();
    }

    public void addRecipient(PdfPublicKeyRecipient pdfPublicKeyRecipient) {
        this.a.add(pdfPublicKeyRecipient);
    }

    protected byte[] getSeed() {
        return (byte[])this.b.clone();
    }

    public int getRecipientsSize() {
        return this.a.size();
    }

    public byte[] getEncodedRecipient(int n2) {
        PdfPublicKeyRecipient pdfPublicKeyRecipient = this.a.get(n2);
        Object object = pdfPublicKeyRecipient.getCms();
        if (object != null) {
            return object;
        }
        object = pdfPublicKeyRecipient.getCertificate();
        int n3 = pdfPublicKeyRecipient.getPermission();
        n3 |= 0xFFFFF0C0;
        n3 &= 0xFFFFFFFC;
        Object object2 = new byte[24];
        byte by = (byte)(++n3);
        byte by2 = (byte)(n3 >> 8);
        byte by3 = (byte)(n3 >> 16);
        n3 = (byte)(n3 >> 24);
        System.arraycopy(this.b, 0, object2, 0, 20);
        object2[20] = n3;
        object2[21] = by3;
        object2[22] = by2;
        object2[23] = by;
        byte[] byArray = object2;
        object2 = (X509Certificate)object;
        Object object3 = byArray;
        object = this;
        object = "1.2.840.113549.3.2";
        Object object4 = AlgorithmParameterGenerator.getInstance("1.2.840.113549.3.2");
        object4 = ((AlgorithmParameterGenerator)object4).generateParameters();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((AlgorithmParameters)object4).getEncoded("ASN.1"));
        byteArrayInputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        byteArrayInputStream = byteArrayInputStream.readObject();
        Object object5 = KeyGenerator.getInstance((String)object);
        ((KeyGenerator)object5).init(128);
        object5 = ((KeyGenerator)object5).generateKey();
        Cipher cipher = Cipher.getInstance((String)object);
        cipher.init(1, (Key)object5, (AlgorithmParameters)object4);
        object3 = cipher.doFinal((byte[])object3);
        object3 = new DEROctetString((byte[])object3);
        object4 = object5.getEncoded();
        object5 = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509Certificate)object2).getTBSCertificate()));
        object5 = TBSCertificate.getInstance((Object)object5.readObject());
        cipher = object5.getSubjectPublicKeyInfo().getAlgorithm();
        object5 = new IssuerAndSerialNumber(object5.getIssuer(), object5.getSerialNumber().getValue());
        Cipher cipher2 = Cipher.getInstance(cipher.getAlgorithm().getId());
        cipher2.init(1, (Certificate)object2);
        object2 = new DEROctetString(cipher2.doFinal((byte[])object4));
        object4 = new RecipientIdentifier((IssuerAndSerialNumber)object5);
        object2 = new KeyTransRecipientInfo((RecipientIdentifier)object4, (AlgorithmIdentifier)cipher, (ASN1OctetString)object2);
        object2 = new DERSet((ASN1Encodable)new RecipientInfo((KeyTransRecipientInfo)object2));
        object = new AlgorithmIdentifier(new ASN1ObjectIdentifier((String)object), (ASN1Encodable)byteArrayInputStream);
        object = new EncryptedContentInfo(PKCSObjectIdentifiers.data, (AlgorithmIdentifier)object, (ASN1OctetString)object3);
        object = new EnvelopedData(null, (ASN1Set)object2, (EncryptedContentInfo)object, null);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.envelopedData, (ASN1Encodable)object);
        object = contentInfo;
        object = contentInfo.toASN1Primitive();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object3 = byteArrayOutputStream;
        object2 = ASN1OutputStream.create((OutputStream)byteArrayOutputStream, (String)"DER");
        object2.writeObject((ASN1Primitive)object);
        object = ((ByteArrayOutputStream)object3).toByteArray();
        pdfPublicKeyRecipient.setCms((byte[])object);
        return object;
    }

    public PdfArray getEncodedRecipients() {
        PdfArray pdfArray = new PdfArray();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            try {
                byte[] byArray = this.getEncodedRecipient(i2);
                pdfArray.add(new PdfLiteral(PdfContentByte.a(byArray)));
                continue;
            }
            catch (IOException | GeneralSecurityException exception) {
                pdfArray = null;
                break;
            }
        }
        return pdfArray;
    }
}

