/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.bouncycastle.BouncyCastleHelper;
import com.lowagie.text.DocWriter;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.exceptions.BadPasswordException;
import com.lowagie.text.exceptions.InvalidPdfException;
import com.lowagie.text.exceptions.UnsupportedPdfException;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.LZWDecoder;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SequenceList;
import com.lowagie.text.pdf.interfaces.PdfViewerPreferences;
import com.lowagie.text.pdf.internal.PdfViewerPreferencesImp;
import com.lowagie.text.pdf.k;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.Key;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.zip.InflaterInputStream;

public class PdfReader
implements PdfViewerPreferences,
Closeable {
    static final PdfName[] a = new PdfName[]{PdfName.MEDIABOX, PdfName.ROTATE, PdfName.RESOURCES, PdfName.CROPBOX};
    private static final byte[] c = PdfEncodings.convertToBytes("endstream", null);
    private static final byte[] d = PdfEncodings.convertToBytes("endobj", null);
    protected PRTokeniser tokens;
    protected int[] xref;
    protected Map<Integer, IntHashtable> objStmMark;
    protected IntHashtable objStmToOffset;
    protected boolean newXrefType;
    private List<PdfObject> e;
    PdfDictionary b;
    protected PdfDictionary trailer;
    protected PdfDictionary catalog;
    protected a pageRefs;
    protected PRAcroForm acroForm = null;
    protected boolean acroFormParsed = false;
    protected boolean encrypted = false;
    protected boolean rebuilt = false;
    protected int freeXref;
    protected boolean tampered = false;
    protected int lastXref;
    protected int eofPos;
    protected char pdfVersion;
    protected PdfEncryption decrypt;
    protected byte[] password = null;
    protected Key certificateKey = null;
    protected Certificate certificate = null;
    protected String certificateKeyProvider = null;
    private boolean f;
    private boolean g = true;
    protected List<PdfObject> strings = new ArrayList<PdfObject>();
    protected boolean sharedStreams = true;
    protected boolean consolidateNamedDestinations = false;
    protected boolean remoteToLocalNamedDestinations = false;
    protected int rValue;
    protected int pValue;
    private int h;
    private int i;
    private int j;
    private boolean k;
    private int l = -1;
    private boolean m;
    private PRIndirectReference n;
    private final PdfViewerPreferencesImp o = new PdfViewerPreferencesImp();
    private boolean p;
    private boolean q;
    private int r = 0;

    protected PdfReader() {
    }

    public PdfReader(String string) {
        this(string, null);
    }

    public PdfReader(String string, byte[] byArray) {
        this.password = byArray;
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(byte[] byArray) {
        this(byArray, null);
    }

    public PdfReader(byte[] byArray, byte[] byArray2) {
        this.password = byArray2;
        this.tokens = new PRTokeniser(byArray);
        this.readPdf();
    }

    public PdfReader(String string, Certificate certificate, Key key, String string2) {
        this.certificate = certificate;
        this.certificateKey = key;
        this.certificateKeyProvider = string2;
        this.tokens = new PRTokeniser(string);
        this.readPdf();
    }

    public PdfReader(URL uRL) {
        this(uRL, null);
    }

    public PdfReader(URL uRL, byte[] byArray) {
        this.password = byArray;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(uRL));
        this.readPdf();
    }

    public PdfReader(InputStream inputStream, byte[] byArray) {
        this.password = byArray;
        this.tokens = new PRTokeniser(new RandomAccessFileOrArray(inputStream));
        this.readPdf();
    }

    public PdfReader(InputStream inputStream) {
        this(inputStream, null);
    }

    public PdfReader(RandomAccessFileOrArray randomAccessFileOrArray, byte[] byArray) {
        this.password = byArray;
        this.m = true;
        this.tokens = new PRTokeniser(randomAccessFileOrArray);
        this.readPdfPartial();
    }

    public PdfReader(PdfReader pdfReader) {
        this.q = pdfReader.q;
        this.consolidateNamedDestinations = pdfReader.consolidateNamedDestinations;
        this.encrypted = pdfReader.encrypted;
        this.rebuilt = pdfReader.rebuilt;
        this.sharedStreams = pdfReader.sharedStreams;
        this.tampered = pdfReader.tampered;
        this.password = pdfReader.password;
        this.pdfVersion = pdfReader.pdfVersion;
        this.eofPos = pdfReader.eofPos;
        this.freeXref = pdfReader.freeXref;
        this.lastXref = pdfReader.lastXref;
        this.tokens = new PRTokeniser(pdfReader.tokens.getSafeFile());
        if (pdfReader.decrypt != null) {
            this.decrypt = new PdfEncryption(pdfReader.decrypt);
        }
        this.pValue = pdfReader.pValue;
        this.rValue = pdfReader.rValue;
        this.e = new ArrayList<PdfObject>(pdfReader.e);
        for (int i2 = 0; i2 < pdfReader.e.size(); ++i2) {
            this.e.set(i2, PdfReader.duplicatePdfObject(pdfReader.e.get(i2), this));
        }
        this.pageRefs = new a(pdfReader.pageRefs, this);
        this.trailer = (PdfDictionary)PdfReader.duplicatePdfObject(pdfReader.trailer, this);
        this.catalog = this.trailer.getAsDict(PdfName.ROOT);
        this.b = this.catalog.getAsDict(PdfName.PAGES);
        this.j = pdfReader.j;
        this.m = pdfReader.m;
        this.k = pdfReader.k;
        this.objStmToOffset = pdfReader.objStmToOffset;
        this.xref = pdfReader.xref;
        this.n = (PRIndirectReference)PdfReader.duplicatePdfObject(pdfReader.n, this);
        this.f = pdfReader.f;
    }

    public RandomAccessFileOrArray getSafeFile() {
        return this.tokens.getSafeFile();
    }

    protected k getPdfReaderInstance(PdfWriter pdfWriter) {
        return new k(this, pdfWriter);
    }

    public int getNumberOfPages() {
        return this.pageRefs.a();
    }

    public PdfDictionary getCatalog() {
        return this.catalog;
    }

    public PRAcroForm getAcroForm() {
        if (!this.acroFormParsed) {
            this.acroFormParsed = true;
            PdfObject pdfObject = this.catalog.get(PdfName.ACROFORM);
            if (pdfObject != null) {
                try {
                    this.acroForm = new PRAcroForm(this);
                    this.acroForm.readAcroForm((PdfDictionary)PdfReader.getPdfObject(pdfObject));
                }
                catch (Exception exception) {
                    this.acroForm = null;
                }
            }
        }
        return this.acroForm;
    }

    public int getPageRotation(int n2) {
        return PdfReader.a(this.pageRefs.b(n2));
    }

    static int a(PdfDictionary pdfObject) {
        if ((pdfObject = ((PdfDictionary)pdfObject).getAsNumber(PdfName.ROTATE)) == null) {
            return 0;
        }
        int n2 = ((PdfNumber)pdfObject).intValue();
        if ((n2 %= 360) < 0) {
            return n2 + 360;
        }
        return n2;
    }

    public Rectangle getPageSizeWithRotation(int n2) {
        PdfReader pdfReader = this;
        return pdfReader.getPageSizeWithRotation(pdfReader.pageRefs.b(n2));
    }

    public Rectangle getPageSizeWithRotation(PdfDictionary pdfDictionary) {
        Rectangle rectangle = this.getPageSize(pdfDictionary);
        for (int i2 = PdfReader.a(pdfDictionary); i2 > 0; i2 -= 90) {
            rectangle = rectangle.rotate();
        }
        return rectangle;
    }

    public Rectangle getPageSize(int n2) {
        PdfReader pdfReader = this;
        return pdfReader.getPageSize(pdfReader.pageRefs.b(n2));
    }

    public Rectangle getPageSize(PdfDictionary pdfObject) {
        pdfObject = pdfObject.getAsArray(PdfName.MEDIABOX);
        return PdfReader.getNormalizedRectangle((PdfArray)pdfObject);
    }

    public Rectangle getCropBox(int n2) {
        PdfDictionary pdfDictionary = this.pageRefs.b(n2);
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.CROPBOX));
        if (pdfArray == null) {
            return this.getPageSize(pdfDictionary);
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Rectangle getBoxSize(int n2, String string) {
        PdfDictionary pdfDictionary = this.pageRefs.b(n2);
        PdfArray pdfArray = null;
        int n3 = -1;
        switch (string.hashCode()) {
            case 3568674: {
                if (!string.equals("trim")) break;
                n3 = 0;
                break;
            }
            case 96867: {
                if (!string.equals("art")) break;
                n3 = 1;
                break;
            }
            case 93822778: {
                if (!string.equals("bleed")) break;
                n3 = 2;
                break;
            }
            case 3062416: {
                if (!string.equals("crop")) break;
                n3 = 3;
                break;
            }
            case 103772132: {
                if (!string.equals("media")) break;
                n3 = 4;
            }
        }
        switch (n3) {
            case 0: {
                pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.TRIMBOX));
                break;
            }
            case 1: {
                pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.ARTBOX));
                break;
            }
            case 2: {
                pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.BLEEDBOX));
                break;
            }
            case 3: {
                pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.CROPBOX));
                break;
            }
            case 4: {
                pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.MEDIABOX));
            }
        }
        if (pdfArray == null) {
            return null;
        }
        return PdfReader.getNormalizedRectangle(pdfArray);
    }

    public Map<String, String> getInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PdfDictionary pdfDictionary = this.trailer.getAsDict(PdfName.INFO);
        if (pdfDictionary == null) {
            return hashMap;
        }
        for (PdfName pdfName : pdfDictionary.getKeys()) {
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName));
            if (pdfObject == null) continue;
            String string = pdfObject.toString();
            switch (pdfObject.type()) {
                case 3: {
                    string = ((PdfString)pdfObject).toUnicodeString();
                    break;
                }
                case 4: {
                    string = PdfName.decodeName(string);
                }
            }
            hashMap.put(PdfName.decodeName(pdfName.toString()), string);
        }
        return hashMap;
    }

    public static Rectangle getNormalizedRectangle(PdfArray pdfArray) {
        float f2 = ((PdfNumber)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(0))).floatValue();
        float f3 = ((PdfNumber)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(1))).floatValue();
        float f4 = ((PdfNumber)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(2))).floatValue();
        float f5 = ((PdfNumber)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(3))).floatValue();
        return new Rectangle(Math.min(f2, f4), Math.min(f3, f5), Math.max(f2, f4), Math.max(f3, f5));
    }

    protected void readPdf() {
        try {
            this.j = this.tokens.getFile().length();
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception exception) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception exception2) {
                    throw new InvalidPdfException(MessageLocalization.getComposedMessage("rebuild.failed.1.original.message.2", exception2.getMessage(), exception.getMessage()));
                }
            }
            try {
                this.readDocObj();
            }
            catch (Exception exception) {
                Exception exception3 = exception;
                if (exception instanceof BadPasswordException) {
                    throw new BadPasswordException(exception3.getMessage());
                }
                if (this.rebuilt || this.p) {
                    throw new InvalidPdfException(exception3.getMessage());
                }
                this.rebuilt = true;
                this.encrypted = false;
                this.rebuildXref();
                this.lastXref = -1;
                this.readDocObj();
            }
            this.strings.clear();
            this.readPages();
            this.eliminateSharedStreams();
            this.removeUnusedObjects();
        }
        catch (Throwable throwable) {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            this.tokens.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void readPdfPartial() {
        try {
            this.j = this.tokens.getFile().length();
            this.pdfVersion = this.tokens.checkPdfHeader();
            try {
                this.readXref();
            }
            catch (Exception exception) {
                try {
                    this.rebuilt = true;
                    this.rebuildXref();
                    this.lastXref = -1;
                }
                catch (Exception exception2) {
                    throw new InvalidPdfException(MessageLocalization.getComposedMessage("rebuild.failed.1.original.message.2", exception2.getMessage(), exception.getMessage()));
                }
            }
            this.readDocObjPartial();
            this.readPages();
            return;
        }
        catch (IOException iOException) {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
            throw iOException;
        }
    }

    private static boolean a(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private void c() {
        PdfObject pdfObject;
        int n2;
        int n3;
        byte[] byArray;
        byte[] byArray2;
        Object object;
        Object object2;
        PdfObject pdfObject2;
        block52: {
            Object object3;
            Object object4;
            block51: {
                if (this.encrypted) {
                    return;
                }
                if (this.trailer == null) {
                    return;
                }
                pdfObject2 = this.trailer.get(PdfName.ENCRYPT);
                if (pdfObject2 == null || pdfObject2.toString().equals("null")) {
                    return;
                }
                this.p = true;
                object2 = null;
                this.encrypted = true;
                object4 = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
                object = this.trailer.getAsArray(PdfName.ID);
                byArray2 = null;
                if (object != null) {
                    Object object5 = ((PdfArray)object).getPdfObject(0);
                    this.strings.remove(object5);
                    object5 = ((PdfObject)object5).toString();
                    byArray2 = DocWriter.getISOBytes((String)object5);
                    if (((PdfArray)object).size() > 1) {
                        this.strings.remove(((PdfArray)object).getPdfObject(1));
                    }
                }
                if (byArray2 == null) {
                    byArray2 = new byte[]{};
                }
                object = null;
                byArray = null;
                n3 = 0;
                n2 = 0;
                pdfObject = PdfReader.getPdfObjectRelease(((PdfDictionary)object4).get(PdfName.FILTER));
                if (!pdfObject.equals(PdfName.STANDARD)) break block51;
                Object object6 = ((PdfDictionary)object4).get(PdfName.U).toString();
                this.strings.remove(((PdfDictionary)object4).get(PdfName.U));
                object = DocWriter.getISOBytes((String)object6);
                object6 = ((PdfDictionary)object4).get(PdfName.O).toString();
                this.strings.remove(((PdfDictionary)object4).get(PdfName.O));
                byArray = DocWriter.getISOBytes((String)object6);
                object6 = ((PdfDictionary)object4).get(PdfName.P);
                if (!((PdfObject)object6).isNumber()) {
                    throw new InvalidPdfException(MessageLocalization.getComposedMessage("illegal.p.value"));
                }
                this.pValue = ((PdfNumber)object6).intValue();
                object6 = ((PdfDictionary)object4).get(PdfName.R);
                if (!((PdfObject)object6).isNumber()) {
                    throw new InvalidPdfException(MessageLocalization.getComposedMessage("illegal.r.value"));
                }
                this.rValue = ((PdfNumber)object6).intValue();
                switch (this.rValue) {
                    case 2: {
                        n3 = 0;
                        break block52;
                    }
                    case 3: {
                        object6 = ((PdfDictionary)object4).get(PdfName.LENGTH);
                        if (!((PdfObject)object6).isNumber()) {
                            throw new InvalidPdfException(MessageLocalization.getComposedMessage("illegal.length.value"));
                        }
                        n2 = ((PdfNumber)object6).intValue();
                        if (n2 > 128 || n2 < 40 || n2 % 8 != 0) {
                            throw new InvalidPdfException(MessageLocalization.getComposedMessage("illegal.length.value"));
                        }
                        n3 = 1;
                        break block52;
                    }
                    case 4: {
                        object3 = (PdfDictionary)((PdfDictionary)object4).get(PdfName.CF);
                        if (object3 == null) {
                            throw new InvalidPdfException(MessageLocalization.getComposedMessage("cf.not.found.encryption"));
                        }
                        if ((object3 = (PdfDictionary)((PdfDictionary)object3).get(PdfName.STDCF)) == null) {
                            throw new InvalidPdfException(MessageLocalization.getComposedMessage("stdcf.not.found.encryption"));
                        }
                        if (PdfName.V2.equals(((PdfDictionary)object3).get(PdfName.CFM))) {
                            n3 = 1;
                        } else if (PdfName.AESV2.equals(((PdfDictionary)object3).get(PdfName.CFM))) {
                            n3 = 2;
                        } else {
                            throw new UnsupportedPdfException(MessageLocalization.getComposedMessage("no.compatible.encryption.found"));
                        }
                        PdfObject object7 = ((PdfDictionary)object4).get(PdfName.ENCRYPTMETADATA);
                        if (object7 != null && object7.toString().equals("false")) {
                            n3 |= 8;
                        }
                        break block52;
                    }
                    default: {
                        throw new UnsupportedPdfException(MessageLocalization.getComposedMessage("unknown.encryption.type.r.eq.1", this.rValue));
                    }
                }
            }
            if (pdfObject.equals(PdfName.PUBSEC)) {
                PdfObject pdfObject3 = ((PdfDictionary)object4).get(PdfName.V);
                if (!pdfObject3.isNumber()) {
                    throw new InvalidPdfException(MessageLocalization.getComposedMessage("illegal.v.value"));
                }
                int n4 = ((PdfNumber)pdfObject3).intValue();
                switch (n4) {
                    case 1: {
                        n3 = 0;
                        n2 = 40;
                        object3 = (PdfArray)((PdfDictionary)object4).get(PdfName.RECIPIENTS);
                        break;
                    }
                    case 2: {
                        pdfObject3 = ((PdfDictionary)object4).get(PdfName.LENGTH);
                        if (!pdfObject3.isNumber()) {
                            throw new InvalidPdfException(MessageLocalization.getComposedMessage("illegal.length.value"));
                        }
                        n2 = ((PdfNumber)pdfObject3).intValue();
                        if (n2 > 128 || n2 < 40 || n2 % 8 != 0) {
                            throw new InvalidPdfException(MessageLocalization.getComposedMessage("illegal.length.value"));
                        }
                        n3 = 1;
                        object3 = (PdfArray)((PdfDictionary)object4).get(PdfName.RECIPIENTS);
                        break;
                    }
                    case 4: {
                        object2 = (PdfDictionary)((PdfDictionary)object4).get(PdfName.CF);
                        if (object2 == null) {
                            throw new InvalidPdfException(MessageLocalization.getComposedMessage("cf.not.found.encryption"));
                        }
                        if ((object2 = (PdfDictionary)((PdfDictionary)object2).get(PdfName.DEFAULTCRYPTFILTER)) == null) {
                            throw new InvalidPdfException(MessageLocalization.getComposedMessage("defaultcryptfilter.not.found.encryption"));
                        }
                        if (PdfName.V2.equals(((PdfDictionary)object2).get(PdfName.CFM))) {
                            n3 = 1;
                            n2 = 128;
                        } else if (PdfName.AESV2.equals(((PdfDictionary)object2).get(PdfName.CFM))) {
                            n3 = 2;
                            n2 = 128;
                        } else {
                            throw new UnsupportedPdfException(MessageLocalization.getComposedMessage("no.compatible.encryption.found"));
                        }
                        object4 = ((PdfDictionary)object2).get(PdfName.ENCRYPTMETADATA);
                        if (object4 != null && ((PdfObject)object4).toString().equals("false")) {
                            n3 |= 8;
                        }
                        object3 = (PdfArray)((PdfDictionary)object2).get(PdfName.RECIPIENTS);
                        break;
                    }
                    default: {
                        throw new UnsupportedPdfException(MessageLocalization.getComposedMessage("unknown.encryption.type.v.eq.1", this.rValue));
                    }
                }
                BouncyCastleHelper.checkCertificateEncodingOrThrowException(this.certificate);
                byte[] byArray3 = BouncyCastleHelper.getEnvelopedData((PdfArray)object3, this.strings, this.certificate, this.certificateKey, this.certificateKeyProvider);
                object2 = byArray3;
                if (byArray3 == null) {
                    throw new UnsupportedPdfException(MessageLocalization.getComposedMessage("bad.certificate.and.key"));
                }
                try {
                    object4 = MessageDigest.getInstance("SHA-1");
                    ((MessageDigest)object4).update((byte[])object2, 0, 20);
                    for (int i2 = 0; i2 < ((PdfArray)object3).size(); ++i2) {
                        byte[] byArray4 = ((PdfArray)object3).getPdfObject(i2).getBytes();
                        ((MessageDigest)object4).update(byArray4);
                    }
                    if ((n3 & 8) != 0) {
                        ((MessageDigest)object4).update(new byte[]{-1, -1, -1, -1});
                    }
                    object2 = ((MessageDigest)object4).digest();
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
            }
        }
        this.decrypt = new PdfEncryption();
        this.decrypt.setCryptoMode(n3, n2);
        if (pdfObject.equals(PdfName.STANDARD)) {
            this.decrypt.setupByOwnerPassword(byArray2, this.password, (byte[])object, byArray, this.pValue);
            if (!PdfReader.a((byte[])object, this.decrypt.a, this.rValue == 3 || this.rValue == 4 ? 16 : 32)) {
                this.decrypt.setupByUserPassword(byArray2, this.password, byArray, this.pValue);
                if (!PdfReader.a((byte[])object, this.decrypt.a, this.rValue == 3 || this.rValue == 4 ? 16 : 32)) {
                    throw new BadPasswordException(MessageLocalization.getComposedMessage("bad.user.password"));
                }
            } else {
                this.f = true;
            }
        } else if (pdfObject.equals(PdfName.PUBSEC)) {
            this.decrypt.setupByEncryptionKey((byte[])object2, n2);
            this.f = true;
        }
        for (Object e2 : this.strings) {
            object2 = (PdfString)e2;
            ((PdfString)object2).a(this);
        }
        if (pdfObject2.isIndirect()) {
            this.n = (PRIndirectReference)pdfObject2;
            this.e.set(this.n.getNumber(), null);
        }
        this.p = false;
    }

    public static PdfObject getPdfObjectRelease(PdfObject pdfObject) {
        PdfObject pdfObject2 = PdfReader.getPdfObject(pdfObject);
        PdfReader.releaseLastXrefPartial(pdfObject);
        return pdfObject2;
    }

    public static PdfObject getPdfObject(PdfObject pdfObject) {
        if (pdfObject == null) {
            return null;
        }
        if (!pdfObject.isIndirect()) {
            return pdfObject;
        }
        try {
            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject;
            int n2 = pRIndirectReference.getNumber();
            boolean bl2 = pRIndirectReference.getReader().q;
            PdfObject pdfObject2 = pRIndirectReference.getReader().getPdfObject(n2);
            if (pdfObject2 == null) {
                return null;
            }
            if (bl2) {
                switch (pdfObject2.type()) {
                    case 8: {
                        pdfObject2 = new PdfNull();
                        break;
                    }
                    case 1: {
                        pdfObject2 = new PdfBoolean(((PdfBoolean)pdfObject2).booleanValue());
                        break;
                    }
                    case 4: {
                        pdfObject2 = new PdfName(pdfObject2.getBytes());
                    }
                }
                pdfObject2.setIndRef(pRIndirectReference);
            }
            return pdfObject2;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static PdfObject getPdfObjectRelease(PdfObject pdfObject, PdfObject pdfObject2) {
        pdfObject2 = PdfReader.getPdfObject(pdfObject, pdfObject2);
        PdfReader.releaseLastXrefPartial(pdfObject);
        return pdfObject2;
    }

    public static PdfObject getPdfObject(PdfObject pdfObject, PdfObject pdfObject2) {
        if (pdfObject == null) {
            return null;
        }
        if (!pdfObject.isIndirect()) {
            if (pdfObject2 != null && (pdfObject2 = pdfObject2.getIndRef()) != null && ((PRIndirectReference)pdfObject2).getReader().isAppendable()) {
                switch (pdfObject.type()) {
                    case 8: {
                        pdfObject = new PdfNull();
                        break;
                    }
                    case 1: {
                        pdfObject = new PdfBoolean(((PdfBoolean)pdfObject).booleanValue());
                        break;
                    }
                    case 4: {
                        pdfObject = new PdfName(pdfObject.getBytes());
                    }
                }
                pdfObject.setIndRef((PRIndirectReference)pdfObject2);
            }
            return pdfObject;
        }
        return PdfReader.getPdfObject(pdfObject);
    }

    public PdfObject getPdfObjectRelease(int n2) {
        PdfObject pdfObject = this.getPdfObject(n2);
        this.releaseLastXrefPartial();
        return pdfObject;
    }

    public PdfObject getPdfObject(int n2) {
        try {
            this.l = -1;
            if (n2 < 0 || n2 >= this.e.size()) {
                return null;
            }
            PdfObject pdfObject = this.e.get(n2);
            if (!this.m || pdfObject != null) {
                return pdfObject;
            }
            if (n2 << 1 >= this.xref.length) {
                return null;
            }
            pdfObject = this.readSingleObject(n2);
            this.l = -1;
            if (pdfObject != null) {
                this.l = n2;
            }
            return pdfObject;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void resetLastXrefPartial() {
        this.l = -1;
    }

    public void releaseLastXrefPartial() {
        if (this.m && this.l != -1) {
            this.e.set(this.l, null);
            this.l = -1;
        }
    }

    public static void releaseLastXrefPartial(PdfObject pdfObject) {
        if (pdfObject == null) {
            return;
        }
        if (!pdfObject.isIndirect()) {
            return;
        }
        if (!(pdfObject instanceof PRIndirectReference)) {
            return;
        }
        pdfObject = (PRIndirectReference)pdfObject;
        PdfReader pdfReader = ((PRIndirectReference)pdfObject).getReader();
        if (pdfReader.m && pdfReader.l != -1 && pdfReader.l == ((PdfIndirectReference)pdfObject).getNumber()) {
            pdfReader.e.set(pdfReader.l, null);
        }
        pdfReader.l = -1;
    }

    private void a(int n2, PdfObject pdfObject) {
        if (!this.m || n2 < 0) {
            return;
        }
        this.e.set(n2, pdfObject);
    }

    public PRIndirectReference addPdfObject(PdfObject pdfObject) {
        this.e.add(pdfObject);
        PdfReader pdfReader = this;
        return new PRIndirectReference(pdfReader, pdfReader.e.size() - 1);
    }

    protected void readPages() {
        this.catalog = this.trailer.getAsDict(PdfName.ROOT);
        this.b = this.catalog.getAsDict(PdfName.PAGES);
        this.pageRefs = new a(this, 0);
    }

    protected void readDocObjPartial() {
        this.e = new ArrayList<PdfObject>(this.xref.length / 2);
        this.e.addAll(Collections.nCopies(this.xref.length / 2, null));
        this.c();
        if (this.objStmToOffset != null) {
            int[] nArray = this.objStmToOffset.getKeys();
            int[] nArray2 = nArray;
            nArray2 = nArray;
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray2[i2];
                this.objStmToOffset.put(n3, this.xref[n3 << 1]);
                this.xref[n3 << 1] = -1;
            }
        }
    }

    protected PdfObject readSingleObject(int n2) {
        PdfObject pdfObject;
        this.strings.clear();
        int n3 = n2 << 1;
        int n4 = this.xref[n3];
        if (n4 < 0) {
            return null;
        }
        if (this.xref[n3 + 1] > 0) {
            n4 = this.objStmToOffset.get(this.xref[n3 + 1]);
        }
        if (n4 == 0) {
            return null;
        }
        this.tokens.seek(n4);
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != 1) {
            this.tokens.throwError(MessageLocalization.getComposedMessage("invalid.object.number"));
        }
        this.h = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (this.tokens.getTokenType() != 1) {
            this.tokens.throwError(MessageLocalization.getComposedMessage("invalid.generation.number"));
        }
        this.i = this.tokens.intValue();
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("obj")) {
            this.tokens.throwError(MessageLocalization.getComposedMessage("token.obj.expected"));
        }
        try {
            pdfObject = this.readPRObject();
            for (PdfObject pdfObject2 : this.strings) {
                pdfObject2 = (PdfString)pdfObject2;
                ((PdfString)pdfObject2).a(this);
            }
            if (pdfObject.isStream()) {
                this.a((PRStream)pdfObject);
            }
        }
        catch (Exception exception) {
            pdfObject = null;
        }
        if (this.xref[n3 + 1] > 0) {
            pdfObject = this.readOneObjStm((PRStream)pdfObject, this.xref[n3]);
        }
        this.e.set(n2, pdfObject);
        return pdfObject;
    }

    protected PdfObject readOneObjStm(PRStream object, int n2) {
        int n3 = ((PdfDictionary)object).getAsNumber(PdfName.FIRST).intValue();
        object = PdfReader.getStreamBytes((PRStream)object, this.tokens.getFile());
        PRTokeniser pRTokeniser = this.tokens;
        this.tokens = new PRTokeniser((byte[])object);
        try {
            int n4 = 0;
            boolean bl2 = true;
            ++n2;
            for (int i2 = 0; i2 < n2 && (bl2 = this.tokens.nextToken()); ++i2) {
                if (this.tokens.getTokenType() != 1) {
                    bl2 = false;
                    break;
                }
                bl2 = this.tokens.nextToken();
                if (!bl2) break;
                if (this.tokens.getTokenType() != 1) {
                    bl2 = false;
                    break;
                }
                n4 = this.tokens.intValue() + n3;
            }
            if (!bl2) {
                throw new InvalidPdfException(MessageLocalization.getComposedMessage("error.reading.objstm"));
            }
            this.tokens.seek(n4);
            PdfObject pdfObject = this.readPRObject();
            return pdfObject;
        }
        finally {
            this.tokens = pRTokeniser;
        }
    }

    public double dumpPerc() {
        int n2 = 0;
        for (PdfObject pdfObject : this.e) {
            if (pdfObject == null) continue;
            ++n2;
        }
        return (double)n2 * 100.0 / (double)this.e.size();
    }

    /*
     * WARNING - void declaration
     */
    protected void readDocObj() {
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        this.e = new ArrayList<PdfObject>(this.xref.length / 2);
        this.e.addAll(Collections.nCopies(this.xref.length / 2, null));
        for (int i2 = 2; i2 < this.xref.length; i2 += 2) {
            void object;
            int n2 = this.xref[i2];
            if (n2 <= 0 || this.xref.length > i2 + 1 && this.xref[i2 + 1] > 0) continue;
            this.tokens.seek(n2);
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("invalid.object.number"));
            }
            this.h = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("invalid.generation.number"));
            }
            this.i = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (!this.tokens.getStringValue().equals("obj")) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("token.obj.expected"));
            }
            try {
                PdfObject pdfObject = this.readPRObject();
                if (pdfObject.isStream()) {
                    arrayList.add(pdfObject);
                }
            }
            catch (Exception exception) {
                Object pdfObject = null;
            }
            this.e.set(i2 / 2, (PdfObject)object);
        }
        for (PdfObject pdfObject : arrayList) {
            this.a((PRStream)pdfObject);
        }
        this.c();
        if (this.objStmMark != null) {
            for (Object object : this.objStmMark.entrySet()) {
                Map.Entry entry = (Map.Entry)object;
                int n3 = (Integer)entry.getKey();
                IntHashtable intHashtable = (IntHashtable)entry.getValue();
                PdfReader pdfReader = this;
                pdfReader.readObjStm((PRStream)pdfReader.e.get(n3), intHashtable);
                this.e.set(n3, null);
            }
            this.objStmMark = null;
        }
        this.xref = null;
    }

    private void a(PRStream pRStream) {
        int n2;
        block6: {
            int n3 = this.tokens.length();
            int n4 = pRStream.getOffset();
            int n5 = 0;
            n2 = 0;
            PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.LENGTH));
            if (pdfObject != null && pdfObject.type() == 2 && (n2 = ((PdfNumber)pdfObject).intValue()) + n4 <= n3 - 20) {
                this.tokens.seek(n4 + n2);
                String string = this.tokens.readString(20);
                if (!(string.startsWith("\nendstream") || string.startsWith("\r\nendstream") || string.startsWith("\rendstream") || string.startsWith("endstream"))) {
                    n5 = 1;
                }
            } else {
                n5 = 1;
            }
            if (n5 != 0) {
                Object object = new byte[16];
                this.tokens.seek(n4);
                do {
                    n5 = this.tokens.getFilePointer();
                    if (!this.tokens.readLineSegment((byte[])object)) break block6;
                    if (!PdfReader.a(object, c)) continue;
                    n2 = n5 - n4;
                    break block6;
                } while (!PdfReader.a(object, d));
                this.tokens.seek(n5 - 16);
                String string = this.tokens.readString(16);
                object = string;
                int n6 = string.indexOf("endstream");
                if (n6 >= 0) {
                    n5 = n5 - 16 + n6;
                }
                n2 = n5 - n4;
            }
        }
        pRStream.setLength(n2);
    }

    protected void readObjStm(PRStream object, IntHashtable intHashtable) {
        int n2 = ((PdfDictionary)object).getAsNumber(PdfName.FIRST).intValue();
        int n3 = ((PdfDictionary)object).getAsNumber(PdfName.N).intValue();
        object = PdfReader.getStreamBytes((PRStream)object, this.tokens.getFile());
        PRTokeniser pRTokeniser = this.tokens;
        this.tokens = new PRTokeniser((byte[])object);
        try {
            int n4;
            object = new int[n3];
            int[] nArray = new int[n3];
            boolean bl2 = true;
            for (n4 = 0; n4 < n3 && (bl2 = this.tokens.nextToken()); ++n4) {
                if (this.tokens.getTokenType() != 1) {
                    bl2 = false;
                    break;
                }
                nArray[n4] = this.tokens.intValue();
                bl2 = this.tokens.nextToken();
                if (!bl2) break;
                if (this.tokens.getTokenType() != 1) {
                    bl2 = false;
                    break;
                }
                object[n4] = this.tokens.intValue() + n2;
            }
            if (!bl2) {
                throw new InvalidPdfException(MessageLocalization.getComposedMessage("error.reading.objstm"));
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (!intHashtable.containsKey(n4)) continue;
                this.tokens.seek((int)object[n4]);
                PdfObject pdfObject = this.readPRObject();
                this.e.set(nArray[n4], pdfObject);
            }
            return;
        }
        finally {
            this.tokens = pRTokeniser;
        }
    }

    public static PdfObject killIndirect(PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            return null;
        }
        PdfObject pdfObject2 = PdfReader.getPdfObjectRelease(pdfObject);
        if (pdfObject.isIndirect()) {
            pdfObject = (PRIndirectReference)pdfObject;
            PdfReader pdfReader = ((PRIndirectReference)pdfObject).getReader();
            int n2 = ((PdfIndirectReference)pdfObject).getNumber();
            pdfReader.e.set(n2, null);
            if (pdfReader.m) {
                pdfReader.xref[n2 << 1] = -1;
            }
        }
        return pdfObject2;
    }

    private void a(int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.xref == null) {
            this.xref = new int[n2];
            return;
        }
        if (this.xref.length < n2) {
            int[] nArray = new int[n2];
            System.arraycopy(this.xref, 0, nArray, 0, this.xref.length);
            this.xref = nArray;
        }
    }

    protected void readXref() {
        int n2;
        this.k = false;
        this.newXrefType = false;
        this.tokens.seek(this.tokens.getStartxref());
        this.tokens.nextToken();
        if (!this.tokens.getStringValue().equals("startxref")) {
            throw new InvalidPdfException(MessageLocalization.getComposedMessage("startxref.not.found"));
        }
        this.tokens.nextToken();
        if (this.tokens.getTokenType() != 1) {
            throw new InvalidPdfException(MessageLocalization.getComposedMessage("startxref.is.not.followed.by.a.number"));
        }
        this.lastXref = n2 = this.tokens.intValue();
        this.eofPos = this.tokens.getFilePointer();
        try {
            if (this.readXRefStream(n2)) {
                this.newXrefType = true;
                return;
            }
        }
        catch (Exception exception) {}
        this.xref = null;
        this.tokens.seek(n2);
        this.trailer = this.readXrefSection();
        PdfObject pdfObject = this.trailer;
        while ((pdfObject = (PdfNumber)((PdfDictionary)pdfObject).get(PdfName.PREV)) != null) {
            this.tokens.seek(((PdfNumber)pdfObject).intValue());
            pdfObject = this.readXrefSection();
        }
    }

    protected PdfDictionary readXrefSection() {
        this.tokens.nextValidToken();
        if (!this.tokens.getStringValue().equals("xref")) {
            this.tokens.throwError(MessageLocalization.getComposedMessage("xref.subsection.not.found"));
        }
        block2: while (true) {
            int n2;
            int n3;
            this.tokens.nextValidToken();
            if (this.tokens.getStringValue().equals("trailer")) break;
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("object.number.of.the.first.object.in.this.xref.subsection.not.found"));
            }
            int n4 = this.tokens.intValue();
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() != 1) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("number.of.entries.in.this.xref.subsection.not.found"));
            }
            int n5 = this.tokens.intValue() + n4;
            if (n4 == 1) {
                n3 = this.tokens.getFilePointer();
                this.tokens.nextValidToken();
                n2 = this.tokens.intValue();
                this.tokens.nextValidToken();
                int n6 = this.tokens.intValue();
                if (n2 == 0 && n6 == 65535) {
                    --n4;
                    --n5;
                }
                this.tokens.seek(n3);
            }
            this.a(n5 << 1);
            n3 = n4;
            while (true) {
                if (n3 >= n5) continue block2;
                this.tokens.nextValidToken();
                n2 = this.tokens.intValue();
                this.tokens.nextValidToken();
                this.tokens.nextValidToken();
                n4 = n3 << 1;
                if (this.tokens.getStringValue().equals("n")) {
                    if (this.xref[n4] == 0 && this.xref[n4 + 1] == 0) {
                        this.xref[n4] = n2;
                    }
                } else if (this.tokens.getStringValue().equals("f")) {
                    if (this.xref[n4] == 0 && this.xref[n4 + 1] == 0) {
                        this.xref[n4] = -1;
                    }
                } else {
                    this.tokens.throwError(MessageLocalization.getComposedMessage("invalid.cross.reference.entry.in.this.xref.subsection"));
                }
                ++n3;
            }
            break;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)this.readPRObject();
        PdfObject pdfObject = (PdfNumber)pdfDictionary.get(PdfName.SIZE);
        this.a(((PdfNumber)pdfObject).intValue() << 1);
        pdfObject = pdfDictionary.get(PdfName.XREFSTM);
        if (pdfObject != null && pdfObject.isNumber()) {
            int n7 = ((PdfNumber)pdfObject).intValue();
            try {
                this.readXRefStream(n7);
                this.newXrefType = true;
                this.k = true;
            }
            catch (IOException iOException) {
                this.xref = null;
                throw iOException;
            }
        }
        return pdfDictionary;
    }

    protected boolean readXRefStream(int n2) {
        int n3;
        PdfArray pdfArray;
        this.tokens.seek(n2);
        if (!this.tokens.nextToken()) {
            return false;
        }
        if (this.tokens.getTokenType() != 1) {
            return false;
        }
        n2 = this.tokens.intValue();
        if (!this.tokens.nextToken() || this.tokens.getTokenType() != 1) {
            return false;
        }
        if (!this.tokens.nextToken() || !this.tokens.getStringValue().equals("obj")) {
            return false;
        }
        Object object = this.readPRObject();
        if (((PdfObject)object).isStream()) {
            if (!PdfName.XREF.equals(((PdfDictionary)(object = (PRStream)object)).get(PdfName.TYPE))) {
                return false;
            }
        } else {
            return false;
        }
        if (this.trailer == null) {
            this.trailer = new PdfDictionary();
            this.trailer.putAll((PdfDictionary)object);
        }
        PdfObject pdfObject = object;
        ((PRStream)pdfObject).setLength(((PdfNumber)((PdfDictionary)pdfObject).get(PdfName.LENGTH)).intValue());
        int n4 = ((PdfNumber)((PdfDictionary)object).get(PdfName.SIZE)).intValue();
        Object object2 = ((PdfDictionary)object).get(PdfName.INDEX);
        if (object2 == null) {
            pdfArray = new PdfArray();
            pdfArray.add(new int[]{0, n4});
        } else {
            pdfArray = (PdfArray)object2;
        }
        PdfArray pdfArray2 = (PdfArray)((PdfDictionary)object).get(PdfName.W);
        int n5 = -1;
        object2 = ((PdfDictionary)object).get(PdfName.PREV);
        if (object2 != null) {
            n5 = ((PdfNumber)object2).intValue();
        }
        this.a(n4 << 1);
        if (this.objStmMark == null && !this.m) {
            this.objStmMark = new HashMap<Integer, IntHashtable>();
        }
        if (this.objStmToOffset == null && this.m) {
            this.objStmToOffset = new IntHashtable();
        }
        object = PdfReader.getStreamBytes((PRStream)object, this.tokens.getFile());
        n4 = 0;
        object2 = new int[3];
        for (n3 = 0; n3 < 3; ++n3) {
            object2[n3] = pdfArray2.getAsNumber(n3).intValue();
        }
        for (n3 = 0; n3 < pdfArray.size(); n3 += 2) {
            int n6 = pdfArray.getAsNumber(n3).intValue();
            int n7 = pdfArray.getAsNumber(n3 + 1).intValue();
            this.a(n6 + n7 << 1);
            while (n7-- > 0) {
                int n8;
                int n9;
                int n10;
                int n11 = 1;
                if (object2[0] > 0) {
                    n11 = 0;
                    for (n10 = 0; n10 < object2[0]; ++n10) {
                        n11 = (n11 << 8) + (object[n4++] & 0xFF);
                    }
                }
                n10 = 0;
                for (n9 = 0; n9 < object2[1]; ++n9) {
                    n10 = (n10 << 8) + (object[n4++] & 0xFF);
                }
                n9 = 0;
                for (n8 = 0; n8 < object2[2]; ++n8) {
                    n9 = (n9 << 8) + (object[n4++] & 0xFF);
                }
                n8 = n6 << 1;
                if (this.xref[n8] == 0 && this.xref[n8 + 1] == 0) {
                    switch (n11) {
                        case 0: {
                            this.xref[n8] = -1;
                            break;
                        }
                        case 1: {
                            this.xref[n8] = n10;
                            break;
                        }
                        case 2: {
                            this.xref[n8] = n9;
                            this.xref[n8 + 1] = n10;
                            if (this.m) {
                                this.objStmToOffset.put(n10, 0);
                                break;
                            }
                            Integer n12 = n10;
                            IntHashtable intHashtable = this.objStmMark.get(n12);
                            if (intHashtable == null) {
                                intHashtable = new IntHashtable();
                                intHashtable.put(n9, 1);
                                this.objStmMark.put(n12, intHashtable);
                                break;
                            }
                            intHashtable.put(n9, 1);
                        }
                    }
                }
                ++n6;
            }
        }
        if ((n2 <<= 1) < this.xref.length) {
            this.xref[n2] = -1;
        }
        if (n5 == -1) {
            return true;
        }
        return this.readXRefStream(n5);
    }

    protected void rebuildXref() {
        Object object;
        int n2;
        this.k = false;
        this.newXrefType = false;
        this.tokens.seek(0);
        int[][] nArrayArray = new int[1024][];
        int n3 = 0;
        this.trailer = null;
        byte[] byArray = new byte[64];
        while (true) {
            n2 = this.tokens.getFilePointer();
            if (!this.tokens.readLineSegment(byArray)) break;
            if (byArray[0] == 116) {
                if (!PdfEncodings.convertToString(byArray, null).startsWith("trailer")) continue;
                this.tokens.seek(n2);
                this.tokens.nextToken();
                n2 = this.tokens.getFilePointer();
                try {
                    PdfDictionary pdfDictionary = (PdfDictionary)this.readPRObject();
                    object = pdfDictionary;
                    if (pdfDictionary.get(PdfName.ROOT) != null) {
                        this.trailer = object;
                        continue;
                    }
                    this.tokens.seek(n2);
                }
                catch (Exception exception) {
                    this.tokens.seek(n2);
                }
                continue;
            }
            if (byArray[0] < 48 || byArray[0] > 57 || (object = PRTokeniser.checkObjectStart(byArray)) == null) continue;
            int n4 = object[0];
            int n5 = object[1];
            if (n4 >= nArrayArray.length) {
                int n6 = n4 << 1;
                int[][] nArrayArray2 = new int[n6][];
                System.arraycopy(nArrayArray, 0, nArrayArray2, 0, n3);
                nArrayArray = nArrayArray2;
            }
            if (n4 >= n3) {
                n3 = n4 + 1;
            }
            if (nArrayArray[n4] != null && n5 < nArrayArray[n4][1]) continue;
            object[0] = n2;
            nArrayArray[n4] = object;
        }
        this.xref = new int[n3 << 1];
        for (n2 = 0; n2 < n3; ++n2) {
            object = nArrayArray[n2];
            if (object == null) continue;
            this.xref[n2 << 1] = object[0];
        }
    }

    protected PdfDictionary readDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        while (true) {
            this.tokens.nextValidToken();
            if (this.tokens.getTokenType() == 8) break;
            if (this.tokens.getTokenType() != 3) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("dictionary.key.is.not.a.name"));
            }
            PdfName pdfName = new PdfName(this.tokens.getStringValue(), false);
            PdfObject pdfObject = this.readPRObject();
            int n2 = pdfObject.type();
            if (-n2 == 8) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("unexpected.gt.gt"));
            }
            if (-n2 == 6) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("unexpected.close.bracket"));
            }
            pdfDictionary.put(pdfName, pdfObject);
        }
        return pdfDictionary;
    }

    protected PdfArray readArray() {
        PdfObject pdfObject;
        int n2;
        PdfArray pdfArray = new PdfArray();
        while (-(n2 = (pdfObject = this.readPRObject()).type()) != 6) {
            if (-n2 == 8) {
                this.tokens.throwError(MessageLocalization.getComposedMessage("unexpected.gt.gt"));
            }
            pdfArray.add(pdfObject);
        }
        return pdfArray;
    }

    protected PdfObject readPRObject() {
        this.tokens.nextValidToken();
        int n2 = this.tokens.getTokenType();
        switch (n2) {
            case 7: {
                boolean bl2;
                ++this.r;
                PdfDictionary pdfDictionary = this.readDictionary();
                --this.r;
                int n3 = this.tokens.getFilePointer();
                while ((bl2 = this.tokens.nextToken()) && this.tokens.getTokenType() == 4) {
                }
                if (bl2 && this.tokens.getStringValue().equals("stream")) {
                    while ((n3 = this.tokens.read()) == 32 || n3 == 9 || n3 == 0 || n3 == 12) {
                    }
                    if (n3 != 10) {
                        n3 = this.tokens.read();
                    }
                    if (n3 != 10) {
                        this.tokens.backOnePosition(n3);
                    }
                    PdfReader pdfReader = this;
                    PRStream pRStream = new PRStream(pdfReader, pdfReader.tokens.getFilePointer());
                    pRStream.putAll(pdfDictionary);
                    pRStream.setObjNum(this.h, this.i);
                    return pRStream;
                }
                this.tokens.seek(n3);
                return pdfDictionary;
            }
            case 5: {
                ++this.r;
                PdfArray pdfArray = this.readArray();
                --this.r;
                return pdfArray;
            }
            case 1: {
                return new PdfNumber(this.tokens.getStringValue());
            }
            case 2: {
                PdfString pdfString = new PdfString(this.tokens.getStringValue(), null).setHexWriting(this.tokens.isHexString());
                pdfString.a(this.h, this.i);
                if (this.strings != null) {
                    this.strings.add(pdfString);
                }
                return pdfString;
            }
            case 3: {
                PdfName pdfName = PdfName.staticNames.get(this.tokens.getStringValue());
                if (this.r > 0 && pdfName != null) {
                    return pdfName;
                }
                return new PdfName(this.tokens.getStringValue(), false);
            }
            case 9: {
                int n4 = this.tokens.getReference();
                PRIndirectReference pRIndirectReference = new PRIndirectReference(this, n4, this.tokens.getGeneration());
                return pRIndirectReference;
            }
            case 11: {
                throw new IOException(MessageLocalization.getComposedMessage("unexpected.end.of.file"));
            }
        }
        String string = this.tokens.getStringValue();
        if ("null".equals(string)) {
            if (this.r == 0) {
                return new PdfNull();
            }
            return PdfNull.PDFNULL;
        }
        if ("true".equals(string)) {
            if (this.r == 0) {
                return new PdfBoolean(true);
            }
            return PdfBoolean.PDFTRUE;
        }
        if ("false".equals(string)) {
            if (this.r == 0) {
                return new PdfBoolean(false);
            }
            return PdfBoolean.PDFFALSE;
        }
        return new PdfLiteral(-n2, this.tokens.getStringValue());
    }

    public static byte[] FlateDecode(byte[] byArray) {
        byte[] byArray2 = PdfReader.FlateDecode(byArray, true);
        if (byArray2 == null) {
            return PdfReader.FlateDecode(byArray, false);
        }
        return byArray2;
    }

    public static byte[] decodePredictor(byte[] object, PdfObject object2) {
        if (object2 == null || !((PdfObject)object2).isDictionary()) {
            return object;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(((PdfDictionary)(object2 = (PdfDictionary)object2)).get(PdfName.PREDICTOR));
        if (pdfObject == null || !pdfObject.isNumber()) {
            return object;
        }
        int n2 = ((PdfNumber)pdfObject).intValue();
        if (n2 < 10) {
            return object;
        }
        int n3 = 1;
        PdfObject pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.COLUMNS));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n3 = ((PdfNumber)pdfObject2).intValue();
        }
        int n4 = 1;
        pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.COLORS));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n4 = ((PdfNumber)pdfObject2).intValue();
        }
        int n5 = 8;
        pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)object2).get(PdfName.BITSPERCOMPONENT));
        if (pdfObject2 != null && pdfObject2.isNumber()) {
            n5 = ((PdfNumber)pdfObject2).intValue();
        }
        object2 = new DataInputStream(new ByteArrayInputStream((byte[])object));
        object = new ByteArrayOutputStream(((byte[])object).length);
        int n6 = n4 * n5 / 8;
        n3 = (n4 * n3 * n5 + 7) / 8;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        while (true) {
            int n7;
            try {
                n7 = ((FilterInputStream)object2).read();
                if (n7 < 0) {
                    return ((ByteArrayOutputStream)object).toByteArray();
                }
                ((DataInputStream)object2).readFully(byArray, 0, n3);
            }
            catch (Exception exception) {
                return ((ByteArrayOutputStream)object).toByteArray();
            }
            switch (n7) {
                case 0: {
                    break;
                }
                case 1: {
                    for (n7 = n6; n7 < n3; ++n7) {
                        int n8 = n7;
                        byArray[n8] = (byte)(byArray[n8] + byArray[n7 - n6]);
                    }
                    break;
                }
                case 2: {
                    for (n7 = 0; n7 < n3; ++n7) {
                        int n9 = n7;
                        byArray[n9] = (byte)(byArray[n9] + byArray2[n7]);
                    }
                    break;
                }
                case 3: {
                    for (n7 = 0; n7 < n6; ++n7) {
                        int n10 = n7;
                        byArray[n10] = (byte)(byArray[n10] + byArray2[n7] / 2);
                    }
                    for (n7 = n6; n7 < n3; ++n7) {
                        int n11 = n7;
                        byArray[n11] = (byte)(byArray[n11] + ((byArray[n7 - n6] & 0xFF) + (byArray2[n7] & 0xFF)) / 2);
                    }
                    break;
                }
                case 4: {
                    for (n7 = 0; n7 < n6; ++n7) {
                        int n12 = n7;
                        byArray[n12] = (byte)(byArray[n12] + byArray2[n7]);
                    }
                    n7 = n6;
                    while (n7 < n3) {
                        int n13 = byArray[n7 - n6] & 0xFF;
                        int n14 = byArray2[n7] & 0xFF;
                        int n15 = byArray2[n7 - n6] & 0xFF;
                        int n16 = n13 + n14 - n15;
                        int n17 = Math.abs(n16 - n13);
                        int n18 = Math.abs(n16 - n14);
                        n16 = Math.abs(n16 - n15);
                        if (n17 > n18 || n17 > n16) {
                            n13 = n18 <= n16 ? n14 : n15;
                        }
                        int n19 = n7++;
                        byArray[n19] = (byte)(byArray[n19] + (byte)n13);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException(MessageLocalization.getComposedMessage("png.filter.unknown"));
                }
            }
            try {
                ((OutputStream)object).write(byArray);
            }
            catch (IOException iOException) {}
            byte[] byArray3 = byArray2;
            byArray2 = byArray;
            byArray = byArray3;
        }
    }

    public static byte[] FlateDecode(byte[] object, boolean bl2) {
        object = new ByteArrayInputStream((byte[])object);
        object = new InflaterInputStream((InputStream)object);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[bl2 ? 4092 : 1];
        try {
            int n2;
            while ((n2 = ((FilterInputStream)object).read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            ((InflaterInputStream)object).close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            if (bl2) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public static byte[] ASCIIHexDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl2 = true;
        int n2 = 0;
        for (int n3 : byArray) {
            if ((n3 &= 0xFF) == 62) break;
            if (PRTokeniser.isWhitespace(n3)) continue;
            if ((n3 = PRTokeniser.getHex(n3)) == -1) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("illegal.character.in.asciihexdecode"));
            }
            if (bl2) {
                n2 = n3;
            } else {
                byteArrayOutputStream.write((byte)((n2 << 4) + n3));
            }
            bl2 = !bl2;
        }
        if (!bl2) {
            byteArrayOutputStream.write((byte)(n2 << 4));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ASCII85Decode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        int[] nArray = new int[5];
        for (int n3 : byArray) {
            if ((n3 &= 0xFF) == 126) break;
            if (PRTokeniser.isWhitespace(n3)) continue;
            if (n3 == 122 && n2 == 0) {
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.write(0);
                continue;
            }
            if (n3 < 33 || n3 > 117) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("illegal.character.in.ascii85decode"));
            }
            nArray[n2] = n3 - 33;
            if (++n2 != 5) continue;
            n2 = 0;
            n3 = 0;
            for (int i2 = 0; i2 < 5; ++i2) {
                n3 = n3 * 85 + nArray[i2];
            }
            byteArrayOutputStream.write((byte)(n3 >> 24));
            byteArrayOutputStream.write((byte)(n3 >> 16));
            byteArrayOutputStream.write((byte)(n3 >> 8));
            byteArrayOutputStream.write((byte)n3);
        }
        if (n2 == 2) {
            int n4 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + 614125 + 7225 + 85;
            byteArrayOutputStream.write((byte)(n4 >> 24));
        } else if (n2 == 3) {
            int n5 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85 + 7225 + 85;
            byteArrayOutputStream.write((byte)(n5 >> 24));
            byteArrayOutputStream.write((byte)(n5 >> 16));
        } else if (n2 == 4) {
            int n6 = nArray[0] * 85 * 85 * 85 * 85 + nArray[1] * 85 * 85 * 85 + nArray[2] * 85 * 85 + nArray[3] * 85 + 85;
            byteArrayOutputStream.write((byte)(n6 >> 24));
            byteArrayOutputStream.write((byte)(n6 >> 16));
            byteArrayOutputStream.write((byte)(n6 >> 8));
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] LZWDecode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LZWDecoder lZWDecoder = new LZWDecoder();
        lZWDecoder.decode(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isRebuilt() {
        return this.rebuilt;
    }

    public PdfDictionary getPageN(int n2) {
        PdfDictionary pdfDictionary = this.pageRefs.a(n2);
        if (pdfDictionary == null) {
            return null;
        }
        if (this.q) {
            pdfDictionary.setIndRef(this.pageRefs.c(n2));
        }
        return pdfDictionary;
    }

    public PdfDictionary getPageNRelease(int n2) {
        PdfDictionary pdfDictionary = this.getPageN(n2);
        this.pageRefs.d(n2);
        return pdfDictionary;
    }

    public void releasePage(int n2) {
        this.pageRefs.d(n2);
    }

    public void resetReleasePage() {
        this.pageRefs.c();
    }

    public PRIndirectReference getPageOrigRef(int n2) {
        return this.pageRefs.c(n2);
    }

    public byte[] getPageContent(int n2, RandomAccessFileOrArray randomAccessFileOrArray) {
        Object object = this.getPageNRelease(n2);
        if (object == null) {
            return null;
        }
        if ((object = PdfReader.getPdfObjectRelease(((PdfDictionary)object).get(PdfName.CONTENTS))) == null) {
            return new byte[0];
        }
        if (((PdfObject)object).isStream()) {
            return PdfReader.getStreamBytes((PRStream)object, randomAccessFileOrArray);
        }
        if (((PdfObject)object).isArray()) {
            PdfArray pdfArray = (PdfArray)object;
            object = new ByteArrayOutputStream();
            for (int i2 = 0; i2 < pdfArray.size(); ++i2) {
                Object object2 = PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(i2));
                if (object2 == null || !((PdfObject)object2).isStream()) continue;
                object2 = PdfReader.getStreamBytes((PRStream)object2, randomAccessFileOrArray);
                ((OutputStream)object).write((byte[])object2);
                if (i2 == pdfArray.size() - 1) continue;
                ((ByteArrayOutputStream)object).write(10);
            }
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        return new byte[0];
    }

    public byte[] getPageContent(int n2) {
        byte[] byArray;
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byArray = this.getPageContent(n2, randomAccessFileOrArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    protected void killXref(PdfObject object) {
        if (object == null) {
            return;
        }
        if (object instanceof PdfIndirectReference && !((PdfObject)object).isIndirect()) {
            return;
        }
        switch (((PdfObject)object).type()) {
            case 10: {
                int n2 = ((PRIndirectReference)object).getNumber();
                object = this.e.get(n2);
                this.e.set(n2, null);
                this.freeXref = n2;
                this.killXref((PdfObject)object);
                return;
            }
            case 5: {
                PdfArray pdfArray = (PdfArray)object;
                for (int i2 = 0; i2 < pdfArray.size(); ++i2) {
                    this.killXref(pdfArray.getPdfObject(i2));
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary pdfDictionary = (PdfDictionary)object;
                for (Object e2 : pdfDictionary.getKeys()) {
                    this.killXref(pdfDictionary.get((PdfName)e2));
                }
                break;
            }
        }
    }

    public void setPageContent(int n2, byte[] byArray) {
        this.setPageContent(n2, byArray, -1);
    }

    public void setPageContent(int n2, byte[] byArray, int n3) {
        PdfDictionary pdfDictionary = this.getPageN(n2);
        if (pdfDictionary == null) {
            return;
        }
        PdfObject pdfObject = pdfDictionary.get(PdfName.CONTENTS);
        this.freeXref = -1;
        this.killXref(pdfObject);
        if (this.freeXref == -1) {
            this.e.add(null);
            this.freeXref = this.e.size() - 1;
        }
        PdfReader pdfReader = this;
        pdfDictionary.put(PdfName.CONTENTS, new PRIndirectReference(pdfReader, pdfReader.freeXref));
        this.e.set(this.freeXref, new PRStream(this, byArray, n3));
    }

    public static byte[] getStreamBytes(PRStream object, RandomAccessFileOrArray object2) {
        List<PdfObject> list = PdfReader.getPdfObjectRelease(((PdfDictionary)object).get(PdfName.FILTER));
        object2 = PdfReader.getStreamBytesRaw((PRStream)object, (RandomAccessFileOrArray)object2);
        List<PdfObject> list2 = new ArrayList<PdfObject>();
        list2 = PdfReader.a(list2, (PdfObject)((Object)list));
        list = new ArrayList();
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(((PdfDictionary)object).get(PdfName.DECODEPARMS));
        if (pdfObject == null || !pdfObject.isDictionary() && !pdfObject.isArray()) {
            pdfObject = PdfReader.getPdfObjectRelease(((PdfDictionary)object).get(PdfName.DP));
        }
        if (pdfObject != null) {
            if (pdfObject.isDictionary()) {
                list.add(pdfObject);
            } else if (pdfObject.isArray()) {
                list = ((PdfArray)pdfObject).getElements();
            }
        }
        block17: for (int i2 = 0; i2 < list2.size(); ++i2) {
            object = PdfReader.getPdfObjectRelease(list2.get(i2)).toString();
            switch (object) {
                case "/FlateDecode": 
                case "/Fl": {
                    object2 = PdfReader.FlateDecode((byte[])object2);
                    if (i2 >= list.size()) continue block17;
                    object = list.get(i2);
                    object2 = PdfReader.decodePredictor((byte[])object2, (PdfObject)object);
                    continue block17;
                }
                case "/ASCIIHexDecode": 
                case "/AHx": {
                    object2 = PdfReader.ASCIIHexDecode((byte[])object2);
                    continue block17;
                }
                case "/ASCII85Decode": 
                case "/A85": {
                    object2 = PdfReader.ASCII85Decode((byte[])object2);
                    continue block17;
                }
                case "/LZWDecode": {
                    object2 = PdfReader.LZWDecode((byte[])object2);
                    if (i2 >= list.size()) continue block17;
                    object = list.get(i2);
                    object2 = PdfReader.decodePredictor((byte[])object2, (PdfObject)object);
                    continue block17;
                }
                case "/Crypt": {
                    continue block17;
                }
                default: {
                    throw new UnsupportedPdfException(MessageLocalization.getComposedMessage("the.filter.1.is.not.supported", object));
                }
            }
        }
        return object2;
    }

    public static byte[] getStreamBytes(PRStream object) {
        RandomAccessFileOrArray randomAccessFileOrArray = ((PRStream)object).getReader().getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            object = PdfReader.getStreamBytes((PRStream)object, randomAccessFileOrArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return object;
    }

    public static byte[] getStreamBytesRaw(PRStream pRStream, RandomAccessFileOrArray object) {
        byte[] byArray;
        Object object2 = pRStream.getReader();
        if (pRStream.getOffset() < 0) {
            byArray = ((PdfObject)pRStream).getBytes();
        } else {
            byArray = new byte[pRStream.getLength()];
            ((RandomAccessFileOrArray)object).seek(pRStream.getOffset());
            ((RandomAccessFileOrArray)object).readFully(byArray);
            object = object2;
            object = ((PdfReader)object).decrypt;
            if (object != null) {
                object2 = PdfReader.getPdfObjectRelease(pRStream.get(PdfName.FILTER));
                Object object3 = new ArrayList<PdfObject>();
                object3 = PdfReader.a(object3, (PdfObject)object2);
                boolean bl2 = false;
                object3 = object3.iterator();
                while (object3.hasNext()) {
                    PdfObject pdfObject = (PdfObject)object3.next();
                    if ((pdfObject = PdfReader.getPdfObjectRelease(pdfObject)) == null || !pdfObject.toString().equals("/Crypt")) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    ((PdfEncryption)object).setHashKey(pRStream.a(), pRStream.b());
                    byArray = ((PdfEncryption)object).decryptByteArray(byArray);
                }
            }
        }
        return byArray;
    }

    private static List<PdfObject> a(List<PdfObject> list, PdfObject pdfObject) {
        if (pdfObject != null) {
            if (pdfObject.isName()) {
                list.add(pdfObject);
            } else if (pdfObject.isArray()) {
                list = ((PdfArray)pdfObject).getElements();
            }
        }
        return list;
    }

    public static byte[] getStreamBytesRaw(PRStream object) {
        RandomAccessFileOrArray randomAccessFileOrArray = ((PRStream)object).getReader().getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            object = PdfReader.getStreamBytesRaw((PRStream)object, randomAccessFileOrArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return object;
    }

    public void eliminateSharedStreams() {
        PdfObject pdfObject;
        int n2;
        if (!this.sharedStreams) {
            return;
        }
        this.sharedStreams = false;
        if (this.pageRefs.a() == 1) {
            return;
        }
        ArrayList<PdfObject> arrayList = new ArrayList<PdfObject>();
        ArrayList<PRStream> arrayList2 = new ArrayList<PRStream>();
        IntHashtable intHashtable = new IntHashtable();
        for (n2 = 1; n2 <= this.pageRefs.a(); ++n2) {
            PdfObject pdfObject2;
            pdfObject = this.pageRefs.a(n2);
            if (pdfObject == null || (pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.CONTENTS))) == null) continue;
            if (pdfObject2.isStream()) {
                if (intHashtable.containsKey(((PdfIndirectReference)(pdfObject = (PRIndirectReference)((PdfDictionary)pdfObject).get(PdfName.CONTENTS))).getNumber())) {
                    arrayList.add(pdfObject);
                    arrayList2.add(new PRStream((PRStream)pdfObject2, null));
                    continue;
                }
                intHashtable.put(((PdfIndirectReference)pdfObject).getNumber(), 1);
                continue;
            }
            if (!pdfObject2.isArray()) continue;
            pdfObject = (PdfArray)pdfObject2;
            for (int i2 = 0; i2 < ((PdfArray)pdfObject).size(); ++i2) {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)((PdfArray)pdfObject).getPdfObject(i2);
                if (intHashtable.containsKey(pRIndirectReference.getNumber())) {
                    arrayList.add(pRIndirectReference);
                    arrayList2.add(new PRStream((PRStream)PdfReader.getPdfObject(pRIndirectReference), null));
                    continue;
                }
                intHashtable.put(pRIndirectReference.getNumber(), 1);
            }
        }
        if (arrayList2.isEmpty()) {
            return;
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            this.e.add((PdfObject)arrayList2.get(n2));
            pdfObject = (PRIndirectReference)arrayList.get(n2);
            ((PRIndirectReference)pdfObject).setNumber(this.e.size() - 1, 0);
        }
    }

    public boolean isTampered() {
        return this.tampered;
    }

    public void setTampered(boolean bl2) {
        this.tampered = bl2;
        this.pageRefs.b();
    }

    public byte[] getMetadata() {
        Object object = PdfReader.getPdfObject(this.catalog.get(PdfName.METADATA));
        if (!(object instanceof PRStream)) {
            return null;
        }
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            object = PdfReader.getStreamBytes((PRStream)object, randomAccessFileOrArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return object;
    }

    public int getLastXref() {
        return this.lastXref;
    }

    public int getXrefSize() {
        return this.e.size();
    }

    public int getEofPos() {
        return this.eofPos;
    }

    public char getPdfVersion() {
        return this.pdfVersion;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public int getPermissions() {
        return this.pValue;
    }

    public boolean is128Key() {
        return this.rValue == 3;
    }

    public PdfDictionary getTrailer() {
        return this.trailer;
    }

    final PdfEncryption a() {
        return this.decrypt;
    }

    private static boolean a(byte[] byArray, byte[] byArray2) {
        int n2 = byArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private static boolean a(PdfDictionary pdfObject, PdfName pdfName, PdfName pdfName2) {
        if ((pdfObject = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(pdfName))) == null || !pdfObject.isName()) {
            return false;
        }
        pdfObject = (PdfName)pdfObject;
        return ((PdfName)pdfObject).equals(pdfName2);
    }

    static String b(PdfDictionary pdfDictionary) {
        return PdfReader.a(pdfDictionary, PdfName.FONTNAME);
    }

    private static String a(PdfDictionary pdfObject, PdfName pdfName) {
        if (pdfObject == null) {
            return null;
        }
        if ((pdfObject = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(pdfName))) == null || !pdfObject.isName()) {
            return null;
        }
        return PdfName.decodeName(pdfObject.toString());
    }

    static boolean a(String string) {
        return string != null && string.length() >= 8 && string.charAt(6) == '+';
    }

    private static String c(PdfDictionary object) {
        if (object == null) {
            return null;
        }
        if ((object = PdfReader.a((PdfDictionary)object, PdfName.BASEFONT)) == null) {
            return null;
        }
        if (((String)object).length() < 8 || ((String)object).charAt(6) != '+') {
            return null;
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            char c2 = ((String)object).charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z') continue;
            return null;
        }
        return object;
    }

    public int shuffleSubsetNames() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.e.size(); ++i2) {
            Object object;
            Object object2;
            Object object3;
            PdfObject pdfObject = this.getPdfObjectRelease(i2);
            if (pdfObject == null || !pdfObject.isDictionary() || !PdfReader.a((PdfDictionary)(pdfObject = (PdfDictionary)pdfObject), PdfName.TYPE, PdfName.FONT)) continue;
            if (PdfReader.a((PdfDictionary)pdfObject, PdfName.SUBTYPE, PdfName.TYPE1) || PdfReader.a((PdfDictionary)pdfObject, PdfName.SUBTYPE, PdfName.MMTYPE1) || PdfReader.a((PdfDictionary)pdfObject, PdfName.SUBTYPE, PdfName.TRUETYPE)) {
                object3 = PdfReader.c((PdfDictionary)pdfObject);
                if (object3 == null) continue;
                object2 = BaseFont.createSubsetPrefix() + ((String)object3).substring(7);
                object2 = new PdfName((String)object2);
                ((PdfDictionary)pdfObject).put(PdfName.BASEFONT, (PdfObject)object2);
                this.a(i2, pdfObject);
                ++n2;
                object = ((PdfDictionary)pdfObject).getAsDict(PdfName.FONTDESCRIPTOR);
                if (object == null) continue;
                ((PdfDictionary)object).put(PdfName.FONTNAME, (PdfObject)object2);
                continue;
            }
            if (!PdfReader.a((PdfDictionary)pdfObject, PdfName.SUBTYPE, PdfName.TYPE0)) continue;
            object3 = PdfReader.c((PdfDictionary)pdfObject);
            object2 = ((PdfDictionary)pdfObject).getAsArray(PdfName.DESCENDANTFONTS);
            if (object2 == null || ((PdfArray)object2).isEmpty() || (object = PdfReader.c((PdfDictionary)(object2 = ((PdfArray)object2).getAsDict(0)))) == null) continue;
            String string = BaseFont.createSubsetPrefix();
            if (object3 != null) {
                ((PdfDictionary)pdfObject).put(PdfName.BASEFONT, new PdfName(string + ((String)object3).substring(7)));
            }
            this.a(i2, pdfObject);
            pdfObject = new PdfName(string + ((String)object).substring(7));
            ((PdfDictionary)object2).put(PdfName.BASEFONT, pdfObject);
            ++n2;
            object3 = ((PdfDictionary)object2).getAsDict(PdfName.FONTDESCRIPTOR);
            if (object3 == null) continue;
            ((PdfDictionary)object3).put(PdfName.FONTNAME, pdfObject);
        }
        return n2;
    }

    public int createFakeFontSubsets() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.e.size(); ++i2) {
            Object object;
            PdfObject pdfObject = this.getPdfObjectRelease(i2);
            if (pdfObject == null || !pdfObject.isDictionary() || !PdfReader.a((PdfDictionary)(pdfObject = (PdfDictionary)pdfObject), PdfName.TYPE, PdfName.FONT) || !PdfReader.a((PdfDictionary)pdfObject, PdfName.SUBTYPE, PdfName.TYPE1) && !PdfReader.a((PdfDictionary)pdfObject, PdfName.SUBTYPE, PdfName.MMTYPE1) && !PdfReader.a((PdfDictionary)pdfObject, PdfName.SUBTYPE, PdfName.TRUETYPE) || (object = PdfReader.c((PdfDictionary)pdfObject)) != null) continue;
            object = pdfObject;
            if ((object = PdfReader.a((PdfDictionary)object, PdfName.BASEFONT)) == null) continue;
            object = BaseFont.createSubsetPrefix() + (String)object;
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.FONTDESCRIPTOR));
            if (pdfDictionary == null || pdfDictionary.get(PdfName.FONTFILE) == null && pdfDictionary.get(PdfName.FONTFILE2) == null && pdfDictionary.get(PdfName.FONTFILE3) == null) continue;
            pdfDictionary = ((PdfDictionary)pdfObject).getAsDict(PdfName.FONTDESCRIPTOR);
            object = new PdfName((String)object);
            ((PdfDictionary)pdfObject).put(PdfName.BASEFONT, (PdfObject)object);
            pdfDictionary.put(PdfName.FONTNAME, (PdfObject)object);
            this.a(i2, pdfObject);
            ++n2;
        }
        return n2;
    }

    private static PdfArray a(PdfObject pdfObject) {
        if (pdfObject == null) {
            return null;
        }
        if ((pdfObject = PdfReader.getPdfObjectRelease(pdfObject)) == null) {
            return null;
        }
        if (pdfObject.isArray()) {
            return (PdfArray)pdfObject;
        }
        if (pdfObject.isDictionary() && (pdfObject = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.D))) != null && pdfObject.isArray()) {
            return (PdfArray)pdfObject;
        }
        return null;
    }

    public HashMap<Object, PdfObject> getNamedDestination() {
        return this.getNamedDestination(false);
    }

    public HashMap<Object, PdfObject> getNamedDestination(boolean bl2) {
        HashMap<Object, PdfObject> hashMap = this.getNamedDestinationFromNames(bl2);
        hashMap.putAll(this.getNamedDestinationFromStrings());
        return hashMap;
    }

    public HashMap getNamedDestinationFromNames() {
        return this.getNamedDestinationFromNames(false);
    }

    public HashMap<Object, PdfObject> getNamedDestinationFromNames(boolean bl2) {
        HashMap<Object, PdfObject> hashMap = new HashMap<Object, PdfObject>();
        if (this.catalog.get(PdfName.DESTS) != null) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.DESTS));
            if (pdfDictionary == null) {
                return hashMap;
            }
            Object object = pdfDictionary.getKeys();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                PdfArray pdfArray = PdfReader.a(pdfDictionary.get((PdfName)(object2 = (PdfName)object2)));
                if (pdfArray == null) continue;
                if (bl2) {
                    hashMap.put(object2, pdfArray);
                    continue;
                }
                object2 = PdfName.decodeName(((PdfObject)object2).toString());
                hashMap.put(object2, pdfArray);
            }
        }
        return hashMap;
    }

    public HashMap getNamedDestinationFromStrings() {
        Object object;
        if (this.catalog.get(PdfName.NAMES) != null && (object = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.NAMES))) != null && (object = (PdfDictionary)PdfReader.getPdfObjectRelease(((PdfDictionary)object).get(PdfName.DESTS))) != null) {
            object = PdfNameTree.readTree((PdfDictionary)object);
            Iterator<Map.Entry<String, PdfObject>> iterator = ((HashMap)object).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PdfObject> entry = iterator.next();
                PdfArray pdfArray = PdfReader.a(entry.getValue());
                if (pdfArray != null) {
                    entry.setValue(pdfArray);
                    continue;
                }
                iterator.remove();
            }
            return object;
        }
        return new HashMap();
    }

    public void removeFields() {
        this.pageRefs.c();
        for (int i2 = 1; i2 <= this.pageRefs.a(); ++i2) {
            PdfDictionary pdfDictionary = this.pageRefs.a(i2);
            PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.ANNOTS);
            if (pdfArray != null) {
                for (int i3 = 0; i3 < pdfArray.size(); ++i3) {
                    PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(i3));
                    if (pdfObject == null || !pdfObject.isDictionary() || !PdfName.WIDGET.equals(((PdfDictionary)(pdfObject = (PdfDictionary)pdfObject)).get(PdfName.SUBTYPE))) continue;
                    pdfArray.remove(i3--);
                }
                if (pdfArray.isEmpty()) {
                    pdfDictionary.remove(PdfName.ANNOTS);
                    continue;
                }
            }
            this.pageRefs.d(i2);
        }
        this.catalog.remove(PdfName.ACROFORM);
        this.pageRefs.c();
    }

    public void removeAnnotations() {
        this.pageRefs.c();
        for (int i2 = 1; i2 <= this.pageRefs.a(); ++i2) {
            PdfDictionary pdfDictionary = this.pageRefs.a(i2);
            if (pdfDictionary.get(PdfName.ANNOTS) == null) {
                this.pageRefs.d(i2);
                continue;
            }
            pdfDictionary.remove(PdfName.ANNOTS);
        }
        this.catalog.remove(PdfName.ACROFORM);
        this.pageRefs.c();
    }

    public ArrayList<PdfAnnotation.PdfImportedLink> getLinks(int n2) {
        this.pageRefs.c();
        ArrayList<PdfAnnotation.PdfImportedLink> arrayList = new ArrayList<PdfAnnotation.PdfImportedLink>();
        PdfObject pdfObject = this.pageRefs.a(n2);
        if (((PdfDictionary)pdfObject).get(PdfName.ANNOTS) != null) {
            pdfObject = ((PdfDictionary)pdfObject).getAsArray(PdfName.ANNOTS);
            for (int i2 = 0; i2 < ((PdfArray)pdfObject).size(); ++i2) {
                PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(((PdfArray)pdfObject).getPdfObject(i2));
                if (!PdfName.LINK.equals(pdfDictionary.get(PdfName.SUBTYPE))) continue;
                arrayList.add(new PdfAnnotation.PdfImportedLink(pdfDictionary));
            }
        }
        this.pageRefs.d(n2);
        this.pageRefs.c();
        return arrayList;
    }

    private void a(PdfObject pdfObject, Map<Object, PdfObject> map) {
        while (pdfObject != null) {
            this.b(pdfObject, map);
            pdfObject = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfObject);
            PdfObject pdfObject2 = ((PdfDictionary)pdfObject).get(PdfName.FIRST);
            if (pdfObject2 != null) {
                this.a(pdfObject2, map);
            }
            pdfObject = ((PdfDictionary)pdfObject).get(PdfName.NEXT);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void makeRemoteNamedDestinationsLocal() {
        if (this.remoteToLocalNamedDestinations) {
            return;
        }
        this.remoteToLocalNamedDestinations = true;
        var1_1 = this.getNamedDestination(true);
        if (var1_1.isEmpty()) {
            return;
        }
        for (var2_2 = 1; var2_2 <= this.pageRefs.a(); ++var2_2) {
            block10: {
                var3_3 = this.pageRefs.a(var2_2);
                var3_3 = var3_3.get(PdfName.ANNOTS);
                var4_4 = (PdfArray)PdfReader.getPdfObject(var3_3);
                var5_5 = this.l;
                this.releaseLastXrefPartial();
                if (var4_4 == null) break block10;
                var6_6 = false;
                for (var7_7 = 0; var7_7 < var4_4.size(); ++var7_7) {
                    var8_8 = var4_4.getPdfObject(var7_7);
                    var11_11 = var1_1;
                    var10_10 = var8_8;
                    var9_9 = this;
                    var10_10 = PdfReader.getPdfObject(var10_10);
                    var12_12 = var9_9.l;
                    var9_9.releaseLastXrefPartial();
                    if (var10_10 == null || !var10_10.isDictionary() || (var13_13 = PdfReader.getPdfObject(((PdfDictionary)var10_10).get(PdfName.A))) == null) ** GOTO lbl-1000
                    var14_14 = var9_9.l;
                    var9_9.releaseLastXrefPartial();
                    var15_15 = (PdfDictionary)var13_13;
                    var16_16 = (PdfName)PdfReader.getPdfObjectRelease(var15_15.get(PdfName.S));
                    if (!PdfName.GOTOR.equals(var16_16)) ** GOTO lbl-1000
                    var16_16 = PdfReader.getPdfObjectRelease(var15_15.get(PdfName.D));
                    var17_17 = null;
                    if (var16_16 == null) ** GOTO lbl-1000
                    if (var16_16.isName()) {
                        var17_17 = var16_16;
                    } else if (var16_16.isString()) {
                        var17_17 = var16_16.toString();
                    }
                    var11_11 = (PdfArray)var11_11.get(var17_17);
                    if (var11_11 != null) {
                        var15_15.remove(PdfName.F);
                        var15_15.remove(PdfName.NEWWINDOW);
                        var15_15.put(PdfName.S, PdfName.GOTO);
                        var9_9.a(var14_14, var13_13);
                        var9_9.a(var12_12, var10_10);
                        v0 = true;
                    } else lbl-1000:
                    // 4 sources

                    {
                        v0 = false;
                    }
                    if (!v0 || var8_8.isIndirect()) continue;
                    var6_6 = true;
                }
                if (var6_6) {
                    this.a(var5_5, var4_4);
                }
                if (var6_6 && !var3_3.isIndirect()) continue;
            }
            this.pageRefs.d(var2_2);
        }
    }

    public void consolidateNamedDestinations() {
        if (this.consolidateNamedDestinations) {
            return;
        }
        this.consolidateNamedDestinations = true;
        HashMap<Object, PdfObject> hashMap = this.getNamedDestination(true);
        if (hashMap.isEmpty()) {
            return;
        }
        for (int i2 = 1; i2 <= this.pageRefs.a(); ++i2) {
            PdfObject pdfObject = this.pageRefs.a(i2);
            pdfObject = ((PdfDictionary)pdfObject).get(PdfName.ANNOTS);
            PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfObject);
            int n2 = this.l;
            this.releaseLastXrefPartial();
            if (pdfArray != null) {
                boolean bl2 = false;
                for (int i3 = 0; i3 < pdfArray.size(); ++i3) {
                    PdfObject pdfObject2 = pdfArray.getPdfObject(i3);
                    if (!this.b(pdfObject2, hashMap) || pdfObject2.isIndirect()) continue;
                    bl2 = true;
                }
                if (bl2) {
                    this.a(n2, pdfArray);
                }
                if (bl2 && !pdfObject.isIndirect()) continue;
            }
            this.pageRefs.d(i2);
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.OUTLINES));
        if (pdfDictionary == null) {
            return;
        }
        this.a(pdfDictionary.get(PdfName.FIRST), hashMap);
    }

    private boolean b(PdfObject pdfObject, Map<Object, PdfObject> object) {
        pdfObject = PdfReader.getPdfObject(pdfObject);
        int n2 = this.l;
        this.releaseLastXrefPartial();
        if (pdfObject != null && pdfObject.isDictionary()) {
            PdfObject pdfObject2 = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.DEST));
            Object object2 = null;
            if (pdfObject2 != null) {
                if (pdfObject2.isName()) {
                    object2 = pdfObject2;
                } else if (pdfObject2.isString()) {
                    object2 = pdfObject2.toString();
                }
                PdfArray pdfArray = (PdfArray)object.get(object2);
                if (pdfArray != null) {
                    ((PdfDictionary)pdfObject).put(PdfName.DEST, pdfArray);
                    this.a(n2, pdfObject);
                    return true;
                }
            } else {
                pdfObject2 = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(PdfName.A));
                if (pdfObject2 != null) {
                    int n3 = this.l;
                    this.releaseLastXrefPartial();
                    PdfDictionary pdfDictionary = (PdfDictionary)pdfObject2;
                    PdfObject pdfObject3 = (PdfName)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.S));
                    if (PdfName.GOTO.equals(pdfObject3)) {
                        pdfObject3 = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.D));
                        if (pdfObject3 != null) {
                            if (pdfObject3.isName()) {
                                object2 = pdfObject3;
                            } else if (pdfObject3.isString()) {
                                object2 = pdfObject3.toString();
                            }
                        }
                        if ((object = (PdfArray)object.get(object2)) != null) {
                            pdfDictionary.put(PdfName.D, (PdfObject)object);
                            this.a(n3, pdfObject2);
                            this.a(n2, pdfObject);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    protected static PdfDictionary duplicatePdfDictionary(PdfDictionary pdfDictionary, PdfDictionary pdfDictionary2, PdfReader pdfReader) {
        if (pdfDictionary2 == null) {
            pdfDictionary2 = new PdfDictionary();
        }
        for (PdfName pdfName : pdfDictionary.getKeys()) {
            pdfDictionary2.put(pdfName, PdfReader.duplicatePdfObject(pdfDictionary.get(pdfName), pdfReader));
        }
        return pdfDictionary2;
    }

    protected static PdfObject duplicatePdfObject(PdfObject pdfObject2, PdfReader pdfReader) {
        if (pdfObject2 == null) {
            return null;
        }
        switch (pdfObject2.type()) {
            case 6: {
                return PdfReader.duplicatePdfDictionary((PdfDictionary)pdfObject2, null, pdfReader);
            }
            case 7: {
                PRStream pRStream = (PRStream)pdfObject2;
                pdfObject2 = new PRStream(pRStream, null, pdfReader);
                PdfReader.duplicatePdfDictionary(pRStream, (PdfDictionary)pdfObject2, pdfReader);
                return pdfObject2;
            }
            case 5: {
                PdfArray pdfArray = new PdfArray();
                ((PdfArray)pdfObject2).getElements().forEach(pdfObject -> pdfArray.add(PdfReader.duplicatePdfObject(pdfObject, pdfReader)));
                return pdfArray;
            }
            case 10: {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfObject2;
                return new PRIndirectReference(pdfReader, pRIndirectReference.getNumber(), pRIndirectReference.getGeneration());
            }
        }
        return pdfObject2;
    }

    @Override
    public void close() {
        if (!this.m) {
            return;
        }
        try {
            this.tokens.close();
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    protected void removeUnusedNode(PdfObject pdfObject, boolean[] blArray) {
        Stack<Object> stack = new Stack<Object>();
        stack.push(pdfObject);
        block5: while (!stack.empty()) {
            int n2;
            Object[] objectArray;
            PdfName[] pdfNameArray;
            PdfDictionary pdfDictionary;
            ArrayList arrayList;
            block18: {
                int n3;
                block17: {
                    pdfObject = stack.pop();
                    if (pdfObject == null) continue;
                    arrayList = null;
                    pdfDictionary = null;
                    pdfNameArray = null;
                    objectArray = null;
                    n3 = 0;
                    if (!(pdfObject instanceof PdfObject)) break block17;
                    switch (pdfObject.type()) {
                        case 6: 
                        case 7: {
                            pdfDictionary = (PdfDictionary)pdfObject;
                            pdfNameArray = new PdfName[pdfDictionary.size()];
                            pdfDictionary.getKeys().toArray(pdfNameArray);
                            break block18;
                        }
                        case 5: {
                            arrayList = ((PdfArray)pdfObject).getElements();
                            break block18;
                        }
                        case 10: {
                            n3 = ((PdfIndirectReference)(pdfObject = (PRIndirectReference)pdfObject)).getNumber();
                            if (blArray[n3]) continue block5;
                            blArray[n3] = true;
                            stack.push(PdfReader.getPdfObjectRelease(pdfObject));
                            break;
                        }
                    }
                    continue;
                }
                objectArray = (Object[])pdfObject;
                if (objectArray[0] instanceof ArrayList) {
                    arrayList = (ArrayList)objectArray[0];
                    n3 = (Integer)objectArray[1];
                } else {
                    pdfNameArray = (PdfName[])objectArray[0];
                    pdfDictionary = (PdfDictionary)objectArray[1];
                    n3 = (Integer)objectArray[2];
                }
            }
            if (arrayList != null) {
                for (n2 = n3; n2 < arrayList.size(); ++n2) {
                    int n4;
                    PdfObject pdfObject2 = (PdfObject)arrayList.get(n2);
                    if (!pdfObject2.isIndirect() || (n4 = ((PRIndirectReference)pdfObject2).getNumber()) < this.e.size() && (this.m || this.e.get(n4) != null)) {
                        if (objectArray == null) {
                            stack.push(new Object[]{arrayList, n2 + 1});
                        } else {
                            objectArray[1] = n2 + 1;
                            stack.push(objectArray);
                        }
                        stack.push(pdfObject2);
                        continue block5;
                    }
                    arrayList.set(n2, PdfNull.PDFNULL);
                }
                continue;
            }
            for (n2 = n3; n2 < pdfNameArray.length; ++n2) {
                int n5;
                PdfName pdfName = pdfNameArray[n2];
                PdfObject pdfObject3 = pdfDictionary.get(pdfName);
                if (!pdfObject3.isIndirect() || (n5 = ((PRIndirectReference)pdfObject3).getNumber()) >= 0 && n5 < this.e.size() && (this.m || this.e.get(n5) != null)) {
                    if (objectArray == null) {
                        stack.push(new Object[]{pdfNameArray, pdfDictionary, n2 + 1});
                    } else {
                        objectArray[2] = n2 + 1;
                        stack.push(objectArray);
                    }
                    stack.push(pdfObject3);
                    continue block5;
                }
                pdfDictionary.put(pdfName, PdfNull.PDFNULL);
            }
        }
    }

    public int removeUnusedObjects() {
        boolean[] blArray = new boolean[this.e.size()];
        PdfReader pdfReader = this;
        pdfReader.removeUnusedNode(pdfReader.trailer, blArray);
        int n2 = 0;
        if (this.m) {
            for (int i2 = 1; i2 < blArray.length; ++i2) {
                if (blArray[i2]) continue;
                this.xref[i2 << 1] = -1;
                this.xref[(i2 << 1) + 1] = 0;
                this.e.set(i2, null);
                ++n2;
            }
        } else {
            for (int i3 = 1; i3 < blArray.length; ++i3) {
                if (blArray[i3]) continue;
                this.e.set(i3, null);
                ++n2;
            }
        }
        return n2;
    }

    public AcroFields getAcroFields() {
        return new AcroFields(this, null);
    }

    public String getJavaScript(RandomAccessFileOrArray randomAccessFileOrArray) {
        Object object = (PdfDictionary)PdfReader.getPdfObjectRelease(this.catalog.get(PdfName.NAMES));
        if (object == null) {
            return null;
        }
        if ((object = (PdfDictionary)PdfReader.getPdfObjectRelease(((PdfDictionary)object).get(PdfName.JAVASCRIPT))) == null) {
            return null;
        }
        object = PdfNameTree.readTree((PdfDictionary)object);
        String[] stringArray = new String[object.size()];
        stringArray = object.keySet().toArray(stringArray);
        Arrays.sort(stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            PdfObject pdfObject;
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease((PdfObject)object.get(string));
            if (pdfDictionary == null || (pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.JS))) == null) continue;
            if (pdfObject.isString()) {
                stringBuilder.append(((PdfString)pdfObject).toUnicodeString()).append('\n');
                continue;
            }
            if (!pdfObject.isStream()) continue;
            byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject, randomAccessFileOrArray);
            if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
                stringBuilder.append(PdfEncodings.convertToString(byArray, "UnicodeBig"));
            } else {
                stringBuilder.append(PdfEncodings.convertToString(byArray, "PDF"));
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public String getJavaScript() {
        String string;
        RandomAccessFileOrArray randomAccessFileOrArray = this.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            string = this.getJavaScript(randomAccessFileOrArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return string;
    }

    public void selectPages(String string) {
        this.selectPages(SequenceList.expand(string, this.getNumberOfPages()));
    }

    public void selectPages(List<Integer> list) {
        com.lowagie.text.pdf.PdfReader$a.a(this.pageRefs, list);
        this.removeUnusedObjects();
    }

    @Override
    public void setViewerPreferences(int n2) {
        this.o.setViewerPreferences(n2);
        PdfReader pdfReader = this;
        pdfReader.a(pdfReader.o);
    }

    @Override
    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.o.addViewerPreference(pdfName, pdfObject);
        PdfReader pdfReader = this;
        pdfReader.a(pdfReader.o);
    }

    final void a(PdfViewerPreferencesImp pdfViewerPreferencesImp) {
        pdfViewerPreferencesImp.addToCatalog(this.catalog);
    }

    public int getSimpleViewerPreferences() {
        return PdfViewerPreferencesImp.getViewerPreferences(this.catalog).getPageLayoutAndMode();
    }

    public boolean isAppendable() {
        return this.q;
    }

    public void setAppendable(boolean bl2) {
        this.q = bl2;
        if (bl2) {
            PdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        }
    }

    public boolean isNewXrefType() {
        return this.newXrefType;
    }

    public int getFileLength() {
        return this.j;
    }

    public boolean isHybridXref() {
        return this.k;
    }

    final PdfIndirectReference b() {
        if (this.n == null) {
            return null;
        }
        return new PdfIndirectReference(this.n.getNumber(), this.n.getGeneration(), 0);
    }

    public void removeUsageRights() {
        PdfDictionary pdfDictionary = this.catalog.getAsDict(PdfName.PERMS);
        if (pdfDictionary == null) {
            return;
        }
        pdfDictionary.remove(PdfName.UR);
        pdfDictionary.remove(PdfName.UR3);
        if (pdfDictionary.size() == 0) {
            this.catalog.remove(PdfName.PERMS);
        }
    }

    public int getCertificationLevel() {
        PdfObject pdfObject = this.catalog.getAsDict(PdfName.PERMS);
        if (pdfObject == null) {
            return 0;
        }
        if ((pdfObject = ((PdfDictionary)pdfObject).getAsDict(PdfName.DOCMDP)) == null) {
            return 0;
        }
        if ((pdfObject = ((PdfDictionary)pdfObject).getAsArray(PdfName.REFERENCE)) == null || ((PdfArray)pdfObject).size() == 0) {
            return 0;
        }
        if ((pdfObject = ((PdfArray)pdfObject).getAsDict(0)) == null) {
            return 0;
        }
        if ((pdfObject = ((PdfDictionary)pdfObject).getAsDict(PdfName.TRANSFORMPARAMS)) == null) {
            return 0;
        }
        if ((pdfObject = ((PdfDictionary)pdfObject).getAsNumber(PdfName.P)) == null) {
            return 0;
        }
        return ((PdfNumber)pdfObject).intValue();
    }

    public boolean isModificationlowedWithoutOwnerPassword() {
        return this.g;
    }

    public void setModificationAllowedWithoutOwnerPassword(boolean bl2) {
        this.g = bl2;
    }

    public final boolean isOpenedWithFullPermissions() {
        return !this.encrypted || this.f || this.g;
    }

    public int getCryptoMode() {
        if (this.decrypt == null) {
            return -1;
        }
        return this.decrypt.getCryptoMode();
    }

    public boolean isMetadataEncrypted() {
        if (this.decrypt == null) {
            return false;
        }
        return this.decrypt.isMetadataEncrypted();
    }

    public byte[] computeUserPassword() {
        if (!this.encrypted || !this.f) {
            return null;
        }
        return this.decrypt.computeUserPassword(this.password);
    }

    static class a {
        private final PdfReader a;
        private List<PdfObject> b;
        private int c;
        private IntHashtable d;
        private int e = -1;
        private List<PdfDictionary> f;
        private boolean g;

        private a(PdfReader object) {
            this.a = object;
            if (((PdfReader)object).m) {
                this.d = new IntHashtable();
                object = (PdfNumber)PdfReader.getPdfObjectRelease(((PdfReader)object).b.get(PdfName.COUNT));
                this.c = ((PdfNumber)object).intValue();
                return;
            }
            object = this;
            if (((a)object).b == null) {
                ((a)object).d = null;
                ((a)object).b = new ArrayList<PdfObject>();
                ((a)object).f = new ArrayList<PdfDictionary>();
                Object object2 = object;
                super.a((PRIndirectReference)((a)object2).a.catalog.get(PdfName.PAGES));
                ((a)object).f = null;
                ((a)object).a.b.put(PdfName.COUNT, new PdfNumber(((a)object).b.size()));
            }
        }

        a(a a2, PdfReader pdfReader) {
            this.a = pdfReader;
            this.c = a2.c;
            if (a2.b != null) {
                this.b = new ArrayList<PdfObject>(a2.b);
                for (int i2 = 0; i2 < this.b.size(); ++i2) {
                    List<PdfObject> list = this.b;
                    list.set(i2, PdfReader.duplicatePdfObject(list.get(i2), pdfReader));
                }
                return;
            }
            this.d = (IntHashtable)a2.d.clone();
        }

        final int a() {
            if (this.b != null) {
                return this.b.size();
            }
            return this.c;
        }

        public final PdfDictionary a(int n2) {
            PRIndirectReference pRIndirectReference = this.c(n2);
            return (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
        }

        public final PdfDictionary b(int n2) {
            PdfDictionary pdfDictionary = this.a(n2);
            this.d(n2);
            return pdfDictionary;
        }

        public final PRIndirectReference c(int n2) {
            try {
                if (--n2 < 0 || n2 >= this.a()) {
                    return null;
                }
                if (this.b != null) {
                    return (PRIndirectReference)this.b.get(n2);
                }
                int n3 = this.d.get(n2);
                if (n3 == 0) {
                    PdfObject pdfObject;
                    PdfObject pdfObject2;
                    int n4 = n2;
                    Object object = this;
                    PdfDictionary pdfDictionary = new PdfDictionary();
                    PdfObject pdfObject3 = ((a)object).a.b;
                    int n5 = 0;
                    block2: while (true) {
                        Object object2 = a;
                        int n6 = a.length;
                        for (int i2 = 0; i2 < n6; ++i2) {
                            pdfObject2 = object2[i2];
                            pdfObject = pdfObject3.get((PdfName)pdfObject2);
                            if (pdfObject == null) continue;
                            pdfDictionary.put((PdfName)pdfObject2, pdfObject);
                        }
                        object2 = (PdfArray)PdfReader.getPdfObjectRelease(pdfObject3.get(PdfName.KIDS));
                        Iterator<PdfObject> iterator = object2.getElements().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            PdfObject pdfObject4 = iterator.next();
                            pdfObject2 = (PRIndirectReference)pdfObject4;
                            pdfObject = (PdfDictionary)PdfReader.getPdfObject(pdfObject2);
                            int n7 = ((a)object).a.l;
                            pdfObject4 = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.COUNT));
                            ((a)object).a.l = n7;
                            n7 = 1;
                            if (pdfObject4 != null && pdfObject4.type() == 2) {
                                n7 = ((PdfNumber)pdfObject4).intValue();
                            }
                            if (n4 < n5 + n7) {
                                if (pdfObject4 == null) break block2;
                                ((a)object).a.releaseLastXrefPartial();
                                pdfObject3 = pdfObject;
                                continue block2;
                            }
                            ((a)object).a.releaseLastXrefPartial();
                            n5 += n7;
                        }
                        break;
                    }
                    ((PdfDictionary)pdfObject).mergeDifferent(pdfDictionary);
                    object = pdfObject2;
                    this.e = this.a.l == -1 ? -1 : n2;
                    this.a.l = -1;
                    this.d.put(n2, ((PdfIndirectReference)object).getNumber());
                    if (this.g) {
                        this.e = -1;
                    }
                    return object;
                }
                if (this.e != n2) {
                    this.e = -1;
                }
                if (this.g) {
                    this.e = -1;
                }
                return new PRIndirectReference(this.a, n3);
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }

        final void b() {
            if (this.d == null || this.g) {
                return;
            }
            this.g = true;
            this.d.clear();
        }

        public final void d(int n2) {
            if (this.d == null) {
                return;
            }
            if (--n2 < 0 || n2 >= this.a()) {
                return;
            }
            if (n2 != this.e) {
                return;
            }
            this.e = -1;
            this.a.l = this.d.get(n2);
            this.a.releaseLastXrefPartial();
            this.d.remove(n2);
        }

        public final void c() {
            if (this.d == null) {
                return;
            }
            this.e = -1;
        }

        final void a(int n2, PRIndirectReference pRIndirectReference) {
            --n2;
            if (this.b != null) {
                if (n2 >= this.b.size()) {
                    this.b.add(pRIndirectReference);
                    return;
                }
                this.b.add(n2, pRIndirectReference);
                return;
            }
            ++this.c;
            this.e = -1;
            if (n2 >= this.a()) {
                this.d.put(this.a(), pRIndirectReference.getNumber());
                return;
            }
            IntHashtable intHashtable = new IntHashtable(this.d.size() + 1 << 1);
            Iterator iterator = this.d.getEntryIterator();
            while (iterator.hasNext()) {
                IntHashtable.a a2;
                IntHashtable.a a3 = a2 = (IntHashtable.a)iterator.next();
                a3 = a2;
                int n3 = a2.b;
                intHashtable.put(n3 >= n2 ? n3 + 1 : n3, a3.c);
            }
            intHashtable.put(n2, pRIndirectReference.getNumber());
            this.d = intHashtable;
        }

        private void a(PdfDictionary pdfDictionary) {
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            if (!this.f.isEmpty()) {
                pdfDictionary2.putAll(this.f.get(this.f.size() - 1));
            }
            PdfName[] pdfNameArray = a;
            int n2 = a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                PdfName pdfName = pdfNameArray[i2];
                PdfObject pdfObject = pdfDictionary.get(pdfName);
                if (pdfObject == null) continue;
                pdfDictionary2.put(pdfName, pdfObject);
            }
            this.f.add(pdfDictionary2);
        }

        private void d() {
            this.f.remove(this.f.size() - 1);
        }

        private void a(PRIndirectReference pRIndirectReference) {
            PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference);
            Object object = pdfDictionary.getAsArray(PdfName.KIDS);
            if (object == null) {
                pdfDictionary.put(PdfName.TYPE, PdfName.PAGE);
                PdfDictionary pdfDictionary2 = this.f.get(this.f.size() - 1);
                for (Object pdfObject : pdfDictionary2.getKeys()) {
                    PdfName object2 = (PdfName)pdfObject;
                    if (pdfDictionary.get(object2) != null) continue;
                    pdfDictionary.put(object2, pdfDictionary2.get(object2));
                }
                if (pdfDictionary.get(PdfName.MEDIABOX) == null) {
                    object = new PdfArray(new float[]{0.0f, 0.0f, PageSize.LETTER.getRight(), PageSize.LETTER.getTop()});
                    pdfDictionary.put(PdfName.MEDIABOX, (PdfObject)object);
                }
                this.b.add(pRIndirectReference);
                return;
            }
            pdfDictionary.put(PdfName.TYPE, PdfName.PAGES);
            this.a(pdfDictionary);
            for (int i2 = 0; i2 < ((PdfArray)object).size(); ++i2) {
                PdfObject pdfObject = ((PdfArray)object).getPdfObject(i2);
                if (!pdfObject.isIndirect()) {
                    while (i2 < ((PdfArray)object).size()) {
                        ((PdfArray)object).remove(i2);
                    }
                    break;
                }
                this.a((PRIndirectReference)pdfObject);
            }
            this.d();
        }

        /* synthetic */ a(PdfReader pdfReader, byte by) {
            this(pdfReader);
        }

        static /* synthetic */ void a(a a2, List object) {
            PRIndirectReference pRIndirectReference;
            int n2;
            Object object2;
            IntHashtable intHashtable = new IntHashtable();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n3 = a2.a();
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (Integer)object.next();
                if ((Integer)object2 <= 0 || (Integer)object2 > n3 || intHashtable.put((Integer)object2, 1) != 0) continue;
                arrayList.add(object2);
            }
            if (a2.a.m) {
                for (int i2 = 1; i2 <= n3; ++i2) {
                    a2.c(i2);
                    a2.c();
                }
            }
            PRIndirectReference pRIndirectReference2 = (PRIndirectReference)a2.a.catalog.get(PdfName.PAGES);
            object2 = (PdfDictionary)PdfReader.getPdfObject(pRIndirectReference2);
            ArrayList<PdfObject> arrayList2 = new ArrayList<PdfObject>(arrayList.size());
            PdfArray pdfArray = new PdfArray();
            for (Object e2 : arrayList) {
                n2 = (Integer)e2;
                pRIndirectReference = a2.c(n2);
                a2.c();
                pdfArray.add(pRIndirectReference);
                arrayList2.add(pRIndirectReference);
                a2.a(n2).put(PdfName.PARENT, pRIndirectReference2);
            }
            AcroFields acroFields = a2.a.getAcroFields();
            boolean bl2 = acroFields.getAllFields().size() > 0;
            for (n2 = 1; n2 <= n3; ++n2) {
                if (intHashtable.containsKey(n2)) continue;
                if (bl2) {
                    acroFields.removeFieldsFromPage(n2);
                }
                pRIndirectReference = a2.c(n2);
                int n4 = pRIndirectReference.getNumber();
                a2.a.e.set(n4, null);
                if (!a2.a.m) continue;
                a2.a.xref[n4 << 1] = -1;
                a2.a.xref[(n4 << 1) + 1] = 0;
            }
            ((PdfDictionary)object2).put(PdfName.COUNT, new PdfNumber(arrayList.size()));
            ((PdfDictionary)object2).put(PdfName.KIDS, pdfArray);
            a2.d = null;
            a2.b = arrayList2;
        }
    }
}

