/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;

public class PdfRectangle
extends PdfArray {
    private float a = 0.0f;
    private float b = 0.0f;
    private float c = 0.0f;
    private float d = 0.0f;

    public PdfRectangle(float f2, float f3, float f4, float f5, int n2) {
        if (n2 == 90 || n2 == 270) {
            this.a = f3;
            this.b = f2;
            this.c = f5;
            this.d = f4;
        } else {
            this.a = f2;
            this.b = f3;
            this.c = f4;
            this.d = f5;
        }
        super.add(new PdfNumber(this.a));
        super.add(new PdfNumber(this.b));
        super.add(new PdfNumber(this.c));
        super.add(new PdfNumber(this.d));
    }

    public PdfRectangle(float f2, float f3, float f4, float f5) {
        this(f2, f3, f4, f5, 0);
    }

    public PdfRectangle(float f2, float f3, int n2) {
        this(0.0f, 0.0f, f2, f3, n2);
    }

    public PdfRectangle(float f2, float f3) {
        this(0.0f, 0.0f, f2, f3, 0);
    }

    public PdfRectangle(Rectangle rectangle, int n2) {
        this(rectangle.getLeft(), rectangle.getBottom(), rectangle.getRight(), rectangle.getTop(), n2);
    }

    public PdfRectangle(Rectangle rectangle) {
        this(rectangle.getLeft(), rectangle.getBottom(), rectangle.getRight(), rectangle.getTop(), 0);
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.left(), this.bottom(), this.right(), this.top());
    }

    @Override
    public boolean add(PdfObject pdfObject) {
        return false;
    }

    @Override
    public boolean add(float[] fArray) {
        return false;
    }

    @Override
    public boolean add(int[] nArray) {
        return false;
    }

    @Override
    public void addFirst(PdfObject pdfObject) {
    }

    public float left() {
        return this.a;
    }

    public float right() {
        return this.c;
    }

    public float top() {
        return this.d;
    }

    public float bottom() {
        return this.b;
    }

    public float left(int n2) {
        return this.a + (float)n2;
    }

    public float right(int n2) {
        return this.c - (float)n2;
    }

    public float top(int n2) {
        return this.d - (float)n2;
    }

    public float bottom(int n2) {
        return this.b + (float)n2;
    }

    public float width() {
        return this.c - this.a;
    }

    public float height() {
        return this.d - this.b;
    }

    public PdfRectangle rotate() {
        return new PdfRectangle(this.b, this.a, this.d, this.c, 0);
    }
}

