/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFunction;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SpotColor;
import com.lowagie.text.pdf.b;
import java.awt.Color;

public class PdfShading {
    protected PdfDictionary shading;
    protected PdfWriter writer;
    protected int shadingType;
    protected b colorDetails;
    protected PdfName shadingName;
    protected PdfIndirectReference shadingReference;
    private Color a;
    protected float[] bBox;
    protected boolean antiAlias = false;

    protected PdfShading(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    protected void setColorSpace(Color object) {
        this.a = object;
        int n2 = ExtendedColor.getType((Color)object);
        PdfObject pdfObject = null;
        switch (n2) {
            case 1: {
                pdfObject = PdfName.DEVICEGRAY;
                break;
            }
            case 2: {
                pdfObject = PdfName.DEVICECMYK;
                break;
            }
            case 3: {
                object = (SpotColor)object;
                this.colorDetails = this.writer.a(((SpotColor)object).getPdfSpotColor());
                object = this.colorDetails;
                pdfObject = ((b)object).a;
                break;
            }
            case 4: 
            case 5: {
                PdfShading.throwColorSpaceError();
                break;
            }
            default: {
                pdfObject = PdfName.DEVICERGB;
            }
        }
        this.shading.put(PdfName.COLORSPACE, pdfObject);
    }

    public Color getColorSpace() {
        return this.a;
    }

    public static void throwColorSpaceError() {
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("a.tiling.or.shading.pattern.cannot.be.used.as.a.color.space.in.a.shading.pattern"));
    }

    public static void checkCompatibleColors(Color color, Color color2) {
        int n2;
        int n3 = ExtendedColor.getType(color);
        if (n3 != (n2 = ExtendedColor.getType(color2))) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("both.colors.must.be.of.the.same.type"));
        }
        if (n3 == 3 && ((SpotColor)color).getPdfSpotColor() != ((SpotColor)color2).getPdfSpotColor()) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.spot.color.must.be.the.same.only.the.tint.can.vary"));
        }
        if (n3 == 4 || n3 == 5) {
            PdfShading.throwColorSpaceError();
        }
    }

    public static float[] getColorArray(Color color) {
        int n2 = ExtendedColor.getType(color);
        switch (n2) {
            case 1: {
                return new float[]{((GrayColor)color).getGray()};
            }
            case 2: {
                color = (CMYKColor)color;
                return new float[]{((CMYKColor)color).getCyan(), ((CMYKColor)color).getMagenta(), ((CMYKColor)color).getYellow(), ((CMYKColor)color).getBlack()};
            }
            case 3: {
                return new float[]{((SpotColor)color).getTint()};
            }
            case 0: {
                return new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
            }
        }
        PdfShading.throwColorSpaceError();
        return null;
    }

    public static PdfShading type1(PdfWriter object, Color color, float[] fArray, float[] fArray2, PdfFunction pdfFunction) {
        object = new PdfShading((PdfWriter)object);
        v0.shading = new PdfDictionary();
        ((PdfShading)object).shadingType = 1;
        ((PdfShading)object).shading.put(PdfName.SHADINGTYPE, new PdfNumber(((PdfShading)object).shadingType));
        ((PdfShading)object).setColorSpace(color);
        if (fArray != null) {
            ((PdfShading)object).shading.put(PdfName.DOMAIN, new PdfArray(fArray));
        }
        if (fArray2 != null) {
            ((PdfShading)object).shading.put(PdfName.MATRIX, new PdfArray(fArray2));
        }
        ((PdfShading)object).shading.put(PdfName.FUNCTION, pdfFunction.a());
        return object;
    }

    public static PdfShading type2(PdfWriter object, Color object2, float[] fArray, float[] fArray2, PdfFunction pdfFunction, boolean[] blArray) {
        object = new PdfShading((PdfWriter)object);
        v0.shading = new PdfDictionary();
        ((PdfShading)object).shadingType = 2;
        ((PdfShading)object).shading.put(PdfName.SHADINGTYPE, new PdfNumber(((PdfShading)object).shadingType));
        ((PdfShading)object).setColorSpace((Color)object2);
        ((PdfShading)object).shading.put(PdfName.COORDS, new PdfArray(fArray));
        if (fArray2 != null) {
            ((PdfShading)object).shading.put(PdfName.DOMAIN, new PdfArray(fArray2));
        }
        ((PdfShading)object).shading.put(PdfName.FUNCTION, pdfFunction.a());
        if (blArray != null && (blArray[0] || blArray[1])) {
            object2 = new PdfArray(blArray[0] ? PdfBoolean.PDFTRUE : PdfBoolean.PDFFALSE);
            ((PdfArray)object2).add(blArray[1] ? PdfBoolean.PDFTRUE : PdfBoolean.PDFFALSE);
            ((PdfShading)object).shading.put(PdfName.EXTEND, (PdfObject)object2);
        }
        return object;
    }

    public static PdfShading type3(PdfWriter object, Color color, float[] fArray, float[] fArray2, PdfFunction pdfFunction, boolean[] blArray) {
        object = PdfShading.type2((PdfWriter)object, color, fArray, fArray2, pdfFunction, blArray);
        v0.shadingType = 3;
        ((PdfShading)object).shading.put(PdfName.SHADINGTYPE, new PdfNumber(((PdfShading)object).shadingType));
        return object;
    }

    public static PdfShading simpleAxial(PdfWriter pdfWriter, float f2, float f3, float f4, float f5, Color color, Color object, boolean bl2, boolean bl3) {
        PdfShading.checkCompatibleColors(color, (Color)object);
        object = PdfFunction.type2(pdfWriter, new float[]{0.0f, 1.0f}, null, PdfShading.getColorArray(color), PdfShading.getColorArray((Color)object), 1.0f);
        return PdfShading.type2(pdfWriter, color, new float[]{f2, f3, f4, f5}, null, (PdfFunction)object, new boolean[]{bl2, bl3});
    }

    public static PdfShading simpleAxial(PdfWriter pdfWriter, float f2, float f3, float f4, float f5, Color color, Color color2) {
        return PdfShading.simpleAxial(pdfWriter, f2, f3, f4, f5, color, color2, true, true);
    }

    public static PdfShading simpleRadial(PdfWriter pdfWriter, float f2, float f3, float f4, float f5, float f6, float f7, Color color, Color object, boolean bl2, boolean bl3) {
        PdfShading.checkCompatibleColors(color, (Color)object);
        object = PdfFunction.type2(pdfWriter, new float[]{0.0f, 1.0f}, null, PdfShading.getColorArray(color), PdfShading.getColorArray((Color)object), 1.0f);
        return PdfShading.type3(pdfWriter, color, new float[]{f2, f3, f4, f5, f6, f7}, null, (PdfFunction)object, new boolean[]{bl2, bl3});
    }

    public static PdfShading simpleRadial(PdfWriter pdfWriter, float f2, float f3, float f4, float f5, float f6, float f7, Color color, Color color2) {
        return PdfShading.simpleRadial(pdfWriter, f2, f3, f4, f5, f6, f7, color, color2, true, true);
    }

    final PdfName a() {
        return this.shadingName;
    }

    final PdfIndirectReference b() {
        if (this.shadingReference == null) {
            this.shadingReference = this.writer.getPdfIndirectReference();
        }
        return this.shadingReference;
    }

    final void a(int n2) {
        this.shadingName = new PdfName("Sh" + n2);
    }

    final void c() {
        if (this.bBox != null) {
            this.shading.put(PdfName.BBOX, new PdfArray(this.bBox));
        }
        if (this.antiAlias) {
            this.shading.put(PdfName.ANTIALIAS, PdfBoolean.PDFTRUE);
        }
        this.writer.addToBody((PdfObject)this.shading, this.b());
    }

    final PdfWriter d() {
        return this.writer;
    }

    final b e() {
        return this.colorDetails;
    }

    public float[] getBBox() {
        return this.bBox;
    }

    public void setBBox(float[] fArray) {
        if (fArray.length != 4) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("bbox.must.be.a.4.element.array"));
        }
        this.bBox = fArray;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean bl2) {
        this.antiAlias = bl2;
    }
}

