/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSigGenericPKCS;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.m;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PdfSignatureAppearance {
    public static final int SignatureRenderDescription = 0;
    public static final int SignatureRenderNameAndDescription = 1;
    public static final int SignatureRenderGraphicAndDescription = 2;
    public static final PdfName SELF_SIGNED = PdfName.ADOBE_PPKLITE;
    public static final PdfName VERISIGN_SIGNED = PdfName.VERISIGN_PPKVS;
    public static final PdfName WINCER_SIGNED = PdfName.ADOBE_PPKMS;
    public static final int NOT_CERTIFIED = 0;
    public static final int CERTIFIED_NO_CHANGES_ALLOWED = 1;
    public static final int CERTIFIED_FORM_FILLING = 2;
    public static final int CERTIFIED_FORM_FILLING_AND_ANNOTATIONS = 3;
    private Rectangle a;
    private Rectangle b;
    private final PdfTemplate[] c = new PdfTemplate[5];
    private PdfTemplate d;
    private final m e;
    private String f;
    private String g;
    private String h;
    private Calendar i;
    private String j;
    private int k = 1;
    private String l;
    private PrivateKey m;
    private CRL[] n;
    private PdfName o;
    private boolean p;
    private ByteBuffer q;
    private OutputStream r;
    private File s;
    private PdfDictionary t;
    private PdfStamper u;
    private boolean v = false;
    private PdfSigGenericPKCS w;
    private long[] x;
    private RandomAccessFile y;
    private byte[] z;
    private int A;
    private byte[] B;
    private byte[] C;
    private String D;
    private Map<PdfName, PdfLiteral> E;
    private Certificate[] F;
    private int G = 0;
    private Image H = null;
    public static final String questionMark = "% DSUnknown\nq\n1 G\n1 g\n0.1 0 0 0.1 9 0 cm\n0 J 0 j 4 M []0 d\n1 i \n0 g\n313 292 m\n313 404 325 453 432 529 c\n478 561 504 597 504 645 c\n504 736 440 760 391 760 c\n286 760 271 681 265 626 c\n265 625 l\n100 625 l\n100 828 253 898 381 898 c\n451 898 679 878 679 650 c\n679 555 628 499 538 435 c\n488 399 467 376 467 292 c\n313 292 l\nh\n308 214 170 -164 re\nf\n0.44 G\n1.2 w\n1 1 0.4 rg\n287 318 m\n287 430 299 479 406 555 c\n451 587 478 623 478 671 c\n478 762 414 786 365 786 c\n260 786 245 707 239 652 c\n239 651 l\n74 651 l\n74 854 227 924 355 924 c\n425 924 653 904 653 676 c\n653 581 602 525 512 461 c\n462 425 441 402 441 318 c\n287 318 l\nh\n282 240 170 -164 re\nB\nQ\n";
    private String I;
    private Font J;
    private String K;
    private boolean L;
    private int M = 1;
    private SignatureEvent N;
    private Image O;
    private float P;
    private int Q = 0;

    PdfSignatureAppearance(m m2) {
        this.e = m2;
        this.i = new GregorianCalendar();
        this.l = this.getNewSigName();
    }

    public int getRender() {
        return this.G;
    }

    public void setRender(int n2) {
        this.G = n2;
    }

    public Image getSignatureGraphic() {
        return this.H;
    }

    public void setSignatureGraphic(Image image) {
        this.H = image;
    }

    public void setLayer2Text(String string) {
        this.f = string;
    }

    public String getLayer2Text() {
        return this.f;
    }

    public void setLayer4Text(String string) {
        this.K = string;
    }

    public String getLayer4Text() {
        return this.K;
    }

    public Rectangle getRect() {
        return this.a;
    }

    public boolean isInvisible() {
        return this.a == null || this.a.getWidth() == 0.0f || this.a.getHeight() == 0.0f;
    }

    public void setCrypto(PrivateKey privateKey, X509Certificate x509Certificate, CRL cRL, PdfName pdfName) {
        this.m = privateKey;
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Null certificate not allowed");
        }
        this.F = new Certificate[1];
        this.F[0] = x509Certificate;
        if (cRL != null) {
            this.n = new CRL[1];
            this.n[0] = cRL;
        }
        this.o = pdfName;
    }

    public void setCrypto(PrivateKey privateKey, Certificate[] certificateArray, CRL[] cRLArray, PdfName pdfName) {
        this.m = privateKey;
        this.F = certificateArray;
        this.n = cRLArray;
        this.o = pdfName;
    }

    public void setVisibleSignature(Rectangle rectangle, int n2) {
        this.setVisibleSignature(rectangle, n2, this.getNewSigName());
    }

    public void setVisibleSignature(Rectangle rectangle, int n2, String string) {
        if (string != null) {
            if (string.indexOf(46) >= 0) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("field.names.cannot.contain.a.dot"));
            }
            Object object = this.e.c();
            if ((object = ((AcroFields)object).getFieldItem(string)) != null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.field.1.already.exists", string));
            }
            this.l = string;
        }
        if (n2 < 0 || n2 > this.e.a.getNumberOfPages()) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.page.number.1", n2));
        }
        this.b = new Rectangle(rectangle);
        this.b.normalize();
        this.a = new Rectangle(this.b.getWidth(), this.b.getHeight());
        this.k = n2;
        this.p = true;
    }

    public void setVisibleSignature(String object) {
        Object object2 = this.e.c();
        if ((object2 = ((AcroFields)object2).getFieldItem((String)object)) == null) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.field.1.does.not.exist", object));
        }
        PdfDictionary pdfDictionary = ((AcroFields.Item)object2).getMerged(0);
        if (!PdfName.SIG.equals(PdfReader.getPdfObject(pdfDictionary.get(PdfName.FT)))) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.field.1.is.not.a.signature.field", object));
        }
        this.l = object;
        object = pdfDictionary.getAsArray(PdfName.RECT);
        float f2 = ((PdfArray)object).getAsNumber(0).floatValue();
        float f3 = ((PdfArray)object).getAsNumber(1).floatValue();
        float f4 = ((PdfArray)object).getAsNumber(2).floatValue();
        float f5 = ((PdfArray)object).getAsNumber(3).floatValue();
        this.b = new Rectangle(f2, f3, f4, f5);
        this.b.normalize();
        this.k = ((AcroFields.Item)object2).getPage(0);
        int n2 = this.e.a.getPageRotation(this.k);
        object2 = this.e.a.getPageSizeWithRotation(this.k);
        switch (n2) {
            case 90: {
                this.b = new Rectangle(this.b.getBottom(), ((Rectangle)object2).getTop() - this.b.getLeft(), this.b.getTop(), ((Rectangle)object2).getTop() - this.b.getRight());
                break;
            }
            case 180: {
                this.b = new Rectangle(((Rectangle)object2).getRight() - this.b.getLeft(), ((Rectangle)object2).getTop() - this.b.getBottom(), ((Rectangle)object2).getRight() - this.b.getRight(), ((Rectangle)object2).getTop() - this.b.getTop());
                break;
            }
            case 270: {
                this.b = new Rectangle(((Rectangle)object2).getRight() - this.b.getBottom(), this.b.getLeft(), ((Rectangle)object2).getRight() - this.b.getTop(), this.b.getRight());
            }
        }
        if (n2 != 0) {
            this.b.normalize();
        }
        this.a = new Rectangle(this.b.getWidth(), this.b.getHeight());
    }

    public PdfTemplate getLayer(int n2) {
        if (n2 < 0 || n2 >= this.c.length) {
            return null;
        }
        PdfTemplate pdfTemplate = this.c[n2];
        if (pdfTemplate == null) {
            pdfTemplate = this.c[n2] = new PdfTemplate(this.e);
            this.c[n2].setBoundingBox(this.a);
            this.e.a(pdfTemplate, new PdfName("n" + n2));
        }
        return pdfTemplate;
    }

    public PdfTemplate getTopLayer() {
        if (this.d == null) {
            this.d = new PdfTemplate(this.e);
            this.d.setBoundingBox(this.a);
            this.e.a(this.d, new PdfName("FRM"));
        }
        return this.d;
    }

    public PdfTemplate getAppearance() {
        Rectangle rectangle;
        Object object;
        Object object2;
        Object object3;
        if (this.isInvisible()) {
            PdfTemplate pdfTemplate = new PdfTemplate(this.e);
            pdfTemplate.setBoundingBox(new Rectangle(0.0f, 0.0f));
            this.e.a(pdfTemplate, null);
            return pdfTemplate;
        }
        if (this.c[0] == null) {
            this.c[0] = new PdfTemplate(this.e);
            object3 = this.c[0];
            this.c[0].setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.e.a((PdfTemplate)object3, new PdfName("n0"));
            ((PdfContentByte)object3).setLiteral("% DSBlank\n");
        }
        if (this.c[1] == null && !this.L) {
            this.c[1] = new PdfTemplate(this.e);
            object3 = this.c[1];
            this.c[1].setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.e.a((PdfTemplate)object3, new PdfName("n1"));
            ((PdfContentByte)object3).setLiteral(questionMark);
        }
        if (this.c[2] == null) {
            Rectangle rectangle2;
            float f2;
            Object object4;
            if (this.f == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Digitally signed by ").append(PdfPKCS7.getSubjectFields((X509Certificate)this.F[0]).getField("CN")).append('\n');
                object4 = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
                ((StringBuilder)object2).append("Date: ").append(((DateFormat)object4).format(this.i.getTime()));
                if (this.g != null) {
                    ((StringBuilder)object2).append('\n').append("Reason: ").append(this.g);
                }
                if (this.h != null) {
                    ((StringBuilder)object2).append('\n').append("Location: ").append(this.h);
                }
                object3 = ((StringBuilder)object2).toString();
            } else {
                object3 = this.f;
            }
            this.c[2] = new PdfTemplate(this.e);
            object2 = this.c[2];
            this.c[2].setBoundingBox(this.a);
            this.e.a((PdfTemplate)object2, new PdfName("n2"));
            if (this.O != null) {
                if (this.P == 0.0f) {
                    ((PdfContentByte)object2).addImage(this.O, this.a.getWidth(), 0.0f, 0.0f, this.a.getHeight(), 0.0f, 0.0f);
                } else {
                    float f3 = this.P;
                    if (this.P < 0.0f) {
                        f3 = Math.min(this.a.getWidth() / this.O.getWidth(), this.a.getHeight() / this.O.getHeight());
                    }
                    f2 = this.O.getWidth() * f3;
                    float f4 = this.O.getHeight() * f3;
                    float f5 = (this.a.getWidth() - f2) / 2.0f;
                    float f6 = (this.a.getHeight() - f4) / 2.0f;
                    ((PdfContentByte)object2).addImage(this.O, f2, 0.0f, 0.0f, f4, f5, f6);
                }
            }
            object4 = this.J == null ? new Font() : new Font(this.J);
            f2 = ((Font)object4).getSize();
            object = null;
            if (this.G == 1 || this.G == 2 && this.H != null) {
                object = new Rectangle(2.0f, 2.0f, this.a.getWidth() / 2.0f - 2.0f, this.a.getHeight() - 2.0f);
                rectangle = new Rectangle(this.a.getWidth() / 2.0f + 1.0f, 2.0f, this.a.getWidth() - 1.0f, this.a.getHeight() - 2.0f);
                if (this.a.getHeight() > this.a.getWidth()) {
                    object = new Rectangle(2.0f, this.a.getHeight() / 2.0f, this.a.getWidth() - 2.0f, this.a.getHeight());
                    rectangle = new Rectangle(2.0f, 2.0f, this.a.getWidth() - 2.0f, this.a.getHeight() / 2.0f - 2.0f);
                }
            } else {
                rectangle = new Rectangle(2.0f, 2.0f, this.a.getWidth() - 2.0f, this.a.getHeight() * 0.7f - 2.0f);
            }
            if (this.G == 1) {
                String string = PdfPKCS7.getSubjectFields((X509Certificate)this.F[0]).getField("CN");
                rectangle2 = new Rectangle(((Rectangle)object).getWidth() - 2.0f, ((Rectangle)object).getHeight() - 2.0f);
                float f7 = PdfSignatureAppearance.fitText((Font)object4, string, rectangle2, -1.0f, this.M);
                ColumnText columnText = new ColumnText((PdfContentByte)object2);
                columnText.setRunDirection(this.M);
                columnText.setSimpleColumn(new Phrase(string, (Font)object4), ((Rectangle)object).getLeft(), ((Rectangle)object).getBottom(), ((Rectangle)object).getRight(), ((Rectangle)object).getTop(), f7, 0);
                columnText.go();
            } else if (this.G == 2) {
                ColumnText columnText = new ColumnText((PdfContentByte)object2);
                columnText.setRunDirection(this.M);
                columnText.setSimpleColumn(((Rectangle)object).getLeft(), ((Rectangle)object).getBottom(), ((Rectangle)object).getRight(), ((Rectangle)object).getTop(), 0.0f, 2);
                rectangle2 = Image.getInstance(this.H);
                ((Image)rectangle2).scaleToFit(((Rectangle)object).getWidth(), ((Rectangle)object).getHeight());
                Paragraph paragraph = new Paragraph();
                float f8 = -((Image)rectangle2).getScaledHeight() + 15.0f;
                float f9 = 0.0f + (((Rectangle)object).getWidth() - ((Image)rectangle2).getScaledWidth()) / 2.0f;
                ((Phrase)paragraph).add(new Chunk((Image)rectangle2, f9 + (((Rectangle)object).getWidth() - ((Image)rectangle2).getScaledWidth()) / 2.0f, f8 -= (((Rectangle)object).getHeight() - ((Image)rectangle2).getScaledHeight()) / 2.0f, false));
                columnText.addElement(paragraph);
                columnText.go();
            }
            if (f2 <= 0.0f) {
                Rectangle rectangle3 = new Rectangle(rectangle.getWidth(), rectangle.getHeight());
                f2 = PdfSignatureAppearance.fitText((Font)object4, (String)object3, rectangle3, 12.0f, this.M);
            }
            ColumnText columnText = new ColumnText((PdfContentByte)object2);
            columnText.setRunDirection(this.M);
            columnText.setSimpleColumn(new Phrase((String)object3, (Font)object4), rectangle.getLeft(), rectangle.getBottom(), rectangle.getRight(), rectangle.getTop(), f2, 0);
            columnText.go();
        }
        if (this.c[3] == null && !this.L) {
            this.c[3] = new PdfTemplate(this.e);
            object3 = this.c[3];
            this.c[3].setBoundingBox(new Rectangle(100.0f, 100.0f));
            this.e.a((PdfTemplate)object3, new PdfName("n3"));
            ((PdfContentByte)object3).setLiteral("% DSBlank\n");
        }
        if (this.c[4] == null && !this.L) {
            this.c[4] = new PdfTemplate(this.e);
            object3 = this.c[4];
            this.c[4].setBoundingBox(new Rectangle(0.0f, this.a.getHeight() * 0.7f, this.a.getRight(), this.a.getTop()));
            this.e.a((PdfTemplate)object3, new PdfName("n4"));
            object2 = this.J == null ? new Font() : new Font(this.J);
            ((Font)object2).getSize();
            String string = "Signature Not Verified";
            if (this.K != null) {
                string = this.K;
            }
            rectangle = new Rectangle(this.a.getWidth() - 4.0f, this.a.getHeight() * 0.3f - 4.0f);
            float f10 = PdfSignatureAppearance.fitText((Font)object2, string, rectangle, 15.0f, this.M);
            object = new ColumnText((PdfContentByte)object3);
            ((ColumnText)object).setRunDirection(this.M);
            ((ColumnText)object).setSimpleColumn(new Phrase(string, (Font)object2), 2.0f, 0.0f, this.a.getWidth() - 2.0f, this.a.getHeight() - 2.0f, f10, 0);
            ((ColumnText)object).go();
        }
        int n2 = this.e.a.getPageRotation(this.k);
        object2 = new Rectangle(this.a);
        for (int i2 = n2; i2 > 0; i2 -= 90) {
            object2 = ((Rectangle)object2).rotate();
        }
        if (this.d == null) {
            this.d = new PdfTemplate(this.e);
            this.d.setBoundingBox((Rectangle)object2);
            this.e.a(this.d, new PdfName("FRM"));
            float f11 = Math.min(this.a.getWidth(), this.a.getHeight()) * 0.9f;
            float f12 = (this.a.getWidth() - f11) / 2.0f;
            float f13 = (this.a.getHeight() - f11) / 2.0f;
            f11 /= 100.0f;
            if (n2 == 90) {
                this.d.concatCTM(0.0f, 1.0f, -1.0f, 0.0f, this.a.getHeight(), 0.0f);
            } else if (n2 == 180) {
                this.d.concatCTM(-1.0f, 0.0f, 0.0f, -1.0f, this.a.getWidth(), this.a.getHeight());
            } else if (n2 == 270) {
                this.d.concatCTM(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.a.getWidth());
            }
            this.d.addTemplate(this.c[0], 0.0f, 0.0f);
            if (!this.L) {
                this.d.addTemplate(this.c[1], f11, 0.0f, 0.0f, f11, f12, f13);
            }
            this.d.addTemplate(this.c[2], 0.0f, 0.0f);
            if (!this.L) {
                this.d.addTemplate(this.c[3], f11, 0.0f, 0.0f, f11, f12, f13);
                this.d.addTemplate(this.c[4], 0.0f, 0.0f);
            }
        }
        PdfTemplate pdfTemplate = new PdfTemplate(this.e);
        pdfTemplate.setBoundingBox((Rectangle)object2);
        this.e.a(pdfTemplate, null);
        pdfTemplate.addTemplate(this.d, 0.0f, 0.0f);
        return pdfTemplate;
    }

    public static float fitText(Font font, String string, Rectangle rectangle, float f2, int n2) {
        try {
            int n3;
            if (f2 <= 0.0f) {
                char[] cArray;
                int n4 = 0;
                int n5 = 0;
                char[] cArray2 = cArray = string.toCharArray();
                int n6 = cArray.length;
                for (n3 = 0; n3 < n6; ++n3) {
                    char c2 = cArray2[n3];
                    if (c2 == '\n') {
                        ++n5;
                        continue;
                    }
                    if (c2 != '\r') continue;
                    ++n4;
                }
                int n7 = Math.max(n4, n5) + 1;
                f2 = Math.abs(rectangle.getHeight()) / (float)n7 - 0.001f;
            }
            font.setSize(f2);
            Phrase phrase = new Phrase(string, font);
            ColumnText columnText = new ColumnText(null);
            columnText.setSimpleColumn(phrase, rectangle.getLeft(), rectangle.getBottom(), rectangle.getRight(), rectangle.getTop(), f2, 0);
            columnText.setRunDirection(n2);
            int n8 = columnText.go(true);
            if ((n8 & 1) != 0) {
                return f2;
            }
            float f3 = 0.0f;
            float f4 = f2;
            float f5 = f2;
            for (n3 = 0; n3 < 50; ++n3) {
                f5 = (f3 + f4) / 2.0f;
                ColumnText columnText2 = new ColumnText(null);
                font.setSize(f5);
                columnText2.setSimpleColumn(new Phrase(string, font), rectangle.getLeft(), rectangle.getBottom(), rectangle.getRight(), rectangle.getTop(), f5, 0);
                columnText2.setRunDirection(n2);
                n8 = columnText2.go(true);
                if ((n8 & 1) != 0) {
                    if (f4 - f3 < f5 * 0.1f) {
                        return f5;
                    }
                    f3 = f5;
                    continue;
                }
                f4 = f5;
            }
            return f5;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void setExternalDigest(byte[] byArray, byte[] byArray2, String string) {
        this.B = byArray;
        this.C = byArray2;
        this.D = string;
    }

    public String getReason() {
        return this.g;
    }

    public void setReason(String string) {
        this.g = string;
    }

    public String getLocation() {
        return this.h;
    }

    public void setLocation(String string) {
        this.h = string;
    }

    public String getProvider() {
        return this.j;
    }

    public void setProvider(String string) {
        this.j = string;
    }

    public PrivateKey getPrivKey() {
        return this.m;
    }

    public CRL[] getCrlList() {
        return this.n;
    }

    public PdfName getFilter() {
        return this.o;
    }

    public boolean isNewField() {
        return this.p;
    }

    public int getPage() {
        return this.k;
    }

    public String getFieldName() {
        return this.l;
    }

    public Rectangle getPageRect() {
        return this.b;
    }

    public Calendar getSignDate() {
        return this.i;
    }

    public void setSignDate(Calendar calendar) {
        this.i = calendar;
    }

    final void a(ByteBuffer byteBuffer) {
        this.q = byteBuffer;
    }

    final void a(OutputStream outputStream) {
        this.r = outputStream;
    }

    public File getTempFile() {
        return this.s;
    }

    final void a(File file) {
        this.s = file;
    }

    public final String getNewSigName() {
        AcroFields acroFields = this.e.c();
        String string = "Signature";
        int n2 = 0;
        boolean bl2 = false;
        block0: while (!bl2) {
            String string2 = string + ++n2;
            if (acroFields.getFieldItem(string2) != null) continue;
            string2 = string2 + ".";
            bl2 = true;
            for (String string3 : acroFields.getAllFields().keySet()) {
                if (!string3.startsWith(string2)) continue;
                bl2 = false;
                continue block0;
            }
        }
        string = string + n2;
        return string;
    }

    public void preClose() {
        this.preClose(null);
    }

    public void preClose(Map<PdfName, Integer> object) {
        Object object2;
        Iterator<PdfLiteral> byteBuffer;
        Object object3;
        PdfObject pdfObject;
        if (this.v) {
            throw new DocumentException(MessageLocalization.getComposedMessage("document.already.pre.closed"));
        }
        this.v = true;
        AcroFields acroFields = this.e.c();
        String string = this.getFieldName();
        boolean bl2 = !this.isInvisible() && !this.isNewField();
        PdfIndirectReference pdfIndirectReference = this.e.getPdfIndirectReference();
        ((PdfWriter)this.e).setSigFlags(3);
        if (bl2) {
            int n4;
            pdfObject = acroFields.getFieldItem(string).getWidget(0);
            this.e.a(pdfObject);
            ((PdfDictionary)pdfObject).put(PdfName.P, ((PdfWriter)this.e).getPageReference(this.getPage()));
            ((PdfDictionary)pdfObject).put(PdfName.V, pdfIndirectReference);
            object3 = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.F));
            boolean n2 = false;
            if (object3 != null && ((PdfObject)object3).isNumber()) {
                n4 = ((PdfNumber)object3).intValue();
            }
            int e2 = n4 | 0x80;
            ((PdfDictionary)pdfObject).put(PdfName.F, new PdfNumber(e2));
            byteBuffer = new PdfDictionary();
            ((PdfDictionary)((Object)byteBuffer)).put(PdfName.N, this.getAppearance().getIndirectReference());
            ((PdfDictionary)pdfObject).put(PdfName.AP, (PdfObject)((Object)byteBuffer));
        } else {
            pdfObject = PdfFormField.createSignature(this.e);
            ((PdfFormField)pdfObject).setFieldName(string);
            ((PdfDictionary)pdfObject).put(PdfName.V, pdfIndirectReference);
            ((PdfAnnotation)pdfObject).setFlags(132);
            int n2 = this.getPage();
            if (!this.isInvisible() && n2 == 0) {
                int n5 = this.e.a.getNumberOfPages();
                for (int l4 = 1; l4 <= n5; ++l4) {
                    object2 = PdfFormField.createEmpty(this.e);
                    this.k = l4;
                    n2 = l4;
                    ((PdfFormField)object2).setWidget(this.getPageRect(), null);
                    ((PdfAnnotation)object2).setAppearance(PdfAnnotation.APPEARANCE_NORMAL, this.getAppearance());
                    ((PdfAnnotation)object2).setPlaceInPage(l4);
                    ((PdfAnnotation)object2).setPage(l4);
                    ((PdfAnnotation)object2).setFlags(4);
                    ((PdfFormField)pdfObject).addKid((PdfFormField)object2);
                }
            } else if (!this.isInvisible()) {
                ((PdfFormField)pdfObject).setWidget(this.getPageRect(), null);
            } else {
                ((PdfFormField)pdfObject).setWidget(new Rectangle(0.0f, 0.0f), null);
            }
            ((PdfAnnotation)pdfObject).setAppearance(PdfAnnotation.APPEARANCE_NORMAL, this.getAppearance());
            ((PdfAnnotation)pdfObject).setPage(n2);
            this.e.a((PdfAnnotation)pdfObject, n2);
        }
        this.E = new HashMap<PdfName, PdfLiteral>();
        if (this.t == null) {
            if (PdfName.ADOBE_PPKLITE.equals(this.getFilter())) {
                this.w = new PdfSigGenericPKCS.PPKLite(this.getProvider());
            } else if (PdfName.ADOBE_PPKMS.equals(this.getFilter())) {
                this.w = new PdfSigGenericPKCS.PPKMS(this.getProvider());
            } else if (PdfName.VERISIGN_PPKVS.equals(this.getFilter())) {
                this.w = new PdfSigGenericPKCS.VeriSign(this.getProvider());
            } else {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("unknown.filter.1", this.getFilter()));
            }
            this.w.setExternalDigest(this.B, this.C, this.D);
            if (this.getReason() != null) {
                this.w.setReason(this.getReason());
            }
            if (this.getLocation() != null) {
                this.w.setLocation(this.getLocation());
            }
            if (this.getContact() != null) {
                this.w.setContact(this.getContact());
            }
            this.w.put(PdfName.M, new PdfDate(this.getSignDate()));
            this.w.setSignInfo(this.getPrivKey(), this.F, this.n);
            pdfObject = (PdfString)this.w.get(PdfName.CONTENTS);
            object3 = new PdfLiteral((pdfObject.toString().length() + (PdfName.ADOBE_PPKLITE.equals(this.getFilter()) ? 0 : 64) << 1) + 2);
            this.E.put(PdfName.CONTENTS, (PdfLiteral)object3);
            this.w.put(PdfName.CONTENTS, (PdfObject)object3);
            object3 = new PdfLiteral(80);
            this.E.put(PdfName.BYTERANGE, (PdfLiteral)object3);
            this.w.put(PdfName.BYTERANGE, (PdfObject)object3);
            if (this.Q > 0) {
                PdfSignatureAppearance pdfSignatureAppearance = this;
                pdfSignatureAppearance.a(pdfSignatureAppearance.w);
            }
            if (this.N != null) {
                this.N.getSignatureDictionary(this.w);
            }
            this.e.addToBody((PdfObject)this.w, pdfIndirectReference, false);
        } else {
            pdfObject = new PdfLiteral(80);
            this.E.put(PdfName.BYTERANGE, (PdfLiteral)pdfObject);
            this.t.put(PdfName.BYTERANGE, pdfObject);
            for (Object e2 : object.entrySet()) {
                byteBuffer = (Map.Entry)e2;
                object2 = (PdfName)byteBuffer.getKey();
                object = (Integer)byteBuffer.getValue();
                pdfObject = new PdfLiteral((Integer)object);
                this.E.put((PdfName)object2, (PdfLiteral)pdfObject);
                this.t.put((PdfName)object2, pdfObject);
            }
            if (this.Q > 0) {
                PdfSignatureAppearance pdfSignatureAppearance = this;
                pdfSignatureAppearance.a(pdfSignatureAppearance.t);
            }
            if (this.N != null) {
                this.N.getSignatureDictionary(this.t);
            }
            this.e.addToBody((PdfObject)this.t, pdfIndirectReference, false);
        }
        if (this.Q > 0) {
            pdfObject = new PdfDictionary();
            ((PdfDictionary)pdfObject).put(new PdfName("DocMDP"), pdfIndirectReference);
            this.e.a.getCatalog().put(new PdfName("Perms"), pdfObject);
        }
        this.e.a(this.u.getInfoDictionary());
        this.x = new long[this.E.size() << 1];
        long l2 = this.E.get(PdfName.BYTERANGE).getPosition();
        this.E.remove(PdfName.BYTERANGE);
        boolean bl3 = true;
        byteBuffer = this.E.values().iterator();
        while (byteBuffer.hasNext()) {
            object = object2 = byteBuffer.next();
            long l3 = ((PdfLiteral)object2).getPosition();
            this.x[var2_10++] = l3;
            this.x[var2_10++] = (long)((PdfLiteral)object).getPosLength() + l3;
        }
        Arrays.sort(this.x, 1, this.x.length - 1);
        for (int iOException = 3; iOException < this.x.length - 2; iOException += 2) {
            int n3 = iOException;
            this.x[n3] = this.x[n3] - this.x[iOException - 1];
        }
        if (this.s == null) {
            this.z = this.q.getBuffer();
            this.A = this.q.size();
            this.x[this.x.length - 1] = (long)this.A - this.x[this.x.length - 2];
            ByteBuffer byteBuffer2 = new ByteBuffer();
            byteBuffer2.append('[');
            object2 = this.x;
            int n7 = this.x.length;
            for (int i2 = 0; i2 < n7; ++i2) {
                Object object4 = object2[i2];
                byteBuffer2.append((long)object4).append(' ');
            }
            byteBuffer2.append(']');
            System.arraycopy(byteBuffer2.getBuffer(), 0, this.z, (int)l2, byteBuffer2.size());
            return;
        }
        try {
            this.y = new RandomAccessFile(this.s, "rw");
            long l4 = this.y.length();
            this.x[this.x.length - 1] = l4 - this.x[this.x.length - 2];
            object = new ByteBuffer();
            ((ByteBuffer)object).append('[');
            long[] lArray = this.x;
            int n4 = this.x.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                long l5 = lArray[i3];
                ((ByteBuffer)object).append(l5).append(' ');
            }
            ((ByteBuffer)object).append(']');
            this.y.seek(l2);
            this.y.write(((ByteBuffer)object).getBuffer(), 0, ((ByteBuffer)object).size());
            return;
        }
        catch (IOException iOException) {
            try {
                this.y.close();
            }
            catch (Exception exception) {}
            try {
                this.s.delete();
            }
            catch (Exception exception) {}
            throw iOException;
        }
    }

    public void close(PdfDictionary pdfDictionary) {
        block30: {
            try {
                Object object;
                if (!this.v) {
                    throw new DocumentException(MessageLocalization.getComposedMessage("preclose.must.be.called.first"));
                }
                ByteBuffer byteBuffer = new ByteBuffer();
                for (PdfName pdfName : pdfDictionary.getKeys()) {
                    object = pdfDictionary.get(pdfName);
                    PdfLiteral pdfLiteral = this.E.get(pdfName);
                    if (pdfLiteral == null) {
                        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.key.1.didn.t.reserve.space.in.preclose", pdfName.toString()));
                    }
                    byteBuffer.reset();
                    ((PdfObject)object).toPdf(null, byteBuffer);
                    if (byteBuffer.size() > pdfLiteral.getPosLength()) {
                        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.key.1.is.too.big.is.2.reserved.3", pdfName.toString(), String.valueOf(byteBuffer.size()), String.valueOf(pdfLiteral.getPosLength())));
                    }
                    if (this.s == null) {
                        System.arraycopy(byteBuffer.getBuffer(), 0, this.z, (int)pdfLiteral.getPosition(), byteBuffer.size());
                        continue;
                    }
                    this.y.seek(pdfLiteral.getPosition());
                    this.y.write(byteBuffer.getBuffer(), 0, byteBuffer.size());
                }
                if (pdfDictionary.size() != this.E.size()) {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.update.dictionary.has.less.keys.than.required"));
                }
                if (this.s == null) {
                    this.r.write(this.z, 0, this.A);
                } else if (this.r != null) {
                    int n2;
                    this.y.seek(0L);
                    object = new byte[8192];
                    for (long i2 = this.y.length(); i2 > 0L; i2 -= (long)n2) {
                        int cfr_ignored_0 = ((Object)object).length;
                        n2 = this.y.read((byte[])object, 0, (int)Math.min(8192L, i2));
                        if (n2 < 0) {
                            throw new EOFException(MessageLocalization.getComposedMessage("unexpected.eof"));
                        }
                        this.r.write((byte[])object, 0, n2);
                    }
                }
                if (this.s == null) break block30;
            }
            catch (Throwable throwable) {
                if (this.s != null) {
                    try {
                        this.y.close();
                    }
                    catch (Exception exception) {}
                    if (this.r != null) {
                        try {
                            this.s.delete();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (this.r != null) {
                    try {
                        this.r.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                this.y.close();
            }
            catch (Exception exception) {}
            if (this.r != null) {
                try {
                    this.s.delete();
                }
                catch (Exception exception) {}
            }
        }
        if (this.r != null) {
            try {
                this.r.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private void a(PdfDictionary pdfDictionary) {
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        PdfObject pdfObject = new PdfDictionary();
        ((PdfDictionary)pdfObject).put(PdfName.P, new PdfNumber(this.Q));
        ((PdfDictionary)pdfObject).put(PdfName.V, new PdfName("1.2"));
        ((PdfDictionary)pdfObject).put(PdfName.TYPE, PdfName.TRANSFORMPARAMS);
        pdfDictionary2.put(PdfName.TRANSFORMMETHOD, PdfName.DOCMDP);
        pdfDictionary2.put(PdfName.TYPE, PdfName.SIGREF);
        pdfDictionary2.put(PdfName.TRANSFORMPARAMS, pdfObject);
        pdfDictionary2.put(new PdfName("DigestValue"), new PdfString("aa"));
        pdfObject = new PdfArray();
        ((PdfArray)pdfObject).add(new PdfNumber(0));
        ((PdfArray)pdfObject).add(new PdfNumber(0));
        pdfDictionary2.put(new PdfName("DigestLocation"), pdfObject);
        pdfDictionary2.put(new PdfName("DigestMethod"), new PdfName("MD5"));
        pdfDictionary2.put(PdfName.DATA, this.e.a.getTrailer().get(PdfName.ROOT));
        pdfObject = new PdfArray();
        ((PdfArray)pdfObject).add(pdfDictionary2);
        pdfDictionary.put(PdfName.REFERENCE, pdfObject);
    }

    public InputStream getRangeStream() {
        return new a(this.y, this.z, this.x, 0);
    }

    public PdfDictionary getCryptoDictionary() {
        return this.t;
    }

    public void setCryptoDictionary(PdfDictionary pdfDictionary) {
        this.t = pdfDictionary;
    }

    public PdfStamper getStamper() {
        return this.u;
    }

    final void a(PdfStamper pdfStamper) {
        this.u = pdfStamper;
    }

    public boolean isPreClosed() {
        return this.v;
    }

    public PdfSigGenericPKCS getSigStandard() {
        return this.w;
    }

    public String getContact() {
        return this.I;
    }

    public void setContact(String string) {
        this.I = string;
    }

    public Font getLayer2Font() {
        return this.J;
    }

    public void setLayer2Font(Font font) {
        this.J = font;
    }

    public boolean isAcro6Layers() {
        return this.L;
    }

    public void setAcro6Layers(boolean bl2) {
        this.L = bl2;
    }

    public void setRunDirection(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.run.direction.1", n2));
        }
        this.M = n2;
    }

    public int getRunDirection() {
        return this.M;
    }

    public SignatureEvent getSignatureEvent() {
        return this.N;
    }

    public void setSignatureEvent(SignatureEvent signatureEvent) {
        this.N = signatureEvent;
    }

    public Image getImage() {
        return this.O;
    }

    public void setImage(Image image) {
        this.O = image;
    }

    public float getImageScale() {
        return this.P;
    }

    public void setImageScale(float f2) {
        this.P = f2;
    }

    public int getCertificationLevel() {
        return this.Q;
    }

    public void setCertificationLevel(int n2) {
        this.Q = n2;
    }

    public static interface SignatureEvent {
        public void getSignatureDictionary(PdfDictionary var1);
    }

    private static final class a
    extends InputStream {
        private final byte[] a = new byte[1];
        private final RandomAccessFile b;
        private final byte[] c;
        private final long[] d;
        private long e = 0L;

        private a(RandomAccessFile randomAccessFile, byte[] byArray, long[] lArray) {
            this.b = randomAccessFile;
            this.c = byArray;
            this.d = lArray;
        }

        @Override
        public final int read() {
            a a2 = this;
            int n2 = a2.read(a2.a);
            if (n2 != 1) {
                return -1;
            }
            return this.a[0] & 0xFF;
        }

        @Override
        public final int read(byte[] byArray, int n2, int n3) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            if (this.e >= this.d[this.d.length - 2] + this.d[this.d.length - 1]) {
                return -1;
            }
            for (int i2 = 0; i2 < this.d.length; i2 += 2) {
                long l2;
                long l3 = l2 = this.d[i2];
                if (this.d.length > i2 + 1) {
                    l3 = l2 + this.d[i2 + 1];
                }
                if (this.e < l2) {
                    this.e = l2;
                }
                if (this.e >= l3) continue;
                n3 = (int)Math.min((long)n3, l3 - this.e);
                if (this.b == null) {
                    System.arraycopy(this.c, (int)this.e, byArray, n2, n3);
                } else {
                    this.b.seek(this.e);
                    this.b.readFully(byArray, n2, n3);
                }
                this.e += (long)n3;
                return n3;
            }
            return -1;
        }

        /* synthetic */ a(RandomAccessFile randomAccessFile, byte[] byArray, long[] lArray, byte by) {
            this(randomAccessFile, byArray, lArray);
        }
    }
}

