/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfFunction;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;

public class PdfSpotColor {
    public PdfName name;
    public Color altcs;

    public PdfSpotColor(String string, Color color) {
        this.name = new PdfName(string);
        this.altcs = color;
    }

    public Color getAlternativeCS() {
        return this.altcs;
    }

    protected PdfObject getSpotObject(PdfWriter object) {
        PdfArray pdfArray;
        block5: {
            block4: {
                pdfArray = new PdfArray(PdfName.SEPARATION);
                pdfArray.add(this.name);
                if (!(this.altcs instanceof ExtendedColor)) break block4;
                int n2 = ((ExtendedColor)this.altcs).type;
                switch (n2) {
                    case 1: {
                        pdfArray.add(PdfName.DEVICEGRAY);
                        object = PdfFunction.type2((PdfWriter)object, new float[]{0.0f, 1.0f}, null, new float[]{0.0f}, new float[]{((GrayColor)this.altcs).getGray()}, 1.0f);
                        break block5;
                    }
                    case 2: {
                        pdfArray.add(PdfName.DEVICECMYK);
                        CMYKColor cMYKColor = (CMYKColor)this.altcs;
                        object = PdfFunction.type2((PdfWriter)object, new float[]{0.0f, 1.0f}, null, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, new float[]{cMYKColor.getCyan(), cMYKColor.getMagenta(), cMYKColor.getYellow(), cMYKColor.getBlack()}, 1.0f);
                        break block5;
                    }
                    default: {
                        throw new RuntimeException(MessageLocalization.getComposedMessage("only.rgb.gray.and.cmyk.are.supported.as.alternative.color.spaces"));
                    }
                }
            }
            pdfArray.add(PdfName.DEVICERGB);
            object = PdfFunction.type2((PdfWriter)object, new float[]{0.0f, 1.0f}, null, new float[]{1.0f, 1.0f, 1.0f}, new float[]{(float)this.altcs.getRed() / 255.0f, (float)this.altcs.getGreen() / 255.0f, (float)this.altcs.getBlue() / 255.0f}, 1.0f);
        }
        pdfArray.add(((PdfFunction)object).a());
        return pdfArray;
    }
}

