/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.OutputStreamCounter;
import com.lowagie.text.pdf.OutputStreamEncryption;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PdfStream
extends PdfDictionary {
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    protected boolean compressed = false;
    protected int compressionLevel = 0;
    protected ByteArrayOutputStream streamBytes = null;
    protected InputStream inputStream;
    protected PdfIndirectReference ref;
    protected long inputStreamLength = -1L;
    protected PdfWriter writer;
    protected long rawLength;
    static final byte[] g = DocWriter.getISOBytes("stream\n");
    static final byte[] h = DocWriter.getISOBytes("\nendstream");

    public PdfStream(byte[] byArray) {
        this.type = 7;
        this.bytes = byArray;
        this.rawLength = byArray.length;
        this.put(PdfName.LENGTH, new PdfNumber(byArray.length));
    }

    public PdfStream(InputStream inputStream, PdfWriter pdfWriter) {
        this.type = 7;
        this.inputStream = inputStream;
        this.writer = pdfWriter;
        this.ref = pdfWriter.getPdfIndirectReference();
        this.put(PdfName.LENGTH, this.ref);
    }

    protected PdfStream() {
        this.type = 7;
    }

    public void writeLength() {
        if (this.inputStream == null) {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("writelength.can.only.be.called.in.a.contructed.pdfstream.inputstream.pdfwriter"));
        }
        if (this.inputStreamLength == -1L) {
            throw new IOException(MessageLocalization.getComposedMessage("writelength.can.only.be.called.after.output.of.the.stream.body"));
        }
        this.writer.addToBody((PdfObject)new PdfNumber(this.inputStreamLength), this.ref, false);
    }

    public long getRawLength() {
        return this.rawLength;
    }

    public void flateCompress() {
        this.flateCompress(-1);
    }

    public void flateCompress(int n2) {
        if (!Document.compress) {
            return;
        }
        if (this.compressed) {
            return;
        }
        this.compressionLevel = n2;
        if (this.inputStream != null) {
            this.compressed = true;
            return;
        }
        PdfObject pdfObject = PdfReader.getPdfObject(this.get(PdfName.FILTER));
        if (pdfObject != null) {
            if (pdfObject.isName()) {
                if (PdfName.FLATEDECODE.equals(pdfObject)) {
                    return;
                }
            } else if (pdfObject.isArray()) {
                if (((PdfArray)pdfObject).contains(PdfName.FLATEDECODE)) {
                    return;
                }
            } else {
                throw new RuntimeException(MessageLocalization.getComposedMessage("stream.could.not.be.compressed.filter.is.not.a.name.or.array"));
            }
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Object object = new Deflater(n2);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, (Deflater)object);
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(deflaterOutputStream);
            } else {
                deflaterOutputStream.write(this.bytes);
            }
            deflaterOutputStream.close();
            ((Deflater)object).end();
            this.streamBytes = byteArrayOutputStream;
            this.bytes = null;
            this.put(PdfName.LENGTH, new PdfNumber(this.streamBytes.size()));
            if (pdfObject == null) {
                this.put(PdfName.FILTER, PdfName.FLATEDECODE);
            } else {
                object = new PdfArray(pdfObject);
                ((PdfArray)object).add(PdfName.FLATEDECODE);
                this.put(PdfName.FILTER, (PdfObject)object);
            }
            this.compressed = true;
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    protected void superToPdf(PdfWriter pdfWriter, OutputStream outputStream) {
        super.toPdf(pdfWriter, outputStream);
    }

    @Override
    public void toPdf(PdfWriter object, OutputStream outputStream) {
        Object object2;
        if (this.inputStream != null && this.compressed) {
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        }
        Object object3 = null;
        if (object != null) {
            object3 = ((PdfWriter)object).o();
        }
        if (object3 != null && (object2 = this.get(PdfName.FILTER)) != null) {
            PdfArray pdfArray;
            if (PdfName.CRYPT.equals(object2)) {
                object3 = null;
            } else if (((PdfObject)object2).isArray() && !(pdfArray = (PdfArray)object2).isEmpty() && PdfName.CRYPT.equals(pdfArray.getPdfObject(0))) {
                object3 = null;
            }
        }
        object2 = this.get(PdfName.LENGTH);
        if (object3 != null && object2 != null && ((PdfObject)object2).isNumber()) {
            int n2 = ((PdfNumber)object2).intValue();
            this.put(PdfName.LENGTH, new PdfNumber(((PdfEncryption)object3).calculateStreamSize(n2)));
            this.superToPdf((PdfWriter)object, outputStream);
            this.put(PdfName.LENGTH, (PdfObject)object2);
        } else {
            this.superToPdf((PdfWriter)object, outputStream);
        }
        outputStream.write(g);
        if (this.inputStream != null) {
            int n3;
            this.rawLength = 0L;
            DeflaterOutputStream deflaterOutputStream = null;
            object = new OutputStreamCounter(outputStream);
            object2 = null;
            Object object4 = object;
            if (object3 != null && !((PdfEncryption)object3).isEmbeddedFilesOnly()) {
                object4 = object2 = ((PdfEncryption)object3).getEncryptionStream((OutputStream)object4);
            }
            object3 = null;
            if (this.compressed) {
                object3 = new Deflater(this.compressionLevel);
                deflaterOutputStream = new DeflaterOutputStream((OutputStream)object4, (Deflater)object3, 32768);
                object4 = deflaterOutputStream;
            }
            byte[] byArray = new byte[4192];
            while ((n3 = this.inputStream.read(byArray)) > 0) {
                ((OutputStream)object4).write(byArray, 0, n3);
                this.rawLength += (long)n3;
            }
            if (deflaterOutputStream != null) {
                deflaterOutputStream.finish();
                ((Deflater)object3).end();
            }
            if (object2 != null) {
                ((OutputStreamEncryption)object2).finish();
            }
            this.inputStreamLength = ((OutputStreamCounter)object).getCounter();
        } else if (object3 != null && !((PdfEncryption)object3).isEmbeddedFilesOnly()) {
            byte[] byArray = this.streamBytes != null ? ((PdfEncryption)object3).encryptByteArray(this.streamBytes.toByteArray()) : ((PdfEncryption)object3).encryptByteArray(this.bytes);
            outputStream.write(byArray);
        } else if (this.streamBytes != null) {
            this.streamBytes.writeTo(outputStream);
        } else {
            outputStream.write(this.bytes);
        }
        outputStream.write(h);
    }

    public void writeContent(OutputStream outputStream) {
        if (this.streamBytes != null) {
            this.streamBytes.writeTo(outputStream);
            return;
        }
        if (this.bytes != null) {
            outputStream.write(this.bytes);
        }
    }

    @Override
    public String toString() {
        if (this.get(PdfName.TYPE) == null) {
            return "Stream";
        }
        return "Stream of type: " + this.get(PdfName.TYPE);
    }

    static {
        int cfr_ignored_0 = g.length;
        int cfr_ignored_1 = h.length;
    }
}

