/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class PdfString
extends PdfObject {
    protected String value = "";
    protected String originalValue = null;
    protected String encoding = "PDF";
    protected int objNum = 0;
    protected int objGen = 0;
    protected boolean hexWriting = false;

    public PdfString() {
        super(3);
    }

    public PdfString(String string) {
        super(3);
        this.value = string;
    }

    public PdfString(String string, String string2) {
        super(3);
        this.value = string;
        this.encoding = string2;
    }

    public PdfString(byte[] byArray) {
        super(3);
        this.value = PdfEncodings.convertToString(byArray, null);
        this.encoding = "";
    }

    @Override
    public void toPdf(PdfWriter object, OutputStream outputStream) {
        byte[] byArray = ((PdfObject)this).getBytes();
        PdfEncryption pdfEncryption = null;
        if (object != null) {
            pdfEncryption = ((PdfWriter)object).o();
        }
        if (pdfEncryption != null && !pdfEncryption.isEmbeddedFilesOnly()) {
            byArray = pdfEncryption.encryptByteArray(byArray);
        }
        if (this.hexWriting) {
            object = new ByteBuffer();
            ((ByteBuffer)object).append('<');
            int cfr_ignored_0 = byArray.length;
            for (byte by : byArray) {
                ((ByteBuffer)object).appendHex(by);
            }
            ((ByteBuffer)object).append('>');
            outputStream.write(((ByteBuffer)object).toByteArray());
            return;
        }
        outputStream.write(PdfContentByte.a(byArray));
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = this.encoding != null && this.encoding.equals("UnicodeBig") && PdfEncodings.isPdfDocEncoding(this.value) ? PdfEncodings.convertToBytes(this.value, "PDF") : PdfEncodings.convertToBytes(this.value, this.encoding);
        }
        return this.bytes;
    }

    public String toUnicodeString() {
        if (this.encoding != null && this.encoding.length() != 0) {
            return this.value;
        }
        ((PdfObject)this).getBytes();
        if (this.bytes.length >= 2 && this.bytes[0] == -2 && this.bytes[1] == -1) {
            return PdfEncodings.convertToString(this.bytes, "UnicodeBig");
        }
        return PdfEncodings.convertToString(this.bytes, "PDF");
    }

    public String getEncoding() {
        return this.encoding;
    }

    final void a(int n2, int n3) {
        this.objNum = n2;
        this.objGen = n3;
    }

    final void a(PdfReader object) {
        if ((object = ((PdfReader)object).a()) != null) {
            this.originalValue = this.value;
            ((PdfEncryption)object).setHashKey(this.objNum, this.objGen);
            this.bytes = PdfEncodings.convertToBytes(this.value, null);
            this.bytes = ((PdfEncryption)object).decryptByteArray(this.bytes);
            this.value = PdfEncodings.convertToString(this.bytes, null);
        }
    }

    public byte[] getOriginalBytes() {
        if (this.originalValue == null) {
            return ((PdfObject)this).getBytes();
        }
        return PdfEncodings.convertToBytes(this.originalValue, null);
    }

    public char[] getOriginalChars() {
        char[] cArray;
        if (this.encoding == null || this.encoding.length() == 0) {
            byte[] byArray = this.getOriginalBytes();
            cArray = new char[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                cArray[i2] = (char)(byArray[i2] & 0xFF);
            }
        } else if (this.encoding.equals("IDENTITY_H2")) {
            byte[] byArray = this.value.getBytes(StandardCharsets.ISO_8859_1);
            cArray = new char[byArray.length / 2];
            for (int i3 = 0; i3 < byArray.length / 2; ++i3) {
                cArray[i3] = (char)(((byArray[2 * i3] & 0xFF) << 8) + (byArray[2 * i3 + 1] & 0xFF));
            }
        } else if (this.encoding.equals("IDENTITY_H1")) {
            byte[] byArray = this.value.getBytes(StandardCharsets.ISO_8859_1);
            cArray = new char[byArray.length];
            for (int i4 = 0; i4 < byArray.length; ++i4) {
                cArray[i4] = (char)(byArray[i4] & 0xFF);
            }
        } else {
            cArray = new char[]{};
        }
        return cArray;
    }

    public PdfString setHexWriting(boolean bl2) {
        this.hexWriting = bl2;
        return this;
    }

    public boolean isHexWriting() {
        return this.hexWriting;
    }
}

