/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgJBIG2;
import com.lowagie.text.ImgWMF;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.OutputStreamCounter;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDeveloperExtension;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLayer;
import com.lowagie.text.pdf.PdfLayerMembership;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfOCProperties;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfPages;
import com.lowagie.text.pdf.PdfPattern;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfStructureTreeRoot;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfXConformanceException;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.text.pdf.SpotColor;
import com.lowagie.text.pdf.b;
import com.lowagie.text.pdf.collection.PdfCollection;
import com.lowagie.text.pdf.d;
import com.lowagie.text.pdf.events.PdfPageEventForwarder;
import com.lowagie.text.pdf.g;
import com.lowagie.text.pdf.interfaces.PdfAnnotations;
import com.lowagie.text.pdf.interfaces.PdfDocumentActions;
import com.lowagie.text.pdf.interfaces.PdfEncryptionSettings;
import com.lowagie.text.pdf.interfaces.PdfPageActions;
import com.lowagie.text.pdf.interfaces.PdfRunDirection;
import com.lowagie.text.pdf.interfaces.PdfVersion;
import com.lowagie.text.pdf.interfaces.PdfViewerPreferences;
import com.lowagie.text.pdf.interfaces.PdfXConformance;
import com.lowagie.text.pdf.internal.PdfVersionImp;
import com.lowagie.text.pdf.internal.PdfXConformanceImp;
import com.lowagie.text.pdf.k;
import com.lowagie.text.xml.xmp.XmpWriter;
import java.awt.Color;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class PdfWriter
extends DocWriter
implements PdfAnnotations,
PdfDocumentActions,
PdfEncryptionSettings,
PdfPageActions,
PdfRunDirection,
PdfVersion,
PdfViewerPreferences,
PdfXConformance {
    public static final int GENERATION_MAX = 65535;
    protected PdfDocument pdf;
    protected PdfContentByte directContent;
    protected PdfContentByte directContentUnder;
    protected PdfBody body;
    protected PdfDictionary extraCatalog;
    protected PdfPages root = new PdfPages(this);
    protected ArrayList<PdfIndirectReference> pageReferences = new ArrayList();
    protected int currentPageNumber = 1;
    protected PdfName tabs = null;
    private PdfPageEvent a;
    protected int prevxref = 0;
    protected List newBookmarks;
    public static final char VERSION_1_2 = '2';
    public static final char VERSION_1_3 = '3';
    public static final char VERSION_1_4 = '4';
    public static final char VERSION_1_5 = '5';
    public static final char VERSION_1_6 = '6';
    public static final char VERSION_1_7 = '7';
    public static final PdfName PDF_VERSION_1_2 = new PdfName("1.2");
    public static final PdfName PDF_VERSION_1_3 = new PdfName("1.3");
    public static final PdfName PDF_VERSION_1_4 = new PdfName("1.4");
    public static final PdfName PDF_VERSION_1_5 = new PdfName("1.5");
    public static final PdfName PDF_VERSION_1_6 = new PdfName("1.6");
    public static final PdfName PDF_VERSION_1_7 = new PdfName("1.7");
    protected PdfVersionImp pdf_version = new PdfVersionImp();
    public static final int PageLayoutSinglePage = 1;
    public static final int PageLayoutOneColumn = 2;
    public static final int PageLayoutTwoColumnLeft = 4;
    public static final int PageLayoutTwoColumnRight = 8;
    public static final int PageLayoutTwoPageLeft = 16;
    public static final int PageLayoutTwoPageRight = 32;
    public static final int PageModeUseNone = 64;
    public static final int PageModeUseOutlines = 128;
    public static final int PageModeUseThumbs = 256;
    public static final int PageModeFullScreen = 512;
    public static final int PageModeUseOC = 1024;
    public static final int PageModeUseAttachments = 2048;
    public static final int HideToolbar = 4096;
    public static final int HideMenubar = 8192;
    public static final int HideWindowUI = 16384;
    public static final int FitWindow = 32768;
    public static final int CenterWindow = 65536;
    public static final int DisplayDocTitle = 131072;
    public static final int NonFullScreenPageModeUseNone = 262144;
    public static final int NonFullScreenPageModeUseOutlines = 524288;
    public static final int NonFullScreenPageModeUseThumbs = 0x100000;
    public static final int NonFullScreenPageModeUseOC = 0x200000;
    public static final int DirectionL2R = 0x400000;
    public static final int DirectionR2L = 0x800000;
    public static final int PrintScalingNone = 0x1000000;
    public static final PdfName DOCUMENT_CLOSE = PdfName.WC;
    public static final PdfName WILL_SAVE = PdfName.WS;
    public static final PdfName DID_SAVE = PdfName.DS;
    public static final PdfName WILL_PRINT = PdfName.WP;
    public static final PdfName DID_PRINT = PdfName.DP;
    public static final int SIGNATURE_EXISTS = 1;
    public static final int SIGNATURE_APPEND_ONLY = 2;
    protected byte[] xmpMetadata = null;
    public static final int PDFXNONE = 0;
    public static final int PDFX1A2001 = 1;
    public static final int PDFX32002 = 2;
    public static final int PDFA1A = 3;
    public static final int PDFA1B = 4;
    private PdfXConformanceImp b = new PdfXConformanceImp();
    public static final int STANDARD_ENCRYPTION_40 = 0;
    public static final int STANDARD_ENCRYPTION_128 = 1;
    public static final int ENCRYPTION_AES_128 = 2;
    public static final int DO_NOT_ENCRYPT_METADATA = 8;
    public static final int EMBEDDED_FILES_ONLY = 24;
    public static final int ALLOW_PRINTING = 2052;
    public static final int ALLOW_MODIFY_CONTENTS = 8;
    public static final int ALLOW_COPY = 16;
    public static final int ALLOW_MODIFY_ANNOTATIONS = 32;
    public static final int ALLOW_FILL_IN = 256;
    public static final int ALLOW_SCREENREADERS = 512;
    public static final int ALLOW_ASSEMBLY = 1024;
    public static final int ALLOW_DEGRADED_PRINTING = 4;
    public static final int AllowPrinting = 2052;
    public static final int AllowModifyContents = 8;
    public static final int AllowCopy = 16;
    public static final int AllowModifyAnnotations = 32;
    public static final int AllowFillIn = 256;
    public static final int AllowScreenReaders = 512;
    public static final int AllowAssembly = 1024;
    public static final int AllowDegradedPrinting = 4;
    public static final boolean STRENGTH40BITS = false;
    public static final boolean STRENGTH128BITS = true;
    protected PdfEncryption crypto;
    protected boolean fullCompression = false;
    protected int compressionLevel = -1;
    protected LinkedHashMap<BaseFont, d> documentFonts = new LinkedHashMap();
    protected int fontNumber = 1;
    protected LinkedHashMap<PdfIndirectReference, Object[]> formXObjects = new LinkedHashMap();
    protected int formXObjectsCounter = 1;
    protected HashMap<PdfReader, k> importedPages = new HashMap();
    protected k currentPdfReaderInstance;
    protected HashMap<PdfSpotColor, b> documentColors = new HashMap();
    protected int colorNumber = 1;
    protected HashMap<PdfPatternPainter, PdfName> documentPatterns = new HashMap();
    protected int patternNumber = 1;
    protected HashMap<PdfShadingPattern, Object> documentShadingPatterns = new HashMap();
    protected HashMap<PdfShading, Object> documentShadings = new HashMap();
    protected HashMap<PdfDictionary, PdfObject[]> documentExtGState = new LinkedHashMap<PdfDictionary, PdfObject[]>();
    protected HashMap<Object, PdfObject[]> documentProperties = new HashMap();
    protected boolean tagged = false;
    protected PdfStructureTreeRoot structureTreeRoot;
    protected Set<PdfOCG> documentOCG = new HashSet<PdfOCG>();
    protected List<PdfOCG> documentOCGorder = new ArrayList<PdfOCG>();
    protected PdfOCProperties OCProperties;
    protected PdfArray OCGRadioGroup = new PdfArray();
    protected PdfArray OCGLocked = new PdfArray();
    public static final PdfName PAGE_OPEN = PdfName.O;
    public static final PdfName PAGE_CLOSE = PdfName.C;
    protected PdfDictionary group;
    public static final float SPACE_CHAR_RATIO_DEFAULT = 2.5f;
    public static final float NO_SPACE_CHAR_RATIO = 1.0E7f;
    private float c = 2.5f;
    public static final int RUN_DIRECTION_DEFAULT = 0;
    public static final int RUN_DIRECTION_NO_BIDI = 1;
    public static final int RUN_DIRECTION_LTR = 2;
    public static final int RUN_DIRECTION_RTL = 3;
    protected int runDirection = 1;
    protected float userunit = 0.0f;
    protected PdfDictionary defaultColorspace = new PdfDictionary();
    protected HashMap<b, b> documentSpotPatterns = new HashMap();
    protected b patternColorspaceRGB;
    protected b patternColorspaceGRAY;
    protected b patternColorspaceCMYK;
    protected PdfDictionary imageDictionary = new PdfDictionary();
    private HashMap<Long, PdfName> d = new HashMap();
    protected HashMap<PdfStream, PdfIndirectReference> JBIG2Globals = new HashMap();
    private boolean e;
    private boolean f;

    protected PdfWriter() {
    }

    protected PdfWriter(PdfDocument pdfDocument, OutputStream outputStream) {
        super(pdfDocument, outputStream);
        this.pdf = pdfDocument;
        this.directContent = new PdfContentByte(this);
        this.directContentUnder = new PdfContentByte(this);
    }

    public static PdfWriter getInstance(Document docListener, OutputStream outputStream) {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.setDocumentLanguage(docListener.getDocumentLanguage());
        docListener.addDocListener(pdfDocument);
        docListener = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter((PdfWriter)docListener);
        return docListener;
    }

    public static PdfWriter getInstance(Document docListener, OutputStream outputStream, DocListener docListener2) {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.setDocumentLanguage(docListener.getDocumentLanguage());
        pdfDocument.addDocListener(docListener2);
        docListener.addDocListener(pdfDocument);
        docListener = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter((PdfWriter)docListener);
        return docListener;
    }

    final PdfDocument i() {
        return this.pdf;
    }

    public PdfDictionary getInfo() {
        return this.pdf.getInfo();
    }

    public float getVerticalPosition(boolean bl2) {
        return this.pdf.getVerticalPosition(bl2);
    }

    public void setInitialLeading(float f2) {
        if (this.open) {
            throw new DocumentException(MessageLocalization.getComposedMessage("you.can.t.set.the.initial.leading.if.the.document.is.already.open"));
        }
        this.pdf.a(f2);
    }

    public PdfContentByte getDirectContent() {
        if (!this.open) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("the.document.is.not.open"));
        }
        return this.directContent;
    }

    public PdfContentByte getDirectContentUnder() {
        if (!this.open) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("the.document.is.not.open"));
        }
        return this.directContentUnder;
    }

    final void j() {
        this.directContent.reset();
        this.directContentUnder.reset();
    }

    public PdfIndirectObject addToBody(PdfObject object) {
        object = this.body.a((PdfObject)object);
        return object;
    }

    public PdfIndirectObject addToBody(PdfObject object, boolean bl2) {
        boolean bl3 = bl2;
        PdfObject pdfObject = object;
        object = this.body;
        object = ((PdfBody)object).a(pdfObject, ((PdfBody)object).b(), bl3);
        return object;
    }

    public PdfIndirectObject addToBody(PdfObject object, PdfIndirectReference pdfIndirectReference) {
        object = this.body.a((PdfObject)object, pdfIndirectReference);
        return object;
    }

    public PdfIndirectObject addToBody(PdfObject object, PdfIndirectReference pdfObject, boolean bl2) {
        boolean bl3 = bl2;
        PdfIndirectReference pdfIndirectReference = pdfObject;
        pdfObject = object;
        object = this.body;
        object = ((PdfBody)object).a(pdfObject, pdfIndirectReference.getNumber(), bl3);
        return object;
    }

    public PdfIndirectObject addToBody(PdfObject object, int n2) {
        object = this.body.a((PdfObject)object, n2);
        return object;
    }

    public PdfIndirectObject addToBody(PdfObject object, int n2, boolean bl2) {
        object = this.body.a((PdfObject)object, n2, bl2);
        return object;
    }

    public PdfIndirectReference getPdfIndirectReference() {
        return this.body.a();
    }

    final int k() {
        return this.body.b();
    }

    final OutputStreamCounter l() {
        return this.os;
    }

    protected PdfDictionary getCatalog(PdfIndirectReference pdfObject) {
        pdfObject = this.pdf.a((PdfIndirectReference)pdfObject);
        if (this.tagged) {
            try {
                this.getStructureTreeRoot().a();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            ((PdfDictionary)pdfObject).put(PdfName.STRUCTTREEROOT, this.structureTreeRoot.getReference());
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(PdfName.MARKED, PdfBoolean.PDFTRUE);
            if (this.e) {
                pdfDictionary.put(PdfName.USERPROPERTIES, PdfBoolean.PDFTRUE);
            }
            ((PdfDictionary)pdfObject).put(PdfName.MARKINFO, pdfDictionary);
        }
        if (!this.documentOCG.isEmpty()) {
            this.fillOCProperties(false);
            ((PdfDictionary)pdfObject).put(PdfName.OCPROPERTIES, this.OCProperties);
        }
        return pdfObject;
    }

    public PdfDictionary getExtraCatalog() {
        if (this.extraCatalog == null) {
            this.extraCatalog = new PdfDictionary();
        }
        return this.extraCatalog;
    }

    public void setLinearPageMode() {
        this.root.b(null);
    }

    public int reorderPages(int[] nArray) {
        return this.root.a(nArray);
    }

    public PdfIndirectReference getPageReference(int n2) {
        PdfIndirectReference pdfIndirectReference;
        if (--n2 < 0) {
            throw new IndexOutOfBoundsException(MessageLocalization.getComposedMessage("the.page.number.must.be.gt.eq.1"));
        }
        if (n2 < this.pageReferences.size()) {
            pdfIndirectReference = this.pageReferences.get(n2);
            if (pdfIndirectReference == null) {
                pdfIndirectReference = this.body.a();
                this.pageReferences.set(n2, pdfIndirectReference);
            }
        } else {
            n2 -= this.pageReferences.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.pageReferences.add(null);
            }
            pdfIndirectReference = this.body.a();
            this.pageReferences.add(pdfIndirectReference);
        }
        return pdfIndirectReference;
    }

    public int getPageNumber() {
        return this.pdf.getPageNumber();
    }

    final PdfIndirectReference m() {
        PdfWriter pdfWriter = this;
        return pdfWriter.getPageReference(pdfWriter.currentPageNumber);
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void setTabs(PdfName pdfName) {
        this.tabs = pdfName;
    }

    public PdfName getTabs() {
        return this.tabs;
    }

    PdfIndirectReference a(PdfPage pdfPage, g object) {
        if (!this.open) {
            throw new PdfException(MessageLocalization.getComposedMessage("the.document.is.not.open"));
        }
        try {
            object = this.addToBody((PdfObject)object);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        PdfIndirectReference pdfIndirectReference = ((PdfIndirectObject)object).getIndirectReference();
        object = pdfPage;
        ((PdfDictionary)object).put(PdfName.CONTENTS, pdfIndirectReference);
        if (this.group != null) {
            pdfPage.put(PdfName.GROUP, this.group);
            this.group = null;
        } else if (this.f) {
            object = new PdfDictionary();
            ((PdfDictionary)object).put(PdfName.TYPE, PdfName.GROUP);
            ((PdfDictionary)object).put(PdfName.S, PdfName.TRANSPARENCY);
            ((PdfDictionary)object).put(PdfName.CS, PdfName.DEVICERGB);
            pdfPage.put(PdfName.GROUP, (PdfObject)object);
        }
        this.root.a(pdfPage);
        ++this.currentPageNumber;
        return null;
    }

    public void setPageEvent(PdfPageEvent pdfPageEvent) {
        if (pdfPageEvent == null) {
            this.a = null;
            return;
        }
        if (this.a == null) {
            this.a = pdfPageEvent;
            return;
        }
        if (this.a instanceof PdfPageEventForwarder) {
            ((PdfPageEventForwarder)this.a).addPageEvent(pdfPageEvent);
            return;
        }
        PdfPageEventForwarder pdfPageEventForwarder = new PdfPageEventForwarder();
        pdfPageEventForwarder.addPageEvent(this.a);
        pdfPageEventForwarder.addPageEvent(pdfPageEvent);
        this.a = pdfPageEventForwarder;
    }

    public PdfPageEvent getPageEvent() {
        return this.a;
    }

    @Override
    public void open() {
        super.open();
        try {
            this.pdf_version.writeHeader(this.os);
            this.body = new PdfBody(this);
            if (this.b.isPdfX32002()) {
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.GAMMA, new PdfArray(new float[]{2.2f, 2.2f, 2.2f}));
                pdfDictionary.put(PdfName.MATRIX, new PdfArray(new float[]{0.4124f, 0.2126f, 0.0193f, 0.3576f, 0.7152f, 0.1192f, 0.1805f, 0.0722f, 0.9505f}));
                pdfDictionary.put(PdfName.WHITEPOINT, new PdfArray(new float[]{0.9505f, 1.0f, 1.089f}));
                PdfArray pdfArray = new PdfArray(PdfName.CALRGB);
                pdfArray.add(pdfDictionary);
                this.setDefaultColorspace(PdfName.DEFAULTRGB, this.addToBody(pdfArray).getIndirectReference());
            }
            return;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    @Override
    public void close() {
        if (this.open) {
            if (this.currentPageNumber - 1 != this.pageReferences.size()) {
                throw new RuntimeException("The page " + this.pageReferences.size() + " was requested but the document has only " + (this.currentPageNumber - 1) + " pages.");
            }
            try {
                PdfObject pdfObject;
                Object object;
                Object object2;
                this.addSharedObjectsToBody();
                Object object3 = this.root.a();
                object3 = this.getCatalog((PdfIndirectReference)object3);
                if (this.xmpMetadata != null) {
                    object2 = new PdfStream(this.xmpMetadata);
                    ((PdfDictionary)object2).put(PdfName.TYPE, PdfName.METADATA);
                    ((PdfDictionary)object2).put(PdfName.SUBTYPE, PdfName.XML);
                    if (this.crypto != null && !this.crypto.isMetadataEncrypted()) {
                        object = new PdfArray();
                        ((PdfArray)object).add(PdfName.CRYPT);
                        ((PdfDictionary)object2).put(PdfName.FILTER, (PdfObject)object);
                    }
                    ((PdfDictionary)object3).put(PdfName.METADATA, this.body.a((PdfObject)object2).getIndirectReference());
                }
                if (this.isPdfX()) {
                    this.b.completeInfoDictionary(this.getInfo());
                    this.b.completeExtraCatalog(this.getExtraCatalog());
                }
                if (this.extraCatalog != null) {
                    ((PdfDictionary)object3).mergeDifferent(this.extraCatalog);
                }
                this.writeOutlines((PdfDictionary)object3, false);
                object2 = this.addToBody((PdfObject)object3, false);
                PdfWriter pdfWriter = this;
                object = pdfWriter.addToBody((PdfObject)pdfWriter.getInfo(), false);
                object3 = null;
                this.body.e();
                if (this.crypto != null) {
                    PdfWriter pdfWriter2 = this;
                    object3 = pdfWriter2.addToBody((PdfObject)pdfWriter2.crypto.getEncryptionDictionary(), false);
                    object3 = ((PdfIndirectObject)object3).getIndirectReference();
                    pdfObject = this.crypto.getFileID();
                } else {
                    pdfObject = this.getInfo().contains(PdfName.FILEID) ? this.getInfo().get(PdfName.FILEID) : PdfEncryption.createInfoId(PdfEncryption.createDocumentId());
                }
                this.body.a(this.os, ((PdfIndirectObject)object2).getIndirectReference(), ((PdfIndirectObject)object).getIndirectReference(), (PdfIndirectReference)object3, pdfObject, this.prevxref);
                this.os.write(PdfWriter.getISOBytes("startxref\n"));
                this.os.write(PdfWriter.getISOBytes(String.valueOf(this.body.c())));
                this.os.write(PdfWriter.getISOBytes("\n%%EOF\n"));
                super.close();
                return;
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
    }

    protected void addSharedObjectsToBody() {
        Object object;
        for (d object2 : this.documentFonts.values()) {
            object2.a(this);
        }
        for (Object[] objectArray : this.formXObjects.values()) {
            object = (PdfTemplate)objectArray[1];
            if (object != null && ((PdfTemplate)object).getIndirectReference() instanceof PRIndirectReference || object == null || ((PdfTemplate)object).getType() != 1) continue;
            this.addToBody((PdfObject)((PdfTemplate)object).a(this.compressionLevel), ((PdfTemplate)object).getIndirectReference());
        }
        Iterator<Object> iterator = this.importedPages.values().iterator();
        while (iterator.hasNext()) {
            k k2;
            this.currentPdfReaderInstance = k2 = (k)iterator.next();
            this.currentPdfReaderInstance.a();
        }
        this.currentPdfReaderInstance = null;
        iterator = this.documentColors.values().iterator();
        while (iterator.hasNext()) {
            b b2;
            b b3 = b2 = (b)iterator.next();
            this.addToBody(b2.a(this), b3.a);
        }
        for (PdfPatternPainter pdfPatternPainter : this.documentPatterns.keySet()) {
            int n2 = this.compressionLevel;
            object = pdfPatternPainter;
            this.addToBody((PdfObject)new PdfPattern((PdfPatternPainter)object, n2), pdfPatternPainter.getIndirectReference());
        }
        for (PdfShadingPattern pdfShadingPattern : this.documentShadingPatterns.keySet()) {
            pdfShadingPattern.c();
        }
        for (PdfShading pdfShading : this.documentShadings.keySet()) {
            pdfShading.c();
        }
        for (Map.Entry entry : this.documentExtGState.entrySet()) {
            object = (PdfDictionary)entry.getKey();
            PdfObject[] pdfObjectArray = (PdfObject[])entry.getValue();
            this.addToBody((PdfObject)object, (PdfIndirectReference)pdfObjectArray[1]);
        }
        for (Map.Entry entry : this.documentProperties.entrySet()) {
            object = entry.getKey();
            PdfObject[] pdfObjectArray = (PdfObject[])entry.getValue();
            if (object instanceof PdfLayerMembership) {
                PdfLayerMembership pdfLayerMembership = (PdfLayerMembership)object;
                this.addToBody(pdfLayerMembership.getPdfObject(), pdfLayerMembership.getRef());
                continue;
            }
            if (!(object instanceof PdfDictionary) || object instanceof PdfLayer) continue;
            this.addToBody((PdfObject)((PdfDictionary)object), (PdfIndirectReference)pdfObjectArray[1]);
        }
        for (PdfOCG pdfOCG : this.documentOCG) {
            this.addToBody(pdfOCG.getPdfObject(), pdfOCG.getRef());
        }
    }

    public PdfOutline getRootOutline() {
        return this.directContent.getRootOutline();
    }

    public void setOutlines(List list) {
        this.newBookmarks = list;
    }

    protected void writeOutlines(PdfDictionary pdfDictionary, boolean bl2) {
        if (this.newBookmarks == null || this.newBookmarks.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        PdfIndirectReference pdfIndirectReference = this.getPdfIndirectReference();
        Object[] objectArray = SimpleBookmark.iterateOutlines(this, pdfIndirectReference, this.newBookmarks, bl2);
        pdfDictionary2.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
        pdfDictionary2.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
        pdfDictionary2.put(PdfName.COUNT, new PdfNumber((Integer)objectArray[2]));
        this.addToBody((PdfObject)pdfDictionary2, pdfIndirectReference);
        pdfDictionary.put(PdfName.OUTLINES, pdfIndirectReference);
    }

    @Override
    public void setPdfVersion(char c2) {
        this.pdf_version.setPdfVersion(c2);
    }

    @Override
    public void setAtLeastPdfVersion(char c2) {
        this.pdf_version.setAtLeastPdfVersion(c2);
    }

    @Override
    public void setPdfVersion(PdfName pdfName) {
        this.pdf_version.setPdfVersion(pdfName);
    }

    @Override
    public void addDeveloperExtension(PdfDeveloperExtension pdfDeveloperExtension) {
        this.pdf_version.addDeveloperExtension(pdfDeveloperExtension);
    }

    final PdfVersionImp n() {
        return this.pdf_version;
    }

    @Override
    public void setViewerPreferences(int n2) {
        this.pdf.a(n2);
    }

    @Override
    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.pdf.a(pdfName, pdfObject);
    }

    public void setPageLabels(PdfPageLabels pdfPageLabels) {
        this.pdf.a(pdfPageLabels);
    }

    public void addNamedDestinations(Map<String, String> entry, int n2) {
        for (Map.Entry<String, String> entry2 : entry.entrySet()) {
            entry = entry2;
            entry = entry2;
            Object object = entry2.getValue();
            int n3 = Integer.parseInt(((String)object).substring(0, ((String)object).indexOf(" ")));
            String string = object;
            object = new PdfDestination(string.substring(string.indexOf(" ") + 1));
            this.addNamedDestination(entry.getKey(), n3 + n2, (PdfDestination)object);
        }
    }

    public void addNamedDestination(String string, int n2, PdfDestination pdfDestination) {
        pdfDestination.addPage(this.getPageReference(n2));
        this.pdf.a(string, pdfDestination);
    }

    public void addJavaScript(PdfAction pdfAction) {
        this.pdf.a(pdfAction);
    }

    public void addJavaScript(String string, boolean bl2) {
        this.addJavaScript(PdfAction.javaScript(string, this, bl2));
    }

    public void addJavaScript(String string) {
        this.addJavaScript(string, false);
    }

    public void addJavaScript(String string, PdfAction pdfAction) {
        this.pdf.a(string, pdfAction);
    }

    public void addJavaScript(String string, String string2, boolean bl2) {
        this.addJavaScript(string, PdfAction.javaScript(string2, this, bl2));
    }

    public void addJavaScript(String string, String string2) {
        this.addJavaScript(string, string2, false);
    }

    public void addFileAttachment(String string, byte[] byArray, String string2, String string3) {
        this.addFileAttachment(string, PdfFileSpecification.fileEmbedded(this, string2, string3, byArray));
    }

    public void addFileAttachment(String string, PdfFileSpecification pdfFileSpecification) {
        this.pdf.a(string, pdfFileSpecification);
    }

    public void addFileAttachment(PdfFileSpecification pdfFileSpecification) {
        this.addFileAttachment(null, pdfFileSpecification);
    }

    @Override
    public void setOpenAction(String string) {
        this.pdf.a(string);
    }

    @Override
    public void setOpenAction(PdfAction pdfAction) {
        this.pdf.b(pdfAction);
    }

    @Override
    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new DocumentException(MessageLocalization.getComposedMessage("invalid.additional.action.type.1", pdfName.toString()));
        }
        this.pdf.a(pdfName, pdfAction);
    }

    public void setCollection(PdfCollection pdfCollection) {
        this.setAtLeastPdfVersion('7');
        this.pdf.setCollection(pdfCollection);
    }

    @Override
    public PdfAcroForm getAcroForm() {
        PdfDocument pdfDocument = this.pdf;
        return pdfDocument.a.getAcroForm();
    }

    @Override
    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        this.pdf.a(pdfAnnotation);
    }

    void a(PdfAnnotation pdfAnnotation, int n2) {
        this.addAnnotation(pdfAnnotation);
    }

    @Override
    public void addCalculationOrder(PdfFormField object) {
        PdfFormField pdfFormField = object;
        object = this.pdf;
        ((PdfDocument)object).a.addCalculationOrder(pdfFormField);
    }

    @Override
    public void setSigFlags(int n2) {
        int n3 = n2;
        PdfDocument pdfDocument = this.pdf;
        pdfDocument.a.setSigFlags(n3);
    }

    public void setXmpMetadata(byte[] byArray) {
        this.xmpMetadata = byArray;
    }

    public void setPageXmpMetadata(byte[] byArray) {
        this.pdf.setXmpMetadata(byArray);
    }

    public void createXmpMetadata() {
        PdfWriter pdfWriter = this;
        pdfWriter.setXmpMetadata(pdfWriter.a());
    }

    private byte[] a() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XmpWriter xmpWriter = new XmpWriter((OutputStream)byteArrayOutputStream, this.pdf.getInfo(), this.b.getPDFXConformance());
            xmpWriter.close();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void setPDFXConformance(int n2) {
        if (this.b.getPDFXConformance() == n2) {
            return;
        }
        if (this.pdf.isOpen()) {
            throw new PdfXConformanceException(MessageLocalization.getComposedMessage("pdfx.conformance.can.only.be.set.before.opening.the.document"));
        }
        if (this.crypto != null) {
            throw new PdfXConformanceException(MessageLocalization.getComposedMessage("a.pdfx.conforming.document.cannot.be.encrypted"));
        }
        if (n2 == 3 || n2 == 4) {
            this.setPdfVersion('4');
        } else if (n2 != 0) {
            this.setPdfVersion('3');
        }
        this.b.setPDFXConformance(n2);
    }

    @Override
    public int getPDFXConformance() {
        return this.b.getPDFXConformance();
    }

    @Override
    public boolean isPdfX() {
        return this.b.isPdfX();
    }

    public void setOutputIntents(String object, String string, String string2, String string3, ICC_Profile iCC_Profile) {
        this.getExtraCatalog();
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.OUTPUTINTENT);
        if (string != null) {
            pdfDictionary.put(PdfName.OUTPUTCONDITION, new PdfString(string, "UnicodeBig"));
        }
        if (object != null) {
            pdfDictionary.put(PdfName.OUTPUTCONDITIONIDENTIFIER, new PdfString((String)object, "UnicodeBig"));
        }
        if (string2 != null) {
            pdfDictionary.put(PdfName.REGISTRYNAME, new PdfString(string2, "UnicodeBig"));
        }
        if (string3 != null) {
            pdfDictionary.put(PdfName.INFO, new PdfString(string3, "UnicodeBig"));
        }
        if (iCC_Profile != null) {
            object = new PdfICCBased(iCC_Profile, this.compressionLevel);
            pdfDictionary.put(PdfName.DESTOUTPUTPROFILE, this.addToBody((PdfObject)object).getIndirectReference());
        }
        object = this.b.isPdfA1() || "PDFA/1".equals(string) ? PdfName.GTS_PDFA1 : PdfName.GTS_PDFX;
        pdfDictionary.put(PdfName.S, (PdfObject)object);
        this.extraCatalog.put(PdfName.OUTPUTINTENTS, new PdfArray(pdfDictionary));
    }

    public void setOutputIntents(String string, String string2, String string3, String string4, byte[] object) {
        object = object == null ? null : ICC_Profile.getInstance(object);
        this.setOutputIntents(string, string2, string3, string4, (ICC_Profile)object);
    }

    public boolean setOutputIntents(PdfReader object, boolean bl2) {
        object = ((PdfReader)object).getCatalog();
        if ((object = ((PdfDictionary)object).getAsArray(PdfName.OUTPUTINTENTS)) == null) {
            return false;
        }
        if (((PdfArray)object).isEmpty()) {
            return false;
        }
        Object object2 = PdfReader.getPdfObject(((PdfDictionary)(object = ((PdfArray)object).getAsDict(0))).get(PdfName.S));
        if (!PdfName.GTS_PDFX.equals(object2)) {
            return false;
        }
        if (bl2) {
            return true;
        }
        PRStream pRStream = (PRStream)PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.DESTOUTPUTPROFILE));
        object2 = null;
        if (pRStream != null) {
            object2 = PdfReader.getStreamBytes(pRStream);
        }
        this.setOutputIntents(PdfWriter.a((PdfDictionary)object, PdfName.OUTPUTCONDITIONIDENTIFIER), PdfWriter.a((PdfDictionary)object, PdfName.OUTPUTCONDITION), PdfWriter.a((PdfDictionary)object, PdfName.REGISTRYNAME), PdfWriter.a((PdfDictionary)object, PdfName.INFO), (byte[])object2);
        return true;
    }

    private static String a(PdfDictionary pdfObject, PdfName pdfName) {
        if ((pdfObject = PdfReader.getPdfObject(((PdfDictionary)pdfObject).get(pdfName))) == null || !pdfObject.isString()) {
            return null;
        }
        return ((PdfString)pdfObject).toUnicodeString();
    }

    final PdfEncryption o() {
        return this.crypto;
    }

    @Override
    public void setEncryption(byte[] byArray, byte[] byArray2, int n2, int n3) {
        if (this.pdf.isOpen()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("encryption.can.only.be.added.before.opening.the.document"));
        }
        this.crypto = new PdfEncryption();
        this.crypto.setCryptoMode(n3, 0);
        this.crypto.setupAllKeys(byArray, byArray2, n2);
    }

    @Override
    public void setEncryption(Certificate[] certificateArray, int[] nArray, int n2) {
        if (this.pdf.isOpen()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("encryption.can.only.be.added.before.opening.the.document"));
        }
        this.crypto = new PdfEncryption();
        if (certificateArray != null) {
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                this.crypto.addRecipient(certificateArray[i2], nArray[i2]);
            }
        }
        this.crypto.setCryptoMode(n2, 0);
        this.crypto.getEncryptionDictionary();
    }

    public void setEncryption(byte[] byArray, byte[] byArray2, int n2, boolean bl2) {
        this.setEncryption(byArray, byArray2, n2, bl2 ? 1 : 0);
    }

    public void setEncryption(boolean bl2, String string, String string2, int n2) {
        this.setEncryption(PdfWriter.getISOBytes(string), PdfWriter.getISOBytes(string2), n2, bl2 ? 1 : 0);
    }

    public void setEncryption(int n2, String string, String string2, int n3) {
        this.setEncryption(PdfWriter.getISOBytes(string), PdfWriter.getISOBytes(string2), n3, n2);
    }

    public boolean isFullCompression() {
        return this.fullCompression;
    }

    public void setFullCompression() {
        this.fullCompression = true;
        this.setAtLeastPdfVersion('5');
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int n2) {
        if (n2 < 0 || n2 > 9) {
            this.compressionLevel = -1;
            return;
        }
        this.compressionLevel = n2;
    }

    final d a(BaseFont baseFont) {
        if (baseFont.getFontType() == 4) {
            return new d(new PdfName("F" + this.fontNumber++), ((DocumentFont)baseFont).a(), baseFont);
        }
        d d2 = this.documentFonts.get(baseFont);
        if (d2 == null) {
            PdfXConformanceImp.checkPDFXConformance(this, 4, baseFont);
            d2 = new d(new PdfName("F" + this.fontNumber++), this.body.a(), baseFont);
            this.documentFonts.put(baseFont, d2);
        }
        return d2;
    }

    final void a(PdfDictionary pdfDictionary) {
        Iterator<d> iterator = this.documentFonts.values().iterator();
        while (iterator.hasNext()) {
            d d2;
            d d3 = d2 = iterator.next();
            if (pdfDictionary.get(d3.b) == null) continue;
            d2.a(false);
        }
    }

    final PdfName a(PdfTemplate pdfTemplate, PdfName pdfName) {
        PdfIndirectReference pdfIndirectReference = pdfTemplate.getIndirectReference();
        Object object = this.formXObjects.get(pdfIndirectReference);
        try {
            if (object == null) {
                if (pdfName == null) {
                    pdfName = new PdfName("Xf" + this.formXObjectsCounter);
                    ++this.formXObjectsCounter;
                }
                if (pdfTemplate.getType() == 2) {
                    pdfTemplate = (PdfImportedPage)pdfTemplate;
                    object = pdfTemplate;
                    object = ((PdfImportedPage)pdfTemplate).a;
                    object = object.c;
                    if (!this.importedPages.containsKey(object)) {
                        Object object2 = object;
                        object = pdfTemplate;
                        this.importedPages.put((PdfReader)object2, object.a);
                    }
                    pdfTemplate = null;
                }
                this.formXObjects.put(pdfIndirectReference, new Object[]{pdfName, pdfTemplate});
            } else {
                pdfName = (PdfName)object[0];
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName;
    }

    public void releaseTemplate(PdfTemplate objectArray) {
        objectArray = objectArray.getIndirectReference();
        if ((objectArray = this.formXObjects.get(objectArray)) == null || objectArray[1] == null) {
            return;
        }
        PdfTemplate pdfTemplate = (PdfTemplate)objectArray[1];
        if (pdfTemplate.getIndirectReference() instanceof PRIndirectReference) {
            return;
        }
        if (pdfTemplate.getType() == 1) {
            this.addToBody((PdfObject)pdfTemplate.a(this.compressionLevel), pdfTemplate.getIndirectReference());
            objectArray[1] = null;
        }
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n2) {
        k k2 = this.importedPages.get(pdfReader);
        if (k2 == null) {
            k2 = pdfReader.getPdfReaderInstance(this);
            this.importedPages.put(pdfReader, k2);
        }
        return k2.a(n2);
    }

    public void freeReader(PdfReader pdfReader) {
        this.currentPdfReaderInstance = this.importedPages.get(pdfReader);
        if (this.currentPdfReaderInstance == null) {
            return;
        }
        this.currentPdfReaderInstance.a();
        this.currentPdfReaderInstance = null;
        this.importedPages.remove(pdfReader);
    }

    public long getCurrentDocumentSize() {
        return this.body.c() + (long)this.body.d() * 20L + 72L;
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n2, int n3) {
        if (this.currentPdfReaderInstance == null && this.importedPages.get(pdfReader) == null) {
            PdfReader pdfReader2 = pdfReader;
            this.importedPages.put(pdfReader2, pdfReader2.getPdfReaderInstance(this));
        }
        this.currentPdfReaderInstance = this.importedPages.get(pdfReader);
        int n4 = this.currentPdfReaderInstance.b(n2);
        this.currentPdfReaderInstance = null;
        return n4;
    }

    final PdfName p() {
        return new PdfName("CS" + this.colorNumber++);
    }

    final b a(PdfSpotColor pdfSpotColor) {
        b b2 = this.documentColors.get(pdfSpotColor);
        if (b2 == null) {
            b2 = new b(this.p(), this.body.a(), pdfSpotColor);
            this.documentColors.put(pdfSpotColor, b2);
        }
        return b2;
    }

    final PdfName a(PdfPatternPainter pdfPatternPainter) {
        PdfName pdfName = this.documentPatterns.get(pdfPatternPainter);
        try {
            if (pdfName == null) {
                pdfName = new PdfName("P" + this.patternNumber);
                ++this.patternNumber;
                this.documentPatterns.put(pdfPatternPainter, pdfName);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName;
    }

    final void a(PdfShadingPattern pdfShadingPattern) {
        if (!this.documentShadingPatterns.containsKey(pdfShadingPattern)) {
            pdfShadingPattern.a(this.patternNumber);
            ++this.patternNumber;
            this.documentShadingPatterns.put(pdfShadingPattern, null);
            this.a(pdfShadingPattern.getShading());
        }
    }

    final void a(PdfShading pdfShading) {
        if (!this.documentShadings.containsKey(pdfShading)) {
            this.documentShadings.put(pdfShading, null);
            pdfShading.a(this.documentShadings.size());
        }
    }

    final PdfObject[] a(PdfGState pdfGState) {
        if (!this.documentExtGState.containsKey(pdfGState)) {
            PdfXConformanceImp.checkPDFXConformance(this, 6, pdfGState);
            this.documentExtGState.put(pdfGState, new PdfObject[]{new PdfName("GS" + (this.documentExtGState.size() + 1)), this.getPdfIndirectReference()});
        }
        return this.documentExtGState.get(pdfGState);
    }

    final PdfObject[] a(Object object, PdfIndirectReference pdfIndirectReference) {
        if (!this.documentProperties.containsKey(object)) {
            if (object instanceof PdfOCG) {
                PdfXConformanceImp.checkPDFXConformance(this, 7, null);
            }
            this.documentProperties.put(object, new PdfObject[]{new PdfName("Pr" + (this.documentProperties.size() + 1)), pdfIndirectReference});
        }
        return this.documentProperties.get(object);
    }

    final boolean b(PdfDictionary pdfDictionary) {
        return this.documentProperties.containsKey(pdfDictionary);
    }

    public void setTagged() {
        if (this.open) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("tagging.must.be.set.before.opening.the.document"));
        }
        this.tagged = true;
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public PdfStructureTreeRoot getStructureTreeRoot() {
        if (this.tagged && this.structureTreeRoot == null) {
            this.structureTreeRoot = new PdfStructureTreeRoot(this);
        }
        return this.structureTreeRoot;
    }

    public PdfOCProperties getOCProperties() {
        this.fillOCProperties(true);
        return this.OCProperties;
    }

    public void addOCGRadioGroup(List<PdfLayer> object) {
        PdfArray pdfArray = new PdfArray();
        object = object.iterator();
        while (object.hasNext()) {
            PdfLayer pdfLayer = (PdfLayer)object.next();
            if (pdfLayer.a() != null) continue;
            pdfArray.add(pdfLayer.getRef());
        }
        if (pdfArray.size() == 0) {
            return;
        }
        this.OCGRadioGroup.add(pdfArray);
    }

    public void lockLayer(PdfLayer pdfLayer) {
        this.OCGLocked.add(pdfLayer.getRef());
    }

    private static void a(PdfArray pdfArray, PdfLayer object) {
        Object object2;
        if (!((PdfLayer)object).isOnPanel()) {
            return;
        }
        if (((PdfLayer)object).a() == null) {
            pdfArray.add(((PdfLayer)object).getRef());
        }
        if ((object2 = ((PdfLayer)object).getChildren()) == null) {
            return;
        }
        PdfArray pdfArray2 = new PdfArray();
        if (((PdfLayer)object).a() != null) {
            pdfArray2.add(new PdfString(((PdfLayer)object).a(), "UnicodeBig"));
        }
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            object2 = (PdfLayer)object.next();
            PdfWriter.a(pdfArray2, (PdfLayer)object2);
        }
        if (pdfArray2.size() > 0) {
            pdfArray.add(pdfArray2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void a(PdfName pdfName, PdfName pdfName2) {
        void var5_9;
        PdfDictionary pdfDictionary;
        PdfArray pdfArray = new PdfArray();
        for (PdfOCG pdfOCG : this.documentOCG) {
            pdfDictionary = (PdfLayer)pdfOCG;
            PdfDictionary object2 = (PdfDictionary)pdfDictionary.get(PdfName.USAGE);
            if (object2 == null || object2.get(pdfName2) == null) continue;
            pdfArray.add(((PdfLayer)pdfDictionary).getRef());
        }
        if (pdfArray.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary2 = (PdfDictionary)this.OCProperties.get(PdfName.D);
        PdfArray pdfArray2 = (PdfArray)pdfDictionary2.get(PdfName.AS);
        if (pdfArray2 == null) {
            PdfArray pdfArray3 = new PdfArray();
            pdfDictionary2.put(PdfName.AS, pdfArray3);
        }
        pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.EVENT, pdfName);
        pdfDictionary.put(PdfName.CATEGORY, new PdfArray(pdfName2));
        pdfDictionary.put(PdfName.OCGS, pdfArray);
        var5_9.add(pdfDictionary);
    }

    protected void fillOCProperties(boolean bl2) {
        Object object;
        if (this.OCProperties == null) {
            this.OCProperties = new PdfOCProperties();
        }
        if (bl2) {
            this.OCProperties.remove(PdfName.OCGS);
            this.OCProperties.remove(PdfName.D);
        }
        if (this.OCProperties.get(PdfName.OCGS) == null) {
            PdfArray pdfArray = new PdfArray();
            for (PdfOCG pdfOCG2 : this.documentOCG) {
                object = (PdfLayer)pdfOCG2;
                pdfArray.add(((PdfLayer)object).getRef());
            }
            this.OCProperties.put(PdfName.OCGS, pdfArray);
        }
        if (this.OCProperties.get(PdfName.D) != null) {
            return;
        }
        Iterator<PdfOCG> iterator = this.documentOCGorder.stream().filter(pdfOCG -> ((PdfLayer)pdfOCG).getParent() == null).collect(Collectors.toList());
        PdfArray pdfArray = new PdfArray();
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            object = (PdfOCG)iterator2.next();
            iterator = (PdfLayer)object;
            PdfWriter.a(pdfArray, (PdfLayer)((Object)iterator));
        }
        PdfDictionary pdfDictionary = new PdfDictionary();
        this.OCProperties.put(PdfName.D, pdfDictionary);
        pdfDictionary.put(PdfName.ORDER, pdfArray);
        object = new PdfArray();
        for (PdfOCG pdfOCG3 : this.documentOCG) {
            PdfLayer pdfLayer = (PdfLayer)pdfOCG3;
            if (pdfLayer.isOn()) continue;
            ((PdfArray)object).add(pdfLayer.getRef());
        }
        if (((PdfArray)object).size() > 0) {
            pdfDictionary.put(PdfName.OFF, (PdfObject)object);
        }
        if (this.OCGRadioGroup.size() > 0) {
            pdfDictionary.put(PdfName.RBGROUPS, this.OCGRadioGroup);
        }
        if (this.OCGLocked.size() > 0) {
            pdfDictionary.put(PdfName.LOCKED, this.OCGLocked);
        }
        this.a(PdfName.VIEW, PdfName.ZOOM);
        PdfName pdfName = PdfName.VIEW;
        this.a(pdfName, pdfName);
        PdfName pdfName2 = PdfName.PRINT;
        this.a(pdfName2, pdfName2);
        PdfName pdfName3 = PdfName.EXPORT;
        this.a(pdfName3, pdfName3);
        pdfDictionary.put(PdfName.LISTMODE, PdfName.VISIBLEPAGES);
    }

    final void a(PdfLayer pdfLayer) {
        block3: {
            block0: {
                block2: {
                    block1: {
                        PdfXConformanceImp.checkPDFXConformance(this, 7, null);
                        if (!(pdfLayer instanceof PdfLayer)) break block0;
                        PdfLayer pdfLayer2 = pdfLayer;
                        if (pdfLayer2.a() != null) break block1;
                        if (this.documentOCG.contains(pdfLayer)) break block2;
                        break block3;
                    }
                    this.documentOCGorder.add(pdfLayer);
                }
                return;
            }
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("only.pdflayer.is.accepted"));
        }
        this.documentOCG.add(pdfLayer);
        this.documentOCGorder.add(pdfLayer);
    }

    public Rectangle getPageSize() {
        return this.pdf.getPageSize();
    }

    public void setCropBoxSize(Rectangle rectangle) {
        this.pdf.a(rectangle);
    }

    public void setBoxSize(String string, Rectangle rectangle) {
        this.pdf.a(string, rectangle);
    }

    public Rectangle getBoxSize(String string) {
        return this.pdf.b(string);
    }

    public void setPageEmpty(boolean bl2) {
        if (bl2) {
            return;
        }
        this.pdf.a(bl2);
    }

    public boolean isPageEmpty() {
        return this.pdf.f();
    }

    @Override
    public void setPageAction(PdfName pdfName, PdfAction pdfAction) {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new DocumentException(MessageLocalization.getComposedMessage("invalid.page.additional.action.type.1", pdfName.toString()));
        }
        this.pdf.b(pdfName, pdfAction);
    }

    @Override
    public void setDuration(int n2) {
        this.pdf.b(n2);
    }

    @Override
    public void setTransition(PdfTransition pdfTransition) {
        this.pdf.a(pdfTransition);
    }

    public void setThumbnail(Image image) {
        this.pdf.a(image);
    }

    public PdfDictionary getGroup() {
        return this.group;
    }

    public void setGroup(PdfDictionary pdfDictionary) {
        this.group = pdfDictionary;
    }

    public float getSpaceCharRatio() {
        return this.c;
    }

    public void setSpaceCharRatio(float f2) {
        if (f2 < 0.001f) {
            this.c = 0.001f;
            return;
        }
        this.c = f2;
    }

    @Override
    public void setRunDirection(int n2) {
        if (n2 <= 0 || n2 > 3) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.run.direction.1", n2));
        }
        this.runDirection = n2;
    }

    @Override
    public int getRunDirection() {
        return this.runDirection;
    }

    public float getUserunit() {
        return this.userunit;
    }

    public void setUserunit(float f2) {
        if (f2 < 1.0f || f2 > 75000.0f) {
            throw new DocumentException(MessageLocalization.getComposedMessage("userunit.should.be.a.value.between.1.and.75000"));
        }
        this.userunit = f2;
        this.setAtLeastPdfVersion('6');
    }

    public PdfDictionary getDefaultColorspace() {
        return this.defaultColorspace;
    }

    public void setDefaultColorspace(PdfName pdfName, PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            this.defaultColorspace.remove(pdfName);
        }
        this.defaultColorspace.put(pdfName, pdfObject);
    }

    final b a(Color object) {
        int n2 = ExtendedColor.getType((Color)object);
        if (n2 == 4 || n2 == 5) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("an.uncolored.tile.pattern.can.not.have.another.pattern.or.shading.as.color"));
        }
        try {
            switch (n2) {
                case 0: {
                    if (this.patternColorspaceRGB == null) {
                        this.patternColorspaceRGB = new b(this.p(), this.body.a(), null);
                        object = new PdfArray(PdfName.PATTERN);
                        ((PdfArray)object).add(PdfName.DEVICERGB);
                        b b2 = this.patternColorspaceRGB;
                        this.addToBody((PdfObject)object, b2.a);
                    }
                    return this.patternColorspaceRGB;
                }
                case 2: {
                    if (this.patternColorspaceCMYK == null) {
                        this.patternColorspaceCMYK = new b(this.p(), this.body.a(), null);
                        object = new PdfArray(PdfName.PATTERN);
                        ((PdfArray)object).add(PdfName.DEVICECMYK);
                        b b3 = this.patternColorspaceCMYK;
                        this.addToBody((PdfObject)object, b3.a);
                    }
                    return this.patternColorspaceCMYK;
                }
                case 1: {
                    if (this.patternColorspaceGRAY == null) {
                        this.patternColorspaceGRAY = new b(this.p(), this.body.a(), null);
                        object = new PdfArray(PdfName.PATTERN);
                        ((PdfArray)object).add(PdfName.DEVICEGRAY);
                        b b4 = this.patternColorspaceGRAY;
                        this.addToBody((PdfObject)object, b4.a);
                    }
                    return this.patternColorspaceGRAY;
                }
                case 3: {
                    object = this.a(((SpotColor)object).getPdfSpotColor());
                    b b5 = this.documentSpotPatterns.get(object);
                    if (b5 == null) {
                        b5 = new b(this.p(), this.body.a(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        Object object2 = object;
                        pdfArray.add(((b)object2).a);
                        object2 = b5;
                        this.addToBody((PdfObject)pdfArray, ((b)object2).a);
                        this.documentSpotPatterns.put((b)object, b5);
                    }
                    return b5;
                }
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.color.type"));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public boolean isStrictImageSequence() {
        return this.pdf.h();
    }

    public void setStrictImageSequence(boolean bl2) {
        this.pdf.b(bl2);
    }

    public void clearTextWrap() {
        this.pdf.clearTextWrap();
    }

    public PdfName addDirectImageSimple(Image image) {
        return this.addDirectImageSimple(image, null);
    }

    public PdfName addDirectImageSimple(Image image, PdfIndirectReference pdfObject) {
        if (this.d.containsKey(image.getMySerialId())) {
            pdfObject = this.d.get(image.getMySerialId());
        } else {
            if (image.isImgTemplate()) {
                pdfObject = new PdfName("img" + this.d.size());
                if (image instanceof ImgWMF) {
                    try {
                        ImgWMF imgWMF = (ImgWMF)image;
                        imgWMF.readWMF(PdfTemplate.createTemplate(this, 0.0f, 0.0f));
                    }
                    catch (Exception exception) {
                        throw new DocumentException(exception);
                    }
                }
            } else {
                PdfObject pdfObject2;
                PdfObject pdfObject3 = image.getDirectReference();
                if (pdfObject3 != null) {
                    PdfName pdfName = new PdfName("img" + this.d.size());
                    this.d.put(image.getMySerialId(), pdfName);
                    this.imageDictionary.put(pdfName, pdfObject3);
                    return pdfName;
                }
                Object object = image.getImageMask();
                pdfObject3 = null;
                if (object != null) {
                    pdfObject3 = this.d.get(((Image)object).getMySerialId());
                    pdfObject3 = this.a((PdfName)pdfObject3);
                }
                pdfObject3 = new PdfImage(image, "img" + this.d.size(), (PdfIndirectReference)pdfObject3);
                if (image instanceof ImgJBIG2) {
                    byte[] byArray = ((ImgJBIG2)image).getGlobalBytes();
                    object = byArray;
                    if (byArray != null) {
                        pdfObject2 = new PdfDictionary();
                        ((PdfDictionary)pdfObject2).put(PdfName.JBIG2GLOBALS, this.getReferenceJBIG2Globals((byte[])object));
                        ((PdfDictionary)pdfObject3).put(PdfName.DECODEPARMS, pdfObject2);
                    }
                }
                if (image.hasICCProfile()) {
                    object = new PdfICCBased(image.getICCProfile(), image.getCompressionLevel());
                    pdfObject2 = this.add((PdfICCBased)object);
                    object = new PdfArray();
                    ((PdfArray)object).add(PdfName.ICCBASED);
                    ((PdfArray)object).add(pdfObject2);
                    pdfObject2 = ((PdfDictionary)pdfObject3).getAsArray(PdfName.COLORSPACE);
                    if (pdfObject2 != null) {
                        if (((PdfArray)pdfObject2).size() > 1 && PdfName.INDEXED.equals(((PdfArray)pdfObject2).getPdfObject(0))) {
                            ((PdfArray)pdfObject2).set(1, (PdfObject)object);
                        } else {
                            ((PdfDictionary)pdfObject3).put(PdfName.COLORSPACE, (PdfObject)object);
                        }
                    } else {
                        ((PdfDictionary)pdfObject3).put(PdfName.COLORSPACE, (PdfObject)object);
                    }
                }
                this.a((PdfImage)pdfObject3, (PdfIndirectReference)pdfObject);
                pdfObject = ((PdfImage)pdfObject3).name();
            }
            this.d.put(image.getMySerialId(), (PdfName)pdfObject);
        }
        return pdfObject;
    }

    private PdfIndirectReference a(PdfImage pdfImage, PdfIndirectReference pdfIndirectReference) {
        if (!this.imageDictionary.contains(pdfImage.name())) {
            PdfXConformanceImp.checkPDFXConformance(this, 5, pdfImage);
            if (pdfIndirectReference instanceof PRIndirectReference) {
                pdfIndirectReference = (PRIndirectReference)pdfIndirectReference;
                pdfIndirectReference = new PdfIndirectReference(0, this.getNewObjectNumber(((PRIndirectReference)pdfIndirectReference).getReader(), pdfIndirectReference.getNumber(), pdfIndirectReference.getGeneration()));
            }
            try {
                if (pdfIndirectReference == null) {
                    pdfIndirectReference = this.addToBody(pdfImage).getIndirectReference();
                } else {
                    this.addToBody((PdfObject)pdfImage, pdfIndirectReference);
                }
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.imageDictionary.put(pdfImage.name(), pdfIndirectReference);
            return pdfIndirectReference;
        }
        return (PdfIndirectReference)this.imageDictionary.get(pdfImage.name());
    }

    final PdfIndirectReference a(PdfName pdfName) {
        return (PdfIndirectReference)this.imageDictionary.get(pdfName);
    }

    protected PdfIndirectReference add(PdfICCBased object) {
        try {
            object = this.addToBody((PdfObject)object);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        return ((PdfIndirectObject)object).getIndirectReference();
    }

    protected PdfIndirectReference getReferenceJBIG2Globals(byte[] byArray) {
        PdfIndirectObject pdfIndirectObject;
        PdfStream pdfStream2;
        if (byArray == null) {
            return null;
        }
        for (PdfStream pdfStream2 : this.JBIG2Globals.keySet()) {
            if (!Arrays.equals(byArray, pdfStream2.getBytes())) continue;
            return this.JBIG2Globals.get(pdfStream2);
        }
        pdfStream2 = new PdfStream(byArray);
        try {
            pdfIndirectObject = this.addToBody(pdfStream2);
        }
        catch (IOException iOException) {
            return null;
        }
        this.JBIG2Globals.put(pdfStream2, pdfIndirectObject.getIndirectReference());
        return pdfIndirectObject.getIndirectReference();
    }

    public boolean fitsPage(Table table, float f2) {
        return this.pdf.a(table) > this.pdf.a() + f2;
    }

    public boolean fitsPage(Table table) {
        return this.fitsPage(table, 0.0f);
    }

    public boolean isUserProperties() {
        return this.e;
    }

    public void setUserProperties(boolean bl2) {
        this.e = bl2;
    }

    public boolean isRgbTransparencyBlending() {
        return this.f;
    }

    public void setRgbTransparencyBlending(boolean bl2) {
        this.f = bl2;
    }

    static final class a
    extends PdfDictionary {
        a(int n2, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2, PdfIndirectReference pdfIndirectReference3, PdfObject pdfObject, int n3) {
            this.put(PdfName.SIZE, new PdfNumber(n2));
            this.put(PdfName.ROOT, pdfIndirectReference);
            if (pdfIndirectReference2 != null) {
                this.put(PdfName.INFO, pdfIndirectReference2);
            }
            if (pdfIndirectReference3 != null) {
                this.put(PdfName.ENCRYPT, pdfIndirectReference3);
            }
            if (pdfObject != null) {
                this.put(PdfName.ID, pdfObject);
            }
            if (n3 > 0) {
                this.put(PdfName.PREV, new PdfNumber(n3));
            }
        }

        @Override
        public final void toPdf(PdfWriter pdfWriter, OutputStream outputStream) {
            outputStream.write(DocWriter.getISOBytes("trailer\n"));
            super.toPdf(null, outputStream);
            outputStream.write(10);
        }
    }

    public static class PdfBody {
        private TreeSet<PdfCrossReference> a = new TreeSet();
        private int b;
        private long c;
        private PdfWriter d;
        private ByteBuffer e;
        private ByteBuffer f;
        private int g;
        private int h = 0;

        PdfBody(PdfWriter pdfWriter) {
            this.a.add(new PdfCrossReference(0, 0L, 65535));
            this.c = pdfWriter.l().getCounter();
            this.b = 1;
            this.d = pdfWriter;
        }

        final void a(int n2) {
            this.b = n2;
        }

        private PdfCrossReference b(PdfObject pdfObject, int n2) {
            if (this.h >= 200) {
                this.e();
            }
            if (this.e == null) {
                this.e = new ByteBuffer();
                this.f = new ByteBuffer();
                this.g = this.b();
                this.h = 0;
            }
            int n3 = this.f.size();
            int n4 = this.h++;
            PdfEncryption pdfEncryption = this.d.crypto;
            this.d.crypto = null;
            pdfObject.toPdf(this.d, this.f);
            this.d.crypto = pdfEncryption;
            this.f.append(' ');
            this.e.append(n2).append(' ').append(n3).append(' ');
            return new PdfCrossReference(2, n2, this.g, n4);
        }

        private void e() {
            if (this.h == 0) {
                return;
            }
            int n2 = this.e.size();
            this.e.append(this.f);
            PdfStream pdfStream = new PdfStream(this.e.toByteArray());
            pdfStream.flateCompress(this.d.getCompressionLevel());
            pdfStream.put(PdfName.TYPE, PdfName.OBJSTM);
            pdfStream.put(PdfName.N, new PdfNumber(this.h));
            pdfStream.put(PdfName.FIRST, new PdfNumber(n2));
            int n3 = this.g;
            PdfBody pdfBody = this;
            pdfBody.a(pdfStream, n3, true);
            this.e = null;
            this.f = null;
            this.h = 0;
        }

        final PdfIndirectObject a(PdfObject object) {
            int n2 = this.b();
            PdfObject pdfObject = object;
            object = this;
            return ((PdfBody)object).a(pdfObject, n2, true);
        }

        final PdfIndirectReference a() {
            return new PdfIndirectReference(0, this.b());
        }

        final int b() {
            int n2 = this.b++;
            this.a.add(new PdfCrossReference(n2, 0L, 65535));
            return n2;
        }

        final PdfIndirectObject a(PdfObject object, PdfIndirectReference pdfObject) {
            int n2 = pdfObject.getNumber();
            pdfObject = object;
            object = this;
            return ((PdfBody)object).a(pdfObject, n2, true);
        }

        final PdfIndirectObject a(PdfObject pdfObject, int n2) {
            return this.a(pdfObject, n2, true);
        }

        final PdfIndirectObject a(PdfObject object, int n2, boolean bl2) {
            if (bl2 && ((PdfObject)object).canBeInObjStm() && this.d.isFullCompression()) {
                PdfCrossReference pdfCrossReference = this.b((PdfObject)object, n2);
                object = new PdfIndirectObject(n2, (PdfObject)object, this.d);
                if (!this.a.add(pdfCrossReference)) {
                    this.a.remove(pdfCrossReference);
                    this.a.add(pdfCrossReference);
                }
                return object;
            }
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n2, (PdfObject)object, this.d);
            object = new PdfCrossReference(n2, this.c);
            if (!this.a.add((PdfCrossReference)object)) {
                this.a.remove(object);
                this.a.add((PdfCrossReference)object);
            }
            pdfIndirectObject.a(this.d.l());
            this.c = this.d.l().getCounter();
            return pdfIndirectObject;
        }

        final long c() {
            return this.c;
        }

        final int d() {
            return Math.max(this.a.last().a() + 1, this.b);
        }

        /*
         * WARNING - void declaration
         */
        final void a(OutputStreamCounter object, PdfIndirectReference object2, PdfIndirectReference object32, PdfIndirectReference object42, PdfObject pdfObject, int n2) {
            void var6_13;
            void var5_12;
            void var4_8;
            int n3 = 0;
            boolean bl2 = this.d.isFullCompression() || this.c > 9999999999L;
            if (bl2) {
                this.e();
                n3 = this.b();
                this.a.add(new PdfCrossReference(n3, this.c));
            }
            PdfCrossReference pdfCrossReference = this.a.first();
            int n4 = pdfCrossReference.a();
            int n5 = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (PdfCrossReference pdfCrossReference2 : this.a) {
                pdfCrossReference = pdfCrossReference2;
                if (n4 + n5 == pdfCrossReference.a()) {
                    ++n5;
                    continue;
                }
                arrayList.add(n4);
                arrayList.add(n5);
                n4 = pdfCrossReference.a();
                n5 = 1;
            }
            arrayList.add(n4);
            arrayList.add(n5);
            a a2 = new a(this.d(), (PdfIndirectReference)object2, (PdfIndirectReference)object32, (PdfIndirectReference)var4_8, (PdfObject)var5_12, (int)var6_13);
            if (bl2) {
                int n6 = 8 - (Long.numberOfLeadingZeros(this.c) >> 3);
                object2 = new ByteBuffer();
                object = this.a.iterator();
                while (object.hasNext()) {
                    PdfCrossReference pdfCrossReference3;
                    pdfCrossReference = pdfCrossReference3 = object.next();
                    pdfCrossReference3.toPdf(n6, (OutputStream)object2);
                }
                object = new PdfStream(((ByteBuffer)object2).toByteArray());
                ((PdfStream)object).flateCompress(this.d.getCompressionLevel());
                ((PdfDictionary)object).putAll(a2);
                ((PdfDictionary)object).put(PdfName.W, new PdfArray(new int[]{1, n6, 2}));
                ((PdfDictionary)object).put(PdfName.TYPE, PdfName.XREF);
                PdfArray pdfArray = new PdfArray();
                for (Integer n7 : arrayList) {
                    pdfArray.add(new PdfNumber(n7));
                }
                ((PdfDictionary)object).put(PdfName.INDEX, pdfArray);
                object2 = this.d.crypto;
                this.d.crypto = null;
                PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n3, (PdfObject)object, this.d);
                pdfIndirectObject.a(this.d.l());
                this.d.crypto = object2;
                return;
            }
            ((OutputStream)object).write(DocWriter.getISOBytes("xref\n"));
            Iterator<PdfCrossReference> iterator = this.a.iterator();
            for (int i2 = 0; i2 < arrayList.size(); i2 += 2) {
                n4 = (Integer)arrayList.get(i2);
                n5 = (Integer)arrayList.get(i2 + 1);
                ((OutputStream)object).write(DocWriter.getISOBytes(String.valueOf(n4)));
                ((OutputStream)object).write(DocWriter.getISOBytes(" "));
                ((OutputStream)object).write(DocWriter.getISOBytes(String.valueOf(n5)));
                ((OutputStream)object).write(10);
                while (n5-- > 0) {
                    pdfCrossReference = iterator.next();
                    pdfCrossReference.toPdf((OutputStream)object);
                }
            }
            ((PdfObject)a2).toPdf(this.d, (OutputStream)object);
        }

        public static class PdfCrossReference
        implements Comparable<PdfCrossReference> {
            private int a;
            private long b;
            private int c;
            private int d;

            public PdfCrossReference(int n2, long l2, int n3) {
                this.a = 0;
                this.b = l2;
                this.c = n2;
                this.d = n3;
            }

            public PdfCrossReference(int n2, long l2) {
                this.a = 1;
                this.b = l2;
                this.c = n2;
                this.d = 0;
            }

            public PdfCrossReference(int n2, int n3, long l2, int n4) {
                this.a = n2;
                this.b = l2;
                this.c = n3;
                this.d = n4;
            }

            final int a() {
                return this.c;
            }

            public void toPdf(OutputStream outputStream) {
                char c2 = this.d == 65535 ? (char)'f' : 'n';
                outputStream.write(String.format("%010d %05d %c \n", this.b, this.d, Character.valueOf(c2)).getBytes());
            }

            public void toPdf(int n2, OutputStream outputStream) {
                outputStream.write((byte)this.a);
                while (--n2 >= 0) {
                    outputStream.write((byte)(this.b >>> n2 * 8 & 0xFFL));
                }
                outputStream.write((byte)(this.d >>> 8));
                outputStream.write((byte)this.d);
            }

            @Override
            public int compareTo(PdfCrossReference pdfCrossReference) {
                return Integer.compare(this.c, pdfCrossReference.c);
            }

            public boolean equals(Object object) {
                if (!(object instanceof PdfCrossReference)) {
                    return false;
                }
                object = (PdfCrossReference)object;
                return this.c == ((PdfCrossReference)object).c;
            }

            public int hashCode() {
                return this.c;
            }
        }
    }
}

