/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;

public class PushbuttonField
extends BaseField {
    public static final int LAYOUT_LABEL_ONLY = 1;
    public static final int LAYOUT_ICON_ONLY = 2;
    public static final int LAYOUT_ICON_TOP_LABEL_BOTTOM = 3;
    public static final int LAYOUT_LABEL_TOP_ICON_BOTTOM = 4;
    public static final int LAYOUT_ICON_LEFT_LABEL_RIGHT = 5;
    public static final int LAYOUT_LABEL_LEFT_ICON_RIGHT = 6;
    public static final int LAYOUT_LABEL_OVER_ICON = 7;
    public static final int SCALE_ICON_ALWAYS = 1;
    public static final int SCALE_ICON_NEVER = 2;
    public static final int SCALE_ICON_IS_TOO_BIG = 3;
    public static final int SCALE_ICON_IS_TOO_SMALL = 4;
    private int a = 1;
    private Image b;
    private PdfTemplate c;
    private int d = 1;
    private boolean e = true;
    private float f = 0.5f;
    private float g = 0.5f;
    private boolean h;
    private PdfTemplate i;
    private PRIndirectReference j;

    public PushbuttonField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        super(pdfWriter, rectangle, string);
    }

    public int getLayout() {
        return this.a;
    }

    public void setLayout(int n2) {
        if (n2 <= 0 || n2 > 7) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("layout.out.of.bounds"));
        }
        this.a = n2;
    }

    public Image getImage() {
        return this.b;
    }

    public void setImage(Image image) {
        this.b = image;
        this.c = null;
    }

    public PdfTemplate getTemplate() {
        return this.c;
    }

    public void setTemplate(PdfTemplate pdfTemplate) {
        this.c = pdfTemplate;
        this.b = null;
    }

    public int getScaleIcon() {
        return this.d;
    }

    public void setScaleIcon(int n2) {
        if (n2 <= 0 || n2 > 4) {
            n2 = 1;
        }
        this.d = n2;
    }

    public boolean isProportionalIcon() {
        return this.e;
    }

    public void setProportionalIcon(boolean bl2) {
        this.e = bl2;
    }

    public float getIconVerticalAdjustment() {
        return this.f;
    }

    public void setIconVerticalAdjustment(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.f = f2;
    }

    public float getIconHorizontalAdjustment() {
        return this.g;
    }

    public void setIconHorizontalAdjustment(float f2) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.g = f2;
    }

    private float a(float f2, float f3) {
        BaseFont baseFont = this.getRealFont();
        float f4 = this.fontSize;
        if (f4 == 0.0f) {
            float f5;
            f4 = baseFont.getWidthPoint(this.text, 1.0f);
            f4 = f4 == 0.0f ? 12.0f : f2 / f4;
            f2 = f3 / (1.0f - baseFont.getFontDescriptor(3, 1.0f));
            f4 = Math.min(f4, f2);
            if (f5 < 4.0f) {
                f4 = 4.0f;
            }
        }
        return f4;
    }

    public PdfAppearance getAppearance() {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        Rectangle rectangle = new Rectangle(pdfAppearance.getBoundingBox());
        if ((this.text == null || this.text.length() == 0) && (this.a == 1 || this.b == null && this.c == null && this.j == null)) {
            return pdfAppearance;
        }
        if (this.a == 2 && this.b == null && this.c == null && this.j == null) {
            return pdfAppearance;
        }
        BaseFont baseFont = this.getRealFont();
        boolean bl2 = this.borderStyle == 2 || this.borderStyle == 3;
        rectangle.getHeight();
        float f2 = this.borderWidth;
        if (bl2) {
            f2 *= 2.0f;
        }
        float f3 = bl2 ? 2.0f * this.borderWidth : this.borderWidth;
        f3 = Math.max(f3, 1.0f);
        f3 = Math.min(f2, f3);
        this.i = null;
        f2 = Float.NaN;
        float f4 = 0.0f;
        float f5 = this.fontSize;
        float f6 = rectangle.getWidth() - f3 * 2.0f - 2.0f;
        float f7 = rectangle.getHeight() - f3 * 2.0f;
        float f8 = this.h ? 0.0f : f3 + 1.0f;
        int n2 = this.a;
        if (this.b == null && this.c == null && this.j == null) {
            n2 = 1;
        }
        Rectangle rectangle2 = null;
        block18: while (true) {
            switch (n2) {
                case 1: 
                case 7: {
                    if (this.text != null && this.text.length() > 0 && f6 > 0.0f && f7 > 0.0f) {
                        f5 = this.a(f6, f7);
                        f2 = (rectangle.getWidth() - baseFont.getWidthPoint(this.text, f5)) / 2.0f;
                        f4 = (rectangle.getHeight() - baseFont.getFontDescriptor(1, f5)) / 2.0f;
                    }
                }
                case 2: {
                    if (n2 != 7 && n2 != 2) break block18;
                    rectangle2 = new Rectangle(rectangle.getLeft() + f8, rectangle.getBottom() + f8, rectangle.getRight() - f8, rectangle.getTop() - f8);
                    break block18;
                }
                case 3: {
                    float f9;
                    if (this.text == null || this.text.length() == 0 || f6 <= 0.0f || f7 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    f7 = rectangle.getHeight() * 0.35f - f3;
                    f5 = f9 > 0.0f ? this.a(f6, f7) : 4.0f;
                    f2 = (rectangle.getWidth() - baseFont.getWidthPoint(this.text, f5)) / 2.0f;
                    f4 = f3 - baseFont.getFontDescriptor(3, f5);
                    rectangle2 = new Rectangle(rectangle.getLeft() + f8, f4 + f5, rectangle.getRight() - f8, rectangle.getTop() - f8);
                    break block18;
                }
                case 4: {
                    float f10;
                    float f11;
                    if (this.text == null || this.text.length() == 0 || f6 <= 0.0f || f7 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    f7 = rectangle.getHeight() * 0.35f - f3;
                    f5 = f11 > 0.0f ? this.a(f6, f7) : 4.0f;
                    f2 = (rectangle.getWidth() - baseFont.getWidthPoint(this.text, f5)) / 2.0f;
                    f4 = rectangle.getHeight() - f3 - f5;
                    if (f10 < f3) {
                        f4 = f3;
                    }
                    rectangle2 = new Rectangle(rectangle.getLeft() + f8, rectangle.getBottom() + f8, rectangle.getRight() - f8, f4 + baseFont.getFontDescriptor(3, f5));
                    break block18;
                }
                case 6: {
                    float f12;
                    if (this.text == null || this.text.length() == 0 || f6 <= 0.0f || f7 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    float f13 = rectangle.getWidth() * 0.35f - f3;
                    f5 = f12 > 0.0f ? this.a(f6, f13) : 4.0f;
                    if (baseFont.getWidthPoint(this.text, f5) >= f6) {
                        n2 = 1;
                        f5 = this.fontSize;
                        continue block18;
                    }
                    f2 = f3 + 1.0f;
                    f4 = (rectangle.getHeight() - baseFont.getFontDescriptor(1, f5)) / 2.0f;
                    rectangle2 = new Rectangle(f2 + baseFont.getWidthPoint(this.text, f5), rectangle.getBottom() + f8, rectangle.getRight() - f8, rectangle.getTop() - f8);
                    break block18;
                }
                case 5: {
                    float f14;
                    if (this.text == null || this.text.length() == 0 || f6 <= 0.0f || f7 <= 0.0f) {
                        n2 = 2;
                        continue block18;
                    }
                    float f15 = rectangle.getWidth() * 0.35f - f3;
                    f5 = f14 > 0.0f ? this.a(f6, f15) : 4.0f;
                    if (baseFont.getWidthPoint(this.text, f5) >= f6) {
                        n2 = 1;
                        f5 = this.fontSize;
                        continue block18;
                    }
                    f2 = rectangle.getWidth() - baseFont.getWidthPoint(this.text, f5) - f3 - 1.0f;
                    f4 = (rectangle.getHeight() - baseFont.getFontDescriptor(1, f5)) / 2.0f;
                    rectangle2 = new Rectangle(rectangle.getLeft() + f8, rectangle.getBottom() + f8, f2 - 1.0f, rectangle.getTop() - f8);
                }
            }
            break;
        }
        if (f4 < rectangle.getBottom() + f3) {
            f4 = rectangle.getBottom() + f3;
        }
        if (rectangle2 != null && (rectangle2.getWidth() <= 0.0f || rectangle2.getHeight() <= 0.0f)) {
            rectangle2 = null;
        }
        boolean bl3 = false;
        float f16 = 0.0f;
        f6 = 0.0f;
        PdfArray pdfArray = null;
        if (rectangle2 != null) {
            PdfDictionary pdfDictionary;
            if (this.b != null) {
                this.i = new PdfTemplate(this.writer);
                this.i.setBoundingBox(new Rectangle(this.b));
                this.writer.a(this.i, PdfName.FRM);
                this.i.addImage(this.b, this.b.getWidth(), 0.0f, 0.0f, this.b.getHeight(), 0.0f, 0.0f);
                bl3 = true;
                f16 = this.i.getBoundingBox().getWidth();
                f6 = this.i.getBoundingBox().getHeight();
            } else if (this.c != null) {
                this.i = new PdfTemplate(this.writer);
                this.i.setBoundingBox(new Rectangle(this.c.getWidth(), this.c.getHeight()));
                this.writer.a(this.i, PdfName.FRM);
                this.i.addTemplate(this.c, this.c.getBoundingBox().getLeft(), this.c.getBoundingBox().getBottom());
                bl3 = true;
                f16 = this.i.getBoundingBox().getWidth();
                f6 = this.i.getBoundingBox().getHeight();
            } else if (this.j != null && (pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.j)) != null) {
                Rectangle rectangle3 = PdfReader.getNormalizedRectangle(pdfDictionary.getAsArray(PdfName.BBOX));
                pdfArray = pdfDictionary.getAsArray(PdfName.MATRIX);
                bl3 = true;
                f16 = rectangle3.getWidth();
                f6 = rectangle3.getHeight();
            }
        }
        if (bl3) {
            float f17 = rectangle2.getWidth() / f16;
            float f18 = rectangle2.getHeight() / f6;
            if (this.e) {
                switch (this.d) {
                    case 3: {
                        f17 = Math.min(f17, f18);
                        f17 = Math.min(f17, 1.0f);
                        break;
                    }
                    case 4: {
                        f17 = Math.min(f17, f18);
                        f17 = Math.max(f17, 1.0f);
                        break;
                    }
                    case 2: {
                        f17 = 1.0f;
                        break;
                    }
                    default: {
                        f17 = Math.min(f17, f18);
                    }
                }
                f18 = f17;
            } else {
                switch (this.d) {
                    case 3: {
                        f17 = Math.min(f17, 1.0f);
                        f18 = Math.min(f18, 1.0f);
                        break;
                    }
                    case 4: {
                        f17 = Math.max(f17, 1.0f);
                        f18 = Math.max(f18, 1.0f);
                        break;
                    }
                    case 2: {
                        f18 = 1.0f;
                        f17 = 1.0f;
                    }
                }
            }
            float f19 = rectangle2.getLeft() + (rectangle2.getWidth() - f16 * f17) * this.g;
            f6 = rectangle2.getBottom() + (rectangle2.getHeight() - f6 * f18) * this.f;
            pdfAppearance.saveState();
            pdfAppearance.rectangle(rectangle2.getLeft(), rectangle2.getBottom(), rectangle2.getWidth(), rectangle2.getHeight());
            pdfAppearance.clip();
            pdfAppearance.newPath();
            if (this.i != null) {
                pdfAppearance.addTemplate(this.i, f17, 0.0f, 0.0f, f18, f19, f6);
            } else {
                f16 = 0.0f;
                float f20 = 0.0f;
                if (pdfArray != null && pdfArray.size() == 6) {
                    PdfNumber pdfNumber = pdfArray.getAsNumber(4);
                    if (pdfNumber != null) {
                        f16 = pdfNumber.floatValue();
                    }
                    if ((pdfNumber = pdfArray.getAsNumber(5)) != null) {
                        f20 = pdfNumber.floatValue();
                    }
                }
                pdfAppearance.a(this.j, PdfName.FRM, f17, 0.0f, 0.0f, f18, f19 - f16 * f17, f6 - f20 * f18);
            }
            pdfAppearance.restoreState();
        }
        if (!Float.isNaN(f2)) {
            pdfAppearance.saveState();
            float f21 = f3;
            pdfAppearance.rectangle(f21, f21, rectangle.getWidth() - f3 * 2.0f, rectangle.getHeight() - f3 * 2.0f);
            pdfAppearance.clip();
            pdfAppearance.newPath();
            if (this.textColor == null) {
                pdfAppearance.resetGrayFill();
            } else {
                pdfAppearance.setColorFill(this.textColor);
            }
            pdfAppearance.beginText();
            ((PdfContentByte)pdfAppearance).setFontAndSize(baseFont, f5);
            pdfAppearance.setTextMatrix(f2, f4);
            pdfAppearance.showText(this.text);
            pdfAppearance.endText();
            pdfAppearance.restoreState();
        }
        return pdfAppearance;
    }

    public PdfFormField getField() {
        PdfFormField pdfFormField = PdfFormField.createPushButton(this.writer);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
        }
        if (this.text != null) {
            pdfFormField.setMKNormalCaption(this.text);
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        Object object = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, (PdfTemplate)object);
        object = (PdfAppearance)((PdfContentByte)object).getDuplicate();
        ((PdfContentByte)object).setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            ((PdfContentByte)object).setGrayFill(0.0f);
        } else {
            ((PdfContentByte)object).setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString((PdfContentByte)object);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        if (this.i != null) {
            pdfFormField.setMKNormalIcon(this.i);
        }
        pdfFormField.setMKTextPosition(this.a - 1);
        object = PdfName.A;
        if (this.d == 3) {
            object = PdfName.B;
        } else if (this.d == 4) {
            object = PdfName.S;
        } else if (this.d == 2) {
            object = PdfName.N;
        }
        pdfFormField.setMKIconFit((PdfName)object, this.e ? PdfName.P : PdfName.A, this.g, this.f, this.h);
        return pdfFormField;
    }

    public boolean isIconFitToBounds() {
        return this.h;
    }

    public void setIconFitToBounds(boolean bl2) {
        this.h = bl2;
    }

    public PRIndirectReference getIconReference() {
        return this.j;
    }

    public void setIconReference(PRIndirectReference pRIndirectReference) {
        this.j = pRIndirectReference;
    }
}

