/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;

public class RadioCheckField
extends BaseField {
    public static final int TYPE_CHECK = 1;
    public static final int TYPE_CIRCLE = 2;
    public static final int TYPE_CROSS = 3;
    public static final int TYPE_DIAMOND = 4;
    public static final int TYPE_SQUARE = 5;
    public static final int TYPE_STAR = 6;
    private static String[] a = new String[]{"4", "l", "8", "u", "n", "H"};
    private int b;
    private String c;
    private boolean d;

    public RadioCheckField(PdfWriter pdfWriter, Rectangle rectangle, String string, String string2) {
        super(pdfWriter, rectangle, string);
        this.setOnValue(string2);
        this.setCheckType(1);
    }

    public int getCheckType() {
        return this.b;
    }

    public void setCheckType(int n2) {
        if (n2 <= 0 || n2 > 6) {
            n2 = 1;
        }
        this.b = n2;
        this.setText(a[n2 - 1]);
        try {
            this.setFont(BaseFont.createFont("ZapfDingbats", "Cp1252", false));
            return;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public String getOnValue() {
        return this.c;
    }

    public void setOnValue(String string) {
        this.c = string;
    }

    public boolean isChecked() {
        return this.d;
    }

    public void setChecked(boolean bl2) {
        this.d = bl2;
    }

    public PdfAppearance getAppearance(boolean bl2, boolean bl3) {
        if (bl2 && this.b == 2) {
            return this.getAppearanceRadioCircle(bl3);
        }
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        if (!bl3) {
            return pdfAppearance;
        }
        BaseFont baseFont = this.getRealFont();
        boolean bl4 = this.borderStyle == 2 || this.borderStyle == 3;
        float f2 = this.box.getHeight() - this.borderWidth * 2.0f;
        float f3 = this.borderWidth;
        if (bl4) {
            f2 -= this.borderWidth * 2.0f;
            f3 *= 2.0f;
        }
        float f4 = bl4 ? 2.0f * this.borderWidth : this.borderWidth;
        f4 = Math.max(f4, 1.0f);
        f4 = Math.min(f3, f4);
        f3 = this.box.getWidth() - f4 * 2.0f;
        float f5 = this.box.getHeight() - f4 * 2.0f;
        float f6 = this.fontSize;
        if (f6 == 0.0f) {
            f6 = baseFont.getWidthPoint(this.text, 1.0f);
            f6 = f6 == 0.0f ? 12.0f : f3 / f6;
            f6 = Math.min(f6, f2 /= baseFont.getFontDescriptor(1, 1.0f));
        }
        pdfAppearance.saveState();
        float f7 = f4;
        pdfAppearance.rectangle(f7, f7, f3, f5);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        if (this.textColor == null) {
            pdfAppearance.resetGrayFill();
        } else {
            pdfAppearance.setColorFill(this.textColor);
        }
        pdfAppearance.beginText();
        ((PdfContentByte)pdfAppearance).setFontAndSize(baseFont, f6);
        pdfAppearance.setTextMatrix((this.box.getWidth() - baseFont.getWidthPoint(this.text, f6)) / 2.0f, (this.box.getHeight() - baseFont.getAscentPoint(this.text, f6)) / 2.0f);
        pdfAppearance.showText(this.text);
        pdfAppearance.endText();
        pdfAppearance.restoreState();
        return pdfAppearance;
    }

    public PdfAppearance getAppearanceRadioCircle(boolean bl2) {
        float f2;
        PdfAppearance pdfAppearance = PdfAppearance.createAppearance(this.writer, this.box.getWidth(), this.box.getHeight());
        switch (this.rotation) {
            case 90: {
                pdfAppearance.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, this.box.getHeight(), 0.0f);
                break;
            }
            case 180: {
                pdfAppearance.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f, this.box.getWidth(), this.box.getHeight());
                break;
            }
            case 270: {
                pdfAppearance.setMatrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, this.box.getWidth());
            }
        }
        Rectangle rectangle = new Rectangle(pdfAppearance.getBoundingBox());
        float f3 = rectangle.getWidth() / 2.0f;
        float f4 = rectangle.getHeight() / 2.0f;
        float f5 = (Math.min(rectangle.getWidth(), rectangle.getHeight()) - this.borderWidth) / 2.0f;
        if (f2 <= 0.0f) {
            return pdfAppearance;
        }
        if (this.backgroundColor != null) {
            pdfAppearance.setColorFill(this.backgroundColor);
            pdfAppearance.circle(f3, f4, f5 + this.borderWidth / 2.0f);
            pdfAppearance.fill();
        }
        if (this.borderWidth > 0.0f && this.borderColor != null) {
            pdfAppearance.setLineWidth(this.borderWidth);
            pdfAppearance.setColorStroke(this.borderColor);
            pdfAppearance.circle(f3, f4, f5);
            pdfAppearance.stroke();
        }
        if (bl2) {
            if (this.textColor == null) {
                pdfAppearance.resetGrayFill();
            } else {
                pdfAppearance.setColorFill(this.textColor);
            }
            pdfAppearance.circle(f3, f4, f5 / 2.0f);
            pdfAppearance.fill();
        }
        return pdfAppearance;
    }

    public PdfFormField getRadioGroup(boolean bl2, boolean bl3) {
        PdfFormField pdfFormField = PdfFormField.createRadioButton(this.writer, bl2);
        if (bl3) {
            pdfFormField.setFieldFlags(0x2000000);
        }
        pdfFormField.setFieldName(this.fieldName);
        if ((this.options & 1) != 0) {
            pdfFormField.setFieldFlags(1);
        }
        if ((this.options & 2) != 0) {
            pdfFormField.setFieldFlags(2);
        }
        pdfFormField.setValueAsName(this.d ? this.c : "Off");
        return pdfFormField;
    }

    public PdfFormField getRadioField() {
        return this.getField(true);
    }

    public PdfFormField getCheckField() {
        return this.getField(false);
    }

    protected PdfFormField getField(boolean bl2) {
        PdfFormField pdfFormField = bl2 ? PdfFormField.createEmpty(this.writer) : PdfFormField.createCheckBox(this.writer);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (!bl2) {
            pdfFormField.setFieldName(this.fieldName);
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            pdfFormField.setValueAsName(this.d ? this.c : "Off");
        }
        if (this.text != null) {
            pdfFormField.setMKNormalCaption(this.text);
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance(bl2, true);
        PdfAppearance pdfAppearance2 = this.getAppearance(bl2, false);
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, this.c, pdfAppearance);
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", pdfAppearance2);
        pdfFormField.setAppearanceState(this.d ? this.c : "Off");
        pdfAppearance2 = (PdfAppearance)((PdfContentByte)pdfAppearance).getDuplicate();
        ((PdfContentByte)pdfAppearance2).setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }
}

