/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SimpleNamedDestination;
import com.lowagie.text.xml.XMLUtil;
import com.lowagie.text.xml.simpleparser.IanaEncodings;
import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import com.lowagie.text.xml.simpleparser.SimpleXMLParser;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

public final class SimpleBookmark
implements SimpleXMLDocHandler {
    private List<Map<String, Object>> a;
    private final Stack<Map<String, Object>> b = new Stack();

    private SimpleBookmark() {
    }

    private static List<Map<String, Object>> a(PdfDictionary pdfDictionary, IntHashtable intHashtable) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        while (pdfDictionary != null) {
            Object object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            PdfObject pdfObject = (PdfString)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.TITLE));
            hashMap.put("Title", ((PdfString)pdfObject).toUnicodeString());
            pdfObject = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.C));
            if (pdfObject != null && ((PdfArray)pdfObject).size() == 3) {
                object = new ByteBuffer();
                ((ByteBuffer)object).append(((PdfArray)pdfObject).getAsNumber(0).floatValue()).append(' ');
                ((ByteBuffer)object).append(((PdfArray)pdfObject).getAsNumber(1).floatValue()).append(' ');
                ((ByteBuffer)object).append(((PdfArray)pdfObject).getAsNumber(2).floatValue());
                hashMap.put("Color", PdfEncodings.convertToString(((ByteBuffer)object).toByteArray(), null));
            }
            if ((object = (PdfNumber)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.F))) != null) {
                int n2 = ((PdfNumber)object).intValue();
                object = "";
                if ((n2 & 1) != 0) {
                    object = (String)object + "italic ";
                }
                if ((n2 & 2) != 0) {
                    object = (String)object + "bold ";
                }
                if (((String)(object = ((String)object).trim())).length() != 0) {
                    hashMap.put("Style", object);
                }
            }
            if ((pdfObject = (PdfNumber)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.COUNT))) != null && ((PdfNumber)pdfObject).intValue() < 0) {
                hashMap.put("Open", "false");
            }
            try {
                object = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.DEST));
                if (object != null) {
                    SimpleBookmark.a(hashMap, (PdfObject)object, intHashtable);
                } else {
                    pdfObject = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.A));
                    if (pdfObject != null) {
                        if (PdfName.GOTO.equals(PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.S)))) {
                            object = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.D));
                            if (object != null) {
                                SimpleBookmark.a(hashMap, (PdfObject)object, intHashtable);
                            }
                        } else if (PdfName.URI.equals(PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.S)))) {
                            hashMap.put("Action", "URI");
                            hashMap.put("URI", ((PdfString)PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.URI))).toUnicodeString());
                        } else if (PdfName.GOTOR.equals(PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.S)))) {
                            Object object2;
                            object = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.D));
                            if (object != null) {
                                if (((PdfObject)object).isString()) {
                                    hashMap.put("Named", ((PdfObject)object).toString());
                                } else if (((PdfObject)object).isName()) {
                                    hashMap.put("NamedN", PdfName.decodeName(((PdfObject)object).toString()));
                                } else if (((PdfObject)object).isArray()) {
                                    object = (PdfArray)object;
                                    object2 = new StringBuilder();
                                    ((StringBuilder)object2).append(((PdfArray)object).getPdfObject(0).toString());
                                    ((StringBuilder)object2).append(' ').append(((PdfArray)object).getPdfObject(1).toString());
                                    for (int i2 = 2; i2 < ((PdfArray)object).size(); ++i2) {
                                        ((StringBuilder)object2).append(' ').append(((PdfArray)object).getPdfObject(i2).toString());
                                    }
                                    hashMap.put("Page", ((StringBuilder)object2).toString());
                                }
                            }
                            hashMap.put("Action", "GoToR");
                            object = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.F));
                            if (object != null) {
                                if (((PdfObject)object).isString()) {
                                    hashMap.put("File", ((PdfString)object).toUnicodeString());
                                } else if (((PdfObject)object).isDictionary() && ((PdfObject)(object = PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.F)))).isString()) {
                                    hashMap.put("File", ((PdfString)object).toUnicodeString());
                                }
                            }
                            if ((object2 = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.NEWWINDOW))) != null) {
                                hashMap.put("NewWindow", ((PdfObject)object2).toString());
                            }
                        } else if (PdfName.LAUNCH.equals(PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.S)))) {
                            hashMap.put("Action", "Launch");
                            object = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.F));
                            if (object == null) {
                                object = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.WIN));
                            }
                            if (object != null) {
                                if (((PdfObject)object).isString()) {
                                    hashMap.put("File", ((PdfString)object).toUnicodeString());
                                } else if (((PdfObject)object).isDictionary() && ((PdfObject)(object = PdfReader.getPdfObjectRelease(((PdfDictionary)object).get(PdfName.F)))).isString()) {
                                    hashMap.put("File", ((PdfString)object).toUnicodeString());
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {}
            object = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.FIRST));
            if (object != null) {
                hashMap.put("Kids", SimpleBookmark.a((PdfDictionary)object, intHashtable));
            }
            arrayList.add(hashMap);
            pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.NEXT));
        }
        return arrayList;
    }

    private static void a(Map<String, Object> map, PdfObject pdfObject, IntHashtable intHashtable) {
        if (pdfObject.isString()) {
            map.put("Named", pdfObject.toString());
        } else if (pdfObject.isName()) {
            map.put("Named", PdfName.decodeName(pdfObject.toString()));
        } else if (pdfObject.isArray()) {
            map.put("Page", SimpleBookmark.a((PdfArray)pdfObject, intHashtable));
        }
        map.put("Action", "GoTo");
    }

    private static String a(PdfArray pdfArray, IntHashtable intHashtable) {
        StringBuilder stringBuilder = new StringBuilder();
        if (pdfArray.size() == 0) {
            throw new IllegalArgumentException("Illegal bookmark destination");
        }
        PdfObject pdfObject = pdfArray.getPdfObject(0);
        if (pdfObject.isNumber()) {
            stringBuilder.append(((PdfNumber)pdfObject).intValue() + 1);
        } else {
            stringBuilder.append(intHashtable.get(SimpleBookmark.a((PdfIndirectReference)pdfObject)));
        }
        stringBuilder.append(' ').append(pdfArray.getPdfObject(1).toString().substring(1));
        for (int i2 = 2; i2 < pdfArray.size(); ++i2) {
            stringBuilder.append(' ').append(pdfArray.getPdfObject(i2).toString());
        }
        return stringBuilder.toString();
    }

    private static int a(PdfIndirectReference pdfObject) {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfObject);
        if (pdfDictionary.contains(PdfName.TYPE) && pdfDictionary.get(PdfName.TYPE).equals(PdfName.PAGES) && pdfDictionary.contains(PdfName.KIDS)) {
            pdfObject = (PdfArray)pdfDictionary.get(PdfName.KIDS);
            pdfObject = (PdfIndirectReference)((PdfArray)pdfObject).getPdfObject(0);
        }
        return pdfObject.getNumber();
    }

    @Deprecated
    public static List getBookmark(PdfReader pdfReader) {
        return SimpleBookmark.getBookmarkList(pdfReader);
    }

    public static List<Map<String, Object>> getBookmarkList(PdfReader pdfReader) {
        PdfObject pdfObject = pdfReader.getCatalog();
        if ((pdfObject = PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.OUTLINES))) == null || !pdfObject.isDictionary()) {
            return null;
        }
        pdfObject = (PdfDictionary)pdfObject;
        IntHashtable intHashtable = new IntHashtable();
        int n2 = pdfReader.getNumberOfPages();
        for (int i2 = 1; i2 <= n2; ++i2) {
            intHashtable.put(pdfReader.getPageOrigRef(i2).getNumber(), i2);
            pdfReader.releasePage(i2);
        }
        return SimpleBookmark.a((PdfDictionary)PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject).get(PdfName.FIRST)), intHashtable);
    }

    public static void eliminatePages(List<Map<String, Object>> object, int[] nArray) {
        if (object == null) {
            return;
        }
        object = object.listIterator();
        while (object.hasNext()) {
            Object object2;
            Map map = (Map)object.next();
            boolean bl2 = false;
            if ("GoTo".equals(map.get("Action")) && (object2 = (String)map.get("Page")) != null) {
                int n2 = ((String)(object2 = ((String)object2).trim())).indexOf(32);
                int n3 = n2 < 0 ? Integer.parseInt((String)object2) : Integer.parseInt(((String)object2).substring(0, n2));
                n2 = nArray.length & 0xFFFFFFFE;
                for (int i2 = 0; i2 < n2; i2 += 2) {
                    if (n3 < nArray[i2] || n3 > nArray[i2 + 1]) continue;
                    bl2 = true;
                    break;
                }
            }
            if ((object2 = (List)map.get("Kids")) != null) {
                SimpleBookmark.eliminatePages((List<Map<String, Object>>)object2, nArray);
                if (object2.isEmpty()) {
                    map.remove("Kids");
                    object2 = null;
                }
            }
            if (!bl2) continue;
            if (object2 == null) {
                object.remove();
                continue;
            }
            map.remove("Action");
            map.remove("Page");
            map.remove("Named");
        }
    }

    @Deprecated
    public static void shiftPageNumbers(List list, int n2, int[] nArray) {
        SimpleBookmark.shiftPageNumbersInRange(list, n2, nArray);
    }

    public static void shiftPageNumbersInRange(List<Map<String, Object>> object, int n2, int[] nArray) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2;
            Map map = (Map)object.next();
            if ("GoTo".equals(map.get("Action")) && (object2 = (String)map.get("Page")) != null) {
                int n3 = ((String)(object2 = ((String)object2).trim())).indexOf(32);
                int n4 = n3 < 0 ? Integer.parseInt((String)object2) : Integer.parseInt(((String)object2).substring(0, n3));
                boolean bl2 = false;
                if (nArray == null) {
                    bl2 = true;
                } else {
                    int n5 = nArray.length & 0xFFFFFFFE;
                    for (int i2 = 0; i2 < n5; i2 += 2) {
                        if (n4 < nArray[i2] || n4 > nArray[i2 + 1]) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) {
                    object2 = n3 < 0 ? Integer.toString(n4 + n2) : n4 + n2 + ((String)object2).substring(n3);
                }
                map.put("Page", object2);
            }
            if ((object2 = (List)map.get("Kids")) == null) continue;
            SimpleBookmark.shiftPageNumbersInRange((List<Map<String, Object>>)object2, n2, nArray);
        }
    }

    public static Object[] iterateOutlines(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, List<Map<String, Object>> object, boolean n2) {
        int n3;
        PdfIndirectReference[] pdfIndirectReferenceArray = new PdfIndirectReference[object.size()];
        for (n3 = 0; n3 < pdfIndirectReferenceArray.length; ++n3) {
            pdfIndirectReferenceArray[n3] = pdfWriter.getPdfIndirectReference();
        }
        n3 = 0;
        int n4 = 0;
        object = object.listIterator();
        while (object.hasNext()) {
            int n5;
            Object object2;
            Object object3 = (Map)object.next();
            Object object4 = null;
            Object object5 = (List)object3.get("Kids");
            if (object5 != null && !object5.isEmpty()) {
                object4 = SimpleBookmark.iterateOutlines(pdfWriter, pdfIndirectReferenceArray[n3], (List<Map<String, Object>>)object5, n2 != 0);
            }
            object5 = new PdfDictionary();
            ++n4;
            if (object4 != null) {
                ((PdfDictionary)object5).put(PdfName.FIRST, (PdfIndirectReference)object4[0]);
                ((PdfDictionary)object5).put(PdfName.LAST, (PdfIndirectReference)object4[1]);
                int n6 = (Integer)object4[2];
                if ("false".equals(object3.get("Open"))) {
                    ((PdfDictionary)object5).put(PdfName.COUNT, new PdfNumber(-n6));
                } else {
                    ((PdfDictionary)object5).put(PdfName.COUNT, new PdfNumber(n6));
                    n4 += n6;
                }
            }
            ((PdfDictionary)object5).put(PdfName.PARENT, pdfIndirectReference);
            if (n3 > 0) {
                ((PdfDictionary)object5).put(PdfName.PREV, pdfIndirectReferenceArray[n3 - 1]);
            }
            if (n3 < pdfIndirectReferenceArray.length - 1) {
                ((PdfDictionary)object5).put(PdfName.NEXT, pdfIndirectReferenceArray[n3 + 1]);
            }
            ((PdfDictionary)object5).put(PdfName.TITLE, new PdfString((String)object3.get("Title"), "UnicodeBig"));
            Object object6 = (String)object3.get("Color");
            if (object6 != null) {
                try {
                    object2 = new PdfArray();
                    object6 = new StringTokenizer((String)object6);
                    for (n5 = 0; n5 < 3; ++n5) {
                        float f2;
                        float f3 = Float.parseFloat(((StringTokenizer)object6).nextToken());
                        if (f2 < 0.0f) {
                            f3 = 0.0f;
                        }
                        if (f3 > 1.0f) {
                            f3 = 1.0f;
                        }
                        ((PdfArray)object2).add(new PdfNumber(f3));
                    }
                    ((PdfDictionary)object5).put(PdfName.C, (PdfObject)object2);
                }
                catch (Exception exception) {}
            }
            if ((object2 = (String)object3.get("Style")) != null) {
                object2 = ((String)object2).toLowerCase();
                int n7 = 0;
                if (((String)object2).contains("italic")) {
                    n7 = 1;
                }
                if (((String)object2).contains("bold")) {
                    n7 |= 2;
                }
                if (n7 != 0) {
                    ((PdfDictionary)object5).put(PdfName.F, new PdfNumber(n7));
                }
            }
            n5 = n2;
            object2 = pdfWriter;
            object4 = object3;
            object3 = object5;
            try {
                int n8;
                Object object7;
                Object object8 = (String)object4.get("Action");
                if ("GoTo".equals(object8)) {
                    object8 = (String)object4.get("Named");
                    if (object8 != null) {
                        if (n5 != 0) {
                            ((PdfDictionary)object3).put(PdfName.DEST, new PdfName((String)object8));
                        } else {
                            ((PdfDictionary)object3).put(PdfName.DEST, new PdfString((String)object8, null));
                        }
                    } else {
                        object8 = (String)object4.get("Page");
                        if (object8 != null) {
                            PdfArray pdfArray = new PdfArray();
                            object7 = new StringTokenizer((String)object8);
                            int n9 = Integer.parseInt(((StringTokenizer)object7).nextToken());
                            pdfArray.add(((PdfWriter)object2).getPageReference(n9));
                            if (!((StringTokenizer)object7).hasMoreTokens()) {
                                pdfArray.add(PdfName.XYZ);
                                pdfArray.add(new float[]{0.0f, 10000.0f, 0.0f});
                            } else {
                                object2 = ((StringTokenizer)object7).nextToken();
                                if (((String)object2).startsWith("/")) {
                                    object2 = ((String)object2).substring(1);
                                }
                                pdfArray.add(new PdfName((String)object2));
                                for (n8 = 0; n8 < 4 && ((StringTokenizer)object7).hasMoreTokens(); ++n8) {
                                    object2 = ((StringTokenizer)object7).nextToken();
                                    if (((String)object2).equals("null")) {
                                        pdfArray.add(PdfNull.PDFNULL);
                                        continue;
                                    }
                                    pdfArray.add(new PdfNumber((String)object2));
                                }
                            }
                            ((PdfDictionary)object3).put(PdfName.DEST, pdfArray);
                        }
                    }
                } else if ("GoToR".equals(object8)) {
                    PdfDictionary pdfDictionary = new PdfDictionary();
                    object8 = (String)object4.get("Named");
                    if (object8 != null) {
                        pdfDictionary.put(PdfName.D, new PdfString((String)object8, null));
                    } else {
                        object8 = (String)object4.get("NamedN");
                        if (object8 != null) {
                            pdfDictionary.put(PdfName.D, new PdfName((String)object8));
                        } else {
                            object8 = (String)object4.get("Page");
                            if (object8 != null) {
                                object7 = new PdfArray();
                                object8 = new StringTokenizer((String)object8);
                                ((PdfArray)object7).add(new PdfNumber(((StringTokenizer)object8).nextToken()));
                                if (!((StringTokenizer)object8).hasMoreTokens()) {
                                    ((PdfArray)object7).add(PdfName.XYZ);
                                    ((PdfArray)object7).add(new float[]{0.0f, 10000.0f, 0.0f});
                                } else {
                                    object2 = ((StringTokenizer)object8).nextToken();
                                    if (((String)object2).startsWith("/")) {
                                        object2 = ((String)object2).substring(1);
                                    }
                                    ((PdfArray)object7).add(new PdfName((String)object2));
                                    for (n8 = 0; n8 < 4 && ((StringTokenizer)object8).hasMoreTokens(); ++n8) {
                                        object2 = ((StringTokenizer)object8).nextToken();
                                        if (((String)object2).equals("null")) {
                                            ((PdfArray)object7).add(PdfNull.PDFNULL);
                                            continue;
                                        }
                                        ((PdfArray)object7).add(new PdfNumber((String)object2));
                                    }
                                }
                                pdfDictionary.put(PdfName.D, (PdfObject)object7);
                            }
                        }
                    }
                    object7 = (String)object4.get("File");
                    if (pdfDictionary.size() > 0 && object7 != null) {
                        pdfDictionary.put(PdfName.S, PdfName.GOTOR);
                        pdfDictionary.put(PdfName.F, new PdfString((String)object7));
                        object8 = (String)object4.get("NewWindow");
                        if (object8 != null) {
                            if (((String)object8).equals("true")) {
                                pdfDictionary.put(PdfName.NEWWINDOW, PdfBoolean.PDFTRUE);
                            } else if (((String)object8).equals("false")) {
                                pdfDictionary.put(PdfName.NEWWINDOW, PdfBoolean.PDFFALSE);
                            }
                        }
                        ((PdfDictionary)object3).put(PdfName.A, pdfDictionary);
                    }
                } else if ("URI".equals(object8)) {
                    object8 = (String)object4.get("URI");
                    if (object8 != null) {
                        PdfDictionary pdfDictionary = new PdfDictionary();
                        pdfDictionary.put(PdfName.S, PdfName.URI);
                        pdfDictionary.put(PdfName.URI, new PdfString((String)object8));
                        ((PdfDictionary)object3).put(PdfName.A, pdfDictionary);
                    }
                } else if ("Launch".equals(object8) && (object8 = (String)object4.get("File")) != null) {
                    PdfDictionary pdfDictionary = new PdfDictionary();
                    pdfDictionary.put(PdfName.S, PdfName.LAUNCH);
                    pdfDictionary.put(PdfName.F, new PdfString((String)object8));
                    ((PdfDictionary)object3).put(PdfName.A, pdfDictionary);
                }
            }
            catch (Exception exception) {}
            pdfWriter.addToBody((PdfObject)object5, pdfIndirectReferenceArray[n3]);
            ++n3;
        }
        return new Object[]{pdfIndirectReferenceArray[0], pdfIndirectReferenceArray[pdfIndirectReferenceArray.length - 1], n4};
    }

    /*
     * WARNING - void declaration
     */
    public static void exportToXMLNode(List iterator, Writer writer, int n2, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append("  ");
        }
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            iterator = iterator2.next();
            iterator = (Map)((Object)iterator);
            String string = null;
            writer.write(stringBuilder.toString());
            writer.write("<Title ");
            List list = null;
            iterator = iterator.entrySet().iterator();
            while (iterator.hasNext()) {
                void var8_14;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                String string2 = (String)entry.getKey();
                if (string2.equals("Title")) {
                    string = (String)entry2.getValue();
                    continue;
                }
                if (string2.equals("Kids")) {
                    list = (List)entry2.getValue();
                    continue;
                }
                writer.write(string2);
                writer.write("=\"");
                String string3 = (String)entry2.getValue();
                if (string2.equals("Named") || string2.equals("NamedN")) {
                    String string4 = SimpleNamedDestination.escapeBinaryString(string3);
                }
                writer.write(XMLUtil.escapeXML((String)var8_14, bl2));
                writer.write("\" ");
            }
            writer.write(">");
            if (string == null) {
                string = "";
            }
            writer.write(XMLUtil.escapeXML(string, bl2));
            if (list != null) {
                writer.write("\n");
                SimpleBookmark.exportToXMLNode(list, writer, n2 + 1, bl2);
                writer.write(stringBuilder.toString());
            }
            writer.write("</Title>\n");
        }
    }

    public static void exportToXML(List list, OutputStream closeable, String string, boolean bl2) {
        String string2 = IanaEncodings.getJavaEncoding(string);
        closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)closeable, string2));
        SimpleBookmark.exportToXML(list, (Writer)closeable, string, bl2);
    }

    public static void exportToXML(List list, Writer writer, String string, boolean bl2) {
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(XMLUtil.escapeXML(string, bl2));
        writer.write("\"?>\n<Bookmark>\n");
        SimpleBookmark.exportToXMLNode(list, writer, 1, bl2);
        writer.write("</Bookmark>\n");
        writer.flush();
    }

    public static List<Map<String, Object>> importFromXML(InputStream inputStream) {
        SimpleBookmark simpleBookmark = new SimpleBookmark();
        SimpleXMLParser.parse((SimpleXMLDocHandler)simpleBookmark, inputStream);
        return simpleBookmark.a;
    }

    public static List<Map<String, Object>> importFromXML(Reader reader) {
        SimpleBookmark simpleBookmark = new SimpleBookmark();
        SimpleXMLParser.parse((SimpleXMLDocHandler)simpleBookmark, reader);
        return simpleBookmark.a;
    }

    @Override
    public final void endDocument() {
    }

    @Override
    public final void endElement(String object) {
        if (((String)object).equals("Bookmark")) {
            if (this.b.isEmpty()) {
                return;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("bookmark.end.tag.out.of.place"));
        }
        if (!((String)object).equals("Title")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.end.tag.1", object));
        }
        object = this.b.pop();
        Map<String, Object> map = (String)object.get("Title");
        object.put("Title", ((String)((Object)map)).trim());
        map = (String)object.get("Named");
        if (map != null) {
            object.put("Named", SimpleNamedDestination.unEscapeBinaryString((String)((Object)map)));
        }
        if ((map = (String)object.get("NamedN")) != null) {
            object.put("NamedN", SimpleNamedDestination.unEscapeBinaryString((String)((Object)map)));
        }
        if (this.b.isEmpty()) {
            this.a.add((Map<String, Object>)object);
            return;
        }
        map = this.b.peek();
        ArrayList<Object> arrayList = (ArrayList<Object>)map.get("Kids");
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            map.put("Kids", arrayList);
        }
        arrayList.add(object);
    }

    @Override
    public final void startDocument() {
    }

    @Override
    @Deprecated
    public final void startElement(String string, HashMap hashMap) {
        this.startElement(string, (Map<String, String>)hashMap);
    }

    @Override
    public final void startElement(String object, Map<String, String> map) {
        if (this.a == null) {
            if (((String)object).equals("Bookmark")) {
                this.a = new ArrayList<Map<String, Object>>();
                return;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("root.element.is.not.bookmark.1", object));
        }
        if (!((String)object).equals("Title")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("tag.1.not.allowed", object));
        }
        object = new HashMap<String, String>(map);
        object.put((String)"Title", (String)"");
        object.remove("Kids");
        this.b.push((Map<String, Object>)object);
    }

    @Override
    public final void text(String string) {
        if (this.b.isEmpty()) {
            return;
        }
        Map<String, Object> map = this.b.peek();
        String string2 = (String)map.get("Title");
        string2 = string2 + string;
        map.put("Title", string2);
    }
}

