/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNameTree;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.xml.XMLUtil;
import com.lowagie.text.xml.simpleparser.IanaEncodings;
import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import com.lowagie.text.xml.simpleparser.SimpleXMLParser;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class SimpleNamedDestination
implements SimpleXMLDocHandler {
    private HashMap<String, String> a;
    private Map<String, String> b;

    private SimpleNamedDestination() {
    }

    public static HashMap<Object, Object> getNamedDestination(PdfReader object, boolean bl2) {
        IntHashtable intHashtable = new IntHashtable();
        int n2 = ((PdfReader)object).getNumberOfPages();
        for (int i2 = 1; i2 <= n2; ++i2) {
            intHashtable.put(((PdfReader)object).getPageOrigRef(i2).getNumber(), i2);
        }
        HashMap hashMap = bl2 ? ((PdfReader)object).getNamedDestinationFromNames() : ((PdfReader)object).getNamedDestinationFromStrings();
        object = hashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            PdfArray pdfArray = (PdfArray)entry.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            try {
                stringBuilder.append(intHashtable.get(pdfArray.getAsIndirectObject(0).getNumber()));
                stringBuilder.append(' ').append(pdfArray.getPdfObject(1).toString().substring(1));
                for (int i3 = 2; i3 < pdfArray.size(); ++i3) {
                    stringBuilder.append(' ').append(pdfArray.getPdfObject(i3).toString());
                }
                entry.setValue(stringBuilder.toString());
            }
            catch (Exception exception) {
                object.remove();
            }
        }
        return hashMap;
    }

    public static void exportToXML(HashMap hashMap, OutputStream closeable, String string, boolean bl2) {
        String string2 = IanaEncodings.getJavaEncoding(string);
        closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)closeable, string2));
        SimpleNamedDestination.exportToXML(hashMap, (Writer)closeable, string, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public static void exportToXML(HashMap object, Writer writer, String object22, boolean bl2) {
        void var3_7;
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(XMLUtil.escapeXML((String)object22, (boolean)var3_7));
        writer.write("\"?>\n<Destination>\n");
        object = ((HashMap)((Object)object)).entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = object.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry2.getValue();
            writer.write("  <Name Page=\"");
            writer.write(XMLUtil.escapeXML(string2, (boolean)var3_7));
            writer.write("\">");
            writer.write(XMLUtil.escapeXML(SimpleNamedDestination.escapeBinaryString(string), (boolean)var3_7));
            writer.write("</Name>\n");
        }
        writer.write("</Destination>\n");
        writer.flush();
    }

    public static HashMap<String, String> importFromXML(InputStream inputStream) {
        SimpleNamedDestination simpleNamedDestination = new SimpleNamedDestination();
        SimpleXMLParser.parse((SimpleXMLDocHandler)simpleNamedDestination, inputStream);
        return simpleNamedDestination.a;
    }

    public static HashMap<String, String> importFromXML(Reader reader) {
        SimpleNamedDestination simpleNamedDestination = new SimpleNamedDestination();
        SimpleXMLParser.parse((SimpleXMLDocHandler)simpleNamedDestination, reader);
        return simpleNamedDestination.a;
    }

    private static PdfArray a(String object, PdfWriter object2) {
        PdfArray pdfArray = new PdfArray();
        object = new StringTokenizer((String)object);
        int n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
        pdfArray.add(((PdfWriter)object2).getPageReference(n2));
        if (!((StringTokenizer)object).hasMoreTokens()) {
            pdfArray.add(PdfName.XYZ);
            pdfArray.add(new float[]{0.0f, 10000.0f, 0.0f});
        } else {
            object2 = ((StringTokenizer)object).nextToken();
            if (((String)object2).startsWith("/")) {
                object2 = ((String)object2).substring(1);
            }
            pdfArray.add(new PdfName((String)object2));
            for (n2 = 0; n2 < 4 && ((StringTokenizer)object).hasMoreTokens(); ++n2) {
                object2 = ((StringTokenizer)object).nextToken();
                if (((String)object2).equals("null")) {
                    pdfArray.add(PdfNull.PDFNULL);
                    continue;
                }
                pdfArray.add(new PdfNumber((String)object2));
            }
        }
        return pdfArray;
    }

    public static PdfDictionary outputNamedDestinationAsNames(HashMap object, PdfWriter pdfWriter) {
        PdfDictionary pdfDictionary = new PdfDictionary();
        object = ((HashMap)((Object)object)).entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = object.next();
            try {
                Object object2 = (String)entry2.getKey();
                String string = (String)entry2.getValue();
                PdfArray pdfArray = SimpleNamedDestination.a(string, pdfWriter);
                object2 = new PdfName((String)object2);
                pdfDictionary.put((PdfName)object2, pdfArray);
            }
            catch (Exception exception) {}
        }
        return pdfDictionary;
    }

    public static PdfDictionary outputNamedDestinationAsStrings(Map<String, String> object, PdfWriter pdfWriter) {
        HashMap hashMap = new HashMap();
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            try {
                Object object2 = (String)entry.getValue();
                object2 = SimpleNamedDestination.a((String)object2, pdfWriter);
                hashMap.put(entry.getKey(), pdfWriter.addToBody((PdfObject)object2).getIndirectReference());
            }
            catch (Exception exception) {
                object.remove();
            }
        }
        return PdfNameTree.writeTree(hashMap, pdfWriter);
    }

    public static String escapeBinaryString(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            if (object2 < 32) {
                String string;
                stringBuilder.append('\\');
                String string2 = string = "00" + Integer.toOctalString((int)object2);
                stringBuilder.append(string2.substring(string2.length() - 3));
                continue;
            }
            if (object2 == 92) {
                stringBuilder.append("\\\\");
                continue;
            }
            stringBuilder.append((char)object2);
        }
        return stringBuilder.toString();
    }

    public static String unEscapeBinaryString(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            if (object2 == 92) {
                if (++i2 >= n2) {
                    stringBuilder.append('\\');
                    break;
                }
                object2 = object[i2];
                if (object2 >= 48 && object2 <= 55) {
                    reference var5_5 = object2 - 48;
                    ++i2;
                    for (int i3 = 0; i3 < 2 && i2 < n2 && (object2 = object[i2]) >= 48 && object2 <= 55; ++i2, ++i3) {
                        var5_5 = (var5_5 << 3) + object2 - 48;
                    }
                    --i2;
                    stringBuilder.append((char)var5_5);
                    continue;
                }
                stringBuilder.append((char)object2);
                continue;
            }
            stringBuilder.append((char)object2);
        }
        return stringBuilder.toString();
    }

    @Override
    public final void endDocument() {
    }

    @Override
    public final void endElement(String string) {
        if (string.equals("Destination")) {
            if (this.b == null && this.a != null) {
                return;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("destination.end.tag.out.of.place"));
        }
        if (!string.equals("Name")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.end.tag.1", string));
        }
        if (this.b == null || this.a == null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("name.end.tag.out.of.place"));
        }
        if (!this.b.containsKey("Page")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("page.attribute.missing"));
        }
        this.a.put(SimpleNamedDestination.unEscapeBinaryString(this.b.get("Name")), this.b.get("Page"));
        this.b = null;
    }

    @Override
    public final void startDocument() {
    }

    @Override
    @Deprecated
    public final void startElement(String string, HashMap hashMap) {
        this.startElement(string, (Map<String, String>)hashMap);
    }

    @Override
    public final void startElement(String string, Map<String, String> map) {
        if (this.a == null) {
            if (string.equals("Destination")) {
                this.a = new HashMap();
                return;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("root.element.is.not.destination"));
        }
        if (!string.equals("Name")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("tag.1.not.allowed", string));
        }
        if (this.b != null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("nested.tags.are.not.allowed"));
        }
        this.b = new HashMap<String, String>(map);
        this.b.put("Name", "");
    }

    @Override
    public final void text(String string) {
        if (this.b == null) {
            return;
        }
        String string2 = this.b.get("Name");
        string2 = string2 + string;
        this.b.put("Name", string2);
    }
}

