/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.TSAClient;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.Base64;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public class TSAClientBouncyCastle
implements TSAClient {
    protected String tsaURL;
    protected String tsaUsername;
    protected String tsaPassword;
    protected int tokSzEstimate;
    private Proxy a;
    private String b;
    private String c;

    public TSAClientBouncyCastle(String string) {
        this(string, null, null, 4096);
    }

    public TSAClientBouncyCastle(String string, String string2, String string3) {
        this(string, string2, string3, 4096);
    }

    public TSAClientBouncyCastle(String string, String string2, String string3, int n2) {
        this.tsaURL = string;
        this.tsaUsername = string2;
        this.tsaPassword = string3;
        this.tokSzEstimate = n2;
    }

    @Override
    public int getTokenSizeEstimate() {
        return this.tokSzEstimate;
    }

    @Override
    public MessageDigest getMessageDigest() {
        return MessageDigest.getInstance(TSAClientBouncyCastle.a(this.c) ? this.c : "SHA-1");
    }

    @Override
    public byte[] getTimeStampToken(PdfPKCS7 pdfPKCS7, byte[] byArray) {
        return this.getTimeStampToken(byArray);
    }

    protected byte[] getTimeStampToken(byte[] object) {
        try {
            TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
            timeStampRequestGenerator.setCertReq(true);
            if (TSAClientBouncyCastle.a(this.b)) {
                timeStampRequestGenerator.setReqPolicy(new ASN1ObjectIdentifier(this.b));
            }
            BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
            ASN1ObjectIdentifier aSN1ObjectIdentifier = X509ObjectIdentifiers.id_SHA1;
            if (TSAClientBouncyCastle.a(this.c)) {
                aSN1ObjectIdentifier = new ASN1ObjectIdentifier(PdfPKCS7.getDigestOid(this.c));
            }
            timeStampRequestGenerator = timeStampRequestGenerator.generate(aSN1ObjectIdentifier, object, bigInteger);
            object = timeStampRequestGenerator.getEncoded();
            object = this.getTSAResponse((byte[])object);
            TimeStampResponse timeStampResponse = new TimeStampResponse(object);
            object = timeStampResponse;
            timeStampResponse.validate((TimeStampRequest)timeStampRequestGenerator);
            timeStampRequestGenerator = object.getFailInfo();
            int n2 = timeStampRequestGenerator == null ? 0 : timeStampRequestGenerator.intValue();
            if (n2 != 0) {
                throw new Exception(MessageLocalization.getComposedMessage("invalid.tsa.1.response.code.2", this.tsaURL, String.valueOf(n2)));
            }
            TimeStampToken timeStampToken = object.getTimeStampToken();
            if (timeStampToken == null) {
                throw new Exception(MessageLocalization.getComposedMessage("tsa.1.failed.to.return.time.stamp.token.2", this.tsaURL, object.getStatusString()));
            }
            timeStampToken.getTimeStampInfo();
            object = timeStampToken.getEncoded();
            System.currentTimeMillis();
            this.tokSzEstimate = ((byte[])object).length + 32;
            return object;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw exception;
        }
        catch (Throwable throwable) {
            throw new Exception(MessageLocalization.getComposedMessage("failed.to.get.tsa.response.from.1", this.tsaURL), throwable);
        }
    }

    protected byte[] getTSAResponse(byte[] object) {
        int n2;
        Object object2 = new URL(this.tsaURL);
        Object object3 = this.a == null ? Proxy.NO_PROXY : this.a;
        object2 = ((URL)object2).openConnection((Proxy)object3);
        ((URLConnection)object2).setDoInput(true);
        ((URLConnection)object2).setDoOutput(true);
        ((URLConnection)object2).setUseCaches(false);
        ((URLConnection)object2).setRequestProperty("Content-Type", "application/timestamp-query");
        ((URLConnection)object2).setRequestProperty("Content-Transfer-Encoding", "binary");
        if (TSAClientBouncyCastle.a(this.tsaUsername)) {
            object3 = this.tsaUsername + ":" + this.tsaPassword;
            ((URLConnection)object2).setRequestProperty("Authorization", "Basic " + new String(Base64.getEncoder().encode(((String)object3).getBytes())));
        }
        object3 = ((URLConnection)object2).getOutputStream();
        ((OutputStream)object3).write((byte[])object);
        ((OutputStream)object3).close();
        object = ((URLConnection)object2).getInputStream();
        object3 = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = object.read(byArray, 0, byArray.length)) >= 0) {
            ((ByteArrayOutputStream)object3).write(byArray, 0, n2);
        }
        object = ((ByteArrayOutputStream)object3).toByteArray();
        if ((object2 = ((URLConnection)object2).getContentEncoding()) != null && ((String)object2).equalsIgnoreCase("base64")) {
            object = Base64.getDecoder().decode((byte[])object);
        }
        return object;
    }

    public void setProxy(Proxy proxy) {
        this.a = proxy;
    }

    public Proxy getProxy() {
        return this.a;
    }

    public String getPolicy() {
        return this.b;
    }

    public void setPolicy(String string) {
        this.b = string;
    }

    public String getTsaURL() {
        return this.tsaURL;
    }

    public String getTsaUsername() {
        return this.tsaUsername;
    }

    public String getTsaPassword() {
        return this.tsaPassword;
    }

    public int getTokSzEstimate() {
        return this.tokSzEstimate;
    }

    public String getDigestName() {
        return this.c;
    }

    public void setDigestName(String string) {
        this.c = string;
    }

    private static boolean a(String string) {
        return string != null && !string.isEmpty();
    }
}

