/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TextField
extends BaseField {
    private String a;
    private String[] b;
    private String[] c;
    private ArrayList<Integer> d = new ArrayList();
    private int e;
    private float f;
    private float g;
    private List<BaseFont> h;
    private BaseFont i;

    public TextField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        super(pdfWriter, rectangle, string);
    }

    private static boolean a(String object) {
        if (object == null || ((String)object).length() == 0) {
            return false;
        }
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            if (object2 < 1424 || object2 >= 1920) continue;
            return true;
        }
        return false;
    }

    private static void a(Phrase object, float f2) {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            ((Chunk)e2).getFont().setSize(f2);
        }
    }

    private Phrase a(String object, BaseFont object2, Color color, float f2) {
        if (this.i == null && (this.h == null || this.h.isEmpty())) {
            object = new Phrase(new Chunk((String)object, new Font((BaseFont)object2, f2, 0, color)));
        } else {
            FontSelector fontSelector = new FontSelector();
            fontSelector.addFont(new Font((BaseFont)object2, f2, 0, color));
            if (this.i != null) {
                fontSelector.addFont(new Font(this.i, f2, 0, color));
            }
            if (this.h != null) {
                for (BaseFont baseFont : this.h) {
                    fontSelector.addFont(new Font(baseFont, f2, 0, color));
                }
            }
            object = fontSelector.process((String)object);
        }
        return object;
    }

    public static String removeCRLF(String object) {
        if (((String)object).indexOf(10) >= 0 || ((String)object).indexOf(13) >= 0) {
            object = ((String)object).toCharArray();
            StringBuilder stringBuilder = new StringBuilder(((Object)object).length);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                Object object2 = object[i2];
                if (object2 == 10) {
                    stringBuilder.append(' ');
                    continue;
                }
                if (object2 == 13) {
                    stringBuilder.append(' ');
                    if (i2 >= ((Object)object).length - 1 || object[i2 + 1] != 10) continue;
                    ++i2;
                    continue;
                }
                stringBuilder.append((char)object2);
            }
            return stringBuilder.toString();
        }
        return object;
    }

    public static String obfuscatePassword(String string) {
        char[] cArray = new char[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            cArray[i2] = 42;
        }
        return new String(cArray);
    }

    public PdfAppearance getAppearance() {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.text == null || this.text.length() == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        boolean bl2 = this.borderStyle == 2 || this.borderStyle == 3;
        float f2 = this.box.getHeight() - this.borderWidth * 2.0f - this.g;
        float f3 = this.borderWidth;
        if (bl2) {
            f2 -= this.borderWidth * 2.0f;
            f3 *= 2.0f;
        }
        float f4 = Math.max(f3, 1.0f);
        f3 = Math.min(f3, f4);
        pdfAppearance.saveState();
        float f5 = f3;
        pdfAppearance.rectangle(f5, f5, this.box.getWidth() - f3 * 2.0f, this.box.getHeight() - f3 * 2.0f);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        String string = (this.options & 0x2000) != 0 ? TextField.obfuscatePassword(this.text) : ((this.options & 0x1000) == 0 ? TextField.removeCRLF(this.text) : this.text);
        BaseFont baseFont = this.getRealFont();
        Object object = this.textColor == null ? GrayColor.GRAYBLACK : this.textColor;
        int n2 = TextField.a(string) ? 2 : 1;
        float f6 = this.fontSize;
        object = this.a(string, baseFont, (Color)object, f6);
        if ((this.options & 0x1000) != 0) {
            float f7 = this.box.getWidth() - 4.0f * f4 - this.f;
            float f8 = baseFont.getFontDescriptor(8, 1.0f) - baseFont.getFontDescriptor(6, 1.0f);
            ColumnText columnText = new ColumnText(null);
            if (f6 == 0.0f) {
                float f9;
                f6 = f2 / f8;
                if (f9 > 4.0f) {
                    if (f6 > 12.0f) {
                        f6 = 12.0f;
                    }
                    float f10 = Math.max((f6 - 4.0f) / 10.0f, 0.2f);
                    columnText.setSimpleColumn(0.0f, -f2, f7, 0.0f);
                    columnText.setAlignment(this.alignment);
                    columnText.setRunDirection(n2);
                    while (f6 > 4.0f) {
                        columnText.setYLine(0.0f);
                        TextField.a((Phrase)object, f6);
                        columnText.setText((Phrase)object);
                        columnText.setLeading(f8 * f6);
                        int n3 = columnText.go(true);
                        if ((n3 & 2) == 0) break;
                        f6 -= f10;
                    }
                }
                if (f6 < 4.0f) {
                    f6 = 4.0f;
                }
            }
            TextField.a((Phrase)object, f6);
            columnText.setCanvas(pdfAppearance);
            float f11 = f6 * f8;
            float f12 = f4 + f2 - baseFont.getFontDescriptor(8, f6);
            columnText.setSimpleColumn(this.f + f4 * 2.0f, -20000.0f, this.box.getWidth() - f4 * 2.0f, f12 + f11);
            columnText.setLeading(f11);
            columnText.setAlignment(this.alignment);
            columnText.setRunDirection(n2);
            columnText.setText((Phrase)object);
            columnText.go();
        } else {
            float f13;
            float f14;
            float f15;
            if (f6 == 0.0f) {
                f15 = f2 / (baseFont.getFontDescriptor(7, 1.0f) - baseFont.getFontDescriptor(6, 1.0f));
                TextField.a((Phrase)object, 1.0f);
                f14 = ColumnText.getWidth((Phrase)object, n2, 0);
                f6 = f14 == 0.0f ? f15 : Math.min(f15, (this.box.getWidth() - this.f - 4.0f * f4) / f14);
                if (f6 < 4.0f) {
                    f6 = 4.0f;
                }
            }
            TextField.a((Phrase)object, f6);
            f15 = f3 + (this.box.getHeight() - f3 * 2.0f - baseFont.getFontDescriptor(1, f6)) / 2.0f;
            if (f13 < f3) {
                f15 = f3;
            }
            if (f15 - f3 < -baseFont.getFontDescriptor(3, f6)) {
                f14 = -baseFont.getFontDescriptor(3, f6) + f3;
                f3 = this.box.getHeight() - f3 - baseFont.getFontDescriptor(1, f6);
                f15 = Math.min(f14, Math.max(f15, f3));
            }
            if ((this.options & 0x1000000) != 0 && this.maxCharacterLength > 0) {
                int n4 = Math.min(this.maxCharacterLength, string.length());
                int n5 = 0;
                if (this.alignment == 2) {
                    n5 = this.maxCharacterLength - n4;
                } else if (this.alignment == 1) {
                    n5 = (this.maxCharacterLength - n4) / 2;
                }
                float f16 = (this.box.getWidth() - this.f) / (float)this.maxCharacterLength;
                float f17 = f16 / 2.0f + (float)n5 * f16;
                if (this.textColor == null) {
                    pdfAppearance.setGrayFill(0.0f);
                } else {
                    pdfAppearance.setColorFill(this.textColor);
                }
                pdfAppearance.beginText();
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    object2 = (Chunk)object2;
                    BaseFont baseFont2 = ((Chunk)object2).getFont().getBaseFont();
                    ((PdfContentByte)pdfAppearance).setFontAndSize(baseFont2, f6);
                    object2 = ((Chunk)object2).append("");
                    int n6 = 0;
                    while (n6 < ((StringBuffer)object2).length()) {
                        int n7 = n6++;
                        object = ((StringBuffer)object2).substring(n7, n7 + 1);
                        float f18 = baseFont2.getWidthPoint((String)object, f6);
                        pdfAppearance.setTextMatrix(this.f + f17 - f18 / 2.0f, f15 - this.g);
                        pdfAppearance.showText((String)object);
                        f17 += f16;
                    }
                }
                pdfAppearance.endText();
            } else {
                switch (this.alignment) {
                    case 2: {
                        f14 = this.f + this.box.getWidth() - f4 * 2.0f;
                        break;
                    }
                    case 1: {
                        f14 = this.f + this.box.getWidth() / 2.0f;
                        break;
                    }
                    default: {
                        f14 = this.f + f4 * 2.0f;
                    }
                }
                ColumnText.showTextAligned(pdfAppearance, this.alignment, (Phrase)object, f14, f15 - this.g, 0.0f, n2, 0);
            }
        }
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    final PdfAppearance a() {
        int n2;
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        if (this.b == null || this.b.length == 0) {
            return pdfAppearance;
        }
        pdfAppearance.beginVariableText();
        int n3 = this.c();
        BaseFont baseFont = this.getRealFont();
        float f2 = this.fontSize;
        if (f2 == 0.0f) {
            f2 = 12.0f;
        }
        boolean bl2 = this.borderStyle == 2 || this.borderStyle == 3;
        float f3 = this.box.getHeight() - this.borderWidth * 2.0f;
        float f4 = this.borderWidth;
        if (bl2) {
            f3 -= this.borderWidth * 2.0f;
            f4 *= 2.0f;
        }
        float f5 = baseFont.getFontDescriptor(8, f2) - baseFont.getFontDescriptor(6, f2);
        int n4 = (int)(f3 / f5) + 1;
        if ((n4 = n3 + n4) > this.b.length) {
            n4 = this.b.length;
        }
        this.e = n3;
        pdfAppearance.saveState();
        float f6 = f4;
        pdfAppearance.rectangle(f6, f6, this.box.getWidth() - f4 * 2.0f, this.box.getHeight() - f4 * 2.0f);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        Color color = this.textColor == null ? GrayColor.GRAYBLACK : this.textColor;
        pdfAppearance.setColorFill(new Color(10, 36, 106));
        for (Integer n5 : this.d) {
            n2 = n5;
            if (n2 < n3 || n2 > n4) continue;
            float f7 = f4;
            pdfAppearance.rectangle(f7, f7 + f3 - (float)(n2 - n3 + 1) * f5, this.box.getWidth() - f4 * 2.0f, f5);
            pdfAppearance.fill();
        }
        float f8 = f4 * 2.0f;
        float f9 = f4 + f3 - baseFont.getFontDescriptor(8, f2);
        n2 = n3;
        while (n2 < n4) {
            Object object = this.b[n2];
            int n6 = TextField.a((String)object) ? 2 : 1;
            object = TextField.removeCRLF((String)object);
            GrayColor grayColor = this.d.contains(n2) ? GrayColor.GRAYWHITE : color;
            object = this.a((String)object, baseFont, grayColor, f2);
            ColumnText.showTextAligned(pdfAppearance, 0, (Phrase)object, f8, f9, 0.0f, n6, 0);
            ++n2;
            f9 -= f5;
        }
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    public PdfFormField getTextField() {
        if (this.maxCharacterLength <= 0) {
            this.options &= 0xFEFFFFFF;
        }
        if ((this.options & 0x1000000) != 0) {
            this.options &= 0xFFFFEFFF;
        }
        PdfFormField pdfFormField = PdfFormField.createTextField(this.writer, false, false, this.maxCharacterLength);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        switch (this.alignment) {
            case 1: {
                pdfFormField.setQuadding(1);
                break;
            }
            case 2: {
                pdfFormField.setQuadding(2);
            }
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if (!"".equals(this.text)) {
                pdfFormField.setValueAsString(this.text);
            }
            if (this.a != null) {
                pdfFormField.setDefaultValueAsString(this.a);
            }
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            if ((this.options & 0x1000) != 0) {
                pdfFormField.setFieldFlags(4096);
            }
            if ((this.options & 0x800000) != 0) {
                pdfFormField.setFieldFlags(0x800000);
            }
            if ((this.options & 0x2000) != 0) {
                pdfFormField.setFieldFlags(8192);
            }
            if ((this.options & 0x100000) != 0) {
                pdfFormField.setFieldFlags(0x100000);
            }
            if ((this.options & 0x400000) != 0) {
                pdfFormField.setFieldFlags(0x400000);
            }
            if ((this.options & 0x1000000) != 0) {
                pdfFormField.setFieldFlags(0x1000000);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        pdfAppearance = (PdfAppearance)((PdfContentByte)pdfAppearance).getDuplicate();
        ((PdfContentByte)pdfAppearance).setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance.setGrayFill(0.0f);
        } else {
            pdfAppearance.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }

    public PdfFormField getComboField() {
        return this.getChoiceField(false);
    }

    public PdfFormField getListField() {
        return this.getChoiceField(true);
    }

    private int c() {
        if (this.d == null || this.d.size() == 0) {
            return 0;
        }
        Integer n2 = this.d.get(0);
        if (n2 == null) {
            return 0;
        }
        int n3 = 0;
        if (this.b != null) {
            n3 = n2;
            n3 = Math.min(n3, this.b.length);
            n3 = Math.max(0, n3);
        }
        return n3;
    }

    protected PdfFormField getChoiceField(boolean bl2) {
        PdfAppearance pdfAppearance;
        PdfFormField pdfFormField;
        this.options &= 0xFEFFEFFF;
        String[] stringArray = this.b;
        if (this.b == null) {
            stringArray = new String[]{};
        }
        int n2 = this.c();
        if (this.text == null) {
            this.text = "";
        }
        if (n2 >= 0) {
            this.text = stringArray[n2];
        }
        String[][] stringArray2 = null;
        if (this.c == null) {
            pdfFormField = bl2 ? PdfFormField.createList(this.writer, stringArray, n2) : PdfFormField.createCombo(this.writer, (this.options & 0x40000) != 0, stringArray, n2);
        } else {
            int n3;
            stringArray2 = new String[stringArray.length][2];
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                String string = stringArray[n3];
                stringArray2[n3][1] = string;
                stringArray2[n3][0] = string;
            }
            n3 = Math.min(stringArray.length, this.c.length);
            for (int i2 = 0; i2 < n3; ++i2) {
                if (this.c[i2] == null) continue;
                stringArray2[i2][0] = this.c[i2];
            }
            pdfFormField = bl2 ? PdfFormField.createList(this.writer, stringArray2, n2) : PdfFormField.createCombo(this.writer, (this.options & 0x40000) != 0, stringArray2, n2);
        }
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if (stringArray.length > 0) {
                if (stringArray2 != null) {
                    if (this.d.size() < 2) {
                        pdfFormField.setValueAsString(stringArray2[n2][0]);
                        pdfFormField.setDefaultValueAsString(stringArray2[n2][0]);
                    } else {
                        this.a(pdfFormField, stringArray2);
                    }
                } else if (this.d.size() < 2) {
                    pdfFormField.setValueAsString(this.text);
                    pdfFormField.setDefaultValueAsString(this.text);
                } else {
                    this.a(pdfFormField, null);
                }
            }
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            if ((this.options & 0x400000) != 0) {
                pdfFormField.setFieldFlags(0x400000);
            }
            if ((this.options & 0x200000) != 0) {
                pdfFormField.setFieldFlags(0x200000);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        if (bl2) {
            pdfAppearance = this.a();
            if (this.e > 0) {
                pdfFormField.put(PdfName.TI, new PdfNumber(this.e));
            }
        } else {
            pdfAppearance = this.getAppearance();
        }
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)((PdfContentByte)pdfAppearance).getDuplicate();
        ((PdfContentByte)pdfAppearance2).setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }

    private void a(PdfFormField pdfFormField, String[][] stringArray) {
        PdfArray pdfArray = new PdfArray();
        PdfArray pdfArray2 = new PdfArray();
        for (Integer n2 : this.d) {
            int n3 = n2;
            pdfArray.add(new PdfNumber(n3));
            if (stringArray != null) {
                pdfArray2.add(new PdfString(stringArray[n3][0]));
                continue;
            }
            if (this.b == null) continue;
            pdfArray2.add(new PdfString(this.b[n3]));
        }
        pdfFormField.put(PdfName.V, pdfArray2);
        pdfFormField.put(PdfName.I, pdfArray);
    }

    public String getDefaultText() {
        return this.a;
    }

    public void setDefaultText(String string) {
        this.a = string;
    }

    public String[] getChoices() {
        return this.b;
    }

    public void setChoices(String[] stringArray) {
        this.b = stringArray;
    }

    public String[] getChoiceExports() {
        return this.c;
    }

    public void setChoiceExports(String[] stringArray) {
        this.c = stringArray;
    }

    public int getChoiceSelection() {
        return this.c();
    }

    public ArrayList<Integer> gteChoiceSelections() {
        return this.d;
    }

    public void setChoiceSelection(int n2) {
        this.d = new ArrayList();
        this.d.add(n2);
    }

    public void addChoiceSelection(int n2) {
        if ((this.options & 0x200000) != 0) {
            this.d.add(n2);
        }
    }

    @Deprecated
    public void setChoiceSelections(ArrayList arrayList) {
        this.setChoiceSelections((List<Integer>)arrayList);
    }

    public void setChoiceSelections(List<Integer> list) {
        if (list != null) {
            this.d = new ArrayList<Integer>(list);
            if (this.d.size() > 1 && (this.options & 0x200000) == 0) {
                while (this.d.size() > 1) {
                    this.d.remove(1);
                }
            }
        } else {
            this.d.clear();
        }
    }

    final int b() {
        return this.e;
    }

    public void setExtraMargin(float f2, float f3) {
        this.f = f2;
        this.g = f3;
    }

    @Deprecated
    public ArrayList getSubstitutionFonts() {
        return (ArrayList)this.h;
    }

    public List<BaseFont> getSubstitutionFontList() {
        return this.h;
    }

    @Deprecated
    public void setSubstitutionFonts(List<BaseFont> list) {
        this.h = list;
    }

    public void setSubstitutionFontList(List<BaseFont> list) {
        this.h = list;
    }

    public BaseFont getExtensionFont() {
        return this.i;
    }

    public void setExtensionFont(BaseFont baseFont) {
        this.i = baseFont;
    }
}

