/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.n;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class TrueTypeFont
extends BaseFont {
    private static String[] o = new String[]{"1252 Latin 1", "1250 Latin 2: Eastern Europe", "1251 Cyrillic", "1253 Greek", "1254 Turkish", "1255 Hebrew", "1256 Arabic", "1257 Windows Baltic", "1258 Vietnamese", null, null, null, null, null, null, null, "874 Thai", "932 JIS/Japan", "936 Chinese: Simplified chars--PRC and Singapore", "949 Korean Wansung", "950 Chinese: Traditional chars--Taiwan and Hong Kong", "1361 Korean Johab", null, null, null, null, null, null, null, "Macintosh Character Set (US Roman)", "OEM Character Set", "Symbol Character Set", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "869 IBM Greek", "866 MS-DOS Russian", "865 MS-DOS Nordic", "864 Arabic", "863 MS-DOS Canadian French", "862 Hebrew", "861 MS-DOS Icelandic", "860 MS-DOS Portuguese", "857 IBM Turkish", "855 IBM Cyrillic; primarily Russian", "852 Latin 2", "775 MS-DOS Baltic", "737 Greek; former 437 G", "708 Arabic; ASMO 708", "850 WE/Latin 1", "437 US"};
    private boolean p = false;
    protected HashMap<String, int[]> b;
    protected RandomAccessFileOrArray c;
    protected String d;
    protected boolean e = false;
    private int q;
    private int r;
    protected int f;
    protected String g;
    protected String h = "";
    private FontHeader s = new FontHeader();
    private HorizontalHeader t = new HorizontalHeader();
    protected WindowsMetrics i = new WindowsMetrics();
    private int[] u;
    protected int[][] j;
    protected HashMap<Integer, int[]> k;
    protected HashMap<Integer, int[]> l;
    protected HashMap<Integer, int[]> m;
    private IntHashtable v = new IntHashtable();
    protected String n;
    private String[][] w;
    private String[][] x;
    private String[][] y;
    private double z;
    private boolean A = false;
    private int B;
    private int C;

    protected TrueTypeFont() {
    }

    TrueTypeFont(String string, String string2, boolean bl2, byte[] byArray, boolean bl3, boolean bl4) {
        this.p = bl3;
        String string3 = TrueTypeFont.getBaseName(string);
        String string4 = TrueTypeFont.b(string3);
        if (string3.length() < string.length()) {
            this.h = string.substring(string3.length());
        }
        this.encoding = string2;
        this.embedded = bl2;
        this.d = string4;
        this.a = 1;
        this.g = "";
        if (string4.length() < string3.length()) {
            this.g = string3.substring(string4.length() + 1);
        }
        if (this.d.toLowerCase().endsWith(".ttf") || this.d.toLowerCase().endsWith(".otf") || this.d.toLowerCase().endsWith(".ttc")) {
            this.a(byArray, bl4);
            if (!bl3 && this.embedded && this.i.d == 2) {
                throw new DocumentException(MessageLocalization.getComposedMessage("1.cannot.be.embedded.due.to.licensing.restrictions", this.d + this.h));
            }
        } else {
            throw new DocumentException(MessageLocalization.getComposedMessage("1.is.not.a.ttf.otf.or.ttc.font.file", this.d + this.h));
        }
        if (!this.encoding.startsWith("#")) {
            PdfEncodings.convertToBytes(" ", string2);
        }
        this.createEncoding();
    }

    protected static String b(String string) {
        int n2 = string.toLowerCase().indexOf(".ttc,");
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2 + 4);
    }

    private void a() {
        int[] nArray = this.b.get("head");
        if (nArray == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("table.1.does.not.exist.in.2", "head", this.d + this.h));
        }
        this.c.seek(nArray[0] + 16);
        this.s.a = this.c.readUnsignedShort();
        this.s.b = this.c.readUnsignedShort();
        this.c.skipBytes(16);
        this.s.c = this.c.readShort();
        this.s.d = this.c.readShort();
        this.s.e = this.c.readShort();
        this.s.f = this.c.readShort();
        this.s.g = this.c.readUnsignedShort();
        nArray = this.b.get("hhea");
        if (nArray == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("table.1.does.not.exist.in.2", "hhea", this.d + this.h));
        }
        this.c.seek(nArray[0] + 4);
        this.t.a = this.c.readShort();
        this.t.b = this.c.readShort();
        this.t.c = this.c.readShort();
        this.t.d = this.c.readUnsignedShort();
        this.t.e = this.c.readShort();
        this.t.f = this.c.readShort();
        this.t.g = this.c.readShort();
        this.t.h = this.c.readShort();
        this.t.i = this.c.readShort();
        this.c.skipBytes(12);
        this.t.j = this.c.readUnsignedShort();
        nArray = this.b.get("OS/2");
        if (nArray == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("table.1.does.not.exist.in.2", "OS/2", this.d + this.h));
        }
        this.c.seek(nArray[0]);
        int n2 = this.c.readUnsignedShort();
        this.i.a = this.c.readShort();
        this.i.b = this.c.readUnsignedShort();
        this.i.c = this.c.readUnsignedShort();
        this.i.d = this.c.readShort();
        this.i.e = this.c.readShort();
        this.i.f = this.c.readShort();
        this.i.g = this.c.readShort();
        this.i.h = this.c.readShort();
        this.i.i = this.c.readShort();
        this.i.j = this.c.readShort();
        this.i.k = this.c.readShort();
        this.i.l = this.c.readShort();
        this.i.m = this.c.readShort();
        this.i.n = this.c.readShort();
        this.i.o = this.c.readShort();
        this.c.readFully(this.i.p);
        this.c.skipBytes(16);
        this.c.readFully(this.i.q);
        this.i.r = this.c.readUnsignedShort();
        this.i.s = this.c.readUnsignedShort();
        this.i.t = this.c.readUnsignedShort();
        this.i.u = this.c.readShort();
        this.i.v = this.c.readShort();
        if (this.i.v > 0) {
            this.i.v = -this.i.v;
        }
        this.i.w = this.c.readShort();
        this.i.x = this.c.readUnsignedShort();
        this.i.y = this.c.readUnsignedShort();
        this.i.z = 0;
        this.i.A = 0;
        if (n2 > 0) {
            this.i.z = this.c.readInt();
            this.i.A = this.c.readInt();
        }
        if (n2 > 1) {
            this.c.skipBytes(2);
            this.i.B = this.c.readShort();
        } else {
            this.i.B = (int)(0.7 * (double)this.s.b);
        }
        int[] nArray2 = this.b.get("post");
        if (nArray2 == null) {
            this.z = -Math.atan2(this.t.i, this.t.h) * 180.0 / Math.PI;
            return;
        }
        this.c.seek(nArray2[0] + 4);
        short s2 = this.c.readShort();
        int n3 = this.c.readUnsignedShort();
        this.z = (double)s2 + (double)n3 / 16384.0;
        this.B = this.c.readShort();
        this.C = this.c.readShort();
        this.A = this.c.readInt() != 0;
    }

    final String b() {
        int[] nArray = this.b.get("name");
        if (nArray == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("table.1.does.not.exist.in.2", "name", this.d + this.h));
        }
        this.c.seek(nArray[0] + 2);
        int n2 = this.c.readUnsignedShort();
        int n3 = this.c.readUnsignedShort();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = this.c.readUnsignedShort();
            this.c.readUnsignedShort();
            this.c.readUnsignedShort();
            int n5 = this.c.readUnsignedShort();
            int n6 = this.c.readUnsignedShort();
            int n7 = this.c.readUnsignedShort();
            if (n5 != 6) continue;
            this.c.seek(nArray[0] + n3 + n7);
            if (n4 == 0 || n4 == 3) {
                return this.g(n6);
            }
            return this.c(n6);
        }
        File file = new File(this.d);
        return file.getName().replace(' ', '-');
    }

    private String[][] f(int n2) {
        int n3;
        int[] nArray = this.b.get("name");
        if (nArray == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("table.1.does.not.exist.in.2", "name", this.d + this.h));
        }
        this.c.seek(nArray[0] + 2);
        int n4 = this.c.readUnsignedShort();
        int n5 = this.c.readUnsignedShort();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 = this.c.readUnsignedShort();
            int n6 = this.c.readUnsignedShort();
            int n7 = this.c.readUnsignedShort();
            int n8 = this.c.readUnsignedShort();
            int n9 = this.c.readUnsignedShort();
            int n10 = this.c.readUnsignedShort();
            if (n8 != n2) continue;
            n8 = this.c.getFilePointer();
            this.c.seek(nArray[0] + n5 + n10);
            String string = n3 == 0 || n3 == 3 || n3 == 2 && n6 == 1 ? this.g(n9) : this.c(n9);
            arrayList.add(new String[]{String.valueOf(n3), String.valueOf(n6), String.valueOf(n7), string});
            this.c.seek(n8);
        }
        String[][] stringArray = new String[arrayList.size()][];
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            stringArray[n3] = (String[])arrayList.get(n3);
        }
        return stringArray;
    }

    private String[][] f() {
        int n2;
        int[] nArray = this.b.get("name");
        if (nArray == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("table.1.does.not.exist.in.2", "name", this.d + this.h));
        }
        this.c.seek(nArray[0] + 2);
        int n3 = this.c.readUnsignedShort();
        int n4 = this.c.readUnsignedShort();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = this.c.readUnsignedShort();
            int n5 = this.c.readUnsignedShort();
            int n6 = this.c.readUnsignedShort();
            int n7 = this.c.readUnsignedShort();
            int n8 = this.c.readUnsignedShort();
            int n9 = this.c.readUnsignedShort();
            int n10 = this.c.getFilePointer();
            this.c.seek(nArray[0] + n4 + n9);
            String string = n2 == 0 || n2 == 3 || n2 == 2 && n5 == 1 ? this.g(n8) : this.c(n8);
            arrayList.add(new String[]{String.valueOf(n7), String.valueOf(n2), String.valueOf(n5), String.valueOf(n6), string});
            this.c.seek(n10);
        }
        String[][] stringArray = new String[arrayList.size()][];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray[n2] = (String[])arrayList.get(n2);
        }
        return stringArray;
    }

    private void g() {
        int[] nArray = this.b.get("CFF ");
        if (nArray != null) {
            this.e = true;
            this.q = nArray[0];
            this.r = nArray[1];
        }
    }

    final void a(byte[] byArray, boolean bl2) {
        this.b = new HashMap();
        try {
            int n2;
            this.c = byArray == null ? new RandomAccessFileOrArray(this.d, bl2, Document.plainRandomAccess) : new RandomAccessFileOrArray(byArray);
            if (this.g.length() > 0) {
                int n3 = Integer.parseInt(this.g);
                if (n3 < 0) {
                    throw new DocumentException(MessageLocalization.getComposedMessage("the.font.index.for.1.must.be.positive", this.d));
                }
                String string = this.c(4);
                if (!string.equals("ttcf")) {
                    throw new DocumentException(MessageLocalization.getComposedMessage("1.is.not.a.valid.ttc.file", this.d));
                }
                this.c.skipBytes(4);
                n2 = this.c.readInt();
                if (n3 >= n2) {
                    throw new DocumentException(MessageLocalization.getComposedMessage("the.font.index.for.1.must.be.between.0.and.2.it.was.3", this.d, String.valueOf(n2 - 1), String.valueOf(n3)));
                }
                this.c.skipBytes(n3 << 2);
                this.f = this.c.readInt();
            }
            this.c.seek(this.f);
            int n4 = this.c.readInt();
            if (n4 != 65536 && n4 != 0x4F54544F) {
                throw new DocumentException(MessageLocalization.getComposedMessage("1.is.not.a.valid.ttf.or.otf.file", this.d));
            }
            int n5 = this.c.readUnsignedShort();
            this.c.skipBytes(6);
            for (n2 = 0; n2 < n5; ++n2) {
                String string = this.c(4);
                this.c.skipBytes(4);
                int[] nArray = new int[2];
                int[] nArray2 = nArray;
                nArray[0] = this.c.readInt();
                nArray2[1] = this.c.readInt();
                this.b.put(string, nArray2);
            }
            this.g();
            this.n = this.b();
            this.w = this.f(4);
            this.y = this.f(1);
            this.x = this.f();
            if (!this.p) {
                this.a();
                this.h();
                this.c();
                this.m();
                this.i();
            }
            if (this.c != null) {
                this.c.close();
                if (!this.embedded) {
                    this.c = null;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            if (this.c != null) {
                this.c.close();
                if (!this.embedded) {
                    this.c = null;
                }
            }
            throw throwable;
        }
    }

    protected final String c(int n2) {
        byte[] byArray = new byte[n2];
        this.c.readFully(byArray);
        try {
            return new String(byArray, "Cp1252");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private String g(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        n2 /= 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(this.c.readChar());
        }
        return stringBuilder.toString();
    }

    private void h() {
        int[] nArray = this.b.get("hmtx");
        if (nArray == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("table.1.does.not.exist.in.2", "hmtx", this.d + this.h));
        }
        this.c.seek(nArray[0]);
        this.u = new int[this.t.j];
        for (int i2 = 0; i2 < this.t.j; ++i2) {
            this.u[i2] = this.c.readUnsignedShort() * 1000 / this.s.b;
            this.c.readUnsignedShort();
        }
    }

    protected final int d(int n2) {
        if (n2 >= this.u.length) {
            n2 = this.u.length - 1;
        }
        return this.u[n2];
    }

    private void i() {
        int[] nArray;
        int n2;
        int[] nArray2;
        int n3;
        int[] nArray3 = this.b.get("head");
        if (nArray3 == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("table.1.does.not.exist.in.2", "head", this.d + this.h));
        }
        this.c.seek(nArray3[0] + 51);
        boolean bl2 = this.c.readUnsignedShort() == 0;
        nArray3 = this.b.get("loca");
        if (nArray3 == null) {
            return;
        }
        this.c.seek(nArray3[0]);
        if (bl2) {
            n3 = nArray3[1] / 2;
            nArray2 = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray2[n2] = this.c.readUnsignedShort() << 1;
            }
        } else {
            n3 = nArray3[1] / 4;
            nArray2 = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray2[n2] = this.c.readInt();
            }
        }
        if ((nArray = this.b.get("glyf")) == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("table.1.does.not.exist.in.2", "glyf", this.d + this.h));
        }
        int n4 = nArray[0];
        this.j = new int[nArray2.length - 1][];
        for (n2 = 0; n2 < nArray2.length - 1; ++n2) {
            int n5 = nArray2[n2];
            if (n5 == nArray2[n2 + 1]) continue;
            this.c.seek(n4 + n5 + 2);
            this.j[n2] = new int[]{this.c.readShort() * 1000 / this.s.b, this.c.readShort() * 1000 / this.s.b, this.c.readShort() * 1000 / this.s.b, this.c.readShort() * 1000 / this.s.b};
        }
    }

    void c() {
        int n2;
        Object object = this.b.get("cmap");
        if (object == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("table.1.does.not.exist.in.2", "cmap", this.d + this.h));
        }
        this.c.seek(object[0]);
        this.c.skipBytes(2);
        int n3 = this.c.readUnsignedShort();
        this.fontSpecific = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            int n8 = this.c.readUnsignedShort();
            int n9 = this.c.readUnsignedShort();
            int n10 = this.c.readInt();
            if (n8 == 3 && n9 == 0) {
                this.fontSpecific = true;
                n6 = n10;
            } else if (n8 == 3 && n9 == 1) {
                n5 = n10;
            } else if (n8 == 3 && n9 == 10) {
                n7 = n10;
            }
            if (n8 != 1 || n9 != 0) continue;
            n4 = n10;
        }
        if (n4 > 0) {
            this.c.seek(object[0] + n4);
            n2 = this.c.readUnsignedShort();
            switch (n2) {
                case 0: {
                    this.k = this.j();
                    break;
                }
                case 4: {
                    this.k = this.k();
                    break;
                }
                case 6: {
                    this.k = this.l();
                }
            }
        }
        if (n5 > 0) {
            this.c.seek(object[0] + n5);
            n2 = this.c.readUnsignedShort();
            if (n2 == 4) {
                this.l = this.k();
            }
        }
        if (n6 > 0) {
            this.c.seek(object[0] + n6);
            n2 = this.c.readUnsignedShort();
            if (n2 == 4) {
                this.k = this.k();
            }
        }
        if (n7 > 0) {
            this.c.seek(object[0] + n7);
            n2 = this.c.readUnsignedShort();
            switch (n2) {
                case 0: {
                    this.m = this.j();
                    return;
                }
                case 4: {
                    this.m = this.k();
                    return;
                }
                case 6: {
                    this.m = this.l();
                    return;
                }
                case 12: {
                    object = this;
                    HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
                    object.c.skipBytes(2);
                    object.c.readInt();
                    object.c.skipBytes(4);
                    n4 = object.c.readInt();
                    for (n5 = 0; n5 < n4; ++n5) {
                        n6 = object.c.readInt();
                        n7 = object.c.readInt();
                        n2 = object.c.readInt();
                        while (n6 <= n7) {
                            int[] nArray = new int[2];
                            int[] nArray2 = nArray;
                            nArray[0] = n2++;
                            nArray2[1] = object.d(nArray2[0]);
                            hashMap.put(n6, nArray2);
                            ++n6;
                        }
                    }
                    this.m = hashMap;
                }
            }
        }
    }

    private HashMap<Integer, int[]> j() {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.c.skipBytes(4);
        for (int i2 = 0; i2 < 256; ++i2) {
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = this.c.readUnsignedByte();
            nArray2[1] = this.d(nArray2[0]);
            hashMap.put(i2, nArray2);
        }
        return hashMap;
    }

    private HashMap<Integer, int[]> k() {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        int n2 = this.c.readUnsignedShort();
        this.c.skipBytes(2);
        int n3 = this.c.readUnsignedShort() / 2;
        this.c.skipBytes(6);
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = this.c.readUnsignedShort();
        }
        this.c.skipBytes(2);
        int[] nArray2 = new int[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            nArray2[i3] = this.c.readUnsignedShort();
        }
        int[] nArray3 = new int[n3];
        for (int i4 = 0; i4 < n3; ++i4) {
            nArray3[i4] = this.c.readUnsignedShort();
        }
        int[] nArray4 = new int[n3];
        for (int i5 = 0; i5 < n3; ++i5) {
            nArray4[i5] = this.c.readUnsignedShort();
        }
        int[] nArray5 = new int[n2 / 2 - 8 - (n3 << 2)];
        for (n2 = 0; n2 < nArray5.length; ++n2) {
            nArray5[n2] = this.c.readUnsignedShort();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i6 = nArray2[n2]; i6 <= nArray[n2] && i6 != 65535; ++i6) {
                int n4;
                if (nArray4[n2] == 0) {
                    n4 = i6 + nArray3[n2] & 0xFFFF;
                } else {
                    int n5 = n2 + nArray4[n2] / 2 - n3 + i6 - nArray2[n2];
                    if (n5 >= nArray5.length) continue;
                    n4 = nArray5[n5] + nArray3[n2] & 0xFFFF;
                }
                int[] nArray6 = new int[2];
                int[] nArray7 = nArray6;
                nArray6[0] = n4;
                nArray7[1] = this.d(nArray7[0]);
                hashMap.put(this.fontSpecific ? ((i6 & 0xFF00) == 61440 ? i6 & 0xFF : i6) : i6, nArray7);
            }
        }
        return hashMap;
    }

    private HashMap<Integer, int[]> l() {
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        this.c.skipBytes(4);
        int n2 = this.c.readUnsignedShort();
        int n3 = this.c.readUnsignedShort();
        for (int i2 = 0; i2 < n3; ++i2) {
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = this.c.readUnsignedShort();
            nArray2[1] = this.d(nArray2[0]);
            hashMap.put(i2 + n2, nArray2);
        }
        return hashMap;
    }

    private void m() {
        int[] nArray = this.b.get("kern");
        if (nArray == null) {
            return;
        }
        this.c.seek(nArray[0] + 2);
        int n2 = this.c.readUnsignedShort();
        int n3 = nArray[0] + 4;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.c.seek(n3 += n4);
            this.c.skipBytes(2);
            n4 = this.c.readUnsignedShort();
            int n5 = this.c.readUnsignedShort();
            if ((n5 & 0xFFF7) != 1) continue;
            n5 = this.c.readUnsignedShort();
            this.c.skipBytes(6);
            for (int i3 = 0; i3 < n5; ++i3) {
                int n6 = this.c.readInt();
                int n7 = this.c.readShort() * 1000 / this.s.b;
                this.v.put(n6, n7);
            }
        }
    }

    @Override
    public int getKerning(int n2, int n3) {
        int[] nArray = this.e(n2);
        if (nArray == null) {
            return 0;
        }
        int n4 = nArray[0];
        nArray = this.e(n3);
        if (nArray == null) {
            return 0;
        }
        int n5 = nArray[0];
        return this.v.get((n4 << 16) + n5);
    }

    @Override
    final int a(int n2, String string) {
        int[] nArray = this.e(n2);
        if (nArray == null) {
            return 0;
        }
        return nArray[1];
    }

    protected final PdfDictionary a(PdfIndirectReference pdfIndirectReference, String string, PdfIndirectReference pdfIndirectReference2) {
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONTDESCRIPTOR);
        pdfDictionary.put(PdfName.ASCENT, new PdfNumber(this.i.u * 1000 / this.s.b));
        pdfDictionary.put(PdfName.CAPHEIGHT, new PdfNumber(this.i.B * 1000 / this.s.b));
        pdfDictionary.put(PdfName.DESCENT, new PdfNumber(this.i.v * 1000 / this.s.b));
        pdfDictionary.put(PdfName.FONTBBOX, new PdfRectangle(this.s.c * 1000 / this.s.b, this.s.d * 1000 / this.s.b, this.s.e * 1000 / this.s.b, this.s.f * 1000 / this.s.b));
        if (pdfIndirectReference2 != null) {
            pdfDictionary.put(PdfName.CIDSET, pdfIndirectReference2);
        }
        if (this.e) {
            if (this.encoding.startsWith("Identity-")) {
                pdfDictionary.put(PdfName.FONTNAME, new PdfName(string + this.n + "-" + this.encoding));
            } else {
                pdfDictionary.put(PdfName.FONTNAME, new PdfName(string + this.n + this.h));
            }
        } else {
            pdfDictionary.put(PdfName.FONTNAME, new PdfName(string + this.n + this.h));
        }
        pdfDictionary.put(PdfName.ITALICANGLE, new PdfNumber(this.z));
        pdfDictionary.put(PdfName.STEMV, new PdfNumber(80));
        if (pdfIndirectReference != null) {
            if (this.e) {
                pdfDictionary.put(PdfName.FONTFILE3, pdfIndirectReference);
            } else {
                pdfDictionary.put(PdfName.FONTFILE2, pdfIndirectReference);
            }
        }
        int n2 = 0;
        if (this.A) {
            n2 = 1;
        }
        n2 |= this.fontSpecific ? 4 : 32;
        if ((this.s.g & 2) != 0) {
            n2 |= 0x40;
        }
        if ((this.s.g & 1) != 0) {
            n2 |= 0x40000;
        }
        pdfDictionary.put(PdfName.FLAGS, new PdfNumber(n2));
        return pdfDictionary;
    }

    protected final byte[] d() {
        byte[] byArray;
        RandomAccessFileOrArray randomAccessFileOrArray = null;
        try {
            randomAccessFileOrArray = new RandomAccessFileOrArray(this.c);
            randomAccessFileOrArray.reOpen();
            byArray = new byte[randomAccessFileOrArray.length()];
            randomAccessFileOrArray.readFully(byArray);
        }
        catch (Throwable throwable) {
            try {
                if (randomAccessFileOrArray != null) {
                    randomAccessFileOrArray.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    protected final void a(Map<Integer, int[]> map, boolean bl2, boolean bl3) {
        if (!(bl3 || this.subsetRanges == null && this.f <= 0)) {
            int[] nArray;
            int[] nArray2;
            HashMap<Integer, int[]> hashMap;
            int[] nArray3;
            if (this.subsetRanges == null && this.f > 0) {
                int[] nArray4 = new int[2];
                nArray4[0] = 0;
                nArray3 = nArray4;
                nArray4[1] = 65535;
            } else {
                void n3;
                Object object = this.subsetRanges;
                hashMap = new ArrayList();
                object = ((ArrayList)object).iterator();
                while (object.hasNext()) {
                    Object e2 = object.next();
                    nArray2 = (int[])e2;
                    for (int nArray5 = 0; nArray5 < nArray2.length; nArray5 += 2) {
                        if (nArray2.length <= nArray5 + 1) continue;
                        hashMap.add(new int[]{Math.max(0, Math.min(nArray2[nArray5], nArray2[nArray5 + 1])), Math.min(65535, Math.max(nArray2[nArray5], nArray2[nArray5 + 1]))});
                    }
                }
                for (int i3 = 0; i3 < hashMap.size() - 1; ++i3) {
                    void i5;
                    int i4 = i3 + 1;
                    while (i5 < hashMap.size()) {
                        int[] nArray5;
                        nArray2 = (int[])hashMap.get(i3);
                        if (nArray2[0] >= (nArray5 = (int[])hashMap.get((int)i5))[0] && nArray2[0] <= nArray5[1] || nArray2[1] >= nArray5[0] && nArray2[0] <= nArray5[1]) {
                            nArray2[0] = Math.min(nArray2[0], nArray5[0]);
                            nArray2[1] = Math.max(nArray2[1], nArray5[1]);
                            hashMap.remove((int)i5);
                            --i5;
                        }
                        ++i5;
                    }
                }
                nArray = new int[hashMap.size() << 1];
                boolean entry = false;
                while (n3 < hashMap.size()) {
                    nArray2 = (int[])hashMap.get((int)n3);
                    nArray[n3 << 1] = nArray2[0];
                    nArray[(n3 << 1) + true] = nArray2[1];
                    ++n3;
                }
                nArray3 = nArray = nArray;
            }
            hashMap = !this.fontSpecific && this.l != null ? this.l : ((!this.fontSpecific || this.k == null) && this.l != null ? this.l : this.k);
            for (Map.Entry entry : hashMap.entrySet()) {
                int[] nArray6;
                nArray2 = (int[])entry.getValue();
                Integer n2 = nArray2[0];
                if (map.containsKey(n2)) continue;
                int n3 = (Integer)entry.getKey();
                boolean bl4 = true;
                for (int i2 = 0; i2 < nArray.length; i2 += 2) {
                    if (n3 < nArray[i2] || nArray.length <= i2 + 1 || n3 > nArray[i2 + 1]) continue;
                    bl4 = false;
                    break;
                }
                if (bl4) continue;
                if (bl2) {
                    int[] nArray7 = new int[3];
                    nArray7[0] = nArray2[0];
                    nArray7[1] = nArray2[1];
                    nArray6 = nArray7;
                    nArray7[2] = n3;
                } else {
                    nArray6 = null;
                }
                map.put(n2, nArray6);
            }
        }
    }

    @Override
    void a(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) {
        Object object;
        Object object2;
        int n2 = (Integer)objectArray[0];
        int n3 = (Integer)objectArray[1];
        byte[] byArray = (byte[])objectArray[2];
        boolean bl2 = (Boolean)objectArray[3] != false && this.subset;
        if (!bl2) {
            n2 = 0;
            n3 = byArray.length - 1;
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray[i2] = 1;
            }
        }
        Object object3 = null;
        Object object4 = "";
        if (this.embedded) {
            if (this.e) {
                Object object5 = new BaseFont.a(this.e(), "Type1C", this.compressionLevel);
                object5 = pdfWriter.addToBody((PdfObject)object5);
                object3 = ((PdfIndirectObject)object5).getIndirectReference();
            } else {
                if (bl2) {
                    object4 = TrueTypeFont.createSubsetPrefix();
                }
                object3 = new HashMap();
                for (int i3 = n2; i3 <= n3; ++i3) {
                    if (byArray[i3] == 0) continue;
                    object2 = null;
                    if (this.specialMap != null) {
                        int[] nArray = GlyphList.nameToUnicode(this.differences[i3]);
                        if (nArray != null) {
                            object2 = this.e(nArray[0]);
                        }
                    } else if (this.fontSpecific) {
                        object2 = this.e(i3);
                    } else {
                        TrueTypeFont trueTypeFont = this;
                        object2 = trueTypeFont.e(trueTypeFont.unicodeDifferences[i3]);
                    }
                    if (object2 == null) continue;
                    ((HashMap)object3).put(object2[0], null);
                }
                this.a((Map<Integer, int[]>)object3, false, bl2);
                if (bl2 || this.f != 0 || this.subsetRanges != null) {
                    n n4 = new n(this.d, new RandomAccessFileOrArray(this.c), (HashMap<Integer, int[]>)object3, this.f, true, !bl2);
                    object2 = n4;
                    object = n4.a();
                } else {
                    object = this.d();
                }
                object2 = new int[]{((byte[])object).length};
                Object object6 = new BaseFont.a((byte[])object, (int[])object2, this.compressionLevel);
                object6 = pdfWriter.addToBody((PdfObject)object6);
                object3 = ((PdfIndirectObject)object6).getIndirectReference();
            }
        }
        Object object7 = this.a((PdfIndirectReference)object3, (String)object4, null);
        object7 = pdfWriter.addToBody((PdfObject)object7);
        object3 = ((PdfIndirectObject)object7).getIndirectReference();
        String string = object4;
        object4 = byArray;
        int n5 = n3;
        int n6 = n2;
        String string2 = string;
        Object object8 = object3;
        object7 = this;
        object = new PdfDictionary(PdfName.FONT);
        if (((TrueTypeFont)object7).e) {
            ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.TYPE1);
            ((PdfDictionary)object).put(PdfName.BASEFONT, new PdfName(((TrueTypeFont)object7).n + ((TrueTypeFont)object7).h));
        } else {
            ((PdfDictionary)object).put(PdfName.SUBTYPE, PdfName.TRUETYPE);
            ((PdfDictionary)object).put(PdfName.BASEFONT, new PdfName(string2 + ((TrueTypeFont)object7).n + ((TrueTypeFont)object7).h));
        }
        ((PdfDictionary)object).put(PdfName.BASEFONT, new PdfName(string2 + ((TrueTypeFont)object7).n + ((TrueTypeFont)object7).h));
        if (!((BaseFont)object7).fontSpecific) {
            for (int i4 = n6; i4 <= n5; ++i4) {
                if (((BaseFont)object7).differences[i4].equals(".notdef")) continue;
                n6 = i4;
                break;
            }
            if (((BaseFont)object7).encoding.equals("Cp1252") || ((BaseFont)object7).encoding.equals("MacRoman")) {
                ((PdfDictionary)object).put(PdfName.ENCODING, ((BaseFont)object7).encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary pdfDictionary = new PdfDictionary(PdfName.ENCODING);
                object2 = new PdfArray();
                boolean bl3 = true;
                for (int i5 = n6; i5 <= n5; ++i5) {
                    if (object4[i5] != false) {
                        if (bl3) {
                            ((PdfArray)object2).add(new PdfNumber(i5));
                            bl3 = false;
                        }
                        ((PdfArray)object2).add(new PdfName(((BaseFont)object7).differences[i5]));
                        continue;
                    }
                    bl3 = true;
                }
                pdfDictionary.put(PdfName.DIFFERENCES, (PdfObject)object2);
                ((PdfDictionary)object).put(PdfName.ENCODING, pdfDictionary);
            }
        }
        ((PdfDictionary)object).put(PdfName.FIRSTCHAR, new PdfNumber(n6));
        ((PdfDictionary)object).put(PdfName.LASTCHAR, new PdfNumber(n5));
        PdfArray pdfArray = new PdfArray();
        for (int i6 = n6; i6 <= n5; ++i6) {
            if (object4[i6] == false) {
                pdfArray.add(new PdfNumber(0));
                continue;
            }
            pdfArray.add(new PdfNumber(((BaseFont)object7).widths[i6]));
        }
        ((PdfDictionary)object).put(PdfName.WIDTHS, pdfArray);
        if (object8 != null) {
            ((PdfDictionary)object).put(PdfName.FONTDESCRIPTOR, (PdfObject)object8);
        }
        object7 = object;
        pdfWriter.addToBody((PdfObject)object7, pdfIndirectReference);
    }

    protected final byte[] e() {
        RandomAccessFileOrArray randomAccessFileOrArray = new RandomAccessFileOrArray(this.c);
        byte[] byArray = new byte[this.r];
        try {
            randomAccessFileOrArray.reOpen();
            randomAccessFileOrArray.seek(this.q);
            randomAccessFileOrArray.readFully(byArray);
        }
        catch (Throwable throwable) {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            randomAccessFileOrArray.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    @Override
    public float getFontDescriptor(int n2, float f2) {
        switch (n2) {
            case 1: {
                return (float)this.i.u * f2 / (float)this.s.b;
            }
            case 2: {
                return (float)this.i.B * f2 / (float)this.s.b;
            }
            case 3: {
                return (float)this.i.v * f2 / (float)this.s.b;
            }
            case 4: {
                return (float)this.z;
            }
            case 5: {
                return f2 * (float)this.s.c / (float)this.s.b;
            }
            case 6: {
                return f2 * (float)this.s.d / (float)this.s.b;
            }
            case 7: {
                return f2 * (float)this.s.e / (float)this.s.b;
            }
            case 8: {
                return f2 * (float)this.s.f / (float)this.s.b;
            }
            case 9: {
                return f2 * (float)this.t.a / (float)this.s.b;
            }
            case 10: {
                return f2 * (float)this.t.b / (float)this.s.b;
            }
            case 11: {
                return f2 * (float)this.t.c / (float)this.s.b;
            }
            case 12: {
                return f2 * (float)this.t.d / (float)this.s.b;
            }
            case 13: {
                return (float)(this.B - this.C / 2) * f2 / (float)this.s.b;
            }
            case 14: {
                return (float)this.C * f2 / (float)this.s.b;
            }
            case 15: {
                return (float)this.i.n * f2 / (float)this.s.b;
            }
            case 16: {
                return (float)this.i.m * f2 / (float)this.s.b;
            }
            case 17: {
                return (float)this.i.f * f2 / (float)this.s.b;
            }
            case 18: {
                return (float)(-this.i.h) * f2 / (float)this.s.b;
            }
            case 19: {
                return (float)this.i.j * f2 / (float)this.s.b;
            }
            case 20: {
                return (float)this.i.l * f2 / (float)this.s.b;
            }
        }
        return 0.0f;
    }

    public int[] e(int n2) {
        if (this.m != null) {
            return this.m.get(n2);
        }
        if (!this.fontSpecific && this.l != null) {
            return this.l.get(n2);
        }
        if (this.fontSpecific && this.k != null) {
            return this.k.get(n2);
        }
        if (this.l != null) {
            return this.l.get(n2);
        }
        if (this.k != null) {
            return this.k.get(n2);
        }
        return null;
    }

    @Override
    public String getPostscriptFontName() {
        return this.n;
    }

    @Override
    public String[] getCodePagesSupported() {
        long l2 = ((long)this.i.A << 32) + ((long)this.i.z & 0xFFFFFFFFL);
        int n2 = 0;
        long l3 = 1L;
        for (int i2 = 0; i2 < 64; ++i2) {
            if ((l2 & l3) != 0L && o[i2] != null) {
                ++n2;
            }
            l3 <<= 1;
        }
        String[] stringArray = new String[n2];
        n2 = 0;
        l3 = 1L;
        for (int i3 = 0; i3 < 64; ++i3) {
            if ((l2 & l3) != 0L && o[i3] != null) {
                stringArray[n2++] = o[i3];
            }
            l3 <<= 1;
        }
        return stringArray;
    }

    @Override
    public String[][] getFullFontName() {
        return this.w;
    }

    @Override
    public String[][] getAllNameEntries() {
        return this.x;
    }

    @Override
    public String[][] getFamilyFontName() {
        return this.y;
    }

    @Override
    public boolean hasKernPairs() {
        return this.v.size() > 0;
    }

    @Override
    public void setPostscriptFontName(String string) {
        this.n = string;
    }

    @Override
    public boolean setKerning(int n2, int n3, int n4) {
        int[] nArray = this.e(n2);
        if (nArray == null) {
            return false;
        }
        int n5 = nArray[0];
        nArray = this.e(n3);
        if (nArray == null) {
            return false;
        }
        int n6 = nArray[0];
        this.v.put((n5 << 16) + n6, n4);
        return true;
    }

    @Override
    protected int[] getRawCharBBox(int n2, String hashMap) {
        if ((hashMap = hashMap == null || this.l == null ? this.k : this.l) == null) {
            return null;
        }
        int[] nArray = (int[])hashMap.get(n2);
        if (nArray == null || this.j == null) {
            return null;
        }
        return this.j[nArray[0]];
    }

    protected static class WindowsMetrics {
        short a;
        int b;
        int c;
        short d;
        short e;
        short f;
        short g;
        short h;
        short i;
        short j;
        short k;
        short l;
        short m;
        short n;
        short o;
        byte[] p = new byte[10];
        byte[] q = new byte[4];
        int r;
        int s;
        int t;
        short u;
        short v;
        short w;
        int x;
        int y;
        int z;
        int A;
        int B;

        protected WindowsMetrics() {
        }
    }

    protected static class HorizontalHeader {
        short a;
        short b;
        short c;
        int d;
        short e;
        short f;
        short g;
        short h;
        short i;
        int j;

        protected HorizontalHeader() {
        }
    }

    protected static class FontHeader {
        int a;
        int b;
        short c;
        short d;
        short e;
        short f;
        int g;

        protected FontHeader() {
        }
    }
}

