/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.j;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

public class VerticalText {
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    protected ArrayList<PdfChunk> chunks = new ArrayList();
    protected PdfContentByte text;
    protected int alignment = 0;
    protected int currentChunkMarker = -1;
    protected PdfChunk currentStandbyChunk;
    protected String splittedChunkText;
    protected float leading;
    protected float startX;
    protected float startY;
    protected int maxLines;
    protected float height;

    public VerticalText(PdfContentByte pdfContentByte) {
        this.text = pdfContentByte;
    }

    public void addText(Phrase object) {
        for (Element e2 : ((Phrase)((Object)object)).getChunks()) {
            this.chunks.add(new PdfChunk((Chunk)e2, null));
        }
    }

    public void addText(Chunk chunk) {
        this.chunks.add(new PdfChunk(chunk, null));
    }

    public void setVerticalLayout(float f2, float f3, float f4, int n2, float f5) {
        this.startX = f2;
        this.startY = f3;
        this.height = f4;
        this.maxLines = n2;
        this.setLeading(f5);
    }

    public void setLeading(float f2) {
        this.leading = f2;
    }

    public float getLeading() {
        return this.leading;
    }

    protected PdfLine createLine(float f2) {
        if (this.chunks.isEmpty()) {
            return null;
        }
        this.splittedChunkText = null;
        this.currentStandbyChunk = null;
        PdfLine pdfLine = new PdfLine(0.0f, f2, this.alignment, 0.0f);
        this.currentChunkMarker = 0;
        while (this.currentChunkMarker < this.chunks.size()) {
            PdfChunk pdfChunk = this.chunks.get(this.currentChunkMarker);
            String string = pdfChunk.toString();
            this.currentStandbyChunk = pdfLine.a(pdfChunk);
            if (this.currentStandbyChunk != null) {
                this.splittedChunkText = pdfChunk.toString();
                pdfChunk.c(string);
                return pdfLine;
            }
            ++this.currentChunkMarker;
        }
        return pdfLine;
    }

    protected void shortenChunkArray() {
        if (this.currentChunkMarker < 0) {
            return;
        }
        if (this.currentChunkMarker >= this.chunks.size()) {
            this.chunks.clear();
            return;
        }
        PdfChunk pdfChunk = this.chunks.get(this.currentChunkMarker);
        pdfChunk.c(this.splittedChunkText);
        this.chunks.set(this.currentChunkMarker, this.currentStandbyChunk);
        if (this.currentChunkMarker > 0) {
            this.chunks.subList(0, this.currentChunkMarker).clear();
        }
    }

    public int go() {
        return this.go(false);
    }

    /*
     * WARNING - void declaration
     */
    public int go(boolean bl2) {
        void var1_5;
        boolean bl3 = false;
        PdfContentByte pdfContentByte = null;
        if (this.text != null) {
            pdfContentByte = this.text.getDuplicate();
        } else if (!bl2) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("verticaltext.go.with.simulate.eq.eq.false.and.text.eq.eq.null"));
        }
        while (true) {
            if (this.maxLines <= 0) {
                int n2 = 2;
                if (!this.chunks.isEmpty()) break;
                int n3 = 3;
                break;
            }
            if (this.chunks.isEmpty()) {
                boolean bl4 = true;
                break;
            }
            VerticalText verticalText = this;
            Object object = verticalText.createLine(verticalText.height);
            if (!bl2 && !bl3) {
                this.text.beginText();
                bl3 = true;
            }
            this.shortenChunkArray();
            if (!bl2) {
                this.text.setTextMatrix(this.startX, this.startY - ((PdfLine)object).b());
                PdfContentByte pdfContentByte2 = this.text;
                j j2 = null;
                Iterator iterator = ((PdfLine)object).iterator();
                while (iterator.hasNext()) {
                    Color color;
                    object = (PdfChunk)iterator.next();
                    if (((PdfChunk)object).a().compareTo(j2) != 0) {
                        j2 = ((PdfChunk)object).a();
                        pdfContentByte2.setFontAndSize(j2.b(), j2.a());
                    }
                    if ((color = ((PdfChunk)object).b()) != null) {
                        pdfContentByte2.setColorFill(color);
                    }
                    pdfContentByte2.showText(((PdfChunk)object).toString());
                    if (color == null) continue;
                    pdfContentByte2.resetRGBColorFill();
                }
            }
            --this.maxLines;
            this.startX -= this.leading;
        }
        if (bl3) {
            this.text.endText();
            this.text.add(pdfContentByte);
        }
        return (int)var1_5;
    }

    public void setOrigin(float f2, float f3) {
        this.startX = f2;
        this.startY = f3;
    }

    public float getOriginX() {
        return this.startX;
    }

    public float getOriginY() {
        return this.startY;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int n2) {
        this.maxLines = n2;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f2) {
        this.height = f2;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public int getAlignment() {
        return this.alignment;
    }
}

