/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.xml.XmlDomWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XfaForm {
    private Xml2SomTemplate a;
    private Node b;
    private Xml2SomDatasets c;
    private Node d;
    private AcroFieldsSearch e;
    private PdfReader f;
    private boolean g;
    private Document h;
    private boolean i;
    public static final String XFA_DATA_SCHEMA = "http://www.xfa.org/schema/xfa-data/1.0/";

    public XfaForm() {
    }

    public static PdfObject getXfaObject(PdfReader object) {
        if ((object = (PdfDictionary)PdfReader.getPdfObjectRelease(((PdfReader)object).getCatalog().get(PdfName.ACROFORM))) == null) {
            return null;
        }
        return PdfReader.getPdfObjectRelease(((PdfDictionary)object).get(PdfName.XFA));
    }

    public XfaForm(PdfReader object) {
        this.f = object;
        object = XfaForm.getXfaObject((PdfReader)object);
        if (object == null) {
            this.g = false;
            return;
        }
        this.g = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (((PdfObject)object).isArray()) {
            object = (PdfArray)object;
            for (int i2 = 1; i2 < ((PdfArray)object).size(); i2 += 2) {
                Object object2 = ((PdfArray)object).getDirectObject(i2);
                if (!(object2 instanceof PRStream)) continue;
                object2 = PdfReader.getStreamBytes((PRStream)object2);
                byteArrayOutputStream.write((byte[])object2);
            }
        } else if (object instanceof PRStream) {
            object = PdfReader.getStreamBytes((PRStream)object);
            byteArrayOutputStream.write((byte[])object);
        }
        byteArrayOutputStream.close();
        object = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object).setNamespaceAware(true);
        DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
        documentBuilder.setEntityResolver((string, string2) -> new InputSource(new StringReader("")));
        this.h = documentBuilder.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        this.a();
    }

    private void a() {
        Node node = this.h.getFirstChild();
        while (node.getChildNodes().getLength() == 0) {
            node = node.getNextSibling();
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String string = node.getLocalName();
            if (string.equals("template")) {
                this.b = node;
                this.a = new Xml2SomTemplate(node);
                continue;
            }
            if (!string.equals("datasets")) continue;
            this.d = node;
            this.c = new Xml2SomDatasets(node.getFirstChild());
        }
    }

    public static void setXfa(XfaForm xfaForm, PdfReader pdfReader, PdfWriter pdfWriter) {
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfReader.getCatalog().get(PdfName.ACROFORM));
        if (pdfDictionary == null) {
            return;
        }
        PdfObject pdfObject = XfaForm.getXfaObject(pdfReader);
        if (pdfObject.isArray()) {
            PdfObject pdfObject2;
            pdfObject = (PdfArray)pdfObject;
            int n2 = -1;
            int n3 = -1;
            for (int i2 = 0; i2 < ((PdfArray)pdfObject).size(); i2 += 2) {
                pdfObject2 = ((PdfArray)pdfObject).getAsString(i2);
                if ("template".equals(((PdfObject)pdfObject2).toString())) {
                    n2 = i2 + 1;
                }
                if (!"datasets".equals(((PdfObject)pdfObject2).toString())) continue;
                n3 = i2 + 1;
            }
            if (n2 >= 0 && n3 >= 0) {
                pdfReader.killXref(((PdfArray)pdfObject).getAsIndirectObject(n2));
                pdfReader.killXref(((PdfArray)pdfObject).getAsIndirectObject(n3));
                PdfStream pdfStream = new PdfStream(XfaForm.serializeDoc(xfaForm.b));
                pdfStream.flateCompress(pdfWriter.getCompressionLevel());
                ((PdfArray)pdfObject).set(n2, pdfWriter.addToBody(pdfStream).getIndirectReference());
                pdfObject2 = new PdfStream(XfaForm.serializeDoc(xfaForm.d));
                ((PdfStream)pdfObject2).flateCompress(pdfWriter.getCompressionLevel());
                ((PdfArray)pdfObject).set(n3, pdfWriter.addToBody(pdfObject2).getIndirectReference());
                pdfDictionary.put(PdfName.XFA, new PdfArray((PdfArray)pdfObject));
                return;
            }
        }
        pdfReader.killXref(pdfDictionary.get(PdfName.XFA));
        pdfObject = new PdfStream(XfaForm.serializeDoc(xfaForm.h));
        ((PdfStream)pdfObject).flateCompress(pdfWriter.getCompressionLevel());
        PdfIndirectReference pdfIndirectReference = pdfWriter.addToBody(pdfObject).getIndirectReference();
        pdfDictionary.put(PdfName.XFA, pdfIndirectReference);
    }

    public void setXfa(PdfWriter pdfWriter) {
        XfaForm xfaForm = this;
        XfaForm.setXfa(xfaForm, xfaForm.f, pdfWriter);
    }

    public static byte[] serializeDoc(Node node) {
        XmlDomWriter xmlDomWriter = new XmlDomWriter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        xmlDomWriter.setOutput(byteArrayOutputStream, null);
        xmlDomWriter.setCanonical(false);
        xmlDomWriter.write(node);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isXfaPresent() {
        return this.g;
    }

    public Document getDomDocument() {
        return this.h;
    }

    public String findFieldName(String string, AcroFields object) {
        if ((object = ((AcroFields)object).getAllFields()).containsKey(string)) {
            return string;
        }
        if (this.e == null) {
            this.e = object.isEmpty() && this.g ? new AcroFieldsSearch(this.c.getNodesByName().keySet()) : new AcroFieldsSearch(object.keySet());
        }
        if (this.e.getLongByShortNames().containsKey(string)) {
            return this.e.getLongByShortNames().get(string);
        }
        return this.e.inverseSearch(Xml2Som.splitParts(string));
    }

    public String findDatasetsName(String string) {
        if (this.c.getNodesByName().containsKey(string)) {
            return string;
        }
        return this.c.inverseSearch(Xml2Som.splitParts(string));
    }

    public Node findDatasetsNode(String string) {
        if (string == null) {
            return null;
        }
        if ((string = this.findDatasetsName(string)) == null) {
            return null;
        }
        return this.c.getNodesByName().get(string);
    }

    public static String getNodeText(Node node) {
        if (node == null) {
            return "";
        }
        return XfaForm.a(node, "");
    }

    private static String a(Node node, String string) {
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 1) {
                string = XfaForm.a(node, string);
                continue;
            }
            if (node.getNodeType() != 3) continue;
            string = string + node.getNodeValue();
        }
        return string;
    }

    public void setNodeText(Node node, String string) {
        Node node2;
        if (node == null) {
            return;
        }
        while ((node2 = node.getFirstChild()) != null) {
            node.removeChild(node2);
        }
        if (node.getAttributes().getNamedItemNS(XFA_DATA_SCHEMA, "dataNode") != null) {
            node.getAttributes().removeNamedItemNS(XFA_DATA_SCHEMA, "dataNode");
        }
        node.appendChild(this.h.createTextNode(string));
        this.i = true;
    }

    public void setXfaPresent(boolean bl2) {
        this.g = bl2;
    }

    public void setDomDocument(Document document) {
        this.h = document;
        this.a();
    }

    public PdfReader getReader() {
        return this.f;
    }

    public void setReader(PdfReader pdfReader) {
        this.f = pdfReader;
    }

    public boolean isChanged() {
        return this.i;
    }

    public void setChanged(boolean bl2) {
        this.i = bl2;
    }

    public Xml2SomTemplate getTemplateSom() {
        return this.a;
    }

    public void setTemplateSom(Xml2SomTemplate xml2SomTemplate) {
        this.a = xml2SomTemplate;
    }

    public Xml2SomDatasets getDatasetsSom() {
        return this.c;
    }

    public void setDatasetsSom(Xml2SomDatasets xml2SomDatasets) {
        this.c = xml2SomDatasets;
    }

    public AcroFieldsSearch getAcroFieldsSom() {
        return this.e;
    }

    public void setAcroFieldsSom(AcroFieldsSearch acroFieldsSearch) {
        this.e = acroFieldsSearch;
    }

    public Node getDatasetsNode() {
        return this.d;
    }

    public void fillXfaForm(File file) {
        this.fillXfaForm(new FileInputStream(file));
    }

    public void fillXfaForm(InputStream inputStream) {
        this.fillXfaForm(new InputSource(inputStream));
    }

    public void fillXfaForm(InputSource object) {
        Object object2 = DocumentBuilderFactory.newInstance();
        object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
        ((DocumentBuilder)object2).setEntityResolver((string, string2) -> new InputSource(new StringReader("")));
        object = ((DocumentBuilder)object2).parse((InputSource)object);
        this.fillXfaForm(object.getDocumentElement());
    }

    public void fillXfaForm(Node node) {
        Node node2 = this.d.getFirstChild();
        NodeList nodeList = node2.getChildNodes();
        if (nodeList.getLength() == 0) {
            node2.appendChild(this.h.importNode(node, true));
        } else {
            node2.replaceChild(this.h.importNode(node, true), node2.getFirstChild());
        }
        this.a();
        this.setChanged(true);
    }

    public static class Xml2SomTemplate
    extends Xml2Som {
        private boolean a;
        private int b;

        public Xml2SomTemplate(Node node) {
            this.order = new ArrayList<String>();
            this.name2Node = new HashMap<String, Node>();
            this.stack = new Stack2();
            this.anform = 0;
            this.b = 0;
            this.inverseSearch = new HashMap<String, InverseStore>();
            this.a(node, null);
        }

        public String getFieldType(String object) {
            if ((object = this.name2Node.get(object)) == null) {
                return null;
            }
            if (object.getLocalName().equals("exclGroup")) {
                return "exclGroup";
            }
            for (object = object.getFirstChild(); !(object == null || object.getNodeType() == 1 && object.getLocalName().equals("ui")); object = object.getNextSibling()) {
            }
            if (object == null) {
                return null;
            }
            for (object = object.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 1 || object.getLocalName().equals("extras") && object.getLocalName().equals("picture")) continue;
                return object.getLocalName();
            }
            return null;
        }

        private void a(Node node, Map<String, Integer> map) {
            if (map == null) {
                map = new HashMap<String, Integer>();
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                if (node.getNodeType() != 1) continue;
                Object object2 = node.getLocalName();
                if (((String)object2).equals("subform")) {
                    object2 = node.getAttributes().getNamedItem("name");
                    String string = "#subform";
                    boolean bl2 = true;
                    if (object2 != null) {
                        string = Xml2SomTemplate.escapeSom(object2.getNodeValue());
                        bl2 = false;
                    }
                    if (bl2) {
                        object = this.anform;
                        ++this.anform;
                    } else {
                        object = (Integer)hashMap.get(string);
                        object = object == null ? Integer.valueOf(0) : Integer.valueOf((Integer)object + 1);
                        hashMap.put(string, (Integer)object);
                    }
                    this.stack.push(string + "[" + ((Integer)object).toString() + "]");
                    ++this.b;
                    if (bl2) {
                        this.a(node, map);
                    } else {
                        this.a(node, null);
                    }
                    --this.b;
                    this.stack.pop();
                    continue;
                }
                if (((String)object2).equals("field") || ((String)object2).equals("exclGroup")) {
                    object2 = node.getAttributes().getNamedItem("name");
                    if (object2 == null) continue;
                    String string = Xml2SomTemplate.escapeSom(object2.getNodeValue());
                    Integer n2 = map.get(string);
                    n2 = n2 == null ? Integer.valueOf(0) : Integer.valueOf(n2 + 1);
                    map.put(string, n2);
                    this.stack.push(string + "[" + n2.toString() + "]");
                    object = this.printStack();
                    this.order.add((String)object);
                    this.inverseSearchAdd((String)object);
                    this.name2Node.put((String)object, node);
                    this.stack.pop();
                    continue;
                }
                if (this.a || this.b <= 0 || !((String)object2).equals("occur")) continue;
                int n3 = 1;
                int n4 = 1;
                int n5 = 1;
                object = node.getAttributes().getNamedItem("initial");
                if (object != null) {
                    try {
                        n3 = Integer.parseInt(object.getNodeValue().trim());
                    }
                    catch (Exception exception) {}
                }
                if ((object = node.getAttributes().getNamedItem("min")) != null) {
                    try {
                        n4 = Integer.parseInt(object.getNodeValue().trim());
                    }
                    catch (Exception exception) {}
                }
                if ((object = node.getAttributes().getNamedItem("max")) != null) {
                    try {
                        n5 = Integer.parseInt(object.getNodeValue().trim());
                    }
                    catch (Exception exception) {}
                }
                if (n3 == n4 && n4 == n5) continue;
                this.a = true;
            }
        }

        public boolean isDynamicForm() {
            return this.a;
        }

        public void setDynamicForm(boolean bl2) {
            this.a = bl2;
        }
    }

    public static class AcroFieldsSearch
    extends Xml2Som {
        private Map<String, String> a;

        public AcroFieldsSearch(Collection<String> object) {
            this.inverseSearch = new HashMap<String, InverseStore>();
            this.a = new HashMap<String, String>();
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = AcroFieldsSearch.getShortName(string);
                this.a.put(string2, string);
                AcroFieldsSearch.addSomNameToSearchNodeChain(this.inverseSearch, AcroFieldsSearch.splitParts(string2), string);
            }
        }

        @Deprecated
        public HashMap getAcroShort2LongName() {
            return (HashMap)this.a;
        }

        @Deprecated
        public void setAcroShort2LongName(HashMap hashMap) {
            this.a = hashMap;
        }

        public Map<String, String> getLongByShortNames() {
            return this.a;
        }

        public void setLongByShortNames(Map<String, String> map) {
            this.a = map;
        }
    }

    public static class Xml2SomDatasets
    extends Xml2Som {
        public Xml2SomDatasets(Node node) {
            this.order = new ArrayList<String>();
            this.name2Node = new HashMap<String, Node>();
            this.stack = new Stack2();
            this.anform = 0;
            this.inverseSearch = new HashMap<String, InverseStore>();
            this.b(node);
        }

        public Node insertNode(Node object, String string) {
            Stack2 stack2 = Xml2SomDatasets.splitParts(string);
            Document document = object.getOwnerDocument();
            Object object2 = null;
            object = object.getFirstChild();
            for (Object e2 : stack2) {
                Object object3;
                object2 = e2;
                object2 = (String)e2;
                int n2 = ((String)object2).lastIndexOf(91);
                String string2 = ((String)object2).substring(0, n2);
                n2 = Integer.parseInt(((String)object2).substring(n2 + 1, ((String)object2).length() - 1));
                int n3 = -1;
                for (object2 = object.getFirstChild(); !(object2 == null || object2.getNodeType() == 1 && ((String)(object3 = Xml2SomDatasets.escapeSom(object2.getLocalName()))).equals(string2) && ++n3 == n2); object2 = object2.getNextSibling()) {
                }
                while (n3 < n2) {
                    object2 = document.createElementNS(null, string2);
                    object2 = object.appendChild((Node)object2);
                    object3 = document.createAttributeNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
                    object3.setNodeValue("dataGroup");
                    object2.getAttributes().setNamedItemNS((Node)object3);
                    ++n3;
                }
                object = object2;
            }
            Xml2SomDatasets.addSomNameToSearchNodeChain(this.inverseSearch, stack2, string);
            this.name2Node.put(string, (Node)object2);
            this.order.add(string);
            return object2;
        }

        private static boolean a(Node node) {
            Object object = node.getAttributes().getNamedItemNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
            if (object != null) {
                if ("dataGroup".equals(object = object.getNodeValue())) {
                    return true;
                }
                if ("dataValue".equals(object)) {
                    return false;
                }
            }
            if (!node.hasChildNodes()) {
                return false;
            }
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (object.getNodeType() != 1) continue;
                return true;
            }
            return false;
        }

        private void b(Node node) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                String string = Xml2SomDatasets.escapeSom(node.getLocalName());
                Integer n2 = (Integer)hashMap.get(string);
                n2 = n2 == null ? Integer.valueOf(0) : Integer.valueOf(n2 + 1);
                hashMap.put(string, n2);
                if (Xml2SomDatasets.a(node)) {
                    this.stack.push(string + "[" + n2.toString() + "]");
                    this.b(node);
                    this.stack.pop();
                    continue;
                }
                this.stack.push(string + "[" + n2.toString() + "]");
                string = this.printStack();
                this.order.add(string);
                this.inverseSearchAdd(string);
                this.name2Node.put(string, node);
                this.stack.pop();
            }
        }
    }

    public static class Xml2Som {
        protected List<String> order;
        protected Map<String, Node> name2Node;
        protected Map<String, InverseStore> inverseSearch;
        protected Stack2 stack;
        protected int anform;

        public static String escapeSom(String string) {
            if (string == null) {
                return "";
            }
            int n2 = string.indexOf(46);
            if (n2 < 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = 0;
            while (n2 >= 0) {
                stringBuilder.append(string, n3, n2);
                stringBuilder.append('\\');
                n3 = n2;
                n2 = string.indexOf(46, n2 + 1);
            }
            stringBuilder.append(string.substring(n3));
            return stringBuilder.toString();
        }

        public static String unescapeSom(String string) {
            int n2 = string.indexOf(92);
            if (n2 < 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = 0;
            while (n2 >= 0) {
                stringBuilder.append(string, n3, n2);
                n3 = n2 + 1;
                n2 = string.indexOf(92, n2 + 1);
            }
            stringBuilder.append(string.substring(n3));
            return stringBuilder.toString();
        }

        protected String printStack() {
            if (this.stack.empty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.stack) {
                stringBuilder.append('.').append(string);
            }
            return stringBuilder.substring(1);
        }

        public static String getShortName(String string) {
            int n2 = string.indexOf(".#subform[");
            if (n2 < 0) {
                return string;
            }
            int n3 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            while (n2 >= 0) {
                stringBuilder.append(string, n3, n2);
                n2 = string.indexOf("]", n2 + 10);
                if (n2 < 0) {
                    return stringBuilder.toString();
                }
                n3 = n2 + 1;
                n2 = string.indexOf(".#subform[", n3);
            }
            stringBuilder.append(string.substring(n3));
            return stringBuilder.toString();
        }

        public void inverseSearchAdd(String string) {
            Xml2Som.addSomNameToSearchNodeChain(this.inverseSearch, this.stack, string);
        }

        @Deprecated
        public static void inverseSearchAdd(HashMap hashMap, Stack2 stack2, String string) {
            Xml2Som.addSomNameToSearchNodeChain(hashMap, stack2, string);
        }

        public static void addSomNameToSearchNodeChain(Map<String, InverseStore> map, Stack2 stack2, String string) {
            Object object = stack2.peek();
            Object object2 = map.get(object);
            if (object2 == null) {
                object2 = new InverseStore();
                map.put((String)object, (InverseStore)object2);
            }
            for (int i2 = stack2.size() - 2; i2 >= 0; --i2) {
                object = (String)stack2.get(i2);
                int n2 = ((InverseStore)object2).part.indexOf(object);
                if (n2 < 0) {
                    ((InverseStore)object2).part.add((String)object);
                    object = new InverseStore();
                    ((InverseStore)object2).follow.add(object);
                } else {
                    object = (InverseStore)((InverseStore)object2).follow.get(n2);
                }
                object2 = object;
            }
            ((InverseStore)object2).part.add("");
            ((InverseStore)object2).follow.add(string);
        }

        @Deprecated
        public String inverseSearchGlobal(ArrayList arrayList) {
            return this.inverseSearch(arrayList);
        }

        public String inverseSearch(List<String> list) {
            if (list.isEmpty()) {
                return null;
            }
            List<String> list2 = list;
            InverseStore inverseStore = this.inverseSearch.get(list2.get(list2.size() - 1));
            if (inverseStore == null) {
                return null;
            }
            for (int i2 = list.size() - 2; i2 >= 0; --i2) {
                String string = list.get(i2);
                int n2 = inverseStore.part.indexOf(string);
                if (n2 < 0) {
                    if (inverseStore.isSimilar(string)) {
                        return null;
                    }
                    return inverseStore.getDefaultName();
                }
                inverseStore = (InverseStore)inverseStore.follow.get(n2);
            }
            return inverseStore.getDefaultName();
        }

        public static Stack2 splitParts(String string) {
            while (string.startsWith(".")) {
                string = string.substring(1);
            }
            Stack2 stack2 = new Stack2();
            int n2 = 0;
            while (true) {
                int n3 = n2;
                while ((n3 = string.indexOf(46, n3)) >= 0 && string.charAt(n3 - 1) == '\\') {
                    ++n3;
                }
                if (n3 < 0) break;
                String string2 = string.substring(n2, n3);
                if (!string2.endsWith("]")) {
                    string2 = string2 + "[0]";
                }
                stack2.add(string2);
                n2 = n3 + 1;
            }
            String string3 = string.substring(n2);
            if (!string3.endsWith("]")) {
                string3 = string3 + "[0]";
            }
            stack2.add(string3);
            return stack2;
        }

        @Deprecated
        public ArrayList getOrder() {
            return (ArrayList)this.order;
        }

        public List<String> getNamesOrder() {
            return this.order;
        }

        @Deprecated
        public void setOrder(ArrayList arrayList) {
            this.order = arrayList;
        }

        public void setNamesOrder(List<String> list) {
            this.order = list;
        }

        @Deprecated
        public HashMap getName2Node() {
            return (HashMap)this.name2Node;
        }

        public Map<String, Node> getNodesByName() {
            return this.name2Node;
        }

        @Deprecated
        public void setName2Node(HashMap hashMap) {
            this.name2Node = hashMap;
        }

        public void setNodesByName(Map<String, Node> map) {
            this.name2Node = map;
        }

        @Deprecated
        public HashMap getInverseSearch() {
            return (HashMap)this.inverseSearch;
        }

        public Map<String, InverseStore> getInverseSearchData() {
            return this.inverseSearch;
        }

        @Deprecated
        public void setInverseSearch(Map<String, InverseStore> map) {
            this.inverseSearch = map;
        }

        public void setInverseSearchData(Map<String, InverseStore> map) {
            this.inverseSearch = map;
        }
    }

    public static class Stack2
    extends ArrayList<String> {
        public String peek() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            Stack2 stack2 = this;
            return (String)stack2.get(stack2.size() - 1);
        }

        public String pop() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            Stack2 stack2 = this;
            String string = (String)stack2.get(stack2.size() - 1);
            Stack2 stack22 = this;
            stack22.remove(stack22.size() - 1);
            return string;
        }

        public String push(String string) {
            this.add(string);
            return string;
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }

    public static class InverseStore {
        protected List<String> part = new ArrayList<String>();
        protected List<Object> follow = new ArrayList<Object>();

        public String getDefaultName() {
            Object object = this;
            while (!((object = ((InverseStore)object).follow.get(0)) instanceof String)) {
                object = (InverseStore)object;
            }
            return (String)object;
        }

        public boolean isSimilar(String string) {
            int n2 = string.indexOf(91);
            string = string.substring(0, n2 + 1);
            for (String string2 : this.part) {
                if (!string2.startsWith(string)) continue;
                return true;
            }
            return false;
        }
    }
}

