/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.wmf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.codec.wmf.InputMeta;
import com.lowagie.text.pdf.codec.wmf.MetaBrush;
import com.lowagie.text.pdf.codec.wmf.MetaFont;
import com.lowagie.text.pdf.codec.wmf.MetaObject;
import com.lowagie.text.pdf.codec.wmf.MetaPen;
import com.lowagie.text.pdf.codec.wmf.MetaState;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class MetaDo {
    public static final int META_SETBKCOLOR = 513;
    public static final int META_SETBKMODE = 258;
    public static final int META_SETMAPMODE = 259;
    public static final int META_SETROP2 = 260;
    public static final int META_SETRELABS = 261;
    public static final int META_SETPOLYFILLMODE = 262;
    public static final int META_SETSTRETCHBLTMODE = 263;
    public static final int META_SETTEXTCHAREXTRA = 264;
    public static final int META_SETTEXTCOLOR = 521;
    public static final int META_SETTEXTJUSTIFICATION = 522;
    public static final int META_SETWINDOWORG = 523;
    public static final int META_SETWINDOWEXT = 524;
    public static final int META_SETVIEWPORTORG = 525;
    public static final int META_SETVIEWPORTEXT = 526;
    public static final int META_OFFSETWINDOWORG = 527;
    public static final int META_SCALEWINDOWEXT = 1040;
    public static final int META_OFFSETVIEWPORTORG = 529;
    public static final int META_SCALEVIEWPORTEXT = 1042;
    public static final int META_LINETO = 531;
    public static final int META_MOVETO = 532;
    public static final int META_EXCLUDECLIPRECT = 1045;
    public static final int META_INTERSECTCLIPRECT = 1046;
    public static final int META_ARC = 2071;
    public static final int META_ELLIPSE = 1048;
    public static final int META_FLOODFILL = 1049;
    public static final int META_PIE = 2074;
    public static final int META_RECTANGLE = 1051;
    public static final int META_ROUNDRECT = 1564;
    public static final int META_PATBLT = 1565;
    public static final int META_SAVEDC = 30;
    public static final int META_SETPIXEL = 1055;
    public static final int META_OFFSETCLIPRGN = 544;
    public static final int META_TEXTOUT = 1313;
    public static final int META_BITBLT = 2338;
    public static final int META_STRETCHBLT = 2851;
    public static final int META_POLYGON = 804;
    public static final int META_POLYLINE = 805;
    public static final int META_ESCAPE = 1574;
    public static final int META_RESTOREDC = 295;
    public static final int META_FILLREGION = 552;
    public static final int META_FRAMEREGION = 1065;
    public static final int META_INVERTREGION = 298;
    public static final int META_PAINTREGION = 299;
    public static final int META_SELECTCLIPREGION = 300;
    public static final int META_SELECTOBJECT = 301;
    public static final int META_SETTEXTALIGN = 302;
    public static final int META_CHORD = 2096;
    public static final int META_SETMAPPERFLAGS = 561;
    public static final int META_EXTTEXTOUT = 2610;
    public static final int META_SETDIBTODEV = 3379;
    public static final int META_SELECTPALETTE = 564;
    public static final int META_REALIZEPALETTE = 53;
    public static final int META_ANIMATEPALETTE = 1078;
    public static final int META_SETPALENTRIES = 55;
    public static final int META_POLYPOLYGON = 1336;
    public static final int META_RESIZEPALETTE = 313;
    public static final int META_DIBBITBLT = 2368;
    public static final int META_DIBSTRETCHBLT = 2881;
    public static final int META_DIBCREATEPATTERNBRUSH = 322;
    public static final int META_STRETCHDIB = 3907;
    public static final int META_EXTFLOODFILL = 1352;
    public static final int META_DELETEOBJECT = 496;
    public static final int META_CREATEPALETTE = 247;
    public static final int META_CREATEPATTERNBRUSH = 505;
    public static final int META_CREATEPENINDIRECT = 762;
    public static final int META_CREATEFONTINDIRECT = 763;
    public static final int META_CREATEBRUSHINDIRECT = 764;
    public static final int META_CREATEREGION = 1791;
    public PdfContentByte cb;
    public InputMeta in;
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private MetaState f = new MetaState();

    public MetaDo(InputStream inputStream, PdfContentByte pdfContentByte) {
        this.cb = pdfContentByte;
        this.in = new InputMeta(inputStream);
    }

    public void readAll() {
        if (this.in.readInt() != -1698247209) {
            throw new DocumentException(MessageLocalization.getComposedMessage("not.a.placeable.windows.metafile"));
        }
        this.in.readWord();
        this.a = this.in.readShort();
        this.b = this.in.readShort();
        this.c = this.in.readShort();
        this.d = this.in.readShort();
        this.e = this.in.readWord();
        this.f.setScalingX((float)(this.c - this.a) / (float)this.e * 72.0f);
        this.f.setScalingY((float)(this.d - this.b) / (float)this.e * 72.0f);
        this.f.setOffsetWx(this.a);
        this.f.setOffsetWy(this.b);
        this.f.setExtentWx(this.c - this.a);
        this.f.setExtentWy(this.d - this.b);
        this.in.readInt();
        this.in.readWord();
        this.in.skip(18);
        this.cb.setLineCap(1);
        this.cb.setLineJoin(1);
        while (true) {
            int n2 = this.in.getLength();
            int n3 = this.in.readInt();
            if (n3 < 3) break;
            int n4 = this.in.readWord();
            switch (n4) {
                case 0: {
                    break;
                }
                case 247: 
                case 322: 
                case 1791: {
                    this.f.addMetaObject(new MetaObject());
                    break;
                }
                case 762: {
                    MetaPen metaPen = new MetaPen();
                    metaPen.init(this.in);
                    this.f.addMetaObject(metaPen);
                    break;
                }
                case 764: {
                    MetaBrush metaBrush = new MetaBrush();
                    metaBrush.init(this.in);
                    this.f.addMetaObject(metaBrush);
                    break;
                }
                case 763: {
                    MetaFont metaFont = new MetaFont();
                    metaFont.init(this.in);
                    this.f.addMetaObject(metaFont);
                    break;
                }
                case 301: {
                    n4 = this.in.readWord();
                    this.f.selectMetaObject(n4, this.cb);
                    break;
                }
                case 496: {
                    n4 = this.in.readWord();
                    this.f.deleteMetaObject(n4);
                    break;
                }
                case 30: {
                    this.f.saveState(this.cb);
                    break;
                }
                case 295: {
                    n4 = this.in.readShort();
                    this.f.restoreState(n4, this.cb);
                    break;
                }
                case 523: {
                    this.f.setOffsetWy(this.in.readShort());
                    this.f.setOffsetWx(this.in.readShort());
                    break;
                }
                case 524: {
                    this.f.setExtentWy(this.in.readShort());
                    this.f.setExtentWx(this.in.readShort());
                    break;
                }
                case 532: {
                    n4 = this.in.readShort();
                    Point point = new Point(this.in.readShort(), n4);
                    this.f.setCurrentPoint(point);
                    break;
                }
                case 531: {
                    n4 = this.in.readShort();
                    int n5 = this.in.readShort();
                    Point point = this.f.getCurrentPoint();
                    this.cb.moveTo(this.f.transformX(point.x), this.f.transformY(point.y));
                    this.cb.lineTo(this.f.transformX(n5), this.f.transformY(n4));
                    this.cb.stroke();
                    this.f.setCurrentPoint(new Point(n5, n4));
                    break;
                }
                case 805: {
                    this.f.setLineJoinPolygon(this.cb);
                    n4 = this.in.readWord();
                    int n6 = this.in.readShort();
                    int n7 = this.in.readShort();
                    this.cb.moveTo(this.f.transformX(n6), this.f.transformY(n7));
                    for (int i2 = 1; i2 < n4; ++i2) {
                        n6 = this.in.readShort();
                        n7 = this.in.readShort();
                        this.cb.lineTo(this.f.transformX(n6), this.f.transformY(n7));
                    }
                    this.cb.stroke();
                    break;
                }
                case 804: {
                    if (this.isNullStrokeFill(false)) break;
                    n4 = this.in.readWord();
                    int n8 = this.in.readShort();
                    int n9 = this.in.readShort();
                    this.cb.moveTo(this.f.transformX(n8), this.f.transformY(n9));
                    for (int i3 = 1; i3 < n4; ++i3) {
                        int n10 = this.in.readShort();
                        int n11 = this.in.readShort();
                        this.cb.lineTo(this.f.transformX(n10), this.f.transformY(n11));
                    }
                    this.cb.lineTo(this.f.transformX(n8), this.f.transformY(n9));
                    this.strokeAndFill();
                    break;
                }
                case 1336: {
                    if (this.isNullStrokeFill(false)) break;
                    n4 = this.in.readWord();
                    int[] nArray = new int[n4];
                    for (int i4 = 0; i4 < nArray.length; ++i4) {
                        nArray[i4] = this.in.readWord();
                    }
                    int[] nArray2 = nArray;
                    int cfr_ignored_0 = nArray.length;
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n12 = nArray2[i5];
                        int n13 = this.in.readShort();
                        int n14 = this.in.readShort();
                        this.cb.moveTo(this.f.transformX(n13), this.f.transformY(n14));
                        for (int i6 = 1; i6 < n12; ++i6) {
                            int n15 = this.in.readShort();
                            int n16 = this.in.readShort();
                            this.cb.lineTo(this.f.transformX(n15), this.f.transformY(n16));
                        }
                        this.cb.lineTo(this.f.transformX(n13), this.f.transformY(n14));
                    }
                    this.strokeAndFill();
                    break;
                }
                case 1048: {
                    MetaDo metaDo = this;
                    if (metaDo.isNullStrokeFill(metaDo.f.getLineNeutral())) break;
                    n4 = this.in.readShort();
                    int n17 = this.in.readShort();
                    int n18 = this.in.readShort();
                    int n19 = this.in.readShort();
                    this.cb.arc(this.f.transformX(n19), this.f.transformY(n4), this.f.transformX(n17), this.f.transformY(n18), 0.0f, 360.0f);
                    this.strokeAndFill();
                    break;
                }
                case 2071: {
                    float f2;
                    MetaDo metaDo = this;
                    if (metaDo.isNullStrokeFill(metaDo.f.getLineNeutral())) break;
                    float f3 = this.f.transformY(this.in.readShort());
                    float f4 = this.f.transformX(this.in.readShort());
                    float f5 = this.f.transformY(this.in.readShort());
                    float f6 = this.f.transformX(this.in.readShort());
                    float f7 = this.f.transformY(this.in.readShort());
                    float f8 = this.f.transformX(this.in.readShort());
                    float f9 = this.f.transformY(this.in.readShort());
                    float f10 = this.f.transformX(this.in.readShort());
                    float f11 = (f8 + f10) / 2.0f;
                    float f12 = (f9 + f7) / 2.0f;
                    float f13 = MetaDo.a(f11, f12, f6, f5);
                    f3 = MetaDo.a(f11, f12, f4, f3);
                    f3 -= f13;
                    if (f2 <= 0.0f) {
                        f3 += 360.0f;
                    }
                    this.cb.arc(f10, f7, f8, f9, f13, f3);
                    this.cb.stroke();
                    break;
                }
                case 2074: {
                    Object object;
                    float f14;
                    MetaDo metaDo = this;
                    if (metaDo.isNullStrokeFill(metaDo.f.getLineNeutral())) break;
                    float f15 = this.f.transformY(this.in.readShort());
                    float f16 = this.f.transformX(this.in.readShort());
                    float f17 = this.f.transformY(this.in.readShort());
                    float f18 = this.f.transformX(this.in.readShort());
                    float f19 = this.f.transformY(this.in.readShort());
                    float f20 = this.f.transformX(this.in.readShort());
                    float f9 = this.f.transformY(this.in.readShort());
                    float f10 = this.f.transformX(this.in.readShort());
                    float f11 = (f20 + f10) / 2.0f;
                    float f12 = (f9 + f19) / 2.0f;
                    float f21 = MetaDo.a(f11, f12, f18, f17);
                    f15 = MetaDo.a(f11, f12, f16, f15);
                    f15 -= f21;
                    if (f14 <= 0.0f) {
                        f15 += 360.0f;
                    }
                    if ((object = PdfContentByte.bezierArc(f10, f19, f20, f9, f21, f15)).isEmpty()) break;
                    float[] fArray = object.get(0);
                    this.cb.moveTo(f11, f12);
                    this.cb.lineTo(fArray[0], fArray[1]);
                    object = object.iterator();
                    while (object.hasNext()) {
                        fArray = (float[])object.next();
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    }
                    this.cb.lineTo(f11, f12);
                    this.strokeAndFill();
                    break;
                }
                case 2096: {
                    Object object;
                    float f22;
                    MetaDo metaDo = this;
                    if (metaDo.isNullStrokeFill(metaDo.f.getLineNeutral())) break;
                    float f23 = this.f.transformY(this.in.readShort());
                    float f24 = this.f.transformX(this.in.readShort());
                    float f25 = this.f.transformY(this.in.readShort());
                    float f26 = this.f.transformX(this.in.readShort());
                    float f27 = this.f.transformY(this.in.readShort());
                    float f28 = this.f.transformX(this.in.readShort());
                    float f9 = this.f.transformY(this.in.readShort());
                    float f10 = this.f.transformX(this.in.readShort());
                    float f11 = (f28 + f10) / 2.0f;
                    float f12 = (f9 + f27) / 2.0f;
                    float f29 = MetaDo.a(f11, f12, f26, f25);
                    f23 = MetaDo.a(f11, f12, f24, f23);
                    f23 -= f29;
                    if (f22 <= 0.0f) {
                        f23 += 360.0f;
                    }
                    if ((object = PdfContentByte.bezierArc(f10, f27, f28, f9, f29, f23)).isEmpty()) break;
                    float[] fArray = object.get(0);
                    f11 = fArray[0];
                    f12 = fArray[1];
                    this.cb.moveTo(f11, f12);
                    object = object.iterator();
                    while (object.hasNext()) {
                        fArray = (float[])object.next();
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    }
                    this.cb.lineTo(f11, f12);
                    this.strokeAndFill();
                    break;
                }
                case 1051: {
                    if (this.isNullStrokeFill(true)) break;
                    float f30 = this.f.transformY(this.in.readShort());
                    float f31 = this.f.transformX(this.in.readShort());
                    float f32 = this.f.transformY(this.in.readShort());
                    float f33 = this.f.transformX(this.in.readShort());
                    this.cb.rectangle(f33, f30, f31 - f33, f32 - f30);
                    this.strokeAndFill();
                    break;
                }
                case 1564: {
                    if (this.isNullStrokeFill(true)) break;
                    float f34 = this.f.transformY(0) - this.f.transformY(this.in.readShort());
                    float f35 = this.f.transformX(this.in.readShort()) - this.f.transformX(0);
                    float f36 = this.f.transformY(this.in.readShort());
                    float f37 = this.f.transformX(this.in.readShort());
                    float f38 = this.f.transformY(this.in.readShort());
                    float f39 = this.f.transformX(this.in.readShort());
                    this.cb.roundRectangle(f39, f36, f37 - f39, f38 - f36, (f34 + f35) / 4.0f);
                    this.strokeAndFill();
                    break;
                }
                case 1046: {
                    float f40 = this.f.transformY(this.in.readShort());
                    float f41 = this.f.transformX(this.in.readShort());
                    float f42 = this.f.transformY(this.in.readShort());
                    float f43 = this.f.transformX(this.in.readShort());
                    this.cb.rectangle(f43, f40, f41 - f43, f42 - f40);
                    this.cb.eoClip();
                    this.cb.newPath();
                    break;
                }
                case 2610: {
                    String string;
                    byte by;
                    int n20;
                    n4 = this.in.readShort();
                    int n21 = this.in.readShort();
                    int n22 = this.in.readWord();
                    int n23 = this.in.readWord();
                    int n24 = 0;
                    int n25 = 0;
                    int n26 = 0;
                    int n27 = 0;
                    if ((n23 & 6) != 0) {
                        n24 = this.in.readShort();
                        n25 = this.in.readShort();
                        n26 = this.in.readShort();
                        n27 = this.in.readShort();
                    }
                    byte[] byArray = new byte[n22];
                    for (n20 = 0; n20 < n22 && (by = (byte)this.in.readByte()) != 0; ++n20) {
                        byArray[n20] = by;
                    }
                    try {
                        string = new String(byArray, 0, n20, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n20);
                    }
                    this.outputText(n21, n4, n23, n24, n25, n26, n27, string);
                    break;
                }
                case 1313: {
                    String string;
                    byte by;
                    int n28;
                    n4 = this.in.readWord();
                    byte[] byArray = new byte[n4];
                    for (n28 = 0; n28 < n4 && (by = (byte)this.in.readByte()) != 0; ++n28) {
                        byArray[n28] = by;
                    }
                    try {
                        string = new String(byArray, 0, n28, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n28);
                    }
                    n4 = n4 + 1 & 0xFFFE;
                    this.in.skip(n4 - n28);
                    int n29 = this.in.readShort();
                    int n30 = this.in.readShort();
                    this.outputText(n30, n29, 0, 0, 0, 0, 0, string);
                    break;
                }
                case 513: {
                    this.f.setCurrentBackgroundColor(this.in.readColor());
                    break;
                }
                case 521: {
                    this.f.setCurrentTextColor(this.in.readColor());
                    break;
                }
                case 302: {
                    this.f.setTextAlign(this.in.readWord());
                    break;
                }
                case 258: {
                    this.f.setBackgroundMode(this.in.readWord());
                    break;
                }
                case 262: {
                    this.f.setPolyFillMode(this.in.readWord());
                    break;
                }
                case 1055: {
                    Color color = this.in.readColor();
                    int n31 = this.in.readShort();
                    int n32 = this.in.readShort();
                    this.cb.saveState();
                    this.cb.setColorFill(color);
                    this.cb.rectangle(this.f.transformX(n32), this.f.transformY(n31), 0.2f, 0.2f);
                    this.cb.fill();
                    this.cb.restoreState();
                }
            }
            this.in.skip((n3 << 1) - (this.in.getLength() - n2));
        }
        this.f.cleanup(this.cb);
    }

    public void outputText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) {
        MetaFont metaFont = this.f.getCurrentFont();
        float f2 = this.f.transformX(n2);
        float f3 = this.f.transformY(n3);
        float f4 = this.f.transformAngle(metaFont.getAngle());
        float f5 = (float)Math.sin(f4);
        f4 = (float)Math.cos(f4);
        float f6 = metaFont.getFontSize(this.f);
        BaseFont baseFont = metaFont.getFont();
        int n9 = this.f.getTextAlign();
        float f7 = baseFont.getWidthPoint(string, f6);
        float f8 = 0.0f;
        float f9 = baseFont.getFontDescriptor(3, f6);
        float f10 = baseFont.getFontDescriptor(8, f6);
        this.cb.saveState();
        float f11 = f5;
        this.cb.concatCTM(f4, f11, -f11, f4, f2, f3);
        if ((n9 & 6) == 6) {
            f8 = -f7 / 2.0f;
        } else if ((n9 & 2) == 2) {
            f8 = -f7;
        }
        f2 = (n9 & 0x18) == 24 ? 0.0f : ((n9 & 8) == 8 ? -f9 : -f10);
        if (this.f.getBackgroundMode() == 2) {
            Color color = this.f.getCurrentBackgroundColor();
            this.cb.setColorFill(color);
            this.cb.rectangle(f8, f2 + f9, f7, f10 - f9);
            this.cb.fill();
        }
        Color color = this.f.getCurrentTextColor();
        this.cb.setColorFill(color);
        this.cb.beginText();
        this.cb.setFontAndSize(baseFont, f6);
        this.cb.setTextMatrix(f8, f2);
        this.cb.showText(string);
        this.cb.endText();
        if (metaFont.isUnderline()) {
            this.cb.rectangle(f8, f2 - f6 / 4.0f, f7, f6 / 15.0f);
            this.cb.fill();
        }
        if (metaFont.isStrikeout()) {
            this.cb.rectangle(f8, f2 + f6 / 3.0f, f7, f6 / 15.0f);
            this.cb.fill();
        }
        this.cb.restoreState();
    }

    public boolean isNullStrokeFill(boolean bl2) {
        boolean bl3;
        MetaPen metaPen = this.f.getCurrentPen();
        MetaBrush metaBrush = this.f.getCurrentBrush();
        boolean bl32 = metaPen.getStyle() == 5;
        int bl4 = metaBrush.getStyle();
        boolean bl5 = bl4 == 0 || bl4 == 2 && this.f.getBackgroundMode() == 2;
        boolean bl6 = bl3 = bl32 && !bl5;
        if (!bl32) {
            if (bl2) {
                this.f.setLineJoinRectangle(this.cb);
            } else {
                this.f.setLineJoinPolygon(this.cb);
            }
        }
        return bl3;
    }

    public void strokeAndFill() {
        MetaPen metaPen = this.f.getCurrentPen();
        MetaBrush metaBrush = this.f.getCurrentBrush();
        int n2 = metaPen.getStyle();
        int n3 = metaBrush.getStyle();
        if (n2 == 5) {
            this.cb.closePath();
            if (this.f.getPolyFillMode() == 1) {
                this.cb.eoFill();
                return;
            }
            this.cb.fill();
            return;
        }
        n2 = n3 == 0 || n3 == 2 && this.f.getBackgroundMode() == 2 ? 1 : 0;
        if (n2 != 0) {
            if (this.f.getPolyFillMode() == 1) {
                this.cb.closePathEoFillStroke();
                return;
            }
            this.cb.closePathFillStroke();
            return;
        }
        this.cb.closePathStroke();
    }

    private static float a(float f2, float f3, float f4, float f5) {
        double d2;
        double d3 = Math.atan2(f5 - f3, f4 - f2);
        if (d2 < 0.0) {
            d3 += Math.PI * 2;
        }
        return (float)(d3 / Math.PI * 180.0);
    }

    public static byte[] wrapBMP(Image image) {
        Object object;
        if (image.getOriginalType() != 4) {
            throw new IOException(MessageLocalization.getComposedMessage("only.bmp.can.be.wrapped.in.wmf"));
        }
        if (image.getOriginalData() == null) {
            int n2;
            object = image.getUrl().openStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = object.read()) != -1) {
                byteArrayOutputStream.write(n2);
            }
            object.close();
            object = byteArrayOutputStream.toByteArray();
        } else {
            object = image.getOriginalData();
        }
        int n3 = ((byte[])object).length - 14 + 1 >>> 1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MetaDo.writeWord(byteArrayOutputStream, 1);
        MetaDo.writeWord(byteArrayOutputStream, 9);
        MetaDo.writeWord(byteArrayOutputStream, 768);
        MetaDo.writeDWord(byteArrayOutputStream, 23 + (n3 + 13) + 3);
        MetaDo.writeWord(byteArrayOutputStream, 1);
        MetaDo.writeDWord(byteArrayOutputStream, n3 + 14);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeDWord(byteArrayOutputStream, 4);
        MetaDo.writeWord(byteArrayOutputStream, 259);
        MetaDo.writeWord(byteArrayOutputStream, 8);
        MetaDo.writeDWord(byteArrayOutputStream, 5);
        MetaDo.writeWord(byteArrayOutputStream, 523);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeDWord(byteArrayOutputStream, 5);
        MetaDo.writeWord(byteArrayOutputStream, 524);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getHeight());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getWidth());
        MetaDo.writeDWord(byteArrayOutputStream, n3 + 13);
        MetaDo.writeWord(byteArrayOutputStream, 2881);
        MetaDo.writeDWord(byteArrayOutputStream, 0xCC0020);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getHeight());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getWidth());
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getHeight());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getWidth());
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        byteArrayOutputStream.write((byte[])object, 14, ((byte[])object).length - 14);
        if ((((byte[])object).length & 1) == 1) {
            byteArrayOutputStream.write(0);
        }
        MetaDo.writeDWord(byteArrayOutputStream, 3);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeWord(OutputStream outputStream, int n2) {
        outputStream.write(n2 & 0xFF);
        outputStream.write(n2 >>> 8 & 0xFF);
    }

    public static void writeDWord(OutputStream outputStream, int n2) {
        MetaDo.writeWord(outputStream, n2 & 0xFFFF);
        MetaDo.writeWord(outputStream, n2 >>> 16 & 0xFFFF);
    }
}

