/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.wmf;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.codec.wmf.InputMeta;
import com.lowagie.text.pdf.codec.wmf.MetaObject;
import com.lowagie.text.pdf.codec.wmf.MetaState;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class MetaFont
extends MetaObject {
    private static String[] a = new String[]{"Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique", "Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique", "Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic", "Symbol", "ZapfDingbats"};
    private int b;
    private float c;
    private int d;
    private int e;
    private boolean f;
    private boolean g;
    private int h;
    private int i;
    private String j = "arial";
    private BaseFont k = null;

    public MetaFont() {
        this.type = 3;
    }

    public void init(InputMeta inputMeta) {
        int n2;
        int n3;
        this.b = Math.abs(inputMeta.readShort());
        inputMeta.skip(2);
        this.c = (float)((double)inputMeta.readShort() / 1800.0 * Math.PI);
        inputMeta.skip(2);
        this.d = inputMeta.readShort() >= 600 ? 1 : 0;
        this.e = inputMeta.readByte() != 0 ? 2 : 0;
        this.f = inputMeta.readByte() != 0;
        this.g = inputMeta.readByte() != 0;
        this.h = inputMeta.readByte();
        inputMeta.skip(3);
        this.i = inputMeta.readByte();
        byte[] byArray = new byte[32];
        for (n3 = 0; n3 < 32 && (n2 = inputMeta.readByte()) != 0; ++n3) {
            byArray[n3] = (byte)n2;
        }
        try {
            this.j = new String(byArray, 0, n3, "Cp1252");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.j = new String(byArray, 0, n3);
        }
        this.j = this.j.toLowerCase(Locale.ROOT);
    }

    public BaseFont getFont() {
        if (this.k != null) {
            return this.k;
        }
        Object object = FontFactory.getFont(this.j, "Cp1252", true, 10.0f, (this.e != 0 ? 2 : 0) | (this.d != 0 ? 1 : 0));
        this.k = ((Font)object).getBaseFont();
        if (this.k != null) {
            return this.k;
        }
        if (this.j.contains("courier") || this.j.contains("terminal") || this.j.contains("fixedsys")) {
            object = a[0 + this.e + this.d];
        } else if (this.j.contains("ms sans serif") || this.j.contains("arial") || this.j.contains("system")) {
            object = a[4 + this.e + this.d];
        } else if (this.j.contains("arial black")) {
            object = a[4 + this.e + 1];
        } else if (this.j.contains("times") || this.j.contains("ms serif") || this.j.contains("roman")) {
            object = a[8 + this.e + this.d];
        } else if (this.j.contains("symbol")) {
            object = a[12];
        } else {
            int n2 = this.i & 3;
            int n3 = this.i >> 4 & 7;
            block1 : switch (n3) {
                case 3: {
                    object = a[0 + this.e + this.d];
                    break;
                }
                case 1: {
                    object = a[8 + this.e + this.d];
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    object = a[4 + this.e + this.d];
                    break;
                }
                default: {
                    switch (n2) {
                        case 1: {
                            object = a[0 + this.e + this.d];
                            break block1;
                        }
                    }
                    object = a[4 + this.e + this.d];
                }
            }
        }
        try {
            this.k = BaseFont.createFont((String)object, "Cp1252", false);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return this.k;
    }

    public float getAngle() {
        return this.c;
    }

    public boolean isUnderline() {
        return this.f;
    }

    public boolean isStrikeout() {
        return this.g;
    }

    public float getFontSize(MetaState metaState) {
        return Math.abs(metaState.transformY(this.b) - metaState.transformY(0)) * Document.wmfFontCorrection;
    }
}

