/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.collection;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.collection.PdfCollectionField;
import com.lowagie.text.pdf.collection.PdfCollectionSchema;
import java.util.Calendar;

public class PdfCollectionItem
extends PdfDictionary {
    private PdfCollectionSchema a;

    public PdfCollectionItem(PdfCollectionSchema pdfCollectionSchema) {
        super(PdfName.COLLECTIONITEM);
        this.a = pdfCollectionSchema;
    }

    public void addItem(String object, String string) {
        object = new PdfName((String)object);
        PdfCollectionField pdfCollectionField = (PdfCollectionField)this.a.get((PdfName)object);
        this.put((PdfName)object, pdfCollectionField.getValue(string));
    }

    public void addItem(String object, PdfString pdfString) {
        object = new PdfName((String)object);
        PdfCollectionField pdfCollectionField = (PdfCollectionField)this.a.get((PdfName)object);
        if (pdfCollectionField.fieldType == 0) {
            this.put((PdfName)object, pdfString);
        }
    }

    public void addItem(String object, PdfDate pdfDate) {
        object = new PdfName((String)object);
        PdfCollectionField pdfCollectionField = (PdfCollectionField)this.a.get((PdfName)object);
        if (pdfCollectionField.fieldType == 1) {
            this.put((PdfName)object, pdfDate);
        }
    }

    public void addItem(String object, PdfNumber pdfNumber) {
        object = new PdfName((String)object);
        PdfCollectionField pdfCollectionField = (PdfCollectionField)this.a.get((PdfName)object);
        if (pdfCollectionField.fieldType == 2) {
            this.put((PdfName)object, pdfNumber);
        }
    }

    public void addItem(String string, Calendar calendar) {
        this.addItem(string, new PdfDate(calendar));
    }

    public void addItem(String string, int n2) {
        this.addItem(string, new PdfNumber(n2));
    }

    public void addItem(String string, float f2) {
        this.addItem(string, new PdfNumber(f2));
    }

    public void addItem(String string, double d2) {
        this.addItem(string, new PdfNumber(d2));
    }

    public void setPrefix(String object, String string) {
        PdfObject pdfObject = this.get((PdfName)(object = new PdfName((String)object)));
        if (pdfObject == null) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("you.must.set.a.value.before.adding.a.prefix"));
        }
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.COLLECTIONSUBITEM);
        pdfDictionary.put(PdfName.D, pdfObject);
        pdfDictionary.put(PdfName.P, new PdfString(string, "UnicodeBig"));
        this.put((PdfName)object, pdfDictionary);
    }
}

