/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.collection;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;

public class PdfCollectionSort
extends PdfDictionary {
    public PdfCollectionSort(String string) {
        super(PdfName.COLLECTIONSORT);
        this.put(PdfName.S, new PdfName(string));
    }

    public PdfCollectionSort(String[] stringArray) {
        super(PdfName.COLLECTIONSORT);
        PdfArray pdfArray = new PdfArray();
        for (String string : stringArray) {
            pdfArray.add(new PdfName(string));
        }
        this.put(PdfName.S, pdfArray);
    }

    public void setSortOrder(boolean bl2) {
        PdfObject pdfObject = this.get(PdfName.S);
        if (pdfObject instanceof PdfName) {
            this.put(PdfName.A, new PdfBoolean(bl2));
            return;
        }
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("you.have.to.define.a.boolean.array.for.this.collection.sort.dictionary"));
    }

    public void setSortOrder(boolean[] blArray) {
        PdfObject pdfObject = this.get(PdfName.S);
        if (pdfObject instanceof PdfArray) {
            if (((PdfArray)pdfObject).size() != blArray.length) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.number.of.booleans.in.this.array.doesn.t.correspond.with.the.number.of.fields"));
            }
            pdfObject = new PdfArray();
            for (boolean bl2 : blArray) {
                ((PdfArray)pdfObject).add(new PdfBoolean(bl2));
            }
            this.put(PdfName.A, pdfObject);
            return;
        }
        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("you.need.a.single.boolean.for.this.collection.sort.dictionary"));
    }
}

