/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.draw;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.draw.DrawInterface;
import java.util.ArrayList;

public class VerticalPositionMark
implements Element,
DrawInterface {
    protected DrawInterface drawInterface = null;
    protected float offset = 0.0f;

    public VerticalPositionMark() {
    }

    public VerticalPositionMark(DrawInterface drawInterface, float f2) {
        this.drawInterface = drawInterface;
        this.offset = f2;
    }

    @Override
    public void draw(PdfContentByte pdfContentByte, float f2, float f3, float f4, float f5, float f6) {
        if (this.drawInterface != null) {
            this.drawInterface.draw(pdfContentByte, f2, f3, f4, f5, f6 + this.offset);
        }
    }

    @Override
    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    @Override
    public int type() {
        return 55;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    @Override
    public ArrayList<Element> getChunks() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(new Chunk((DrawInterface)this, true));
        return arrayList;
    }

    public DrawInterface getDrawInterface() {
        return this.drawInterface;
    }

    public void setDrawInterface(DrawInterface drawInterface) {
        this.drawInterface = drawInterface;
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float f2) {
        this.offset = f2;
    }
}

