/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.events;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TextField;
import java.util.HashMap;
import java.util.Map;

public class FieldPositioningEvents
extends PdfPageEventHelper
implements PdfPCellEvent {
    protected Map<String, PdfFormField> genericChunkFields = new HashMap<String, PdfFormField>();
    protected PdfFormField cellField = null;
    protected PdfWriter fieldWriter = null;
    protected PdfFormField parent = null;
    public float padding;

    public FieldPositioningEvents() {
    }

    public void addField(String string, PdfFormField pdfFormField) {
        this.genericChunkFields.put(string, pdfFormField);
    }

    public FieldPositioningEvents(PdfWriter pdfWriter, PdfFormField pdfFormField) {
        this.cellField = pdfFormField;
        this.fieldWriter = pdfWriter;
    }

    public FieldPositioningEvents(PdfFormField pdfFormField, PdfFormField pdfFormField2) {
        this.cellField = pdfFormField2;
        this.parent = pdfFormField;
    }

    public FieldPositioningEvents(PdfWriter object, String string) {
        this.fieldWriter = object;
        object = new TextField((PdfWriter)object, new Rectangle(0.0f, 0.0f), string);
        ((BaseField)object).setFontSize(14.0f);
        this.cellField = ((TextField)object).getTextField();
    }

    public FieldPositioningEvents(PdfWriter object, PdfFormField pdfFormField, String string) {
        this.parent = pdfFormField;
        object = new TextField((PdfWriter)object, new Rectangle(0.0f, 0.0f), string);
        ((BaseField)object).setFontSize(14.0f);
        this.cellField = ((TextField)object).getTextField();
    }

    public void setPadding(float f2) {
        this.padding = f2;
    }

    public void setParent(PdfFormField pdfFormField) {
        this.parent = pdfFormField;
    }

    @Override
    public void onGenericTag(PdfWriter pdfWriter, Document object, Rectangle rectangle, String string) {
        Rectangle rectangle2 = rectangle;
        rectangle2.setBottom(rectangle2.getBottom() - 3.0f);
        object = this.genericChunkFields.get(string);
        if (object == null) {
            object = new TextField(pdfWriter, new Rectangle(rectangle.getLeft(this.padding), rectangle.getBottom(this.padding), rectangle.getRight(this.padding), rectangle.getTop(this.padding)), string);
            ((BaseField)object).setFontSize(14.0f);
            try {
                object = ((TextField)object).getTextField();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        } else {
            ((PdfDictionary)object).put(PdfName.RECT, new PdfRectangle(rectangle.getLeft(this.padding), rectangle.getBottom(this.padding), rectangle.getRight(this.padding), rectangle.getTop(this.padding)));
        }
        if (this.parent == null) {
            pdfWriter.addAnnotation((PdfAnnotation)object);
            return;
        }
        this.parent.addKid((PdfFormField)object);
    }

    @Override
    public void cellLayout(PdfPCell pdfPCell, Rectangle rectangle, PdfContentByte[] pdfContentByteArray) {
        if (this.cellField == null || this.fieldWriter == null && this.parent == null) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("you.have.used.the.wrong.constructor.for.this.fieldpositioningevents.class"));
        }
        this.cellField.put(PdfName.RECT, new PdfRectangle(rectangle.getLeft(this.padding), rectangle.getBottom(this.padding), rectangle.getRight(this.padding), rectangle.getTop(this.padding)));
        if (this.parent == null) {
            this.fieldWriter.addAnnotation(this.cellField);
            return;
        }
        this.parent.addKid(this.cellField);
    }
}

