/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.hyphenation.ByteVector;
import com.lowagie.text.pdf.hyphenation.Hyphenation;
import com.lowagie.text.pdf.hyphenation.PatternConsumer;
import com.lowagie.text.pdf.hyphenation.SimplePatternParser;
import com.lowagie.text.pdf.hyphenation.TernaryTree;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer {
    protected ByteVector vspace;
    protected Map<String, List> stoplist = new HashMap<String, List>(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree a;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    protected int packValues(String string) {
        int n2 = string.length();
        int n3 = (n2 & 1) == 1 ? (n2 >> 1) + 2 : (n2 >> 1) + 1;
        int n4 = this.vspace.alloc(n3);
        byte[] byArray = this.vspace.getArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = i2 >> 1;
            byte by = (byte)(string.charAt(i2) - 48 + 1 & 0xF);
            byArray[n5 + n4] = (i2 & 1) == 1 ? (byte)(byArray[n5 + n4] | by) : (byte)(by << 4);
        }
        byArray[n3 - 1 + n4] = 0;
        return n4;
    }

    protected String unpackValues(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        byte by = this.vspace.get(n2++);
        while (by != 0) {
            char c2 = (char)((by >>> 4) - 1 + 48);
            stringBuilder.append(c2);
            c2 = (char)(by & 0xF);
            if (c2 == '\u0000') break;
            c2 = (char)(c2 - '\u0001' + 48);
            stringBuilder.append(c2);
            by = this.vspace.get(n2++);
        }
        return stringBuilder.toString();
    }

    public void loadSimplePatterns(InputStream inputStream) {
        SimplePatternParser simplePatternParser = new SimplePatternParser();
        this.a = new TernaryTree();
        simplePatternParser.parse(inputStream, this);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.a = null;
    }

    public String findPattern(String string) {
        int n2 = super.find(string);
        if (n2 >= 0) {
            return this.unpackValues(n2);
        }
        return "";
    }

    protected int hstrcmp(char[] cArray, int n2, char[] cArray2, int n3) {
        while (cArray[n2] == cArray2[n3]) {
            if (cArray[n2] == '\u0000') {
                return 0;
            }
            ++n2;
            ++n3;
        }
        if (cArray2[n3] == '\u0000') {
            return 0;
        }
        return cArray[n2] - cArray2[n3];
    }

    protected byte[] getValues(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        byte by = this.vspace.get(n2++);
        while (by != 0) {
            char c2 = (char)((by >>> 4) - 1);
            stringBuilder.append(c2);
            c2 = (char)(by & 0xF);
            if (c2 == '\u0000') break;
            c2 = (char)(c2 - '\u0001');
            stringBuilder.append(c2);
            by = this.vspace.get(n2++);
        }
        byte[] byArray = new byte[stringBuilder.length()];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray[n2] = (byte)stringBuilder.charAt(n2);
        }
        return byArray;
    }

    protected void searchPatterns(char[] cArray, int n2, byte[] byArray) {
        int n3 = n2;
        char c2 = cArray[n2];
        char c3 = this.root;
        block0: while (c3 > '\u0000' && c3 < this.sc.length) {
            int n4;
            int n5;
            int n6;
            if (this.sc[c3] == '\uffff') {
                if (this.hstrcmp(cArray, n3, this.kv.getArray(), this.lo[c3]) == 0) {
                    HyphenationTree hyphenationTree = this;
                    byte[] byArray2 = hyphenationTree.getValues(hyphenationTree.eq[c3]);
                    n6 = n2;
                    byte[] byArray3 = byArray2;
                    int n7 = byArray2.length;
                    for (n5 = 0; n5 < n7; ++n5) {
                        n4 = byArray3[n5];
                        if (n6 < byArray.length && n4 > byArray[n6]) {
                            byArray[n6] = n4;
                        }
                        ++n6;
                    }
                }
                return;
            }
            n6 = c2 - this.sc[c3];
            if (n6 == 0) {
                if (c2 == '\u0000') break;
                c2 = cArray[++n3];
                char c4 = c3 = this.eq[c3];
                while (c4 > '\u0000' && c4 < this.sc.length && this.sc[c4] != '\uffff') {
                    if (this.sc[c4] == '\u0000') {
                        HyphenationTree hyphenationTree = this;
                        byte[] byArray4 = hyphenationTree.getValues(hyphenationTree.eq[c4]);
                        int n8 = n2;
                        n5 = byArray4.length;
                        for (n4 = 0; n4 < n5; ++n4) {
                            n6 = byArray4[n4];
                            if (n8 < byArray.length && n6 > byArray[n8]) {
                                byArray[n8] = n6;
                            }
                            ++n8;
                        }
                        continue block0;
                    }
                    c4 = this.lo[c4];
                }
                continue;
            }
            c3 = n6 < 0 ? this.lo[c3] : this.hi[c3];
        }
    }

    public Hyphenation hyphenate(String object, int n2, int n3) {
        object = ((String)object).toCharArray();
        return this.hyphenate((char[])object, 0, ((Object)object).length, n2, n3);
    }

    public Hyphenation hyphenate(char[] cArray, int n2, int n3, int n4, int n5) {
        Object object;
        char[] cArray2 = new char[n3 + 3];
        char[] cArray3 = new char[2];
        int n6 = 0;
        int n7 = n3;
        boolean bl2 = false;
        for (int i2 = 1; i2 <= n3; ++i2) {
            cArray3[0] = cArray[n2 + i2 - 1];
            int n8 = this.classmap.find(cArray3, 0);
            if (n8 < 0) {
                if (i2 == n6 + 1) {
                    ++n6;
                } else {
                    bl2 = true;
                }
                --n7;
                continue;
            }
            if (!bl2) {
                cArray2[i2 - n6] = (char)n8;
                continue;
            }
            return null;
        }
        n3 = n7;
        if (n3 < n4 + n5) {
            return null;
        }
        int[] nArray = new int[n3 + 1];
        int n9 = 0;
        String string = new String(cArray2, 1, n3);
        if (this.stoplist.containsKey(string)) {
            object = this.stoplist.get(string);
            int n10 = 0;
            for (int i3 = 0; i3 < object.size(); ++i3) {
                Object e2 = object.get(i3);
                if (!(e2 instanceof String) || (n10 += ((String)e2).length()) < n4 || n10 >= n3 - n5) continue;
                nArray[n9++] = n10 + n6;
            }
        } else {
            int n11;
            cArray2[0] = 46;
            cArray2[n3 + 1] = 46;
            cArray2[n3 + 2] = '\u0000';
            object = new byte[n3 + 3];
            for (n11 = 0; n11 < n3 + 1; ++n11) {
                this.searchPatterns(cArray2, n11, (byte[])object);
            }
            for (n11 = 0; n11 < n3; ++n11) {
                if ((object[n11 + 1] & 1) != 1 || n11 < n4 || n11 > n3 - n5) continue;
                nArray[n9++] = n11 + n6;
            }
        }
        if (n9 > 0) {
            object = new int[n9];
            System.arraycopy(nArray, 0, object, 0, n9);
            return new Hyphenation(new String(cArray, n2, n3), (int[])object);
        }
        return null;
    }

    @Override
    public void addClass(String string) {
        if (string.length() > 0) {
            char c2 = string.charAt(0);
            char[] cArray = new char[2];
            char[] cArray2 = cArray;
            cArray[1] = '\u0000';
            for (int i2 = 0; i2 < string.length(); ++i2) {
                cArray2[0] = string.charAt(i2);
                this.classmap.insert(cArray2, 0, c2);
            }
        }
    }

    @Override
    public void addException(String string, ArrayList arrayList) {
        this.stoplist.put(string, arrayList);
    }

    @Override
    public void addPattern(String string, String string2) {
        int n2 = this.a.find(string2);
        if (n2 <= 0) {
            n2 = this.packValues(string2);
            this.a.insert(string2, (char)n2);
        }
        this.insert(string, (char)n2);
    }

    @Override
    public void printStats() {
        System.out.println("Value space size = " + this.vspace.length());
        super.printStats();
    }
}

