/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.hyphenation.Hyphenation;
import com.lowagie.text.pdf.hyphenation.HyphenationTree;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;

public class Hyphenator {
    private static Map<String, HyphenationTree> a = new Hashtable<String, HyphenationTree>();
    private HyphenationTree b = null;
    private int c = 2;
    private int d = 2;
    private static String e = "";

    public Hyphenator(String string, String string2, int n2, int n3) {
        this.b = Hyphenator.getHyphenationTree(string, string2);
        this.c = n2;
        this.d = n3;
    }

    public static HyphenationTree getHyphenationTree(String object, String string) {
        String string2 = object;
        if (string != null && !string.equals("none")) {
            string2 = string2 + "_" + string;
        }
        if (a.containsKey(string2)) {
            return a.get(string2);
        }
        if (a.containsKey(object)) {
            return a.get(object);
        }
        object = Hyphenator.getResourceHyphenationTree(string2);
        if (object == null) {
            object = Hyphenator.getFileHyphenationTree(string2);
        }
        if (object != null) {
            a.put(string2, (HyphenationTree)object);
        }
        return object;
    }

    public static HyphenationTree getResourceHyphenationTree(String object) {
        try {
            InputStream inputStream = BaseFont.getResourceStream("com/lowagie/text/pdf/hyphenation/hyph/" + (String)object + ".xml");
            if (inputStream == null && ((String)object).length() > 2) {
                inputStream = BaseFont.getResourceStream("com/lowagie/text/pdf/hyphenation/hyph/" + ((String)object).substring(0, 2) + ".xml");
            }
            if (inputStream == null) {
                return null;
            }
            object = new HyphenationTree();
            ((HyphenationTree)object).loadSimplePatterns(inputStream);
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static HyphenationTree getFileHyphenationTree(String object) {
        try {
            if (e == null) {
                return null;
            }
            FileInputStream fileInputStream = null;
            File file = new File(e, (String)object + ".xml");
            if (file.canRead()) {
                fileInputStream = new FileInputStream(file);
            }
            if (fileInputStream == null && ((String)object).length() > 2 && (file = new File(e, ((String)object).substring(0, 2) + ".xml")).canRead()) {
                fileInputStream = new FileInputStream(file);
            }
            if (fileInputStream == null) {
                return null;
            }
            object = new HyphenationTree();
            ((HyphenationTree)object).loadSimplePatterns(fileInputStream);
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Hyphenation hyphenate(String object, String string, String string2, int n2, int n3) {
        if ((object = Hyphenator.getHyphenationTree((String)object, string)) == null) {
            return null;
        }
        return ((HyphenationTree)object).hyphenate(string2, n2, n3);
    }

    public static Hyphenation hyphenate(String object, String string, char[] cArray, int n2, int n3, int n4, int n5) {
        if ((object = Hyphenator.getHyphenationTree((String)object, string)) == null) {
            return null;
        }
        return ((HyphenationTree)object).hyphenate(cArray, n2, n3, n4, n5);
    }

    public void setMinRemainCharCount(int n2) {
        this.c = n2;
    }

    public void setMinPushCharCount(int n2) {
        this.d = n2;
    }

    public void setLanguage(String string, String string2) {
        this.b = Hyphenator.getHyphenationTree(string, string2);
    }

    public Hyphenation hyphenate(char[] cArray, int n2, int n3) {
        if (this.b == null) {
            return null;
        }
        return this.b.hyphenate(cArray, n2, n3, this.c, this.d);
    }

    public Hyphenation hyphenate(String string) {
        if (this.b == null) {
            return null;
        }
        return this.b.hyphenate(string, this.c, this.d);
    }

    public static String getHyphenDir() {
        return e;
    }

    public static void setHyphenDir(String string) {
        e = string;
    }
}

