/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.hyphenation.CharVector;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;

public class TernaryTree
implements Serializable,
Cloneable {
    protected char[] lo;
    protected char[] hi;
    protected char[] eq;
    protected char[] sc;
    protected CharVector kv;
    protected char root;
    protected char freenode;
    protected int length;
    protected static final int BLOCK_SIZE = 2048;

    TernaryTree() {
        this.init();
    }

    protected void init() {
        this.root = '\u0000';
        this.freenode = '\u0001';
        this.length = 0;
        this.lo = new char[2048];
        this.hi = new char[2048];
        this.eq = new char[2048];
        this.sc = new char[2048];
        this.kv = new CharVector();
    }

    public void insert(String string, char c2) {
        int n2 = string.length() + 1;
        if (this.freenode + n2 > this.eq.length) {
            TernaryTree ternaryTree = this;
            ternaryTree.a(ternaryTree.eq.length + 2048);
        }
        char[] cArray = new char[n2--];
        string.getChars(0, n2, cArray, 0);
        cArray[n2] = '\u0000';
        this.root = this.a(this.root, cArray, 0, c2);
    }

    public void insert(char[] cArray, int n2, char c2) {
        int n3 = TernaryTree.strlen(cArray) + 1;
        if (this.freenode + n3 > this.eq.length) {
            TernaryTree ternaryTree = this;
            ternaryTree.a(ternaryTree.eq.length + 2048);
        }
        this.root = this.a(this.root, cArray, n2, c2);
    }

    private char a(char c2, char[] cArray, int n2, char c3) {
        char c4;
        int n3 = TernaryTree.strlen(cArray, n2);
        if (c2 == '\u0000') {
            char c5 = this.freenode;
            this.freenode = (char)(c5 + '\u0001');
            c2 = c5;
            this.eq[c2] = c3;
            ++this.length;
            this.hi[c2] = '\u0000';
            if (n3 > 0) {
                this.sc[c2] = 65535;
                this.lo[c2] = (char)this.kv.alloc(n3 + 1);
                TernaryTree.strcpy(this.kv.getArray(), this.lo[c2], cArray, n2);
            } else {
                this.sc[c2] = '\u0000';
                this.lo[c2] = '\u0000';
            }
            return c2;
        }
        if (this.sc[c2] == '\uffff') {
            char c6 = this.freenode;
            this.freenode = (char)(c6 + '\u0001');
            c4 = c6;
            this.lo[c4] = this.lo[c2];
            this.eq[c4] = this.eq[c2];
            this.lo[c2] = '\u0000';
            if (n3 > 0) {
                this.sc[c2] = this.kv.get(this.lo[c4]);
                this.eq[c2] = c4;
                char c7 = c4;
                this.lo[c7] = (char)(this.lo[c7] + '\u0001');
                if (this.kv.get(this.lo[c4]) == '\u0000') {
                    this.lo[c4] = '\u0000';
                    this.sc[c4] = '\u0000';
                    this.hi[c4] = '\u0000';
                } else {
                    this.sc[c4] = 65535;
                }
            } else {
                this.sc[c4] = 65535;
                this.hi[c2] = c4;
                this.sc[c2] = '\u0000';
                this.eq[c2] = c3;
                ++this.length;
                return c2;
            }
        }
        if ((c4 = cArray[n2]) < this.sc[c2]) {
            TernaryTree ternaryTree = this;
            this.lo[c2] = ternaryTree.a(ternaryTree.lo[c2], cArray, n2, c3);
        } else if (c4 == this.sc[c2]) {
            if (c4 != '\u0000') {
                TernaryTree ternaryTree = this;
                this.eq[c2] = ternaryTree.a(ternaryTree.eq[c2], cArray, n2 + 1, c3);
            } else {
                this.eq[c2] = c3;
            }
        } else {
            TernaryTree ternaryTree = this;
            this.hi[c2] = ternaryTree.a(ternaryTree.hi[c2], cArray, n2, c3);
        }
        return c2;
    }

    public static int strcmp(char[] cArray, int n2, char[] cArray2, int n3) {
        while (cArray[n2] == cArray2[n3]) {
            if (cArray[n2] == '\u0000') {
                return 0;
            }
            ++n2;
            ++n3;
        }
        return cArray[n2] - cArray2[n3];
    }

    public static int strcmp(String string, char[] cArray, int n2) {
        int n3;
        int n4 = string.length();
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = string.charAt(n3) - cArray[n2 + n3];
            if (n5 != 0) {
                return n5;
            }
            if (cArray[n2 + n3] != '\u0000') continue;
            return n5;
        }
        if (cArray[n2 + n3] != '\u0000') {
            return -cArray[n2 + n3];
        }
        return 0;
    }

    public static void strcpy(char[] cArray, int n2, char[] cArray2, int n3) {
        while (cArray2[n3] != '\u0000') {
            cArray[n2++] = cArray2[n3++];
        }
        cArray[n2] = '\u0000';
    }

    public static int strlen(char[] cArray, int n2) {
        int n3 = 0;
        while (n2 < cArray.length && cArray[n2] != '\u0000') {
            ++n3;
            ++n2;
        }
        return n3;
    }

    public static int strlen(char[] cArray) {
        return TernaryTree.strlen(cArray, 0);
    }

    public int find(String string) {
        int n2 = string.length();
        char[] cArray = new char[n2 + 1];
        string.getChars(0, n2, cArray, 0);
        cArray[n2] = '\u0000';
        return this.find(cArray, 0);
    }

    public int find(char[] cArray, int n2) {
        char c2 = this.root;
        int n3 = n2;
        while (c2 != '\u0000') {
            if (this.sc[c2] == '\uffff') {
                if (TernaryTree.strcmp(cArray, n3, this.kv.getArray(), this.lo[c2]) == 0) {
                    return this.eq[c2];
                }
                return -1;
            }
            char c3 = cArray[n3];
            n2 = c3 - this.sc[c2];
            if (n2 == 0) {
                if (c3 == '\u0000') {
                    return this.eq[c2];
                }
                ++n3;
                c2 = this.eq[c2];
                continue;
            }
            if (n2 < 0) {
                c2 = this.lo[c2];
                continue;
            }
            c2 = this.hi[c2];
        }
        return -1;
    }

    public boolean knows(String string) {
        return this.find(string) >= 0;
    }

    private void a(int n2) {
        int n3 = n2 < this.lo.length ? n2 : this.lo.length;
        char[] cArray = new char[n2];
        System.arraycopy(this.lo, 0, cArray, 0, n3);
        this.lo = cArray;
        cArray = new char[n2];
        System.arraycopy(this.hi, 0, cArray, 0, n3);
        this.hi = cArray;
        cArray = new char[n2];
        System.arraycopy(this.eq, 0, cArray, 0, n3);
        this.eq = cArray;
        cArray = new char[n2];
        System.arraycopy(this.sc, 0, cArray, 0, n3);
        this.sc = cArray;
    }

    public int size() {
        return this.length;
    }

    public Object clone() {
        TernaryTree ternaryTree = new TernaryTree();
        new TernaryTree().lo = (char[])this.lo.clone();
        ternaryTree.hi = (char[])this.hi.clone();
        ternaryTree.eq = (char[])this.eq.clone();
        ternaryTree.sc = (char[])this.sc.clone();
        ternaryTree.kv = (CharVector)this.kv.clone();
        ternaryTree.root = this.root;
        ternaryTree.freenode = this.freenode;
        ternaryTree.length = this.length;
        return ternaryTree;
    }

    protected void insertBalanced(String[] stringArray, char[] cArray, int n2, int n3) {
        if (n3 <= 0) {
            return;
        }
        int n4 = n3 >> 1;
        this.insert(stringArray[n4 + n2], cArray[n4 + n2]);
        this.insertBalanced(stringArray, cArray, n2, n4);
        this.insertBalanced(stringArray, cArray, n2 + n4 + 1, n3 - n4 - 1);
    }

    public void balance() {
        int n2 = 0;
        int n3 = this.length;
        String[] stringArray = new String[n3];
        char[] cArray = new char[n3];
        Iterator iterator = new Iterator(this);
        while (iterator.hasMoreElements()) {
            cArray[n2] = iterator.getValue();
            stringArray[n2++] = (String)iterator.nextElement();
        }
        this.init();
        this.insertBalanced(stringArray, cArray, 0, n3);
    }

    public void trimToSize() {
        this.balance();
        TernaryTree ternaryTree = this;
        ternaryTree.a(ternaryTree.freenode);
        CharVector charVector = new CharVector();
        charVector.alloc(1);
        TernaryTree ternaryTree2 = new TernaryTree();
        this.a(charVector, ternaryTree2, this.root);
        this.kv = charVector;
        this.kv.trimToSize();
    }

    private void a(CharVector charVector, TernaryTree ternaryTree, char c2) {
        while (c2 != '\u0000') {
            if (this.sc[c2] == '\uffff') {
                int n2 = ternaryTree.find(this.kv.getArray(), this.lo[c2]);
                if (n2 < 0) {
                    n2 = charVector.alloc(TernaryTree.strlen(this.kv.getArray(), this.lo[c2]) + 1);
                    TernaryTree.strcpy(charVector.getArray(), n2, this.kv.getArray(), this.lo[c2]);
                    int n3 = n2;
                    ternaryTree.insert(charVector.getArray(), n3, (char)n3);
                }
                this.lo[c2] = (char)n2;
                return;
            }
            this.a(charVector, ternaryTree, this.lo[c2]);
            if (this.sc[c2] != '\u0000') {
                this.a(charVector, ternaryTree, this.eq[c2]);
            }
            c2 = this.hi[c2];
        }
        return;
    }

    public Enumeration keys() {
        return new Iterator(this);
    }

    public void printStats() {
        System.out.println("Number of keys = " + this.length);
        System.out.println("Node count = " + this.freenode);
        System.out.println("Key Array length = " + this.kv.length());
    }

    public class Iterator
    implements Enumeration {
        private int a = -1;
        private String b;
        private Stack<a> c = new Stack();
        private StringBuffer d = new StringBuffer();
        private /* synthetic */ TernaryTree e;

        public Iterator(TernaryTree ternaryTree) {
            this.e = ternaryTree;
            this.rewind();
        }

        public void rewind() {
            this.c.removeAllElements();
            this.d.setLength(0);
            this.a = this.e.root;
            this.b();
        }

        public Object nextElement() {
            String string = this.b;
            this.a = this.a();
            this.b();
            return string;
        }

        public char getValue() {
            if (this.a >= 0) {
                return this.e.eq[this.a];
            }
            return '\u0000';
        }

        @Override
        public boolean hasMoreElements() {
            return this.a != -1;
        }

        private int a() {
            new a(this);
            int n2 = 0;
            if (this.c.empty()) {
                return -1;
            }
            if (this.a != 0 && this.e.sc[this.a] == '\u0000') {
                return this.e.lo[this.a];
            }
            boolean bl2 = true;
            block4: while (bl2) {
                a a2 = this.c.pop();
                a2.b = (char)(a2.b + '\u0001');
                switch (a2.b) {
                    case '\u0001': {
                        if (this.e.sc[a2.a] != '\u0000') {
                            n2 = this.e.eq[a2.a];
                            this.c.push((a)a2.clone());
                            this.d.append(this.e.sc[a2.a]);
                        } else {
                            a2.b = (char)(a2.b + '\u0001');
                            this.c.push((a)a2.clone());
                            n2 = this.e.hi[a2.a];
                        }
                        bl2 = false;
                        continue block4;
                    }
                    case '\u0002': {
                        n2 = this.e.hi[a2.a];
                        this.c.push((a)a2.clone());
                        if (this.d.length() > 0) {
                            this.d.setLength(this.d.length() - 1);
                        }
                        bl2 = false;
                        continue block4;
                    }
                }
                if (this.c.empty()) {
                    return -1;
                }
                bl2 = true;
            }
            return n2;
        }

        private int b() {
            block9: {
                if (this.a == -1) {
                    return -1;
                }
                boolean bl2 = false;
                while (true) {
                    if (this.a != 0) {
                        if (this.e.sc[this.a] == '\uffff') {
                            bl2 = true;
                        } else {
                            Iterator iterator = this;
                            this.c.push(new a(iterator, (char)iterator.a, '\u0000'));
                            if (this.e.sc[this.a] == '\u0000') {
                                bl2 = true;
                            } else {
                                this.a = this.e.lo[this.a];
                                continue;
                            }
                        }
                    }
                    if (bl2) break block9;
                    this.a = this.a();
                    if (this.a == -1) break;
                }
                return -1;
            }
            StringBuilder stringBuilder = new StringBuilder(this.d.toString());
            if (this.e.sc[this.a] == '\uffff') {
                int n2 = this.e.lo[this.a];
                while (this.e.kv.get(n2) != '\u0000') {
                    stringBuilder.append(this.e.kv.get(n2++));
                }
            }
            this.b = stringBuilder.toString();
            return 0;
        }

        private final class a
        implements Cloneable {
            char a;
            char b;
            private /* synthetic */ Iterator c;

            public a(Iterator iterator) {
                this.c = iterator;
                this.a = '\u0000';
                this.b = '\u0000';
            }

            public a(Iterator iterator, char c2, char c3) {
                this.c = iterator;
                this.a = c2;
                this.b = c3;
            }

            public final Object clone() {
                return new a(this.c, this.a, this.b);
            }
        }
    }
}

