/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.internal;

import com.lowagie.text.Annotation;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdfAnnotationsImp {
    protected PdfAcroForm acroForm;
    protected List<PdfAnnotation> annotations;
    protected List<PdfAnnotation> delayedAnnotations = new ArrayList<PdfAnnotation>();

    public PdfAnnotationsImp(PdfWriter pdfWriter) {
        this.acroForm = new PdfAcroForm(pdfWriter);
    }

    public boolean hasValidAcroForm() {
        return this.acroForm.isValid();
    }

    public PdfAcroForm getAcroForm() {
        return this.acroForm;
    }

    public void setSigFlags(int n2) {
        this.acroForm.setSigFlags(n2);
    }

    public void addCalculationOrder(PdfFormField pdfFormField) {
        this.acroForm.addCalculationOrder(pdfFormField);
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        if (pdfAnnotation.isForm()) {
            if (((PdfFormField)(pdfAnnotation = (PdfFormField)pdfAnnotation)).getParent() == null) {
                this.a((PdfFormField)pdfAnnotation);
            }
            return;
        }
        this.annotations.add(pdfAnnotation);
    }

    public void addPlainAnnotation(PdfAnnotation pdfAnnotation) {
        this.annotations.add(pdfAnnotation);
    }

    private void a(PdfFormField iterator) {
        this.annotations.add((PdfAnnotation)((Object)iterator));
        iterator = ((PdfFormField)((Object)iterator)).getKidFields();
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                PdfFormField pdfFormField = (PdfFormField)iterator.next();
                this.a(pdfFormField);
            }
        }
    }

    public boolean hasUnusedAnnotations() {
        return !this.annotations.isEmpty();
    }

    public void resetAnnotations() {
        this.annotations = this.delayedAnnotations;
        this.delayedAnnotations = new ArrayList<PdfAnnotation>();
    }

    public PdfArray rotateAnnotations(PdfWriter pdfWriter, Rectangle rectangle) {
        PdfArray pdfArray = new PdfArray();
        int n2 = rectangle.getRotation() % 360;
        int n3 = pdfWriter.getCurrentPageNumber();
        for (PdfAnnotation pdfAnnotation : this.annotations) {
            PdfAnnotation pdfAnnotation2 = pdfAnnotation;
            pdfAnnotation2 = pdfAnnotation;
            int n4 = pdfAnnotation.getPlaceInPage();
            if (n4 > n3) {
                this.delayedAnnotations.add(pdfAnnotation2);
                continue;
            }
            if (pdfAnnotation2.isForm()) {
                PdfFormField pdfFormField;
                HashMap<PdfTemplate, Object> hashMap;
                if (!pdfAnnotation2.isUsed() && (hashMap = pdfAnnotation2.getTemplates()) != null) {
                    this.acroForm.addFieldTemplates((Map<PdfTemplate, Object>)hashMap);
                }
                if ((pdfFormField = (PdfFormField)pdfAnnotation2).getParent() == null) {
                    this.acroForm.addDocumentField(pdfFormField.getIndirectReference());
                }
            }
            if (pdfAnnotation2.isAnnotation()) {
                PdfRectangle pdfRectangle;
                pdfArray.add(pdfAnnotation2.getIndirectReference());
                if (!pdfAnnotation2.isUsed() && (pdfRectangle = (PdfRectangle)pdfAnnotation2.get(PdfName.RECT)) != null) {
                    switch (n2) {
                        case 90: {
                            pdfAnnotation2.put(PdfName.RECT, new PdfRectangle(rectangle.getTop() - pdfRectangle.bottom(), pdfRectangle.left(), rectangle.getTop() - pdfRectangle.top(), pdfRectangle.right()));
                            break;
                        }
                        case 180: {
                            pdfAnnotation2.put(PdfName.RECT, new PdfRectangle(rectangle.getRight() - pdfRectangle.left(), rectangle.getTop() - pdfRectangle.bottom(), rectangle.getRight() - pdfRectangle.right(), rectangle.getTop() - pdfRectangle.top()));
                            break;
                        }
                        case 270: {
                            pdfAnnotation2.put(PdfName.RECT, new PdfRectangle(pdfRectangle.bottom(), rectangle.getRight() - pdfRectangle.left(), pdfRectangle.top(), rectangle.getRight() - pdfRectangle.right()));
                        }
                    }
                }
            }
            if (pdfAnnotation2.isUsed()) continue;
            pdfAnnotation2.setUsed();
            try {
                PdfAnnotation pdfAnnotation3 = pdfAnnotation2;
                pdfWriter.addToBody((PdfObject)pdfAnnotation3, pdfAnnotation3.getIndirectReference());
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
        return pdfArray;
    }

    public static PdfAnnotation convertAnnotation(PdfWriter pdfWriter, Annotation annotation, Rectangle object) {
        switch (annotation.annotationType()) {
            case 1: {
                return new PdfAnnotation(pdfWriter, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((URL)annotation.getAttributes().get("url")));
            }
            case 2: {
                return new PdfAnnotation(pdfWriter, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.getAttributes().get("file")));
            }
            case 3: {
                return new PdfAnnotation(pdfWriter, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.getAttributes().get("file"), (String)annotation.getAttributes().get("destination")));
            }
            case 7: {
                PdfFileSpecification pdfFileSpecification;
                object = (boolean[])annotation.getAttributes().get("parameters");
                String string = (String)annotation.getAttributes().get("file");
                String string2 = (String)annotation.getAttributes().get("mime");
                if (object[0] != false) {
                    String string3 = string;
                    pdfFileSpecification = PdfFileSpecification.fileEmbedded(pdfWriter, string3, string3, null);
                } else {
                    pdfFileSpecification = PdfFileSpecification.fileExtern(pdfWriter, string);
                }
                return PdfAnnotation.createScreen(pdfWriter, new Rectangle(annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury()), string, pdfFileSpecification, string2, (boolean)object[1]);
            }
            case 4: {
                return new PdfAnnotation(pdfWriter, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.getAttributes().get("file"), (Integer)annotation.getAttributes().get("page")));
            }
            case 5: {
                return new PdfAnnotation(pdfWriter, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((Integer)annotation.getAttributes().get("named")));
            }
            case 6: {
                return new PdfAnnotation(pdfWriter, annotation.llx(), annotation.lly(), annotation.urx(), annotation.ury(), new PdfAction((String)annotation.getAttributes().get("application"), (String)annotation.getAttributes().get("parameters"), (String)annotation.getAttributes().get("operation"), (String)annotation.getAttributes().get("defaultdir")));
            }
        }
        return new PdfAnnotation(pdfWriter, ((Rectangle)object).getLeft(), ((Rectangle)object).getBottom(), ((Rectangle)object).getRight(), ((Rectangle)object).getTop(), new PdfString(annotation.title(), "UnicodeBig"), new PdfString(annotation.content(), "UnicodeBig"));
    }
}

