/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.internal;

import com.lowagie.text.DocWriter;
import com.lowagie.text.pdf.OutputStreamCounter;
import com.lowagie.text.pdf.PdfDeveloperExtension;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.interfaces.PdfVersion;

public class PdfVersionImp
implements PdfVersion {
    public static final byte[][] HEADER = new byte[][]{DocWriter.getISOBytes("\n"), DocWriter.getISOBytes("%PDF-"), DocWriter.getISOBytes("\n%\u00e2\u00e3\u00cf\u00d3\n")};
    protected boolean headerWasWritten = false;
    protected boolean appendmode = false;
    protected char header_version = (char)53;
    protected PdfName catalog_version = null;
    protected PdfDictionary extensions = null;

    @Override
    public void setPdfVersion(char c2) {
        if (this.headerWasWritten || this.appendmode) {
            PdfVersionImp pdfVersionImp = this;
            pdfVersionImp.setPdfVersion(pdfVersionImp.getVersionAsName(c2));
            return;
        }
        this.header_version = c2;
    }

    @Override
    public void setAtLeastPdfVersion(char c2) {
        if (c2 > this.header_version) {
            this.setPdfVersion(c2);
        }
    }

    @Override
    public void setPdfVersion(PdfName pdfName) {
        if (this.catalog_version == null || this.catalog_version.compareTo(pdfName) < 0) {
            this.catalog_version = pdfName;
        }
    }

    public void setAppendmode(boolean bl2) {
        this.appendmode = bl2;
    }

    public void writeHeader(OutputStreamCounter outputStreamCounter) {
        if (this.appendmode) {
            outputStreamCounter.write(HEADER[0]);
            return;
        }
        outputStreamCounter.write(HEADER[1]);
        PdfVersionImp pdfVersionImp = this;
        outputStreamCounter.write(pdfVersionImp.getVersionAsByteArray(pdfVersionImp.header_version));
        outputStreamCounter.write(HEADER[2]);
        this.headerWasWritten = true;
    }

    public PdfName getVersionAsName(char c2) {
        switch (c2) {
            case '2': {
                return PdfWriter.PDF_VERSION_1_2;
            }
            case '3': {
                return PdfWriter.PDF_VERSION_1_3;
            }
            case '4': {
                return PdfWriter.PDF_VERSION_1_4;
            }
            case '5': {
                return PdfWriter.PDF_VERSION_1_5;
            }
            case '6': {
                return PdfWriter.PDF_VERSION_1_6;
            }
            case '7': {
                return PdfWriter.PDF_VERSION_1_7;
            }
        }
        return PdfWriter.PDF_VERSION_1_4;
    }

    public byte[] getVersionAsByteArray(char c2) {
        return DocWriter.getISOBytes(this.getVersionAsName(c2).toString().substring(1));
    }

    public void addToCatalog(PdfDictionary pdfDictionary) {
        if (this.catalog_version != null) {
            pdfDictionary.put(PdfName.VERSION, this.catalog_version);
        }
        if (this.extensions != null) {
            pdfDictionary.put(PdfName.EXTENSIONS, this.extensions);
        }
    }

    @Override
    public void addDeveloperExtension(PdfDeveloperExtension pdfDeveloperExtension) {
        if (this.extensions == null) {
            this.extensions = new PdfDictionary();
        } else {
            PdfDictionary pdfDictionary = this.extensions.getAsDict(pdfDeveloperExtension.getPrefix());
            if (pdfDictionary != null) {
                int n2 = pdfDeveloperExtension.getBaseversion().compareTo(pdfDictionary.getAsName(PdfName.BASEVERSION));
                if (n2 < 0) {
                    return;
                }
                n2 = pdfDeveloperExtension.getExtensionLevel() - pdfDictionary.getAsNumber(PdfName.EXTENSIONLEVEL).intValue();
                if (n2 <= 0) {
                    return;
                }
            }
        }
        this.extensions.put(pdfDeveloperExtension.getPrefix(), pdfDeveloperExtension.getDeveloperExtensions());
    }
}

