/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.internal;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.interfaces.PdfViewerPreferences;

public class PdfViewerPreferencesImp
implements PdfViewerPreferences {
    public static final PdfName[] VIEWER_PREFERENCES = new PdfName[]{PdfName.HIDETOOLBAR, PdfName.HIDEMENUBAR, PdfName.HIDEWINDOWUI, PdfName.FITWINDOW, PdfName.CENTERWINDOW, PdfName.DISPLAYDOCTITLE, PdfName.NONFULLSCREENPAGEMODE, PdfName.DIRECTION, PdfName.VIEWAREA, PdfName.VIEWCLIP, PdfName.PRINTAREA, PdfName.PRINTCLIP, PdfName.PRINTSCALING, PdfName.DUPLEX, PdfName.PICKTRAYBYPDFSIZE, PdfName.PRINTPAGERANGE, PdfName.NUMCOPIES};
    public static final PdfName[] NONFULLSCREENPAGEMODE_PREFERENCES = new PdfName[]{PdfName.USENONE, PdfName.USEOUTLINES, PdfName.USETHUMBS, PdfName.USEOC};
    public static final PdfName[] DIRECTION_PREFERENCES = new PdfName[]{PdfName.L2R, PdfName.R2L};
    public static final PdfName[] PAGE_BOUNDARIES = new PdfName[]{PdfName.MEDIABOX, PdfName.CROPBOX, PdfName.BLEEDBOX, PdfName.TRIMBOX, PdfName.ARTBOX};
    public static final PdfName[] PRINTSCALING_PREFERENCES = new PdfName[]{PdfName.APPDEFAULT, PdfName.NONE};
    public static final PdfName[] DUPLEX_PREFERENCES = new PdfName[]{PdfName.SIMPLEX, PdfName.DUPLEXFLIPSHORTEDGE, PdfName.DUPLEXFLIPLONGEDGE};
    private int a = 0;
    private PdfDictionary b = new PdfDictionary();

    public int getPageLayoutAndMode() {
        return this.a;
    }

    public PdfDictionary getViewerPreferences() {
        return this.b;
    }

    @Override
    public void setViewerPreferences(int n2) {
        this.a |= n2;
        if ((n2 & 0xFFF000) != 0) {
            this.a = 0xFF000FFF & this.a;
            if ((n2 & 0x1000) != 0) {
                this.b.put(PdfName.HIDETOOLBAR, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x2000) != 0) {
                this.b.put(PdfName.HIDEMENUBAR, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x4000) != 0) {
                this.b.put(PdfName.HIDEWINDOWUI, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x8000) != 0) {
                this.b.put(PdfName.FITWINDOW, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x10000) != 0) {
                this.b.put(PdfName.CENTERWINDOW, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x20000) != 0) {
                this.b.put(PdfName.DISPLAYDOCTITLE, PdfBoolean.PDFTRUE);
            }
            if ((n2 & 0x40000) != 0) {
                this.b.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USENONE);
            } else if ((n2 & 0x80000) != 0) {
                this.b.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USEOUTLINES);
            } else if ((n2 & 0x100000) != 0) {
                this.b.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USETHUMBS);
            } else if ((n2 & 0x200000) != 0) {
                this.b.put(PdfName.NONFULLSCREENPAGEMODE, PdfName.USEOC);
            }
            if ((n2 & 0x400000) != 0) {
                this.b.put(PdfName.DIRECTION, PdfName.L2R);
            } else if ((n2 & 0x800000) != 0) {
                this.b.put(PdfName.DIRECTION, PdfName.R2L);
            }
            if ((n2 & 0x1000000) != 0) {
                this.b.put(PdfName.PRINTSCALING, PdfName.NONE);
            }
        }
    }

    private static boolean a(PdfName pdfName, PdfName[] pdfNameArray) {
        for (PdfName pdfName2 : pdfNameArray) {
            if (!pdfName2.equals(pdfName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        int n2;
        block11: {
            PdfName pdfName2 = pdfName;
            for (int i2 = 0; i2 < VIEWER_PREFERENCES.length; ++i2) {
                if (!VIEWER_PREFERENCES[i2].equals(pdfName2)) continue;
                n2 = i2;
                break block11;
            }
            n2 = -1;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: {
                if (!(pdfObject instanceof PdfBoolean)) break;
                this.b.put(pdfName, pdfObject);
                return;
            }
            case 6: {
                if (!(pdfObject instanceof PdfName) || !PdfViewerPreferencesImp.a((PdfName)pdfObject, NONFULLSCREENPAGEMODE_PREFERENCES)) break;
                this.b.put(pdfName, pdfObject);
                return;
            }
            case 7: {
                if (!(pdfObject instanceof PdfName) || !PdfViewerPreferencesImp.a((PdfName)pdfObject, DIRECTION_PREFERENCES)) break;
                this.b.put(pdfName, pdfObject);
                return;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (!(pdfObject instanceof PdfName) || !PdfViewerPreferencesImp.a((PdfName)pdfObject, PAGE_BOUNDARIES)) break;
                this.b.put(pdfName, pdfObject);
                return;
            }
            case 12: {
                if (!(pdfObject instanceof PdfName) || !PdfViewerPreferencesImp.a((PdfName)pdfObject, PRINTSCALING_PREFERENCES)) break;
                this.b.put(pdfName, pdfObject);
                return;
            }
            case 13: {
                if (!(pdfObject instanceof PdfName) || !PdfViewerPreferencesImp.a((PdfName)pdfObject, DUPLEX_PREFERENCES)) break;
                this.b.put(pdfName, pdfObject);
                return;
            }
            case 15: {
                if (!(pdfObject instanceof PdfArray)) break;
                this.b.put(pdfName, pdfObject);
                return;
            }
            case 16: {
                if (!(pdfObject instanceof PdfNumber)) break;
                this.b.put(pdfName, pdfObject);
            }
        }
    }

    public void addToCatalog(PdfDictionary pdfDictionary) {
        pdfDictionary.remove(PdfName.PAGELAYOUT);
        if ((this.a & 1) != 0) {
            pdfDictionary.put(PdfName.PAGELAYOUT, PdfName.SINGLEPAGE);
        } else if ((this.a & 2) != 0) {
            pdfDictionary.put(PdfName.PAGELAYOUT, PdfName.ONECOLUMN);
        } else if ((this.a & 4) != 0) {
            pdfDictionary.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNLEFT);
        } else if ((this.a & 8) != 0) {
            pdfDictionary.put(PdfName.PAGELAYOUT, PdfName.TWOCOLUMNRIGHT);
        } else if ((this.a & 0x10) != 0) {
            pdfDictionary.put(PdfName.PAGELAYOUT, PdfName.TWOPAGELEFT);
        } else if ((this.a & 0x20) != 0) {
            pdfDictionary.put(PdfName.PAGELAYOUT, PdfName.TWOPAGERIGHT);
        }
        pdfDictionary.remove(PdfName.PAGEMODE);
        if ((this.a & 0x40) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.USENONE);
        } else if ((this.a & 0x80) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
        } else if ((this.a & 0x100) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.USETHUMBS);
        } else if ((this.a & 0x200) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.FULLSCREEN);
        } else if ((this.a & 0x400) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.USEOC);
        } else if ((this.a & 0x800) != 0) {
            pdfDictionary.put(PdfName.PAGEMODE, PdfName.USEATTACHMENTS);
        }
        pdfDictionary.remove(PdfName.VIEWERPREFERENCES);
        if (this.b.size() > 0) {
            pdfDictionary.put(PdfName.VIEWERPREFERENCES, this.b);
        }
    }

    public static PdfViewerPreferencesImp getViewerPreferences(PdfDictionary pdfDictionary) {
        PdfViewerPreferencesImp pdfViewerPreferencesImp = new PdfViewerPreferencesImp();
        int n2 = 0;
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.PAGELAYOUT));
        if (pdfObject != null && pdfObject.isName()) {
            if (((PdfName)(pdfObject = (PdfName)pdfObject)).equals(PdfName.SINGLEPAGE)) {
                n2 = 1;
            } else if (((PdfName)pdfObject).equals(PdfName.ONECOLUMN)) {
                n2 = 2;
            } else if (((PdfName)pdfObject).equals(PdfName.TWOCOLUMNLEFT)) {
                n2 = 4;
            } else if (((PdfName)pdfObject).equals(PdfName.TWOCOLUMNRIGHT)) {
                n2 = 8;
            } else if (((PdfName)pdfObject).equals(PdfName.TWOPAGELEFT)) {
                n2 = 16;
            } else if (((PdfName)pdfObject).equals(PdfName.TWOPAGERIGHT)) {
                n2 = 32;
            }
        }
        if ((pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.PAGEMODE))) != null && pdfObject.isName()) {
            if (((PdfName)(pdfObject = (PdfName)pdfObject)).equals(PdfName.USENONE)) {
                n2 |= 0x40;
            } else if (((PdfName)pdfObject).equals(PdfName.USEOUTLINES)) {
                n2 |= 0x80;
            } else if (((PdfName)pdfObject).equals(PdfName.USETHUMBS)) {
                n2 |= 0x100;
            } else if (((PdfName)pdfObject).equals(PdfName.FULLSCREEN)) {
                n2 |= 0x200;
            } else if (((PdfName)pdfObject).equals(PdfName.USEOC)) {
                n2 |= 0x400;
            } else if (((PdfName)pdfObject).equals(PdfName.USEATTACHMENTS)) {
                n2 |= 0x800;
            }
        }
        pdfViewerPreferencesImp.setViewerPreferences(n2);
        pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.VIEWERPREFERENCES));
        if (pdfObject != null && pdfObject.isDictionary()) {
            pdfDictionary = (PdfDictionary)pdfObject;
            PdfName[] pdfNameArray = VIEWER_PREFERENCES;
            int n3 = VIEWER_PREFERENCES.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                PdfName pdfName = pdfNameArray[i2];
                pdfObject = PdfReader.getPdfObjectRelease(pdfDictionary.get(pdfName));
                pdfViewerPreferencesImp.addViewerPreference(pdfName, pdfObject);
            }
        }
        return pdfViewerPreferencesImp;
    }
}

