/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.internal;

import com.lowagie.text.pdf.internal.PolylineShapeIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PolylineShape
implements Shape {
    protected int[] x;
    protected int[] y;
    protected int np;

    public PolylineShape(int[] nArray, int[] nArray2, int n2) {
        this.np = n2;
        this.x = new int[this.np];
        this.y = new int[this.np];
        System.arraycopy(nArray, 0, this.x, 0, this.np);
        System.arraycopy(nArray2, 0, this.y, 0, this.np);
    }

    @Override
    public Rectangle2D getBounds2D() {
        int[] nArray;
        PolylineShape polylineShape = this;
        if (polylineShape.np == 0) {
            nArray = null;
        } else {
            int n2 = polylineShape.x[0];
            int n3 = polylineShape.y[0];
            int n4 = polylineShape.x[0];
            int n5 = polylineShape.y[0];
            for (int i2 = 1; i2 < polylineShape.np; ++i2) {
                if (polylineShape.x[i2] < n2) {
                    n2 = polylineShape.x[i2];
                } else if (polylineShape.x[i2] > n4) {
                    n4 = polylineShape.x[i2];
                }
                if (polylineShape.y[i2] < n3) {
                    n3 = polylineShape.y[i2];
                    continue;
                }
                if (polylineShape.y[i2] <= n5) continue;
                n5 = polylineShape.y[i2];
            }
            int[] nArray2 = new int[4];
            nArray2[0] = n2;
            nArray2[1] = n3;
            nArray2[2] = n4 - n2;
            nArray = nArray2;
            nArray2[3] = n5 - n3;
        }
        polylineShape = nArray;
        if (nArray == null) {
            return null;
        }
        return new Rectangle2D.Double((double)polylineShape[0], (double)polylineShape[1], (double)polylineShape[2], (double)polylineShape[3]);
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public boolean contains(double d2, double d3) {
        return false;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return false;
    }

    @Override
    public boolean contains(double d2, double d3, double d4, double d5) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    @Override
    public boolean intersects(double d2, double d3, double d4, double d5) {
        return this.intersects(new Rectangle2D.Double(d2, d3, d4, d5));
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        if (this.np == 0) {
            return false;
        }
        Line2D.Double double_ = new Line2D.Double(this.x[0], this.y[0], this.x[0], this.y[0]);
        for (int i2 = 1; i2 < this.np; ++i2) {
            ((Line2D)double_).setLine(this.x[i2 - 1], this.y[i2 - 1], this.x[i2], this.y[i2]);
            if (!double_.intersects(rectangle2D)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new PolylineShapeIterator(this, affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return new PolylineShapeIterator(this, affineTransform);
    }
}

