/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.CMapAwareDocumentFont;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.parser.FinalText;
import com.lowagie.text.pdf.parser.GraphicsState;
import com.lowagie.text.pdf.parser.Matrix;
import com.lowagie.text.pdf.parser.ParsedTextImpl;
import com.lowagie.text.pdf.parser.TextAssembler;
import com.lowagie.text.pdf.parser.Vector;
import com.lowagie.text.pdf.parser.Word;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ParsedText
extends ParsedTextImpl {
    private final Matrix a;
    private final GraphicsState b;
    private PdfString c;

    ParsedText(PdfString object, GraphicsState graphicsState, Matrix matrix) {
        PdfString pdfString = object;
        GraphicsState graphicsState2 = new GraphicsState(graphicsState);
        Matrix matrix2 = matrix.multiply(graphicsState.getCtm());
        object = graphicsState;
        char c2 = ' ';
        if (((BaseFont)((GraphicsState)object).getFont()).getWidth(32) == 0) {
            c2 = '\u00a0';
        }
        this(pdfString, graphicsState2, matrix2, ParsedText.a(String.valueOf(c2), (GraphicsState)object));
    }

    private ParsedText(PdfString pdfString, GraphicsState graphicsState, Matrix matrix, float f2) {
        Matrix matrix2 = matrix;
        Vector vector = ParsedText.a(0.0f, 0.0f, matrix2);
        Vector vector2 = ParsedText.a(f2, 0.0f, matrix2);
        super(null, ParsedText.a(0.0f, 0.0f, matrix), ParsedText.a(ParsedText.a(((PdfObject)pdfString).toString(), graphicsState), 0.0f, matrix), ParsedText.a(1.0f, 0.0f, matrix), ParsedText.a(graphicsState.getFontAscentDescriptor(), matrix), ParsedText.a(graphicsState.getFontDescentDescriptor(), matrix), ParsedText.a(vector, vector2));
        this.c = null;
        this.c = "Identity-H".equals(graphicsState.getFont().getEncoding()) ? (graphicsState.getFont().hasUnicodeCMAP() ? (graphicsState.getFont().hasTwoByteUnicodeCMAP() ? new PdfString(((PdfObject)pdfString).toString(), "IDENTITY_H2") : new PdfString(((PdfObject)pdfString).toString(), "IDENTITY_H1")) : new PdfString(new String(((PdfObject)pdfString).getBytes(), StandardCharsets.UTF_16))) : pdfString;
        this.a = matrix;
        this.b = graphicsState;
    }

    private static Vector a(float f2, float f3, Matrix matrix) {
        return new Vector(f2, f3, 1.0f).cross(matrix);
    }

    private static float a(String object, GraphicsState graphicsState) {
        object = ((String)object).toCharArray();
        float f2 = 0.0f;
        for (Object object2 : object) {
            float f3 = (float)((BaseFont)graphicsState.getFont()).getWidth((int)object2) / 1000.0f;
            float f4 = Character.isSpaceChar((char)object2) ? graphicsState.getWordSpacing() : 0.0f;
            f2 += (f3 * graphicsState.getFontSize() + graphicsState.getCharacterSpacing() + f4) * graphicsState.getHorizontalScaling();
        }
        return f2;
    }

    private static float a(Vector vector, Vector vector2) {
        return vector2.subtract(vector).length();
    }

    private static float a(float f2, Matrix matrix) {
        Vector vector = ParsedText.a(0.0f, 0.0f, matrix);
        Vector vector2 = ParsedText.a(0.0f, f2, matrix);
        return ParsedText.a(vector2, vector);
    }

    protected String decode(String object) {
        if ("Identity-H".equals(this.b.getFont().getEncoding())) {
            ((String)object).getBytes(StandardCharsets.UTF_16);
        }
        object = ((String)object).getBytes();
        return this.b.getFont().decode((byte[])object, 0, ((Object)object).length);
    }

    protected String decode(PdfString object) {
        object = ((PdfString)object).getOriginalBytes();
        return this.b.getFont().decode((byte[])object, 0, ((Object)object).length);
    }

    public List<Word> getAsPartialWords() {
        ArrayList<Word> arrayList = new ArrayList<Word>();
        CMapAwareDocumentFont cMapAwareDocumentFont = this.b.getFont();
        char[] cArray = this.c.getOriginalChars();
        boolean[] blArray = new boolean[cArray.length];
        float f2 = 0.0f;
        StringBuffer stringBuffer = new StringBuffer(3);
        float f3 = 0.0f;
        boolean[] blArray2 = blArray;
        char[] cArray2 = cArray;
        ParsedText parsedText = this;
        char c2 = '\u0000';
        for (int i2 = 0; i2 < cArray2.length; ++i2) {
            char c3 = cArray2[i2];
            blArray2[i2] = false;
            Object object = parsedText.b.getFont().decode(c3);
            if (object == null) continue;
            char[] cArray3 = ((String)object).toCharArray();
            object = cArray3;
            int n2 = cArray3.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Object object2 = object[i3];
                if (!Character.isSpaceChar((char)object2)) continue;
                c2 = '\u0001';
                blArray2[i2] = true;
            }
        }
        char c4 = c2;
        boolean bl2 = false;
        for (int i4 = 0; i4 < cArray.length; ++i4) {
            c2 = cArray[i4];
            float f4 = (float)((BaseFont)cMapAwareDocumentFont).getWidth(c2) / 1000.0f;
            if (blArray[i4]) {
                if (stringBuffer.length() > 0) {
                    arrayList.add(this.a(stringBuffer, f3, f2, this.getBaseline(), c4 != '\u0000', bl2));
                    stringBuffer = new StringBuffer();
                }
                if (!Character.isWhitespace(c2)) {
                    f3 = f2;
                }
                f2 += this.b.calculateCharacterWidthWithSpace(f4);
                if (Character.isWhitespace(c2)) {
                    f3 = f2;
                }
                stringBuffer.append(c2);
                bl2 = true;
                continue;
            }
            stringBuffer.append(c2);
            f2 += this.b.calculateCharacterWidthWithoutSpace(f4);
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(this.a(stringBuffer, f3, f2, this.getBaseline(), c4 != '\u0000', bl2));
        }
        return arrayList;
    }

    private Word a(StringBuffer stringBuffer, float f2, float f3, Vector vector, boolean bl2, boolean bl3) {
        return new Word(this.b.getFont().decode(stringBuffer.toString()), this.getAscent(), this.getDescent(), ParsedText.a(f2, 0.0f, this.a), ParsedText.a(f3, 0.0f, this.a), vector, this.getSingleSpaceWidth(), bl2, bl3);
    }

    public float getUnscaledTextWidth(GraphicsState graphicsState) {
        return ParsedText.a(this.getFontCodes(), graphicsState);
    }

    @Override
    public void accumulate(TextAssembler textAssembler, String string) {
        textAssembler.process(this, string);
    }

    @Override
    public void assemble(TextAssembler textAssembler) {
        textAssembler.renderText(this);
    }

    @Override
    @Nullable
    public String getText() {
        String string = super.getText();
        if (string == null && this.c != null) {
            ParsedText parsedText = this;
            return parsedText.decode(parsedText.c);
        }
        return string;
    }

    @Nonnull
    public String getFontCodes() {
        return Optional.ofNullable(this.c).map(PdfString::toString).orElse("");
    }

    @Override
    public FinalText getFinalText(PdfReader pdfReader, int n2, TextAssembler textAssembler, boolean bl2) {
        throw new RuntimeException("Final text should never be called on unprocessed word fragment.");
    }

    public String toString() {
        return "[ParsedText: [" + ((ParsedTextImpl)this).getText() + "] " + this.getStartPoint() + ", " + this.getEndPoint() + "] lead]";
    }

    @Override
    public boolean shouldNotSplit() {
        return false;
    }

    @Override
    public boolean breakBefore() {
        return false;
    }
}

